/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech;

import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Element;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.behaviors.Behaviour_DataOrb;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.handler.COMPAT_HANDLER;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.minecraft.RecipeUtils;
import gtPlusPlus.everglades.gen.gt.WorldGen_GT;
import gtPlusPlus.recipes.CokeAndPyrolyseOven;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechOrePrefixes;
import gtPlusPlus.xmod.gregtech.api.util.GTPP_Config;
import gtPlusPlus.xmod.gregtech.common.Meta_GT_Proxy;
import gtPlusPlus.xmod.gregtech.common.blocks.fluid.GregtechFluidHandler;
import gtPlusPlus.xmod.gregtech.common.items.MetaGeneratedGregtechTools;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.GregtechMTE_ElementalDuplicator;
import gtPlusPlus.xmod.gregtech.loaders.Gregtech_Blocks;
import gtPlusPlus.xmod.gregtech.loaders.ProcessingAngleGrinder;
import gtPlusPlus.xmod.gregtech.loaders.ProcessingElectricButcherKnife;
import gtPlusPlus.xmod.gregtech.loaders.ProcessingElectricLighter;
import gtPlusPlus.xmod.gregtech.loaders.ProcessingElectricSnips;
import gtPlusPlus.xmod.gregtech.loaders.ProcessingToolHeadChoocher;
import gtPlusPlus.xmod.gregtech.loaders.misc.AddCustomMachineToPA;
import gtPlusPlus.xmod.gregtech.loaders.recipe.RecipeLoader_AlgaeFarm;
import gtPlusPlus.xmod.gregtech.loaders.recipe.RecipeLoader_MolecularTransformer;
import gtPlusPlus.xmod.gregtech.registration.gregtech.GregtechConduits;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class HANDLER_GT {
    public static GT_Config mMaterialProperties = null;
    public static GTPP_Config sCustomWorldgenFile = null;
    public static final List<WorldGen_GT> sWorldgenListEverglades = new ArrayList<WorldGen_GT>();
    public static GT_MetaGenerated_Tool sMetaGeneratedToolInstance;

    public static void preInit() {
        if (mMaterialProperties != null) {
            GregtechOrePrefixes.GT_Materials.init(mMaterialProperties);
        }
        GregtechFluidHandler.run();
    }

    public static void init() {
        Gregtech_Blocks.run();
        GregtechConduits.run();
        COMPAT_HANDLER.registerGregtechMachines();
        if (CORE.ConfigSwitches.enableSkookumChoochers) {
            sMetaGeneratedToolInstance = MetaGeneratedGregtechTools.getInstance();
        }
    }

    public static void postInit() {
        int i;
        if (CORE.ConfigSwitches.enableSkookumChoochers) {
            new ProcessingToolHeadChoocher().run();
        }
        new ProcessingAngleGrinder().run();
        new ProcessingElectricSnips().run();
        new ProcessingElectricButcherKnife().run();
        new ProcessingElectricLighter().run();
        AddCustomMachineToPA.register();
        if (GregtechItemList.Circuit_BioRecipeSelector.hasBeenSet()) {
            for (i = 1; i <= 24; ++i) {
                GregTech_API.registerConfigurationCircuit((ItemStack)CI.getNumberedBioCircuit(i), (int)0);
            }
        }
        if (GregtechItemList.Circuit_T3RecipeSelector.hasBeenSet()) {
            for (i = 1; i <= 24; ++i) {
                GregTech_API.registerConfigurationCircuit((ItemStack)CI.getNumberedAdvancedCircuit(i), (int)3);
            }
        }
    }

    public static void onLoadComplete(FMLLoadCompleteEvent event) {
        CokeAndPyrolyseOven.onLoadComplete();
        HANDLER_GT.generateElementalDuplicatorRecipes();
        Meta_GT_Proxy.fixIC2FluidNames();
        RecipeLoader_AlgaeFarm.generateRecipes();
        if (Mods.AdvancedSolarPanel.isModLoaded()) {
            RecipeLoader_MolecularTransformer.run();
        }
    }

    private static void generateElementalDuplicatorRecipes() {
        for (GT_Recipe aRecipe : GT_Recipe.GT_Recipe_Map.sReplicatorFakeRecipes.mRecipeList) {
            Object aDataOrb = aRecipe.mSpecialItems;
            if (aDataOrb != null) {
                ItemStack aOutput = aRecipe.mOutputs[0];
                if (aOutput != null) {
                    FluidStack aFluid = aRecipe.mFluidInputs[0];
                    if (aFluid != null && aFluid.amount > 0) {
                        ItemStack tDataOrb = GregtechMTE_ElementalDuplicator.getSpecialSlotStack(aRecipe);
                        Materials tMaterial = (Materials)Element.get((String)Behaviour_DataOrb.getDataName((ItemStack)tDataOrb)).mLinkedMaterials.get(0);
                        FluidStack aOutputFluid = null;
                        ItemStack aOutputItem = null;
                        if (tMaterial == null) continue;
                        boolean aUsingFluid = false;
                        aOutputItem = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)tMaterial, (long)1L);
                        if (aOutputItem == null && (aOutputItem = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.cell, (Object)tMaterial, (long)1L)) != null) {
                            aOutputFluid = GT_Utility.getFluidForFilledItem((ItemStack)aOutputItem, (boolean)true);
                            aUsingFluid = true;
                        }
                        GTPP_Recipe aNewRecipe = new GTPP_Recipe(false, new ItemStack[]{}, new ItemStack[]{!aUsingFluid ? aOutputItem : null}, aRecipe.mSpecialItems, null, aRecipe.mFluidInputs, new FluidStack[]{aUsingFluid ? aOutputFluid : null}, aRecipe.mDuration, aRecipe.mEUt, aRecipe.mFluidInputs[0].amount);
                        GTPP_Recipe.GTPP_Recipe_Map.sElementalDuplicatorRecipes.add((GT_Recipe)aNewRecipe);
                        Logger.INFO("[EM] Generated recipe for " + tMaterial.mLocalizedName + ", Outputs " + (aUsingFluid ? "Fluid" : "Dust"));
                        continue;
                    }
                    Logger.INFO("[EM] Bad UU Requirement. " + RecipeUtils.getRecipeInfo(aRecipe));
                    continue;
                }
                Logger.INFO("[EM] Bad Output. " + RecipeUtils.getRecipeInfo(aRecipe));
                continue;
            }
            Logger.INFO("[EM] Bad Data Orb. " + RecipeUtils.getRecipeInfo(aRecipe));
        }
        int aSize = GTPP_Recipe.GTPP_Recipe_Map.sElementalDuplicatorRecipes.mRecipeList.size();
        Logger.INFO("[EM] Generated " + aSize + "/" + GT_Recipe.GT_Recipe_Map.sReplicatorFakeRecipes.mRecipeList.size() + " Replicator recipes.");
    }
}

