/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.forestry.bees.items.output;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Mods;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.xmod.forestry.bees.handler.GTPP_DropType;
import gtPlusPlus.xmod.forestry.bees.registry.GTPP_Bees;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidStack;

public class GTPP_Drop
extends Item {
    @SideOnly(value=Side.CLIENT)
    private IIcon secondIcon;
    private static final int[] sFluidOutputs = new int[]{144, 136, 128, 120, 112, 104, 96, 88, 80, 72, 64, 48, 32, 16, 8, 4};

    public GTPP_Drop() {
        this.func_77637_a(Tabs.tabApiculture);
        this.func_77627_a(true);
        this.func_77655_b("gtpp.drop");
        GameRegistry.registerItem((Item)this, (String)"gtpp.drop", (String)Mods.GTPlusPlus.ID);
    }

    public ItemStack getStackForType(GTPP_DropType type) {
        return new ItemStack((Item)this, 1, type.mID);
    }

    public ItemStack getStackForType(GTPP_DropType type, int count) {
        return new ItemStack((Item)this, count, type.mID);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        for (GTPP_DropType type : GTPP_DropType.values()) {
            if (!type.mShowInList) continue;
            list.add(this.getStackForType(type));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int meta) {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("forestry:honeyDrop.0");
        this.secondIcon = par1IconRegister.func_94245_a("forestry:honeyDrop.1");
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return pass == 0 ? this.field_77791_bV : this.secondIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        int colour = GTPP_DropType.get(stack.func_77960_j()).getColours()[0];
        if (pass >= 1) {
            colour = GTPP_DropType.get(stack.func_77960_j()).getColours()[1];
        }
        return colour;
    }

    public String func_77653_i(ItemStack stack) {
        return GTPP_DropType.get(stack.func_77960_j()).getName();
    }

    public static void initDropsRecipes() {
        Logger.BEES("Processing recipes for " + GTPP_Bees.sDropMappings.size() + " Drops.");
        for (GTPP_DropType aDrop : GTPP_Bees.sDropMappings.values()) {
            ItemStack tDrop = aDrop.getStackForType(1);
            if (GTPP_Drop.addProcess(tDrop, new FluidStack(aDrop.mMaterial.getFluid(), sFluidOutputs[aDrop.mMaterial.vTier]), aDrop.mMaterial.vTier * 20 * 30, aDrop.mMaterial.vVoltageMultiplier)) {
                Logger.BEES("Added Drop extraction recipe for: " + aDrop.getName());
                continue;
            }
            Logger.BEES("Failed to add Drop extraction recipe for: " + aDrop.getName());
        }
    }

    public static boolean addProcess(ItemStack tDrop, FluidStack aOutput, int aDuration, int aEUt) {
        return GT_Values.RA.addFluidExtractionRecipe(tDrop, null, aOutput, 10000, aDuration, aEUt);
    }
}

