/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.general;

import gregtech.api.enums.ItemList;
import gregtech.api.enums.Mods;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.item.base.CoreItem;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;

public class ItemLavaFilter
extends CoreItem {
    public IIcon[] mIcon = new IIcon[1];

    public ItemLavaFilter() {
        super("itemLavaFilter", AddToCreativeTab.tabMachines, 1, 100, new String[]{"Lava Filter"}, EnumRarity.common, EnumChatFormatting.BLACK, false, null);
        this.setGregtechItemList();
    }

    private final boolean setGregtechItemList() {
        ItemList.Component_LavaFilter.set((Item)this);
        return ItemList.Component_LavaFilter.get(1L, new Object[0]) != null;
    }

    public void func_94581_a(IIconRegister reg) {
        this.mIcon[0] = reg.func_94245_a(Mods.GTPlusPlus.ID + ":itemLavaFilter");
    }

    public IIcon func_77617_a(int meta) {
        return this.mIcon[0];
    }

    private static boolean createNBT(ItemStack rStack) {
        NBTTagCompound tagMain = new NBTTagCompound();
        NBTTagCompound tagNBT = new NBTTagCompound();
        tagNBT.func_74772_a("Damage", 0L);
        tagMain.func_74782_a("LavaFilter", (NBTBase)tagNBT);
        rStack.func_77982_d(tagMain);
        return true;
    }

    public static final long getFilterDamage(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null) {
            if ((aNBT = aNBT.func_74775_l("LavaFilter")) != null) {
                return aNBT.func_74763_f("Damage");
            }
        } else {
            ItemLavaFilter.createNBT(aStack);
        }
        return 0L;
    }

    public static final boolean setFilterDamage(ItemStack aStack, long aDamage) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null) {
            if ((aNBT = aNBT.func_74775_l("LavaFilter")) != null) {
                aNBT.func_74772_a("Damage", aDamage);
                return true;
            }
        } else {
            ItemLavaFilter.createNBT(aStack);
        }
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            ItemLavaFilter.createNBT(stack);
        }
        double currentDamage = ItemLavaFilter.getFilterDamage(stack);
        double durabilitypercent = currentDamage / 100.0;
        return durabilitypercent;
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        list.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"item.itemLavaFilter.tooltip"));
        EnumChatFormatting durability = EnumChatFormatting.GRAY;
        if (100L - ItemLavaFilter.getFilterDamage(stack) > 80L) {
            durability = EnumChatFormatting.GRAY;
        } else if (100L - ItemLavaFilter.getFilterDamage(stack) > 60L) {
            durability = EnumChatFormatting.GREEN;
        } else if (100L - ItemLavaFilter.getFilterDamage(stack) > 40L) {
            durability = EnumChatFormatting.YELLOW;
        } else if (100L - ItemLavaFilter.getFilterDamage(stack) > 20L) {
            durability = EnumChatFormatting.GOLD;
        } else if (100L - ItemLavaFilter.getFilterDamage(stack) > 0L) {
            durability = EnumChatFormatting.RED;
        }
        list.add(durability + "" + (100L - ItemLavaFilter.getFilterDamage(stack)) + EnumChatFormatting.GRAY + " / " + 100);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }
}

