/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.chunkloading;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gtPlusPlus.GTplusplus;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.basic.GregtechMetaTileEntityChunkLoader;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;

public class GTPP_ChunkManager
implements ForgeChunkManager.LoadingCallback,
ForgeChunkManager.OrderedLoadingCallback,
ForgeChunkManager.PlayerOrderedLoadingCallback {
    private static GTPP_ChunkManager instance;
    public static boolean enableChunkloaders;
    public static boolean alwaysReloadChunkloaders;
    public static boolean debugChunkloaders;

    public static GTPP_ChunkManager getInstance() {
        if (instance == null) {
            instance = new GTPP_ChunkManager();
        }
        return instance;
    }

    public static void init() {
        if (enableChunkloaders) {
            ForgeChunkManager.setForcedChunkLoadingCallback((Object)GTplusplus.instance, (ForgeChunkManager.LoadingCallback)GTPP_ChunkManager.getInstance());
            MinecraftForge.EVENT_BUS.register((Object)GTPP_ChunkManager.getInstance());
        }
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket ticket : tickets) {
            TileEntity tile;
            Entity entity;
            if (ticket.isPlayerTicket() || (entity = ticket.getEntity()) != null) continue;
            int x = ticket.getModData().func_74762_e("xCoord");
            int y = ticket.getModData().func_74762_e("yCoord");
            int z = ticket.getModData().func_74762_e("zCoord");
            if (y < 0 || !(((IGregTechTileEntity)(tile = world.func_147438_o(x, y, z))).getMetaTileEntity() instanceof GregtechMetaTileEntityChunkLoader)) continue;
            ((GregtechMetaTileEntityChunkLoader)((IGregTechTileEntity)tile).getMetaTileEntity()).forceChunkLoading(ticket);
        }
    }

    public List<ForgeChunkManager.Ticket> ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world, int maxTicketCount) {
        HashSet<ForgeChunkManager.Ticket> validTickets = new HashSet<ForgeChunkManager.Ticket>();
        for (ForgeChunkManager.Ticket ticket : tickets) {
            TileEntity tile;
            Entity entity = ticket.getEntity();
            if (entity != null) continue;
            int x = ticket.getModData().func_74762_e("xCoord");
            int y = ticket.getModData().func_74762_e("yCoord");
            int z = ticket.getModData().func_74762_e("zCoord");
            if (y < 0 || !(((IGregTechTileEntity)(tile = world.func_147438_o(x, y, z))).getMetaTileEntity() instanceof GregtechMetaTileEntityChunkLoader)) continue;
            validTickets.add(ticket);
        }
        return new LinkedList<ForgeChunkManager.Ticket>(validTickets);
    }

    public ListMultimap<String, ForgeChunkManager.Ticket> playerTicketsLoaded(ListMultimap<String, ForgeChunkManager.Ticket> tickets, World world) {
        return LinkedListMultimap.create();
    }

    public static Set<ChunkCoordIntPair> getChunksAround(int xChunk, int zChunk, int radius) {
        HashSet<ChunkCoordIntPair> chunkList = new HashSet<ChunkCoordIntPair>();
        for (int xx = xChunk - radius; xx <= xChunk + radius; ++xx) {
            for (int zz = zChunk - radius; zz <= zChunk + radius; ++zz) {
                chunkList.add(new ChunkCoordIntPair(xx, zz));
            }
        }
        return chunkList;
    }

    static {
        enableChunkloaders = true;
        alwaysReloadChunkloaders = false;
        debugChunkloaders = false;
    }
}

