/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import codechicken.nei.PositionedStack;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.util.GT_Recipe;
import gregtech.common.gui.modularui.UIHelper;
import gregtech.nei.GT_NEI_DefaultHandler;
import gregtech.nei.NEIRecipeInfo;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.item.ModItems;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.api.gui.GTPP_UITextures;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.FluidStack;

public class GTPP_Recipe
extends GT_Recipe {
    public GTPP_Recipe(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecialItems, int[] aChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
        super(aOptimize, aInputs, aOutputs, aSpecialItems, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue);
    }

    public GTPP_Recipe(ItemStack aInput1, ItemStack aOutput1, int aFuelValue, int aType) {
        this(aInput1, aOutput1, null, null, null, aFuelValue, aType);
    }

    public GTPP_Recipe(ItemStack aInput1, ItemStack aOutput1, ItemStack aOutput2, ItemStack aOutput3, ItemStack aOutput4, int aSpecialValue, int aType) {
        this(true, new ItemStack[]{aInput1}, new ItemStack[]{aOutput1, aOutput2, aOutput3, aOutput4}, null, null, null, null, 0, 0, Math.max(1, aSpecialValue));
        Logger.WARNING("Switch case method for adding fuels");
        if (this.mInputs.length > 0 && aSpecialValue > 0) {
            switch (aType) {
                case 0: {
                    Logger.WARNING("Added fuel " + aInput1.func_82833_r() + " is ROCKET FUEL - continuing");
                    GTPP_Recipe_Map.sRocketFuels.addRecipe((GT_Recipe)this);
                    break;
                }
                case 1: {
                    GTPP_Recipe_Map.sGeoThermalFuels.addRecipe((GT_Recipe)this);
                    break;
                }
                case 2: {
                    GTPP_Recipe_Map.sRTGFuels.addRecipe((GT_Recipe)this);
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
            }
        }
    }

    public static class GTPP_Recipe_Map {
        public static final GT_Recipe.GT_Recipe_Map sCokeOvenRecipes = new GT_Recipe.GT_Recipe_Map(new HashSet(200), "gtpp.recipe.cokeoven", "Coke Oven", null, "", 2, 9, 1, 0, 1, "", 1, "", true, true).setProgressBar(GT_UITextures.PROGRESSBAR_SIFT, ProgressBar.Direction.DOWN);
        public static final GT_Recipe.GT_Recipe_Map sMatterFab2Recipes = new GT_Recipe.GT_Recipe_Map(new HashSet(200), "gtpp.recipe.matterfab2", "Matter Fabricator", null, "", 2, 0, 0, 0, 1, "", 1, "", true, true).useModularUI(true);
        public static final GT_Recipe.GT_Recipe_Map_Fuel sRocketFuels = (GT_Recipe.GT_Recipe_Map_Fuel)new GT_Recipe.GT_Recipe_Map_Fuel(new HashSet(10), "gtpp.recipe.rocketenginefuel", "Rocket Engine Fuel", null, "", 0, 0, 0, 0, 1, "Fuel Value: ", 3000, " EU", true, true).useModularUI(true);
        public static final GT_Recipe.GT_Recipe_Map sQuantumForceTransformerRecipes = new GT_Recipe.GT_Recipe_Map_LargeNEI(new HashSet(20), "gtpp.recipe.quantumforcesmelter", "Quantum Force Transformer", null, "", 6, 6, 1, 0, 1, "Tier: ", 1, "", true, true).useModularUI(true).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW_MULTIPLE, ProgressBar.Direction.RIGHT).setUsualFluidInputCount(6).setUsualFluidOutputCount(6);
        public static final GT_Recipe.GT_Recipe_Map sGeoThermalFuels = new GT_Recipe.GT_Recipe_Map(new HashSet(10), "gtpp.recipe.geothermalfuel", "GeoThermal Fuel", null, "", 1, 1, 0, 0, 1, "Fuel Value: ", 1000, " EU", true, true).useModularUI(true);
        public static final GTPP_Recipe_Map_Internal sChemicalDehydratorRecipes = (GTPP_Recipe_Map_Internal)new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(200), "gtpp.recipe.chemicaldehydrator", "Dehydrator", null, "", 2, 9, 0, 0, 1, "", 1, "", true, true).setProgressBar(GT_UITextures.PROGRESSBAR_SIFT, ProgressBar.Direction.DOWN);
        public static final GT_Recipe.GT_Recipe_Map sVacuumFurnaceRecipes = new GT_Recipe.GT_Recipe_Map_LargeNEI(new HashSet(500), "gtpp.recipe.vacfurnace", "Vacuum Furnace", null, "", 9, 9, 1, 0, 1, "Heat Capacity: ", 1, " K", false, true).setUsualFluidInputCount(3).setUsualFluidOutputCount(3);
        public static final GT_Recipe.GT_Recipe_Map sAlloyBlastSmelterRecipes = new GT_Recipe.GT_Recipe_Map_LargeNEI(new HashSet(200), "gtpp.recipe.alloyblastsmelter", "Alloy Blast Smelter", null, "", 9, 9, 1, 0, 1, "", 1, "", true, true).setUsualFluidInputCount(3).setUsualFluidOutputCount(3);
        public static final GT_Recipe.GT_Recipe_Map sSteamTurbineFuels = new GT_Recipe.GT_Recipe_Map(new HashSet(10), "gtpp.recipe.steamturbinefuel", "GeoThermal Fuel", null, "", 1, 1, 0, 0, 1, "Fuel Value: ", 1000, " EU", true, false).useModularUI(true);
        public static final GT_Recipe.GT_Recipe_Map sLiquidFluorineThoriumReactorRecipes = new GT_Recipe.GT_Recipe_Map_FluidOnly(new HashSet(50), "gtpp.recipe.lftr", "Liquid Fluoride Thorium Reactor", null, "", 0, 0, 0, 2, 0, "Power: ", 1, " EU/t per Dynamo", true, true).setUsualFluidInputCount(6).setUsualFluidOutputCount(6).setNEISpecialInfoFormatter((recipeInfo, applyPrefixAndSuffix) -> {
            long tEUt = recipeInfo.recipe.mSpecialValue;
            int tDuration = recipeInfo.recipe.mDuration;
            return Arrays.asList((String)applyPrefixAndSuffix.apply(recipeInfo.recipe.mSpecialValue), "Dynamo: " + MathUtils.formatNumbers((long)tDuration * tEUt) + " EU", "Total: " + MathUtils.formatNumbers((long)tDuration * tEUt * 4L) + " EU");
        });
        public static final GT_Recipe.GT_Recipe_Map sNuclearSaltProcessingPlantRecipes = new GT_Recipe.GT_Recipe_Map_LargeNEI(new HashSet(50), "gtpp.recipe.nuclearsaltprocessingplant", "Nuclear Salt Processing Plant", null, "", 0, 6, 0, 0, 1, "", 0, "", true, true).setUsualFluidInputCount(2).setUsualFluidOutputCount(3);
        public static final GT_Recipe.GT_Recipe_Map sOreMillRecipes = new GT_Recipe.GT_Recipe_Map(new HashSet(10000), "gtpp.recipe.oremill", "Milling", null, "", 3, 3, 1, 0, 1, "", 1, "", true, true){

            protected List<String> handleNEIItemInputTooltip(List<String> currentTip, GT_NEI_DefaultHandler.FixedPositionedStack pStack) {
                if (ItemUtils.isMillingBall(pStack.item)) {
                    currentTip.add(EnumChatFormatting.GRAY + "Does not always get consumed in the process");
                } else {
                    super.handleNEIItemInputTooltip(currentTip, pStack);
                }
                return currentTip;
            }

            protected void drawNEIOverlayForInput(GT_NEI_DefaultHandler.FixedPositionedStack stack) {
                if (ItemUtils.isMillingBall(stack.item)) {
                    this.drawNEIOverlayText("NC*", (PositionedStack)stack);
                } else {
                    super.drawNEIOverlayForInput(stack);
                }
            }
        }.useModularUI(true);
        public static final GT_Recipe.GT_Recipe_Map sFissionFuelProcessing = new GT_Recipe.GT_Recipe_Map_FluidOnly(new HashSet(50), "gtpp.recipe.fissionfuel", "Nuclear Fuel Processing", null, "", 0, 0, 0, 0, 1, "", 1, "", true, true).setUsualFluidInputCount(6).setUsualFluidOutputCount(6);
        public static final GT_Recipe.GT_Recipe_Map sColdTrapRecipes = new GT_Recipe.GT_Recipe_Map(new HashSet(10000), "gtpp.recipe.coldtrap", "Cold Trap", null, "", 2, 9, 0, 0, 1, "", 1, "", true, true).setProgressBar(GT_UITextures.PROGRESSBAR_SIFT, ProgressBar.Direction.DOWN);
        public static final GT_Recipe.GT_Recipe_Map sReactorProcessingUnitRecipes = new GT_Recipe.GT_Recipe_Map(new HashSet(10000), "gtpp.recipe.reactorprocessingunit", "Reactor Processing Unit", null, "", 2, 9, 0, 0, 1, "", 1, "", true, true).setProgressBar(GT_UITextures.PROGRESSBAR_SIFT, ProgressBar.Direction.DOWN);
        public static final GTPP_Recipe_Map_Internal sSimpleWasherRecipes = (GTPP_Recipe_Map_Internal)new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(3), "gtpp.recipe.simplewasher", "Simple Dust Washer", null, "", 1, 1, 0, 0, 1, "", 1, "", true, true).setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_CAULDRON).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW_MULTIPLE);
        public static final GT_Recipe.GT_Recipe_Map sMolecularTransformerRecipes = new GT_Recipe.GT_Recipe_Map(new HashSet(3), "gtpp.recipe.moleculartransformer", "Molecular Transformer", null, "", 1, 1, 0, 0, 1, "", 1, "", true, true).setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_MICROSCOPE);
        public static final GT_Recipe.GT_Recipe_Map sElementalDuplicatorRecipes = new GT_Recipe.GT_Recipe_Map(new HashSet(3), "gtpp.recipe.elementaldupe", "Elemental Duplicator", null, "", 1, 1, 0, 1, 1, "", 1, "", true, false);
        public static final GT_Recipe.GT_Recipe_Map sChemicalPlantRecipes = new GTPP_Recipe_Map_ChemicalPlant(new HashSet<GT_Recipe>(100), "gtpp.recipe.fluidchemicaleactor", "Chemical Plant", null, "", 4, 4, 0, 0, 1, "Tier: ", 1, "", true, true);
        public static final GT_Recipe.GT_Recipe_Map_Fuel sRTGFuels = (GT_Recipe.GT_Recipe_Map_Fuel)new GT_Recipe.GT_Recipe_Map_Fuel(new HashSet(10), "gtpp.recipe.RTGgenerators", "RTG", null, "", 1, 0, 0, 0, 1, "Fuel Value: ", 365, " Minecraft Days", true, true).useModularUI(true);
        public static final GT_Recipe.GT_Recipe_Map sThermalFuels = new GT_Recipe.GT_Recipe_Map_LargeNEI(new HashSet(10), "gtpp.recipe.thermalgeneratorfuel", "Thermal Generator Fuel", null, "", 9, 9, 0, 0, 1, null, 1000, null, true, true).setUsualFluidInputCount(3).setUsualFluidOutputCount(3);
        public static final GT_Recipe.GT_Recipe_Map sSolarTowerRecipes = new GT_Recipe.GT_Recipe_Map_FluidOnly(new HashSet(10), "gtpp.recipe.solartower", "Solar Tower", null, "", 0, 0, 0, 0, 1, null, 1000, null, true, true).useModularUI(true).setNEISpecialInfoFormatter((recipeInfo, applyPrefixAndSuffix) -> Arrays.asList("Solar Heater rings boost tier", "R1:T1, R2:T2, R3:T4, R4:T8, R5:T16", "Input Amount = 1000 x T"));
        public static final GT_Recipe.GT_Recipe_Map sCyclotronRecipes = new GT_Recipe.GT_Recipe_Map(new HashSet(200), "gtpp.recipe.cyclotron", "COMET - Compact Cyclotron", null, "", 9, 9, 0, 0, 1, "", 1, "", true, true).useModularUI(true);
        public static final GT_Recipe.GT_Recipe_Map sSlowFusionRecipes = new GT_Recipe.GT_Recipe_Map(new HashSet(50), "gtpp.recipe.slowfusionreactor", "Mimir - Slow Fusion", null, "", 0, 0, 0, 2, 1, "Start: ", 1, " EU", true, true).useModularUI(true);
        public static final GT_Recipe.GT_Recipe_Map sFishPondRecipes = new GT_Recipe.GT_Recipe_Map(new HashSet(3), "gtpp.recipe.fishpond", "Zhuhai - Fishing Port", null, "", 1, 1, 0, 0, 1, "", 1, "", true, true).setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_CAULDRON).setProgressBar(GT_UITextures.PROGRESSBAR_ARROW_MULTIPLE);
        public static final GT_Recipe.GT_Recipe_Map sSpargeTowerRecipes = new GT_Recipe.GT_Recipe_Map(new HashSet(10000), "gtpp.recipe.spargetower", "Sparging", null, "", 9, 9, 0, 0, 1, "", 1, "", true, false);
        public static final GT_Recipe.GT_Recipe_Map sAdvFreezerRecipes_GT = new GT_Recipe.GT_Recipe_Map(new HashSet(2000), "gtpp.recipe.cryogenicfreezer", "Cryogenic Freezer", null, "", 1, 1, 0, 0, 1, "", 0, "", false, true).setUsualFluidInputCount(2);
        public static final GT_Recipe.GT_Recipe_Map sMultiblockCentrifugeRecipes_GT = new GT_Recipe.GT_Recipe_Map_LargeNEI(new HashSet(2000), "gtpp.recipe.multicentrifuge", "Multiblock Centrifuge", null, "", 6, 6, 0, 0, 1, "", 0, "", false, true).setProgressBar(GT_UITextures.PROGRESSBAR_EXTRACT).setUsualFluidInputCount(6).setUsualFluidOutputCount(6);
        public static final GT_Recipe.GT_Recipe_Map sMultiblockElectrolyzerRecipes_GT = new GT_Recipe.GT_Recipe_Map_LargeNEI(new HashSet(2000), "gtpp.recipe.multielectro", "Multiblock Electrolyzer", null, "", 6, 6, 0, 0, 1, "", 0, "", false, true).setProgressBar(GT_UITextures.PROGRESSBAR_EXTRACT).setUsualFluidInputCount(6).setUsualFluidOutputCount(6);
        public static final GT_Recipe.GT_Recipe_Map sMultiblockMixerRecipes_GT = new GT_Recipe.GT_Recipe_Map_LargeNEI(new HashSet(2000), "gtpp.recipe.multimixer", "Multiblock Mixer", null, "", 9, 9, 0, 0, 1, "", 0, "", false, true).setProgressBar(GT_UITextures.PROGRESSBAR_MIXER, ProgressBar.Direction.CIRCULAR_CW).setUsualFluidInputCount(6).setUsualFluidOutputCount(6);
        public static final GT_Recipe.GT_Recipe_Map sMultiblockChemicalDehydratorRecipes = new GT_Recipe.GT_Recipe_Map_LargeNEI(new HashSet(2000), "gtpp.recipe.multidehydrator", "Multiblock Dehydrator", null, "", 6, 9, 0, 0, 1, "", 0, "", false, true).setUsualFluidInputCount(3).setUsualFluidOutputCount(3);
        public static final GT_Recipe.GT_Recipe_Map_Fuel sSemiFluidLiquidFuels = (GT_Recipe.GT_Recipe_Map_Fuel)new GT_Recipe.GT_Recipe_Map_Fuel(new HashSet(10), "gtpp.recipe.semifluidgeneratorfuels", "Semifluid Generator Fuels", null, "", 0, 0, 0, 0, 1, "Fuel Value: ", 1000, " EU", true, true).useModularUI(true);
        public static final GT_Recipe.GT_Recipe_Map sFlotationCellRecipes = new GT_Recipe.GT_Recipe_Map(new HashSet(10000), "gtpp.recipe.flotationcell", "Flotation Cell", null, "", 6, 0, 1, 1, 1, "", 1, "", true, true).useModularUI(true);
        public static final GT_Recipe.GT_Recipe_Map sTreeSimFakeRecipes = new GT_Recipe.GT_Recipe_Map(new HashSet(100), "gtpp.recipe.treefarm", "Tree Growth Simulator", null, "", 1, 2, 1, 0, 1, "", 1, "", false, true){

            protected void drawNEIEnergyInfo(NEIRecipeInfo recipeInfo) {
            }

            protected void drawNEIDurationInfo(NEIRecipeInfo recipeInfo) {
            }

            protected List<String> handleNEIItemOutputTooltip(List<String> currentTip, GT_NEI_DefaultHandler.FixedPositionedStack pStack) {
                if (ModItems.fluidFertBasic != null && pStack.isChanceBased()) {
                    currentTip.add(EnumChatFormatting.GRAY + "Outputted if " + ModItems.fluidFertBasic.getLocalizedName() + " is provided");
                } else {
                    super.handleNEIItemOutputTooltip(currentTip, pStack);
                }
                return currentTip;
            }

            protected void drawNEIOverlayForOutput(GT_NEI_DefaultHandler.FixedPositionedStack stack) {
            }
        }.useModularUI(true).setNEISpecialInfoFormatter((recipeInfo, applyPrefixAndSuffix) -> {
            ArrayList<String> result = new ArrayList<String>();
            if (ModItems.fluidFertBasic != null) {
                result.add("The sapling is not consumed.");
                result.add("If " + ModItems.fluidFertBasic.getLocalizedName() + " is provided,");
                result.add("Saplings are made instead");
            }
            return result;
        });
    }

    public static class GTPP_Recipe_Map_ChemicalPlant
    extends GT_Recipe.GT_Recipe_Map {
        private static final List<String> tierMaterialNames = Arrays.asList("Bronze", "Steel", "Aluminium", "Stainless Steel", "Titanium", "Tungsten Steel", "Laurenium", "Botmium");

        public GTPP_Recipe_Map_ChemicalPlant(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
            this.setSlotOverlay(false, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_MOLECULAR_1);
            this.setSlotOverlay(false, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_VIAL_1);
            this.setSlotOverlay(true, false, (IDrawable)GT_UITextures.OVERLAY_SLOT_MOLECULAR_3);
            this.setSlotOverlay(true, true, (IDrawable)GT_UITextures.OVERLAY_SLOT_VIAL_2);
            this.setProgressBar(GTPP_UITextures.PROGRESSBAR_FLUID_REACTOR, ProgressBar.Direction.CIRCULAR_CW);
            this.setProgressBarPos(82, 24);
            this.setUsualFluidInputCount(4);
            this.setUsualFluidOutputCount(2);
            this.setNEISpecialInfoFormatter((recipeInfo, applyPrefixAndSuffix) -> {
                int specialValue = recipeInfo.recipe.mSpecialValue;
                String tierMaterial = "";
                for (int i = 0; i < tierMaterialNames.size(); ++i) {
                    if (i != specialValue) continue;
                    tierMaterial = tierMaterialNames.get(i);
                }
                return Collections.singletonList((String)applyPrefixAndSuffix.apply(specialValue + 1) + " - " + tierMaterial);
            });
        }

        public List<Pos2d> getItemInputPositions(int itemInputCount) {
            return UIHelper.getGridPositions((int)itemInputCount, (int)7, (int)6, (int)itemInputCount, (int)1);
        }

        public List<Pos2d> getItemOutputPositions(int itemOutputCount) {
            return UIHelper.getGridPositions((int)itemOutputCount, (int)106, (int)15, (int)2);
        }

        public List<Pos2d> getFluidInputPositions(int fluidInputCount) {
            return UIHelper.getGridPositions((int)fluidInputCount, (int)7, (int)41, (int)fluidInputCount, (int)1);
        }

        public List<Pos2d> getFluidOutputPositions(int fluidOutputCount) {
            return UIHelper.getGridPositions((int)fluidOutputCount, (int)142, (int)15, (int)1, (int)fluidOutputCount);
        }

        protected List<String> handleNEIItemInputTooltip(List<String> currentTip, GT_NEI_DefaultHandler.FixedPositionedStack pStack) {
            if (ItemUtils.isCatalyst(pStack.item)) {
                currentTip.add(EnumChatFormatting.GRAY + "Does not always get consumed in the process");
                currentTip.add(EnumChatFormatting.GRAY + "Higher tier pipe casings allow this item to last longer");
            } else {
                super.handleNEIItemInputTooltip(currentTip, pStack);
            }
            return currentTip;
        }

        protected void drawNEIOverlayForInput(GT_NEI_DefaultHandler.FixedPositionedStack stack) {
            if (ItemUtils.isCatalyst(stack.item)) {
                this.drawNEIOverlayText("NC*", (PositionedStack)stack);
            } else {
                super.drawNEIOverlayForInput(stack);
            }
        }
    }

    public static class GTPP_Recipe_Map_Internal
    extends GT_Recipe.GT_Recipe_Map {
        @Deprecated
        public static final Collection<GTPP_Recipe_Map_Internal> sMappingsEx = new ArrayList<GTPP_Recipe_Map_Internal>();

        public GTPP_Recipe_Map_Internal(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }
    }
}

