/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.recipes;

import gregtech.api.GregTech_API;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.SemiFluidFuelHandler;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialGenerator;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.data.ArrayUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import gtPlusPlus.xmod.gregtech.api.interfaces.internal.IGregtech_RecipeAdder;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy_RTG;
import gtPlusPlus.xmod.gregtech.common.helpers.FlotationRecipeHandler;
import gtPlusPlus.xmod.gregtech.common.tileentities.generators.GregtechMetaTileEntity_RTG;
import gtPlusPlus.xmod.gregtech.recipes.machines.RECIPEHANDLER_MatterFabricator;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GregtechRecipeAdder
implements IGregtech_RecipeAdder {
    @Override
    public boolean addCokeOvenRecipe(ItemStack aInput1, ItemStack aInput2, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack aOutput, int aDuration, int aEUt) {
        if (aInput1 == null || aOutput == null || aFluidOutput == null) {
            Logger.WARNING("Something was null, returning false");
            return false;
        }
        if ((aDuration = GregTech_API.sRecipeFile.get((Object)"cokeoven", aOutput, aDuration)) <= 0) {
            Logger.WARNING("Something was null, returning false");
            return false;
        }
        aDuration = GregTech_API.sRecipeFile.get((Object)"cokeoven", aFluidOutput.getFluid().getName(), aDuration);
        if (aDuration <= 0) {
            Logger.WARNING("Something was null, returning false");
            return false;
        }
        GTPP_Recipe aSpecialRecipe = new GTPP_Recipe(true, new ItemStack[]{aInput1, aInput2}, new ItemStack[]{aOutput}, null, new int[0], new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, Math.max(1, aEUt), 0);
        GTPP_Recipe.GTPP_Recipe_Map.sCokeOvenRecipes.add((GT_Recipe)aSpecialRecipe);
        return true;
    }

    @Override
    public boolean addCokeOvenRecipe(int aCircuit, ItemStack aInput2, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack[] aOutputs, int aDuration, int aEUt) {
        return this.addCokeOvenRecipe(aInput2, CI.getNumberedCircuit(aCircuit), aFluidInputs, aFluidOutputs, aOutputs, aDuration, aEUt);
    }

    @Override
    public boolean addCokeOvenRecipe(ItemStack aInput1, ItemStack aInput2, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack[] aOutputs, int aDuration, int aEUt) {
        GTPP_Recipe aSpecialRecipe = new GTPP_Recipe(true, new ItemStack[]{aInput1, aInput2}, aOutputs, null, new int[0], aFluidInputs, aFluidOutputs, Math.max(1, aDuration), Math.max(1, aEUt), 0);
        GTPP_Recipe.GTPP_Recipe_Map.sCokeOvenRecipes.add((GT_Recipe)aSpecialRecipe);
        return true;
    }

    @Override
    public boolean addMatterFabricatorRecipe(FluidStack aFluidInput, FluidStack aFluidOutput, int aDuration, int aEUt) {
        FluidStack[] fluidStackArray;
        if (aFluidOutput == null) {
            Logger.WARNING("Something was null, returning false");
            return false;
        }
        ItemStack[] itemStackArray = new ItemStack[]{};
        ItemStack[] itemStackArray2 = new ItemStack[]{};
        int[] nArray = new int[]{};
        if (aFluidInput == null) {
            fluidStackArray = new FluidStack[]{};
        } else {
            FluidStack[] fluidStackArray2 = new FluidStack[1];
            fluidStackArray = fluidStackArray2;
            fluidStackArray2[0] = aFluidInput;
        }
        GTPP_Recipe aRecipe = new GTPP_Recipe(false, itemStackArray, itemStackArray2, null, nArray, fluidStackArray, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0);
        GTPP_Recipe.GTPP_Recipe_Map.sMatterFab2Recipes.addRecipe((GT_Recipe)aRecipe);
        RECIPEHANDLER_MatterFabricator.debug5(aFluidInput, aFluidOutput, aDuration, aEUt);
        return true;
    }

    @Override
    public boolean addDehydratorRecipe(ItemStack[] aInput, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack[] aOutputItems, int[] aChances, int aDuration, int aEUt) throws IndexOutOfBoundsException {
        if ((aInput == null || aInput.length == 0) && aFluidInput == null || (aOutputItems == null || aOutputItems.length == 0) && aFluidOutput == null) {
            return false;
        }
        GTPP_Recipe aSpecialRecipe = new GTPP_Recipe(true, aInput, aOutputItems, null, aChances, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, Math.max(1, aDuration), Math.max(1, aEUt), 0);
        GTPP_Recipe.GTPP_Recipe_Map.sChemicalDehydratorRecipes.add(aSpecialRecipe);
        return true;
    }

    @Override
    public boolean addBlastSmelterRecipe(ItemStack[] aInput, FluidStack aOutput, int aChance, int aDuration, int aEUt) {
        return this.addBlastSmelterRecipe(aInput, (FluidStack)null, aOutput, new ItemStack[0], new int[]{aChance}, aDuration, aEUt, 3700);
    }

    @Override
    public boolean addBlastSmelterRecipe(ItemStack[] aInput, FluidStack aInputFluid, FluidStack aOutput, int aChance, int aDuration, int aEUt) {
        return this.addBlastSmelterRecipe(aInput, aInputFluid, aOutput, new ItemStack[0], new int[]{aChance}, aDuration, aEUt, 3700);
    }

    @Override
    public boolean addBlastSmelterRecipe(ItemStack[] aInput, FluidStack[] aInputFluid, FluidStack aOutput, int aChance, int aDuration, int aEUt) {
        return this.addBlastSmelterRecipe(aInput, aInputFluid, aOutput, new ItemStack[0], new int[]{aChance}, aDuration, aEUt, 3700);
    }

    @Override
    public boolean addBlastSmelterRecipe(ItemStack[] aInput, FluidStack aInputFluid, FluidStack aOutput, ItemStack[] aOutputStack, int[] aChance, int aDuration, int aEUt) {
        return this.addBlastSmelterRecipe(aInput, aInputFluid, aOutput, aOutputStack, aChance, aDuration, aEUt, 3700);
    }

    @Override
    public boolean addBlastSmelterRecipe(ItemStack[] aInput, FluidStack[] aInputFluid, FluidStack aOutput, ItemStack[] aOutputStack, int[] aChance, int aDuration, int aEUt) {
        return this.addBlastSmelterRecipe(aInput, aInputFluid, aOutput, aOutputStack, aChance, aDuration, aEUt, 3700);
    }

    @Override
    public boolean addBlastSmelterRecipe(ItemStack[] aInput, FluidStack aInputFluid, FluidStack aOutput, int aChance, int aDuration, int aEUt, int aSpecialValue) {
        return this.addBlastSmelterRecipe(aInput, aInputFluid, aOutput, new ItemStack[0], new int[]{aChance}, aDuration, aEUt, aSpecialValue);
    }

    @Override
    public boolean addBlastSmelterRecipe(ItemStack[] aInput, FluidStack[] aInputFluid, FluidStack aOutput, int aChance, int aDuration, int aEUt, int aSpecialValue) {
        return this.addBlastSmelterRecipe(aInput, aInputFluid, aOutput, new ItemStack[0], new int[]{aChance}, aDuration, aEUt, aSpecialValue);
    }

    @Override
    public boolean addBlastSmelterRecipe(ItemStack[] aInput, FluidStack aInputFluid, FluidStack aOutput, ItemStack[] aOutputStack, int[] aChance, int aDuration, int aEUt, int aSpecialValue) {
        return this.addBlastSmelterRecipe(aInput, aInputFluid, aOutput, aOutputStack, aChance, aDuration, aEUt, aSpecialValue, true);
    }

    @Override
    public boolean addBlastSmelterRecipe(ItemStack[] aInput, FluidStack[] aInputFluid, FluidStack aOutput, ItemStack[] aOutputStack, int[] aChance, int aDuration, int aEUt, int aSpecialValue) {
        return this.addBlastSmelterRecipe(aInput, aInputFluid, aOutput, aOutputStack, aChance, aDuration, aEUt, aSpecialValue, true);
    }

    @Override
    public boolean addBlastSmelterRecipe(ItemStack[] aInput, FluidStack aInputFluid, FluidStack aOutput, ItemStack[] aOutputStack, int[] aChance, int aDuration, int aEUt, int aSpecialValue, boolean aOptimizeRecipe) {
        return this.addBlastSmelterRecipe(aInput, new FluidStack[]{aInputFluid}, aOutput, aOutputStack, aChance, aDuration, aEUt, aSpecialValue, aOptimizeRecipe);
    }

    @Override
    public boolean addBlastSmelterRecipe(ItemStack[] aInput, FluidStack[] aInputFluid, FluidStack aOutput, ItemStack[] aOutputStack, int[] aChance, int aDuration, int aEUt, int aSpecialValue, boolean aOptimizeRecipe) {
        if (aInput == null || aOutput == null) {
            Logger.WARNING("Fail - Input or Output was null.");
            return false;
        }
        if (aOutput.isFluidEqual(Materials.PhasedGold.getMolten(1L))) {
            aOutput = Materials.VibrantAlloy.getMolten((long)aOutput.amount);
        }
        if (aOutput.isFluidEqual(Materials.PhasedIron.getMolten(1L))) {
            aOutput = Materials.PulsatingIron.getMolten((long)aOutput.amount);
        }
        if ((aDuration = GregTech_API.sRecipeFile.get((Object)"blastsmelter", aOutput.getFluid().getName(), aDuration)) <= 0) {
            Logger.WARNING("Recipe did not register.");
            return false;
        }
        if ((aInput = ArrayUtils.removeNulls(aInput)).length <= 1) {
            return false;
        }
        GTPP_Recipe.GTPP_Recipe_Map.sAlloyBlastSmelterRecipes.addRecipe(aOptimizeRecipe, aInput, aOutputStack, null, aChance, aInputFluid, new FluidStack[]{aOutput}, aDuration, Math.max(1, aEUt), aSpecialValue);
        return true;
    }

    @Override
    public boolean addQuantumTransformerRecipe(ItemStack[] aInput, FluidStack[] aFluidInput, FluidStack[] aFluidOutput, ItemStack[] aOutputStack, int[] aChances, int aDuration, int aEUt, int aSpecialValue) {
        if (aInput == null) {
            aInput = new ItemStack[]{};
        }
        if (aFluidInput == null) {
            aFluidInput = new FluidStack[]{};
        }
        if (aOutputStack == null) {
            aOutputStack = new ItemStack[]{};
        }
        if (aFluidOutput == null) {
            aFluidOutput = new FluidStack[]{};
        }
        GTPP_Recipe.GTPP_Recipe_Map.sQuantumForceTransformerRecipes.add(new GT_Recipe(false, aInput, aOutputStack, null, aChances, aFluidInput, aFluidOutput, aDuration, aEUt, aSpecialValue));
        return true;
    }

    @Override
    public boolean addFissionFuel(FluidStack aInput1, FluidStack aInput2, FluidStack aInput3, FluidStack aInput4, FluidStack aInput5, FluidStack aInput6, FluidStack aInput7, FluidStack aInput8, FluidStack aInput9, FluidStack aOutput1, FluidStack aOutput2, int aDuration, int aEUt) {
        return this.addFissionFuel(false, aInput1, aInput2, aInput3, aInput4, aInput5, aInput6, aInput7, aInput8, aInput9, aOutput1, aOutput2, aDuration, aEUt);
    }

    @Override
    public boolean addFissionFuel(boolean aOptimise, FluidStack aInput1, FluidStack aInput2, FluidStack aInput3, FluidStack aInput4, FluidStack aInput5, FluidStack aInput6, FluidStack aInput7, FluidStack aInput8, FluidStack aInput9, FluidStack aOutput1, FluidStack aOutput2, int aDuration, int aEUt) {
        if (aInput1 == null || aOutput1 == null || aDuration < 1 || aEUt < 1) {
            return false;
        }
        FluidStack[] inputs = new FluidStack[]{aInput1, aInput2, aInput3, aInput4, aInput5, aInput6, aInput7, aInput8, aInput9};
        FluidStack[] outputs = new FluidStack[]{aOutput1, aOutput2};
        GTPP_Recipe.GTPP_Recipe_Map.sFissionFuelProcessing.addRecipe(aOptimise, new ItemStack[0], new ItemStack[0], null, new int[0], inputs, outputs, aDuration, aEUt, 0);
        return true;
    }

    @Override
    public boolean addCyclotronRecipe(ItemStack aInputs, FluidStack aFluidInput, ItemStack[] aOutputs, FluidStack aFluidOutput, int[] aChances, int aDuration, int aEUt, int aSpecialValue) {
        return this.addCyclotronRecipe(new ItemStack[]{aInputs}, aFluidInput, aOutputs, aFluidOutput, aChances, aDuration, aEUt, aSpecialValue);
    }

    @Override
    public boolean addCyclotronRecipe(ItemStack[] aInputs, FluidStack aFluidInput, ItemStack[] aOutput, FluidStack aFluidOutput, int[] aChances, int aDuration, int aEUt, int aSpecialValue) {
        if (aOutput == null || aOutput.length < 1 || !ItemUtils.checkForInvalidItems(aOutput)) {
            Logger.INFO("Bad output for Cyclotron Recipe.");
            return false;
        }
        GTPP_Recipe aSpecialRecipe = new GTPP_Recipe(true, aInputs, aOutput, null, aChances, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, Math.max(1, aDuration), Math.max(1, aEUt), aSpecialValue);
        GTPP_Recipe.GTPP_Recipe_Map.sCyclotronRecipes.add((GT_Recipe)aSpecialRecipe);
        return true;
    }

    @Override
    public boolean addMixerRecipe(ItemStack aInput1, ItemStack aInput2, ItemStack aInput3, ItemStack aInput4, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack aOutput1, ItemStack aOutput2, ItemStack aOutput3, ItemStack aOutput4, int aDuration, int aEUt) {
        if (aInput1 == null && aFluidInput == null || aOutput1 == null && aFluidOutput == null) {
            return false;
        }
        GTPP_Recipe aSpecialRecipe = new GTPP_Recipe(true, new ItemStack[]{aInput1, aInput2, aInput3, aInput4}, new ItemStack[]{aOutput1, aOutput2, aOutput3, aOutput4}, null, new int[0], new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, Math.max(1, aDuration), Math.max(1, aEUt), 0);
        GT_Recipe.GT_Recipe_Map.sMixerRecipes.add((GT_Recipe)aSpecialRecipe);
        return true;
    }

    @Override
    public boolean addComponentMakerRecipe(ItemStack[] aInputs, FluidStack aFluidInput, ItemStack aOutput1, int aDuration, int aEUt) {
        return false;
    }

    @Override
    public boolean addMultiblockCentrifugeRecipe(ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack[] aOutputs, int[] aChances, int aDuration, int aEUtick, int aSpecial) {
        if (this.areItemsAndFluidsBothNull(aInputs, aFluidInputs) || this.areItemsAndFluidsBothNull(aOutputs, aFluidOutputs) || aEUtick <= 0) {
            return false;
        }
        if (!ItemUtils.checkForInvalidItems(aInputs, aOutputs)) {
            Logger.INFO("[Recipe] Error generating Large Centrifuge recipe.");
            Logger.INFO("Inputs: " + ItemUtils.getArrayStackNames(aInputs));
            Logger.INFO("Fluid Inputs: " + ItemUtils.getArrayStackNames(aFluidInputs));
            Logger.INFO("Outputs: " + ItemUtils.getArrayStackNames(aOutputs));
            Logger.INFO("Fluid Outputs: " + ItemUtils.getArrayStackNames(aFluidOutputs));
            return false;
        }
        GTPP_Recipe aRecipe = new GTPP_Recipe(false, aInputs, aOutputs, null, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUtick, aSpecial);
        GTPP_Recipe.GTPP_Recipe_Map.sMultiblockCentrifugeRecipes_GT.addRecipe((GT_Recipe)aRecipe);
        return true;
    }

    @Override
    public boolean addMultiblockElectrolyzerRecipe(ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack[] aOutputs, int[] aChances, int aDuration, int aEUtick, int aSpecial) {
        if (this.areItemsAndFluidsBothNull(aInputs, aFluidInputs) || this.areItemsAndFluidsBothNull(aOutputs, aFluidOutputs) || aEUtick <= 0) {
            return false;
        }
        if (!ItemUtils.checkForInvalidItems(aInputs, aOutputs)) {
            Logger.INFO("[Recipe] Error generating Large Electrolyzer recipe.");
            Logger.INFO("Inputs: " + ItemUtils.getArrayStackNames(aInputs));
            Logger.INFO("Fluid Inputs: " + ItemUtils.getArrayStackNames(aFluidInputs));
            Logger.INFO("Outputs: " + ItemUtils.getArrayStackNames(aOutputs));
            Logger.INFO("Fluid Outputs: " + ItemUtils.getArrayStackNames(aFluidOutputs));
            return false;
        }
        GTPP_Recipe aRecipe = new GTPP_Recipe(false, aInputs, aOutputs, null, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUtick, aSpecial);
        GTPP_Recipe.GTPP_Recipe_Map.sMultiblockElectrolyzerRecipes_GT.addRecipe((GT_Recipe)aRecipe);
        return true;
    }

    @Override
    public boolean addAdvancedFreezerRecipe(ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack[] aOutputs, int[] aChances, int aDuration, int aEUtick, int aSpecial) {
        if (this.areItemsAndFluidsBothNull(aInputs, aFluidInputs) || this.areItemsAndFluidsBothNull(aOutputs, aFluidOutputs) || aEUtick <= 0) {
            return false;
        }
        if (!ItemUtils.checkForInvalidItems(aInputs, aOutputs)) {
            Logger.INFO("[Recipe] Error generating Adv. Vac Freezer recipe.");
            Logger.INFO("Inputs: " + ItemUtils.getArrayStackNames(aInputs));
            Logger.INFO("Fluid Inputs: " + ItemUtils.getArrayStackNames(aFluidInputs));
            Logger.INFO("Outputs: " + ItemUtils.getArrayStackNames(aOutputs));
            Logger.INFO("Fluid Outputs: " + ItemUtils.getArrayStackNames(aFluidOutputs));
            return false;
        }
        GTPP_Recipe aRecipe = new GTPP_Recipe(false, aInputs, aOutputs, null, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUtick, aSpecial);
        GTPP_Recipe.GTPP_Recipe_Map.sAdvFreezerRecipes_GT.addRecipe((GT_Recipe)aRecipe);
        return false;
    }

    public boolean addMultiblockMixerRecipe(ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack[] aOutputs, int[] aChances, int aDuration, int aEUtick, int aSpecial) {
        if (this.areItemsAndFluidsBothNull(aInputs, aFluidInputs) || this.areItemsAndFluidsBothNull(aOutputs, aFluidOutputs) || aEUtick <= 0) {
            return false;
        }
        if (!ItemUtils.checkForInvalidItems(aInputs, aOutputs)) {
            Logger.INFO("[Recipe] Error generating Large Mixer recipe.");
            Logger.INFO("Inputs: " + ItemUtils.getArrayStackNames(aInputs));
            Logger.INFO("Fluid Inputs: " + ItemUtils.getArrayStackNames(aFluidInputs));
            Logger.INFO("Outputs: " + ItemUtils.getArrayStackNames(aOutputs));
            Logger.INFO("Fluid Outputs: " + ItemUtils.getArrayStackNames(aFluidOutputs));
            return false;
        }
        GTPP_Recipe aRecipe = new GTPP_Recipe(false, aInputs, aOutputs, null, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUtick, aSpecial);
        GTPP_Recipe.GTPP_Recipe_Map.sMultiblockMixerRecipes_GT.addRecipe((GT_Recipe)aRecipe);
        return true;
    }

    public boolean addMultiblockChemicalDehydratorRecipe(ItemStack[] aInputs, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, ItemStack[] aOutputs, int[] aChances, int aDuration, int aEUtick, int aSpecial) {
        if (this.areItemsAndFluidsBothNull(aInputs, aFluidInputs) || this.areItemsAndFluidsBothNull(aOutputs, aFluidOutputs) || aEUtick <= 0) {
            return false;
        }
        if (!ItemUtils.checkForInvalidItems(aInputs, aOutputs)) {
            Logger.INFO("[Recipe] Error generating Large Chemical Dehydrator recipe.");
            Logger.INFO("Inputs: " + ItemUtils.getArrayStackNames(aInputs));
            Logger.INFO("Fluid Inputs: " + ItemUtils.getArrayStackNames(aFluidInputs));
            Logger.INFO("Outputs: " + ItemUtils.getArrayStackNames(aOutputs));
            Logger.INFO("Fluid Outputs: " + ItemUtils.getArrayStackNames(aFluidOutputs));
            return false;
        }
        GTPP_Recipe aRecipe = new GTPP_Recipe(false, aInputs, aOutputs, null, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUtick, aSpecial);
        GTPP_Recipe.GTPP_Recipe_Map.sMultiblockChemicalDehydratorRecipes.addRecipe((GT_Recipe)aRecipe);
        return true;
    }

    @Override
    public boolean addSixSlotAssemblingRecipe(ItemStack[] aInputs, FluidStack aInputFluid, ItemStack aOutput1, int aDuration, int aEUt) {
        return GT_Values.RA.addAssemblerRecipe(aInputs, aInputFluid, aOutput1, aDuration, aEUt);
    }

    @Override
    public boolean addAssemblylineRecipe(ItemStack aResearchItem, int aResearchTime, ItemStack[] aInputs, FluidStack[] aFluidInputs, ItemStack aOutput, int aDuration, int aEUt) {
        return GT_Values.RA.addAssemblylineRecipe(aResearchItem, aResearchTime, aInputs, aFluidInputs, aOutput, aDuration, aEUt);
    }

    @Override
    public boolean addAssemblylineRecipe(ItemStack aResearchItem, int aResearchTime, Object[] aInputs, FluidStack[] aFluidInputs, ItemStack aOutput, int aDuration, int aEUt) {
        return GT_Values.RA.addAssemblylineRecipe(aResearchItem, aResearchTime, aInputs, aFluidInputs, aOutput, aDuration, aEUt);
    }

    @Override
    public boolean addChemicalRecipe(ItemStack input1, ItemStack input2, FluidStack inputFluid, FluidStack outputFluid, ItemStack output, int time, int eu) {
        return this.addChemicalRecipe(input1, input2, inputFluid, outputFluid, output, null, time, eu);
    }

    @Override
    public boolean addChemicalRecipe(ItemStack input1, ItemStack input2, FluidStack inputFluid, FluidStack outputFluid, ItemStack output, Object object, int time, int eu) {
        return GT_Values.RA.addChemicalRecipe(input1, input2, inputFluid, outputFluid, output, time, eu);
    }

    @Override
    public boolean addChemicalRecipe(ItemStack input1, ItemStack input2, FluidStack inputFluid, FluidStack outputFluid, ItemStack output, ItemStack output2, int time) {
        return GT_Values.RA.addChemicalRecipe(input1, input2, inputFluid, outputFluid, output, output2, time);
    }

    @Override
    public boolean addChemicalRecipe(ItemStack input1, ItemStack input2, int aCircuit, FluidStack inputFluid, FluidStack outputFluid, ItemStack output, ItemStack output2, int time, int eu) {
        if (aCircuit < 0 || aCircuit > 24) {
            aCircuit = 22;
        }
        GTPP_Recipe aSpecialRecipe = new GTPP_Recipe(false, new ItemStack[]{input1, input2}, new ItemStack[]{output, output2}, CI.getNumberedCircuit(aCircuit), new int[0], new FluidStack[]{inputFluid}, new FluidStack[]{outputFluid}, time, eu, 0);
        return GT_Recipe.GT_Recipe_Map.sChemicalRecipes.mRecipeList.add(aSpecialRecipe);
    }

    @Override
    public boolean addMultiblockChemicalRecipe(ItemStack[] itemStacks, FluidStack[] fluidStacks, FluidStack[] fluidStacks2, ItemStack[] outputs, int time, int eu) {
        return GT_Values.RA.addMultiblockChemicalRecipe(itemStacks, fluidStacks, fluidStacks2, outputs, time, eu);
    }

    private boolean areItemsAndFluidsBothNull(ItemStack[] items, FluidStack[] fluids) {
        boolean itemsNull = true;
        if (items != null) {
            for (ItemStack itemStack : items) {
                if (itemStack == null) continue;
                itemsNull = false;
                break;
            }
        }
        boolean fluidsNull = true;
        if (fluids != null) {
            for (FluidStack fluidStack : fluids) {
                if (fluidStack == null) continue;
                fluidsNull = false;
                break;
            }
        }
        return itemsNull && fluidsNull;
    }

    @Override
    public boolean addCompressorRecipe(ItemStack aInput1, ItemStack aOutput1, int aDuration, int aEUt) {
        if (aInput1 == null || aOutput1 == null) {
            return false;
        }
        if ((aDuration = GregTech_API.sRecipeFile.get((Object)"compressor", aInput1, aDuration)) <= 0) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sCompressorRecipes.addRecipe(true, new ItemStack[]{aInput1}, new ItemStack[]{aOutput1}, null, null, null, aDuration, aEUt, 0);
        return true;
    }

    @Override
    public boolean addBrewingRecipe(int aCircuit, FluidStack aInput, FluidStack aOutput, int aTime, int aEu, boolean aHidden) {
        return this.addBrewingRecipe(CI.getNumberedCircuit(aCircuit), aInput, aOutput, aTime, aEu, aHidden);
    }

    @Override
    public boolean addBrewingRecipe(ItemStack aIngredient, FluidStack aInput, FluidStack aOutput, int aTime, int aEu, boolean aHidden) {
        if (aIngredient == null || aInput == null || aOutput == null) {
            return false;
        }
        if (!GregTech_API.sRecipeFile.get((Object)"brewing", aOutput.getUnlocalizedName(), true)) {
            return false;
        }
        GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sBrewingRecipes.addRecipe(false, new ItemStack[]{aIngredient}, null, null, new FluidStack[]{aInput}, new FluidStack[]{aOutput}, aTime, aEu, 0);
        if (aHidden && tRecipe != null) {
            tRecipe.mHidden = true;
        }
        return true;
    }

    @Override
    public boolean addSmeltingAndAlloySmeltingRecipe(ItemStack aDust, ItemStack aOutput) {
        return GT_ModHandler.addSmeltingAndAlloySmeltingRecipe((ItemStack)aDust, (ItemStack)aOutput, (boolean)true);
    }

    @Override
    public boolean addFluidExtractionRecipe(ItemStack input, FluidStack output, int aTime, int aEu) {
        return GT_Values.RA.addFluidSmelterRecipe(GT_Utility.copyAmount((long)1L, (Object[])new Object[]{input}), null, output, 10000, aTime, aEu, false);
    }

    @Override
    public boolean addFluidExtractionRecipe(ItemStack aEmpty, ItemStack aRemains, FluidStack aFluid, int aDuration, int aEU) {
        return GT_Values.RA.addFluidSmelterRecipe(GT_Utility.copyAmount((long)1L, (Object[])new Object[]{aEmpty}), aRemains, aFluid, 10000, aDuration, aEU, false);
    }

    @Override
    public boolean addFluidCannerRecipe(ItemStack aContainer, ItemStack aFullContainer, FluidStack rFluidIn) {
        return MaterialGenerator.addFluidCannerRecipe(aContainer, aFullContainer, rFluidIn, null);
    }

    @Override
    public boolean addFluidCannerRecipe(ItemStack aContainer, ItemStack aFullContainer, FluidStack rFluidIn, FluidStack rFluidOut) {
        return MaterialGenerator.addFluidCannerRecipe(aContainer, aFullContainer, rFluidIn, rFluidOut);
    }

    @Override
    public boolean addFluidCannerRecipe(ItemStack aFullContainer, ItemStack container, FluidStack rFluidIn, FluidStack rFluidOut, int aTime, int aEu) {
        return MaterialGenerator.addFluidCannerRecipe(container, aFullContainer, rFluidIn, rFluidOut, aTime, aEu);
    }

    @Override
    public boolean addSemifluidFuel(ItemStack aFuelItem, int aFuelValue) {
        return SemiFluidFuelHandler.addSemiFluidFuel(aFuelItem, aFuelValue);
    }

    @Override
    public boolean addSemifluidFuel(FluidStack aFuelItem, int aFuelValue) {
        return SemiFluidFuelHandler.addSemiFluidFuel(aFuelItem, aFuelValue);
    }

    @Override
    public boolean addVacuumFurnaceRecipe(ItemStack aInput1, ItemStack aInput2, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack aOutput1, ItemStack aOutput2, int aDuration, int aEUt, int aLevel) {
        if (aInput1 != null && aOutput1 != null) {
            return this.addVacuumFurnaceRecipe(new ItemStack[]{aInput1, aInput2}, new FluidStack[]{aFluidInput}, new ItemStack[]{aOutput1, aOutput2}, new FluidStack[]{aFluidOutput}, aDuration, aEUt, aLevel);
        }
        return false;
    }

    @Override
    public boolean addVacuumFurnaceRecipe(ItemStack[] aInputs, FluidStack[] aFluidInputs, ItemStack[] aOutputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aLevel) {
        if (aInputs != null && aOutputs != null) {
            GTPP_Recipe.GTPP_Recipe_Map.sVacuumFurnaceRecipes.addRecipe(false, aInputs, aOutputs, null, new int[0], aFluidInputs, aFluidOutputs, aDuration, aEUt, aLevel);
            return true;
        }
        return false;
    }

    @Override
    public boolean addUvLaserRecipe(ItemStack aInput1, ItemStack aOutput, int time, long eu) {
        GTPP_Recipe u = new GTPP_Recipe(false, new ItemStack[]{aInput1, GregtechItemList.Laser_Lens_WoodsGlass.get(0L, new Object[0])}, new ItemStack[]{aOutput}, null, new int[]{10000}, new FluidStack[0], new FluidStack[0], time, (int)eu, 0);
        return GT_Recipe.GT_Recipe_Map.sLaserEngraverRecipes.mRecipeList.add(u);
    }

    @Override
    public boolean addChemicalPlantRecipe(ItemStack[] aInputs, FluidStack[] aInputFluids, ItemStack[] aOutputs, FluidStack[] aFluidOutputs, int time, long eu, int aTier) {
        return this.addChemicalPlantRecipe(aInputs, aInputFluids, aOutputs, aFluidOutputs, new int[0], time, eu, aTier);
    }

    @Override
    public boolean addChemicalPlantRecipe(ItemStack[] aInputs, FluidStack[] aInputFluids, ItemStack[] aOutputs, FluidStack[] aFluidOutputs, int[] aChances, int time, long eu, int aTier) {
        if (aInputs.length > 4 || aInputFluids.length > 4 || aOutputs.length > 4 || aFluidOutputs.length > 2) {
            Logger.INFO("Inputs: " + ItemUtils.getArrayStackNames(aInputs));
            Logger.INFO("Fluid Inputs: " + ItemUtils.getArrayStackNames(aInputFluids));
            Logger.INFO("Outputs: " + ItemUtils.getArrayStackNames(aOutputs));
            Logger.INFO("Fluid Outputs: " + ItemUtils.getArrayStackNames(aFluidOutputs));
            CORE.crash();
        }
        GTPP_Recipe.GTPP_Recipe_Map.sChemicalPlantRecipes.addRecipe(false, aInputs, aOutputs, null, aChances, aInputFluids, aFluidOutputs, time, (int)eu, aTier);
        return true;
    }

    @Override
    public boolean addBlastRecipe(ItemStack[] aInputs, FluidStack[] aInputFluids, ItemStack[] aOutputs, FluidStack[] aFluidOutputs, int time, long eu, int aHeat) {
        GTPP_Recipe aSpecialRecipe = new GTPP_Recipe(false, aInputs, aOutputs, null, new int[0], aInputFluids, aFluidOutputs, time, (int)eu, aHeat);
        GT_Recipe.GT_Recipe_Map.sBlastRecipes.add((GT_Recipe)aSpecialRecipe);
        return true;
    }

    @Override
    public boolean addPyrolyseRecipe(ItemStack aInput, FluidStack aFluidInput, int intCircuit, ItemStack aOutput, FluidStack aFluidOutput, int aDuration, int aEUt) {
        return GT_Values.RA.addPyrolyseRecipe(aInput, aFluidInput, intCircuit, aOutput, aFluidOutput, aDuration, aEUt);
    }

    @Override
    public boolean addDistilleryRecipe(ItemStack aCircuit, FluidStack aInput, FluidStack aOutput, ItemStack aSolidOutput, int aDuration, int aEUt, boolean aHidden) {
        if (aInput != null && aOutput != null) {
            aDuration = GregTech_API.sRecipeFile.get((Object)"distillery", aOutput.getFluid().getUnlocalizedName(), aDuration);
            if (aDuration <= 0) {
                return false;
            }
            GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sDistilleryRecipes.addRecipe(true, new ItemStack[]{aCircuit}, new ItemStack[]{aSolidOutput}, null, new FluidStack[]{aInput}, new FluidStack[]{aOutput}, aDuration, aEUt, 0);
            if (aHidden && tRecipe != null) {
                tRecipe.mHidden = true;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addExtractorRecipe(ItemStack aInput, ItemStack aOutput, int aDuration, int aEUt) {
        return this.addExtractorRecipe(aInput, aOutput, 10000, aDuration, aEUt);
    }

    @Override
    public boolean addExtractorRecipe(ItemStack aInput, ItemStack aOutput, int aChance, int aDuration, int aEUt) {
        if (aInput != null && aOutput != null) {
            GTPP_Recipe aRecipe = new GTPP_Recipe(false, new ItemStack[]{aInput.func_77946_l()}, new ItemStack[]{aOutput.func_77946_l()}, null, new int[]{aChance}, null, null, aDuration, aEUt, 0);
            GT_Recipe.GT_Recipe_Map.sExtractorRecipes.add((GT_Recipe)aRecipe);
            return true;
        }
        return false;
    }

    @Override
    public boolean addPulverisationRecipe(ItemStack aInput, ItemStack aOutput1, ItemStack aOutput2, ItemStack aOutput3) {
        aOutput1 = GT_OreDictUnificator.get((boolean)true, (ItemStack)aOutput1);
        aOutput2 = GT_OreDictUnificator.get((boolean)true, (ItemStack)aOutput2);
        aOutput3 = GT_OreDictUnificator.get((boolean)true, (ItemStack)aOutput3);
        if (GT_Utility.isStackInvalid((Object)aInput) || GT_Utility.isStackInvalid((Object)aOutput1)) {
            return false;
        }
        if (GT_Utility.getContainerItem((ItemStack)aInput, (boolean)false) == null) {
            if (GregTech_API.sRecipeFile.get((Object)ConfigCategories.Machines.maceration, aInput, true)) {
                GT_Utility.addSimpleIC2MachineRecipe((ItemStack)aInput, (Map)GT_ModHandler.getMaceratorRecipeList(), null, (Object[])new Object[]{aOutput1});
            }
            GT_Values.RA.addPulveriserRecipe(aInput, new ItemStack[]{aOutput1, aOutput2, aOutput3}, new int[]{10000, 10000, 10000}, 400, 2);
        }
        return true;
    }

    @Override
    public boolean addMillingRecipe(Materials aMat, int aEU) {
        return this.addMillingRecipe(MaterialUtils.generateMaterialFromGtENUM(aMat), aEU);
    }

    @Override
    public boolean addMillingRecipe(Material aMat, int aEU) {
        ItemStack aOreStack = aMat.getOre(16);
        ItemStack aCrushedStack = aMat.getCrushed(16);
        ItemStack aMilledStackOres1 = aMat.getMilled(64);
        ItemStack aMilledStackCrushed1 = aMat.getMilled(32);
        ItemStack aMilledStackOres2 = aMat.getMilled(48);
        ItemStack aMilledStackCrushed2 = aMat.getMilled(16);
        ItemStack aMillingBall_Alumina = GregtechItemList.Milling_Ball_Alumina.get(0L, new Object[0]);
        ItemStack aMillingBall_Soapstone = GregtechItemList.Milling_Ball_Soapstone.get(0L, new Object[0]);
        ItemStack[] aInputsOre1 = new ItemStack[]{CI.getNumberedCircuit(10), aOreStack, aMillingBall_Alumina};
        ItemStack[] aInputsOre2 = new ItemStack[]{CI.getNumberedCircuit(11), aOreStack, aMillingBall_Soapstone};
        ItemStack[] aInputsCrushed1 = new ItemStack[]{CI.getNumberedCircuit(10), aCrushedStack, aMillingBall_Alumina};
        ItemStack[] aInputsCrushed2 = new ItemStack[]{CI.getNumberedCircuit(11), aCrushedStack, aMillingBall_Soapstone};
        ItemStack[] aOutputsOre1 = new ItemStack[]{aMilledStackOres1};
        ItemStack[] aOutputsOre2 = new ItemStack[]{aMilledStackOres2};
        ItemStack[] aOutputsCrushed1 = new ItemStack[]{aMilledStackCrushed1};
        ItemStack[] aOutputsCrushed2 = new ItemStack[]{aMilledStackCrushed2};
        ItemStack[][] aInputArray = new ItemStack[][]{aInputsOre1, aInputsOre2, aInputsCrushed1, aInputsCrushed2};
        ItemStack[][] aOutputArray = new ItemStack[][]{aOutputsOre1, aOutputsOre2, aOutputsCrushed1, aOutputsCrushed2};
        int[] aTime = new int[]{2400, 3000, 1200, 1500};
        for (int i = 0; i < 4; ++i) {
            GTPP_Recipe aOreRecipe = new GTPP_Recipe(false, aInputArray[i], aOutputArray[i], null, new int[0], null, null, aTime[i], aEU, 0);
            GTPP_Recipe.GTPP_Recipe_Map.sOreMillRecipes.add((GT_Recipe)aOreRecipe);
        }
        return true;
    }

    @Override
    public boolean addFlotationRecipe(Materials aMat, ItemStack aXanthate, FluidStack[] aInputFluids, FluidStack[] aOutputFluids, int aTime, int aEU) {
        return this.addFlotationRecipe(MaterialUtils.generateMaterialFromGtENUM(aMat), aXanthate, aInputFluids, aOutputFluids, aTime, aEU);
    }

    @Override
    public boolean addFlotationRecipe(Material aMat, ItemStack aXanthate, FluidStack[] aInputFluids, FluidStack[] aOutputFluids, int aTime, int aEU) {
        FlotationRecipeHandler.registerOreType(aMat);
        GTPP_Recipe aRecipe = new GTPP_Recipe(false, new ItemStack[]{ItemUtils.getSimpleStack(aXanthate, 32), aMat.getMilled(64), aMat.getMilled(64), aMat.getMilled(64), aMat.getMilled(64)}, new ItemStack[0], null, new int[0], aInputFluids, aOutputFluids, aTime, aEU, 0);
        GTPP_Recipe.GTPP_Recipe_Map.sFlotationCellRecipes.add((GT_Recipe)aRecipe);
        return true;
    }

    @Override
    public boolean addpackagerRecipe(ItemStack aRecipeType, ItemStack aSmallDust, ItemStack aTinyDust, ItemStack aOutputStack1) {
        AutoMap<Boolean> aResults = new AutoMap<Boolean>();
        aResults.put(GT_Values.RA.addBoxingRecipe(GT_Utility.copyAmount((long)4L, (Object[])new Object[]{aSmallDust}), aRecipeType, aOutputStack1, 100, 4));
        aResults.put(GT_Values.RA.addBoxingRecipe(GT_Utility.copyAmount((long)9L, (Object[])new Object[]{aTinyDust}), aRecipeType, aOutputStack1, 100, 4));
        Iterator iterator = aResults.iterator();
        while (iterator.hasNext()) {
            boolean b = (Boolean)iterator.next();
            if (b) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addFuelForRTG(ItemStack aFuelPellet, int aFuelDays, int aVoltage) {
        GTPP_Recipe.GTPP_Recipe_Map.sRTGFuels.addRecipe(true, new ItemStack[]{aFuelPellet}, new ItemStack[0], null, null, null, 0, aVoltage, aFuelDays);
        long eu = GregtechMetaTileEntity_RTG.getTotalEUGenerated(GregtechMetaTileEntity_RTG.convertDaysToTicks(aFuelDays), aVoltage);
        GT_MetaTileEntity_Hatch_Energy_RTG.registerPelletForHatch(aFuelPellet, eu);
        return true;
    }

    @Override
    public boolean addColdTrapRecipe(int aCircuit, ItemStack aInput, FluidStack aFluidInput, ItemStack[] aOutputs, int[] aChances, FluidStack aFluidOutput, int aTime, int aEU) {
        GTPP_Recipe aRecipe = new GTPP_Recipe(false, new ItemStack[]{CI.getNumberedAdvancedCircuit(aCircuit), aInput}, aOutputs, null, aChances, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aTime, aEU, 0);
        GTPP_Recipe.GTPP_Recipe_Map.sColdTrapRecipes.add((GT_Recipe)aRecipe);
        return true;
    }

    @Override
    public boolean addReactorProcessingUnitRecipe(ItemStack aInput1, ItemStack aInput2, FluidStack aFluidInput, ItemStack[] aOutputs, int[] aChances, FluidStack aFluidOutput, int aTime, int aEU) {
        GTPP_Recipe aRecipe = new GTPP_Recipe(false, new ItemStack[]{aInput1, aInput2}, aOutputs, null, aChances, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aTime, aEU, 0);
        GTPP_Recipe.GTPP_Recipe_Map.sReactorProcessingUnitRecipes.add((GT_Recipe)aRecipe);
        return true;
    }

    @Override
    public boolean addFluidHeaterRecipe(ItemStack aInput, FluidStack aFluidInput, FluidStack aOutput, int aDuration, int aEUt) {
        if (aInput == null && aFluidInput == null || aOutput == null) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sFluidHeaterRecipes.addRecipe(true, new ItemStack[]{aInput}, null, null, new FluidStack[]{aFluidInput}, new FluidStack[]{aOutput}, aDuration, aEUt, 0);
        return true;
    }

    @Override
    public boolean addVacuumFreezerRecipe(ItemStack aInput, ItemStack aOutput, int aDuration, int aEUt) {
        if (aInput == null || aOutput == null) {
            return false;
        }
        GTPP_Recipe aRecipe = new GTPP_Recipe(false, new ItemStack[]{aInput}, new ItemStack[]{aOutput}, null, new int[]{10000}, new FluidStack[0], new FluidStack[0], aDuration, aEUt, 0);
        GT_Recipe.GT_Recipe_Map.sVacuumRecipes.add((GT_Recipe)aRecipe);
        return true;
    }

    @Override
    public boolean addMolecularTransformerRecipe(ItemStack aInput, ItemStack aOutput, int aDuration, int aEUt) {
        if (aInput == null || aOutput == null) {
            return false;
        }
        GTPP_Recipe aRecipe = new GTPP_Recipe(false, new ItemStack[]{aInput}, new ItemStack[]{aOutput}, null, new int[]{10000}, new FluidStack[0], new FluidStack[0], aDuration, aEUt, 0);
        GTPP_Recipe.GTPP_Recipe_Map.sMolecularTransformerRecipes.add((GT_Recipe)aRecipe);
        return true;
    }

    @Override
    public boolean addMolecularTransformerRecipe(ItemStack aInput, ItemStack aOutput, int aDuration, int aEUt, int aAmps) {
        return this.addMolecularTransformerRecipe(aInput, aOutput, aDuration, aEUt);
    }
}

