/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tools;

import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.IItemBehaviour;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.common.items.behaviors.Behaviour_None;
import gregtech.common.tools.GT_Tool;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtTools;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class TOOL_Gregtech_ElectricButcherKnife
extends GT_Tool {
    public static final List<String> mEffectiveList = Arrays.asList(EntityIronGolem.class.getName(), "EntityTowerGuardian");

    public float getNormalDamageAgainstEntity(float aOriginalDamage, Entity aEntity, ItemStack aStack, EntityPlayer aPlayer) {
        String tName = aEntity.getClass().getName();
        return mEffectiveList.contains(tName = tName.substring(tName.lastIndexOf(".") + 1)) || tName.contains("Golem") ? aOriginalDamage * 2.0f : aOriginalDamage;
    }

    public int getToolDamagePerBlockBreak() {
        return 100;
    }

    public int getToolDamagePerDropConversion() {
        return 100;
    }

    public int getToolDamagePerContainerCraft() {
        return 100;
    }

    public int getToolDamagePerEntityAttack() {
        return 200;
    }

    public int getBaseQuality() {
        return 0;
    }

    public float getBaseDamage() {
        return 8.0f;
    }

    public float getSpeedMultiplier() {
        return 2.0f;
    }

    public float getMaxDurabilityMultiplier() {
        return 1.8f;
    }

    public String getCraftingSound() {
        return (String)GregTech_API.sSoundList.get(1);
    }

    public String getEntityHitSound() {
        return (String)GregTech_API.sSoundList.get(2);
    }

    public String getBreakingSound() {
        return (String)GregTech_API.sSoundList.get(0);
    }

    public String getMiningSound() {
        return null;
    }

    public boolean canBlock() {
        return false;
    }

    public boolean isWrench() {
        return false;
    }

    public boolean isCrowbar() {
        return false;
    }

    public boolean isMinableBlock(Block aBlock, byte aMetaData) {
        String tTool = aBlock.getHarvestTool((int)aMetaData);
        return tTool != null && (tTool.equals("sword") || tTool.equals("knife"));
    }

    public ItemStack getBrokenItem(ItemStack aStack) {
        return null;
    }

    public IIconContainer getIcon(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? TexturesGtTools.ELECTRIC_BUTCHER_KNIFE : Textures.ItemIcons.POWER_UNIT_HV;
    }

    public short[] getRGBa(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mRGBa : Materials.RedSteel.mRGBa;
    }

    public void onToolCrafted(ItemStack aStack, EntityPlayer aPlayer) {
        super.onToolCrafted(aStack, aPlayer);
        aPlayer.func_71029_a((StatBase)AchievementList.field_76024_r);
        try {
            GT_Mod.achievements.issueAchievement(aPlayer, "tools");
            GT_Mod.achievements.issueAchievement(aPlayer, "unitool");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public IChatComponent getDeathMessage(EntityLivingBase aPlayer, EntityLivingBase aEntity) {
        return new ChatComponentText(EnumChatFormatting.RED + aEntity.func_70005_c_() + EnumChatFormatting.WHITE + " has been Sliced out of existence by " + EnumChatFormatting.GREEN + aPlayer.func_70005_c_() + EnumChatFormatting.WHITE);
    }

    public void onStatsAddedToTool(GT_MetaGenerated_Tool aItem, int aID) {
        aItem.addItemBehavior(aID, (IItemBehaviour)new Behaviour_None());
    }

    public boolean isGrafter() {
        return false;
    }

    public int getHurtResistanceTime(int aOriginalHurtResistance, Entity aEntity) {
        return aOriginalHurtResistance * 2;
    }

    public boolean isWeapon() {
        return true;
    }

    public boolean isMiningTool() {
        return false;
    }

    public Enchantment[] getEnchantments(ItemStack aStack) {
        return LOOTING_ENCHANTMENT;
    }

    public int[] getEnchantmentLevels(ItemStack aStack) {
        return new int[]{(4 + GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mToolQuality) / 2};
    }
}

