/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.storage;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.minecraft.BlockPos;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.data.ArrayUtils;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class GT_MetaTileEntity_ConnectableCrate
extends GT_MetaTileEntity_TieredMachineBlock
implements IAddUIWidgets {
    public int mItemCount = 0;
    public ItemStack mItemStack = null;
    private static final double mStorageFactor = 2.0;
    public static final int mCrateID = 955;
    public static final int SIDE_Up = 0;
    public static final int SIDE_Down = 1;
    public static final int SIDE_XPos = 2;
    public static final int SIDE_XNeg = 3;
    public static final int SIDE_ZPos = 4;
    public static final int SIDE_ZNeg = 5;
    public static final int[] SIDES = new int[]{0, 1, 2, 3, 4, 5};
    private GT_MetaTileEntity_ConnectableCrate[] mNeighbourCache = new GT_MetaTileEntity_ConnectableCrate[6];
    private BlockPos mCurrentPos = null;
    protected BlockPos mMasterCrateLocation = null;
    protected boolean mIsMaster = false;
    protected boolean[] mIsConnected = new boolean[]{false, false, false, false, false, false};
    protected int mConnectedCount = 0;
    protected AutoMap<String> mConnectedCache = new AutoMap();

    public GT_MetaTileEntity_ConnectableCrate(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 3, "This Crate stores " + (int)(Math.pow(6.0, aTier) * 2.0) + " Items", new ITexture[0]);
    }

    public GT_MetaTileEntity_ConnectableCrate(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    public String[] getDescription() {
        return new String[]{this.mDescription, CORE.GT_Tooltip.get()};
    }

    public boolean isSimpleMachine() {
        return true;
    }

    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public boolean isValidSlot(int aIndex) {
        return true;
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_ConnectableCrate(this.mName, this.mTier, this.mDescription, this.mTextures);
    }

    public int getOppositeSide(int side) {
        if (side == 0) {
            return 1;
        }
        if (side == 1) {
            return 0;
        }
        if (side == 3) {
            return 2;
        }
        if (side == 2) {
            return 3;
        }
        if (side == 5) {
            return 4;
        }
        return 5;
    }

    public boolean calculateOwnershipIfConnected() {
        if (this.mCurrentPos == null) {
            this.mCurrentPos = new BlockPos(this.getBaseMetaTileEntity().getXCoord(), (int)this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord(), this.getBaseMetaTileEntity().getWorld());
        }
        AutoMap<BlockPos> n = this.mCurrentPos.getSurroundingBlocks();
        int p = 0;
        for (BlockPos i : n) {
            GT_MetaTileEntity_ConnectableCrate yu;
            if (i != null && this.doesSideContainCrate(p) && (yu = this.getCrateAtBlockPos(i)) != null) {
                this.mNeighbourCache[p] = yu;
            }
            ++p;
        }
        int e4 = 0;
        if (this.mNeighbourCache.length > 0) {
            for (GT_MetaTileEntity_ConnectableCrate e : this.mNeighbourCache) {
                this.mConnectedCount = this.mConnectedCache.size();
                if (e != null) {
                    GT_MetaTileEntity_ConnectableCrate gM;
                    if (this.mIsMaster) {
                        if (e.mIsMaster) {
                            if (this.mConnectedCount > e.mConnectedCount) {
                                e.mIsMaster = false;
                                e.mMasterCrateLocation = this.mCurrentPos;
                                if (!e.mIsConnected[this.getOppositeSide(e4)]) {
                                    e.mIsConnected[this.getOppositeSide((int)e4)] = true;
                                }
                                if (!this.mIsConnected[e4]) {
                                    this.mIsConnected[e4] = true;
                                }
                                this.mConnectedCache = ArrayUtils.mergeTwoMaps(this.mConnectedCache, e.mConnectedCache);
                                continue;
                            }
                            this.mIsMaster = false;
                            this.mMasterCrateLocation = e.mCurrentPos;
                            if (!this.mIsConnected[e4]) {
                                this.mIsConnected[e4] = true;
                            }
                            if (!e.mIsConnected[this.getOppositeSide(e4)]) {
                                e.mIsConnected[this.getOppositeSide((int)e4)] = true;
                            }
                            e.mConnectedCache = ArrayUtils.mergeTwoMaps(e.mConnectedCache, this.mConnectedCache);
                            this.mConnectedCache.clear();
                            continue;
                        }
                        if (e.mMasterCrateLocation != null && !e.mMasterCrateLocation.getUniqueIdentifier().equalsIgnoreCase(this.mMasterCrateLocation.getUniqueIdentifier())) {
                            gM = this.getCrateAtBlockPos(e.mMasterCrateLocation);
                            if (gM == null) continue;
                            int gM_Owned = gM.mConnectedCount;
                            if (this.mConnectedCount > gM_Owned) {
                                e.mIsMaster = false;
                                e.mMasterCrateLocation = this.mCurrentPos;
                                gM.mIsMaster = false;
                                gM.mMasterCrateLocation = this.mCurrentPos;
                                if (!e.mIsConnected[this.getOppositeSide(e4)]) {
                                    e.mIsConnected[this.getOppositeSide((int)e4)] = true;
                                }
                                if (!this.mIsConnected[e4]) {
                                    this.mIsConnected[e4] = true;
                                }
                                this.mConnectedCache = ArrayUtils.mergeTwoMaps(this.mConnectedCache, gM.mConnectedCache);
                                continue;
                            }
                            this.mIsMaster = false;
                            this.mMasterCrateLocation = e.mMasterCrateLocation;
                            if (!this.mIsConnected[e4]) {
                                this.mIsConnected[e4] = true;
                            }
                            if (!e.mIsConnected[this.getOppositeSide(e4)]) {
                                e.mIsConnected[this.getOppositeSide((int)e4)] = true;
                            }
                            gM.mConnectedCache = ArrayUtils.mergeTwoMaps(gM.mConnectedCache, this.mConnectedCache);
                            this.mConnectedCache.clear();
                            continue;
                        }
                        if (e.mMasterCrateLocation != null && e.mIsConnected[this.getOppositeSide(e4)]) continue;
                        e.mMasterCrateLocation = this.mCurrentPos;
                        if (!e.mIsConnected[this.getOppositeSide(e4)]) {
                            e.mIsConnected[this.getOppositeSide((int)e4)] = true;
                        }
                        if (!this.mIsConnected[e4]) {
                            this.mIsConnected[e4] = true;
                        }
                        this.mConnectedCache.put(e.mCurrentPos.getUniqueIdentifier());
                        continue;
                    }
                    this.mConnectedCache.clear();
                    if (e.mIsMaster) {
                        this.mIsMaster = false;
                        this.mMasterCrateLocation = e.mCurrentPos;
                        this.mIsConnected[e4] = true;
                        if (!e.mIsConnected[e4]) {
                            e.mIsConnected[e4] = true;
                        }
                        if (e.mMasterCrateLocation == null) {
                            e.mMasterCrateLocation = e.mCurrentPos;
                        }
                        e.mConnectedCache.put(this.mCurrentPos.getUniqueIdentifier());
                        continue;
                    }
                    if (e.mMasterCrateLocation != null) {
                        gM = this.getCrateAtBlockPos(e.mMasterCrateLocation);
                        if (gM == null) continue;
                        this.mIsMaster = false;
                        this.mMasterCrateLocation = e.mMasterCrateLocation;
                        if (!this.mIsConnected[e4]) {
                            this.mIsConnected[e4] = true;
                        }
                        if (!e.mIsConnected[this.getOppositeSide(e4)]) {
                            e.mIsConnected[this.getOppositeSide((int)e4)] = true;
                        }
                        gM.mConnectedCache.put(this.mCurrentPos.getUniqueIdentifier());
                        continue;
                    }
                    this.mIsMaster = true;
                    this.mMasterCrateLocation = this.mCurrentPos;
                    e.mIsMaster = false;
                    e.mMasterCrateLocation = this.mCurrentPos;
                    if (!e.mIsConnected[this.getOppositeSide(e4)]) {
                        e.mIsConnected[this.getOppositeSide((int)e4)] = true;
                    }
                    if (!this.mIsConnected[e4]) {
                        this.mIsConnected[e4] = true;
                    }
                    this.mConnectedCache.put(e.mCurrentPos.getUniqueIdentifier());
                    continue;
                }
                ++e4;
            }
            return true;
        }
        return false;
    }

    public boolean doesSideContainCrate(int side) {
        return this.checkSideForDataType(0, side);
    }

    public boolean isCrateAtSideController(int side) {
        return this.checkSideForDataType(1, side);
    }

    private boolean checkSideForDataType(int aType, int aSide) {
        BlockPos mPosToCheck = aSide == 0 ? this.mCurrentPos.getUp() : (aSide == 1 ? this.mCurrentPos.getDown() : (aSide == 2 ? this.mCurrentPos.getXPos() : (aSide == 3 ? this.mCurrentPos.getXNeg() : (aSide == 4 ? this.mCurrentPos.getZPos() : this.mCurrentPos.getZNeg()))));
        GT_MetaTileEntity_ConnectableCrate g = this.getCrateAtBlockPos(mPosToCheck);
        if (g != null) {
            if (aType == 0) {
                return true;
            }
            if (g.mIsMaster) {
                return true;
            }
        }
        return false;
    }

    public GT_MetaTileEntity_ConnectableCrate getCrateAtBlockPos(BlockPos pos) {
        if (pos != null) {
            Block b = pos.getBlockAtPos();
            int m = pos.getMetaAtPos();
            TileEntity t = pos.world.func_147438_o(pos.xPos, pos.yPos, pos.zPos);
            if (b != null && t != null && b == GregTech_API.sBlockMachines && m == 955 && t instanceof IGregTechTileEntity) {
                IGregTechTileEntity g = (IGregTechTileEntity)t;
                IMetaTileEntity aMetaTileEntity = g.getMetaTileEntity();
                if (aMetaTileEntity == null) {
                    return null;
                }
                if (aMetaTileEntity instanceof GT_MetaTileEntity_ConnectableCrate) {
                    return (GT_MetaTileEntity_ConnectableCrate)aMetaTileEntity;
                }
            }
        }
        return null;
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GT_UIInfos.openGTTileEntityUI((IHasWorldObjectAndCoords)aBaseMetaTileEntity, (EntityPlayer)aPlayer);
        return true;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        if (this.getBaseMetaTileEntity().isServerSide() && this.getBaseMetaTileEntity().isAllowedToWork()) {
            if (this.getItemCount() <= 0) {
                this.mItemStack = null;
                this.mItemCount = 0;
            }
            if (this.mItemStack == null && this.mInventory[0] != null) {
                this.mItemStack = this.mInventory[0].func_77946_l();
            }
            if (this.mInventory[0] != null && this.mItemCount < this.getMaxItemCount() && GT_Utility.areStacksEqual((ItemStack)this.mInventory[0], (ItemStack)this.mItemStack)) {
                this.mItemCount += this.mInventory[0].field_77994_a;
                if (this.mItemCount > this.getMaxItemCount()) {
                    this.mInventory[0].field_77994_a = this.mItemCount - this.getMaxItemCount();
                    this.mItemCount = this.getMaxItemCount();
                } else {
                    this.mInventory[0] = null;
                }
            }
            if (this.mInventory[1] == null && this.mItemStack != null) {
                this.mInventory[1] = this.mItemStack.func_77946_l();
                this.mInventory[1].field_77994_a = Math.min(this.mItemStack.func_77976_d(), this.mItemCount);
                this.mItemCount -= this.mInventory[1].field_77994_a;
            } else if (this.mItemCount > 0 && GT_Utility.areStacksEqual((ItemStack)this.mInventory[1], (ItemStack)this.mItemStack) && this.mInventory[1].func_77976_d() > this.mInventory[1].field_77994_a) {
                int tmp = Math.min(this.mItemCount, this.mInventory[1].func_77976_d() - this.mInventory[1].field_77994_a);
                this.mInventory[1].field_77994_a += tmp;
                this.mItemCount -= tmp;
            }
            if (this.mItemStack != null) {
                this.mInventory[2] = this.mItemStack.func_77946_l();
                this.mInventory[2].field_77994_a = Math.min(this.mItemStack.func_77976_d(), this.mItemCount);
            } else {
                this.mInventory[2] = null;
            }
        }
    }

    private int getItemCount() {
        return this.mItemCount;
    }

    public void setItemCount(int aCount) {
        this.mItemCount = aCount;
    }

    public int getProgresstime() {
        return this.mItemCount + (this.mInventory[0] == null ? 0 : this.mInventory[0].field_77994_a) + (this.mInventory[1] == null ? 0 : this.mInventory[1].field_77994_a);
    }

    public int maxProgresstime() {
        return this.getMaxItemCount();
    }

    public int getMaxItemCount() {
        return (int)(Math.pow(6.0, this.mTier) * 2.0 - 128.0);
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aIndex == 1;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aIndex == 0 && (this.mInventory[0] == null || GT_Utility.areStacksEqual((ItemStack)this.mInventory[0], (ItemStack)aStack));
    }

    public String[] getInfoData() {
        String[] stringArray;
        if (this.mItemStack == null) {
            String[] stringArray2 = new String[5];
            stringArray2[0] = "Super Storage Chest";
            stringArray2[1] = "Stored Items:";
            stringArray2[2] = "No Items";
            stringArray2[3] = Integer.toString(0);
            stringArray = stringArray2;
            stringArray2[4] = Integer.toString(this.getMaxItemCount());
        } else {
            String[] stringArray3 = new String[5];
            stringArray3[0] = "Super Storage Chest";
            stringArray3[1] = "Stored Items:";
            stringArray3[2] = this.mItemStack.func_82833_r();
            stringArray3[3] = Integer.toString(this.mItemCount);
            stringArray = stringArray3;
            stringArray3[4] = Integer.toString(this.getMaxItemCount());
        }
        return stringArray;
    }

    public boolean isGivingInformation() {
        return true;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mItemCount", this.mItemCount);
        if (this.mItemStack != null) {
            aNBT.func_74782_a("mItemStack", (NBTBase)this.mItemStack.func_77955_b(new NBTTagCompound()));
        }
        aNBT.func_74778_a("mMasterCrateLocation", this.mMasterCrateLocation.getUniqueIdentifier());
        aNBT.func_74757_a("mIsMaster", this.mIsMaster);
        for (int y = 0; y < this.mIsConnected.length; ++y) {
            aNBT.func_74757_a("mIsConnected" + y, this.mIsConnected[y]);
        }
        aNBT.func_74768_a("mConnectedCount", this.mConnectedCount);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        if (aNBT.func_74764_b("mItemCount")) {
            this.mItemCount = aNBT.func_74762_e("mItemCount");
        }
        if (aNBT.func_74764_b("mItemStack")) {
            this.mItemStack = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)aNBT.func_74781_a("mItemStack")));
        }
        if (aNBT.func_74764_b("mMasterCrateLocation")) {
            this.mMasterCrateLocation = BlockPos.generateBlockPos(aNBT.func_74779_i("mMasterCrateLocation"));
        }
        if (aNBT.func_74764_b("mIsMaster")) {
            this.mIsMaster = aNBT.func_74767_n("mIsMaster");
        }
        for (int y = 0; y < this.mIsConnected.length; ++y) {
            if (!aNBT.func_74764_b("mIsConnected" + y)) continue;
            this.mIsConnected[y] = aNBT.func_74767_n("mIsConnected" + y);
        }
        if (aNBT.func_74764_b("mConnectedCount")) {
            this.mConnectedCount = aNBT.func_74762_e("mConnectedCount");
        }
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray;
        if (aBaseMetaTileEntity.getFrontFacing() == 0 && aSide == 4) {
            ITexture[] iTextureArray2 = new ITexture[2];
            iTextureArray2[0] = new GT_RenderedTexture((IIconContainer)TexturesGtBlock.TEXTURE_CASING_AMAZON);
            iTextureArray = iTextureArray2;
            iTextureArray2[1] = new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_QCHEST);
        } else if (aSide == aBaseMetaTileEntity.getFrontFacing()) {
            ITexture[] iTextureArray3 = new ITexture[2];
            iTextureArray3[0] = new GT_RenderedTexture((IIconContainer)TexturesGtBlock.TEXTURE_CASING_AMAZON);
            iTextureArray = iTextureArray3;
            iTextureArray3[1] = new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_QCHEST);
        } else {
            ITexture[] iTextureArray4 = new ITexture[1];
            iTextureArray = iTextureArray4;
            iTextureArray4[0] = new GT_RenderedTexture((IIconContainer)TexturesGtBlock.TEXTURE_CASING_AMAZON);
        }
        return iTextureArray;
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return new ITexture[0][0][0];
    }

    public void onExplosion() {
        super.onExplosion();
    }

    public void onRemoval() {
        super.onRemoval();
    }

    public void onMachineBlockUpdate() {
        super.onMachineBlockUpdate();
    }

    public boolean useModularUI() {
        return true;
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_SCREEN_BLACK).setPos(7, 16).setSize(71, 45))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 0).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_IN}).setPos(79, 16))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 1).setAccess(true, false).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_OUT}).setPos(79, 52))).widget(SlotWidget.phantom((IItemHandlerModifiable)this.inventoryHandler, (int)2).disableInteraction().setBackground(new IDrawable[]{GT_UITextures.TRANSPARENT}).setPos(59, 42))).widget(new TextWidget("Item Amount").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(10, 20))).widget(TextWidget.dynamicString(() -> GT_Utility.parseNumberToString((int)this.mItemCount)).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(10, 30));
    }
}

