/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.item.chemistry.IonParticles;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class GregtechMetaTileEntity_Cyclotron
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_Cyclotron>
implements ISurvivalConstructable {
    private int mCasing;
    private static IStructureDefinition<GregtechMetaTileEntity_Cyclotron> STRUCTURE_DEFINITION = null;

    public GregtechMetaTileEntity_Cyclotron(int aID, String aName, String aNameRegional, int tier) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_Cyclotron(String aName) {
        super(aName);
    }

    @Override
    public String getMachineType() {
        return "Particle Accelerator";
    }

    public int tier() {
        return 5;
    }

    public long maxEUStore() {
        return 1800000000L;
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_Cyclotron(this.mName);
    }

    public boolean allowCoverOnSide(byte aSide, GT_ItemStack aStack) {
        return aSide != this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
    }

    public IStructureDefinition<GregtechMetaTileEntity_Cyclotron> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"               ", "      hhh      ", "    hh   hh    ", "   h       h   ", "  h         h  ", "  h         h  ", " h           h ", " h           h ", " h           h ", "  h         h  ", "  h         h  ", "   h       h   ", "    hh   hh    ", "      hhh      ", "               "}, {"      hhh      ", "    hhccchh    ", "   hcchhhcch   ", "  hchh   hhch  ", " hch       hch ", " hch       hch ", "hch         hch", "hch         hch", "hch         hch", " hch       hch ", " hch       hch ", "  hchh   hhch  ", "   hcch~hcch   ", "    hhccchh    ", "      hhh      "}, {"               ", "      hhh      ", "    hh   hh    ", "   h       h   ", "  h         h  ", "  h         h  ", " h           h ", " h           h ", " h           h ", "  h         h  ", "  h         h  ", "   h       h   ", "    hh   hh    ", "      hhh      ", "               "}})).addElement('h', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_Cyclotron.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.Maintenance, GT_HatchElement.Energy, GT_HatchElement.Muffler, GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch}).casingIndex(44).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)this.getCasingBlock(), (int)this.getCasingMeta()))})).addElement('c', StructureUtility.ofBlock((Block)this.getCyclotronCoil(), (int)this.getCyclotronCoilMeta())).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 7, 1, 12);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 7, 1, 12, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 7, 1, 12) && this.mCasing >= 40 && this.checkHatch();
    }

    public Block getCasingBlock() {
        return ModBlocks.blockCasings2Misc;
    }

    public int getCasingMeta() {
        return 10;
    }

    public Block getCyclotronCoil() {
        return ModBlocks.blockCasings2Misc;
    }

    public int getCyclotronCoilMeta() {
        return 9;
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Super Magnetic Speed Shooter").addSeparator().addInfo("Particles are accelerated over 186 revolutions to 80% light speed").addInfo("Can produce a continuous beam current of 2.2 mA at 590 MeV").addInfo("Which will be extracted from the Isochronous Cyclotron").addSeparator().addInfo("Consists of the same layout as a Fusion Reactor").addInfo("Any external casing can be a hatch/bus, unlike Fusion").addInfo("Cyclotron Machine Casings around Cyclotron Coil Blocks").addInfo("All Hatches must be IV or better").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().addCasingInfo("Cyclotron Machine Casings", 40).addCasingInfo("Cyclotron Coil", 32).addInputBus("Any Casing", new int[]{1}).addOutputBus("Any Casing", new int[]{1}).addInputHatch("Any Casing", new int[]{1}).addOutputHatch("Any Casing", new int[]{1}).addEnergyHatch("Any Casing", new int[]{1}).addMaintenanceHatch("Any Casing", new int[]{1}).addMufflerHatch("Any Casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder.get());
        return tt;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return this.getIconOverlay();
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return this.getIconOverlay();
    }

    @Override
    protected int getCasingTextureId() {
        return 44;
    }

    public IIconContainer getIconOverlay() {
        if (this.getBaseMetaTileEntity().isActive()) {
            return TexturesGtBlock.Overlay_MatterFab_Active_Animated;
        }
        return TexturesGtBlock.Overlay_MatterFab_Animated;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public boolean checkRecipe(ItemStack aStack) {
        this.fixAllMaintenanceIssue();
        ArrayList tItemList = this.getStoredInputs();
        ItemStack[] tItemInputs = tItemList.toArray(new ItemStack[tItemList.size()]);
        ArrayList tInputList = this.getStoredFluids();
        FluidStack[] tFluidInputs = tInputList.toArray(new FluidStack[tInputList.size()]);
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
        GT_Recipe tRecipe = GTPP_Recipe.GTPP_Recipe_Map.sCyclotronRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tFluidInputs, tItemInputs);
        if (tRecipe != null && tRecipe.isRecipeInputEqual(true, tFluidInputs, tItemInputs)) {
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            this.lEUt = tRecipe.mEUt;
            this.mMaxProgresstime = tRecipe.mDuration;
            while (this.lEUt <= GT_Values.V[tTier - 1]) {
                this.lEUt *= 4L;
                this.mMaxProgresstime /= 2;
            }
            if (this.lEUt > 0L) {
                this.lEUt = -this.lEUt;
            }
            this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
            ItemStack[] outputs = new ItemStack[tRecipe.mOutputs.length];
            for (int i = 0; i < tRecipe.mOutputs.length; ++i) {
                if (this.getBaseMetaTileEntity().getRandomNumber(10000) < tRecipe.getOutputChance(i)) {
                    Logger.WARNING("Adding a bonus output");
                    outputs[i] = tRecipe.getOutput(i);
                    continue;
                }
                Logger.WARNING("Adding null output");
                outputs[i] = null;
            }
            for (ItemStack s : outputs) {
                long aCharge;
                if (s == null || !(s.func_77973_b() instanceof IonParticles) || (aCharge = IonParticles.getChargeState(s)) != 0L) continue;
                IonParticles.setChargeState(s, MathUtils.getRandomFromArray(new int[]{-5, -5, -4, -4, -4, -3, -3, -3, -3, -3, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 6, 6}));
            }
            this.mOutputItems = outputs;
            this.mOutputFluids = new FluidStack[]{tRecipe.getFluidOutput(0)};
            this.updateSlots();
            return true;
        }
        return false;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 1;
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 0;
    }

    public boolean onRunningTick(ItemStack aStack) {
        if (this.mOutputBusses.size() > 0) {
            for (GT_MetaTileEntity_Hatch_OutputBus g : this.mOutputBusses) {
                if (g == null) continue;
                for (ItemStack s : g.mInventory) {
                    long aCharge;
                    if (s == null || !(s.func_77973_b() instanceof IonParticles) || (aCharge = IonParticles.getChargeState(s)) != 0L) continue;
                    IonParticles.setChargeState(s, MathUtils.getRandomFromArray(new int[]{-5, -5, -4, -4, -4, -3, -3, -3, -3, -3, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 6, 6}));
                }
            }
        }
        this.fixAllMaintenanceIssue();
        return super.onRunningTick(aStack);
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiCyclotron;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public String[] getExtraInfoData() {
        String tier = this.tier() == 5 ? "I" : "II";
        float plasmaOut = 0.0f;
        int powerRequired = 0;
        if (this.mLastRecipe != null) {
            powerRequired = this.mLastRecipe.mEUt;
            if (this.mLastRecipe.getFluidOutput(0) != null) {
                plasmaOut = (float)this.mLastRecipe.getFluidOutput((int)0).amount / (float)this.mLastRecipe.mDuration;
            }
        }
        return new String[]{"COMET - Compact Cyclotron MK " + tier, "EU Required: " + powerRequired + "EU/t", "Stored EU: " + this.getEUVar() + " / " + this.maxEUStore()};
    }

    @Override
    public int getAmountOfOutputs() {
        return 1;
    }

    public boolean turnCasingActive(boolean status) {
        if (this.mEnergyHatches != null) {
            for (GT_MetaTileEntity_Hatch_Muffler hatch : this.mMufflerHatches) {
                hatch.mMachineBlock = (byte)(status ? 44 : 44);
            }
        }
        if (this.mOutputHatches != null) {
            for (GT_MetaTileEntity_Hatch_Muffler hatch : this.mOutputHatches) {
                hatch.mMachineBlock = (byte)(status ? 44 : 44);
            }
        }
        if (this.mInputHatches != null) {
            for (GT_MetaTileEntity_Hatch_Muffler hatch : this.mInputHatches) {
                hatch.mMachineBlock = (byte)(status ? 44 : 44);
            }
        }
        if (this.mMaintenanceHatches != null) {
            for (GT_MetaTileEntity_Hatch_Muffler hatch : this.mMaintenanceHatches) {
                hatch.mMachineBlock = (byte)(status ? 44 : 44);
            }
        }
        return true;
    }

    public boolean doesBindPlayerInventory() {
        return false;
    }
}

