/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.item.general.ItemLavaFilter;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.material.MISC_MATERIALS;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GT4Entity_ThermalBoiler
extends GregtechMeta_MultiBlockBase<GT4Entity_ThermalBoiler>
implements ISurvivalConstructable {
    private int mCasing;
    private static IStructureDefinition<GT4Entity_ThermalBoiler> STRUCTURE_DEFINITION = null;
    private int mSuperEfficencyIncrease = 0;
    private static Item mLavaFilter;
    private static Fluid mLava;
    private static Fluid mPahoehoe;
    private static Fluid mSolarSaltHot;

    public GT4Entity_ThermalBoiler(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT4Entity_ThermalBoiler(String mName) {
        super(mName);
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT4Entity_ThermalBoiler(this.mName);
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public String getMachineType() {
        return "Boiler";
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return aStack != null && aStack.func_77973_b() == mLavaFilter ? 1 : 0;
    }

    public boolean checkRecipe(ItemStack aStack) {
        ItemStack uStack;
        this.mSuperEfficencyIncrease = 0;
        if (mLavaFilter == null) {
            mLavaFilter = ItemList.Component_LavaFilter.getItem();
        }
        if (mLava == null) {
            mLava = FluidRegistry.LAVA;
        }
        if (mPahoehoe == null) {
            mPahoehoe = FluidUtils.getPahoehoeLava(1).getFluid();
        }
        if (mSolarSaltHot == null) {
            mSolarSaltHot = MISC_MATERIALS.SOLAR_SALT_HOT.getFluid();
        }
        if (aStack == null && (uStack = this.findItemInInventory(mLavaFilter)) != null) {
            this.setGUIItemStack(uStack);
            aStack = this.getGUIItemStack();
        }
        for (GT_Recipe tRecipe : GTPP_Recipe.GTPP_Recipe_Map.sThermalFuels.mRecipeList) {
            FluidStack tFluid = tRecipe.mFluidInputs[0];
            if (tFluid == null) continue;
            if (tFluid.getFluid() == mLava || tFluid.getFluid() == mPahoehoe) {
                if (!this.depleteInput(tFluid)) continue;
                this.mMaxProgresstime = Math.max(1, this.runtimeBoost(tRecipe.mSpecialValue * 2));
                this.lEUt = this.getEUt();
                this.mEfficiencyIncrease = this.mMaxProgresstime * this.getEfficiencyIncrease();
                int loot_MAXCHANCE = 100000;
                if (aStack != null && aStack.func_77973_b() == mLavaFilter) {
                    if (tRecipe.getOutput(0) != null && this.getBaseMetaTileEntity().getRandomNumber(loot_MAXCHANCE) < tRecipe.getOutputChance(0)) {
                        this.mOutputItems = new ItemStack[]{GT_Utility.copy((Object[])new Object[]{tRecipe.getOutput(0)})};
                    }
                    if (tRecipe.getOutput(1) != null && this.getBaseMetaTileEntity().getRandomNumber(loot_MAXCHANCE) < tRecipe.getOutputChance(1)) {
                        this.mOutputItems = new ItemStack[]{GT_Utility.copy((Object[])new Object[]{tRecipe.getOutput(1)})};
                    }
                    if (tRecipe.getOutput(2) != null && this.getBaseMetaTileEntity().getRandomNumber(loot_MAXCHANCE) < tRecipe.getOutputChance(2)) {
                        this.mOutputItems = new ItemStack[]{GT_Utility.copy((Object[])new Object[]{tRecipe.getOutput(2)})};
                    }
                    if (tRecipe.getOutput(3) != null && this.getBaseMetaTileEntity().getRandomNumber(loot_MAXCHANCE) < tRecipe.getOutputChance(3)) {
                        this.mOutputItems = new ItemStack[]{GT_Utility.copy((Object[])new Object[]{tRecipe.getOutput(3)})};
                    }
                    if (tRecipe.getOutput(4) != null && this.getBaseMetaTileEntity().getRandomNumber(loot_MAXCHANCE) < tRecipe.getOutputChance(4)) {
                        this.mOutputItems = new ItemStack[]{GT_Utility.copy((Object[])new Object[]{tRecipe.getOutput(4)})};
                    }
                    if (tRecipe.getOutput(5) != null && this.getBaseMetaTileEntity().getRandomNumber(loot_MAXCHANCE) < tRecipe.getOutputChance(5)) {
                        this.mOutputItems = new ItemStack[]{GT_Utility.copy((Object[])new Object[]{tRecipe.getOutput(5)})};
                    }
                }
                FluidStack[] mFluidOutputs = tRecipe.mFluidOutputs;
                this.mOutputFluids = new FluidStack[mFluidOutputs.length];
                int mFluidOutputsLength = mFluidOutputs.length;
                for (int i = 0; i < mFluidOutputsLength; ++i) {
                    this.mOutputFluids[i] = mFluidOutputs[i].copy();
                }
                if (tFluid.getFluid() == mLava && tRecipe.getOutput(6) != null && this.getBaseMetaTileEntity().getRandomNumber(loot_MAXCHANCE) < tRecipe.getOutputChance(6)) {
                    this.mOutputItems = new ItemStack[]{GT_Utility.copy((Object[])new Object[]{tRecipe.getOutput(6)})};
                }
                return true;
            }
            if (tFluid.getFluid() != mSolarSaltHot || !this.depleteInput(tFluid)) continue;
            this.mMaxProgresstime = tRecipe.mDuration;
            this.lEUt = 0L;
            this.mEfficiency = 10000;
            for (FluidStack aOutput : tRecipe.mFluidOutputs) {
                this.addOutput(FluidUtils.getFluidStack(aOutput, aOutput.amount));
            }
            return true;
        }
        this.mMaxProgresstime = 0;
        this.lEUt = 0L;
        return false;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 1;
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 0;
    }

    public boolean onRunningTick(ItemStack aStack) {
        if (this.lEUt > 0L) {
            int tGeneratedEU;
            if (this.mSuperEfficencyIncrease > 0) {
                this.mEfficiency = Math.min(10000, this.mEfficiency + this.mSuperEfficencyIncrease);
            }
            if ((tGeneratedEU = (int)(this.lEUt * 2L * (long)this.mEfficiency / 10000L)) > 0) {
                long amount = (tGeneratedEU + 160) / 160;
                if (this.depleteInput(Materials.Water.getFluid(amount)) || this.depleteInput(GT_ModHandler.getDistilledWater((long)amount))) {
                    this.addOutput(GT_ModHandler.getSteam((long)tGeneratedEU));
                } else {
                    this.explodeMultiblock();
                }
            }
            return true;
        }
        return true;
    }

    public int getEUt() {
        return 400;
    }

    public int getEfficiencyIncrease() {
        return 12;
    }

    int runtimeBoost(int mTime) {
        return mTime * 150 / 100;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiThermalBoiler;
    }

    @Override
    public int getAmountOfOutputs() {
        return 7;
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Thermal Boiler Controller").addInfo("Converts Water & Heat into Steam").addInfo("Explodes if water is not supplied").addInfo("Consult user manual for more information").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 3, 3, true).addController("Front Center").addCasingInfo("Thermal Containment Casings", 10).addInputBus("Any Casing", new int[]{1}).addOutputBus("Any Casing", new int[]{1}).addInputHatch("Any Casing", new int[]{1}).addOutputHatch("Any Casing", new int[]{1}).addMaintenanceHatch("Any Casing", new int[]{1}).addMufflerHatch("Any Casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder.get());
        return tt;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced;
    }

    @Override
    protected int getCasingTextureId() {
        return TAE.GTPP_INDEX(1);
    }

    public IStructureDefinition<GT4Entity_ThermalBoiler> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"C~C", "C-C", "CCC"}, {"CCC", "CCC", "CCC"}})).addElement('C', (IStructureElement)GT_StructureUtility.buildHatchAdder(GT4Entity_ThermalBoiler.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch, GT_HatchElement.Maintenance, GT_HatchElement.Energy, GT_HatchElement.Muffler}).casingIndex(TAE.getIndexFromPage(0, 1)).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)11))})).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 1, 1, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 1, 1, 0) && this.mCasing >= 10 && this.checkHatch();
    }

    public void damageFilter() {
        ItemStack filter = this.mInventory[1];
        if (filter != null && filter.func_77973_b() instanceof ItemLavaFilter) {
            long currentUse = ItemLavaFilter.getFilterDamage(filter);
            if (currentUse >= 99L) {
                this.mInventory[1] = null;
            } else {
                ItemLavaFilter.setFilterDamage(filter, currentUse + 1L);
            }
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            if (this.getGUIItemStack() == null && this.mInputBusses.size() > 0) {
                for (GT_MetaTileEntity_Hatch_InputBus aBus : this.mInputBusses) {
                    for (ItemStack aStack : aBus.mInventory) {
                        if (aStack == null || !(aStack.func_77973_b() instanceof ItemLavaFilter)) continue;
                        this.setGUIItemStack(aStack);
                    }
                }
            }
            if (this.lEUt > 0L && aTick % 600L == 0L) {
                this.damageFilter();
            }
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    static {
        mLava = null;
        mPahoehoe = null;
        mSolarSaltHot = null;
    }
}

