/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.helpers.CraftingHelper;
import gtPlusPlus.xmod.gregtech.common.helpers.autocrafter.AC_Helper_Utils;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.FluidStack;

public class GT4Entity_AutoCrafter
extends GregtechMeta_MultiBlockBase<GT4Entity_AutoCrafter>
implements ISurvivalConstructable {
    private MODE mMachineMode = MODE.ASSEMBLY;
    private byte mTier = 1;
    protected GT_Recipe mLastRecipeToBuffer;
    private int mCasing;
    private static IStructureDefinition<GT4Entity_AutoCrafter> STRUCTURE_DEFINITION = null;
    public CraftingHelper mInventoryCrafter;
    private static GT_Recipe.GT_Recipe_Map fCircuitMap;

    public void onRightclick(EntityPlayer aPlayer) {
    }

    public GT4Entity_AutoCrafter(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT4Entity_AutoCrafter(String mName) {
        super(mName);
    }

    @Override
    public String getMachineType() {
        return "Assembler, Disassembler";
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT4Entity_AutoCrafter(this.mName);
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    public boolean onRunningTick(ItemStack aStack) {
        return super.onRunningTick(aStack);
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiAutoCrafter;
    }

    @Override
    public int getAmountOfOutputs() {
        return 1;
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Highly Advanced Autocrafter").addInfo("Right Click with a Screwdriver to change mode").addInfo("200% faster than using single block machines of the same voltage").addInfo("Processes two items per voltage tier").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 3, 3, true).addController("Front Center").addCasingInfo("Bulk Production Frame", 10).addInputBus("Any Casing", new int[]{1}).addOutputBus("Any Casing", new int[]{1}).addInputHatch("Any Casing", new int[]{1}).addEnergyHatch("Any Casing", new int[]{1}).addMaintenanceHatch("Any Casing", new int[]{1}).addMufflerHatch("Any Casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder.get());
        return tt;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_DISASSEMBLER_ACTIVE;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_DISASSEMBLER;
    }

    @Override
    protected int getCasingTextureId() {
        return TAE.getIndexFromPage(0, 10);
    }

    public IStructureDefinition<GT4Entity_AutoCrafter> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"C~C", "C-C", "CCC"}, {"CCC", "CCC", "CCC"}})).addElement('C', (IStructureElement)GT_StructureUtility.buildHatchAdder(GT4Entity_AutoCrafter.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.InputHatch, GT_HatchElement.Maintenance, GT_HatchElement.Energy, GT_HatchElement.Muffler}).casingIndex(TAE.getIndexFromPage(0, 10)).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)12))})).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 1, 1, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        if (this.checkPiece(this.mName, 1, 1, 0) && this.mCasing >= 10 && this.checkHatch()) {
            this.setTier();
            return true;
        }
        return false;
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        if (this.mMachineMode == MODE.ASSEMBLY) {
            return GT_Recipe.GT_Recipe_Map.sAssemblerRecipes;
        }
        if (this.mMachineMode == MODE.DISASSEMBLY || this.mMachineMode == MODE.CRAFTING) {
            return null;
        }
        return GT_Recipe.GT_Recipe_Map.sAssemblerRecipes;
    }

    @Override
    public void onModeChangeByScrewdriver(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.mMachineMode = this.mMachineMode.nextMode() == MODE.CRAFTING ? MODE.ASSEMBLY : this.mMachineMode.nextMode();
        if (this.mMachineMode == MODE.CRAFTING) {
            PlayerUtils.messagePlayer(aPlayer, "You are now running the Auto-Crafter in mode: " + EnumChatFormatting.AQUA + "AutoCrafting");
        } else if (this.mMachineMode == MODE.ASSEMBLY) {
            PlayerUtils.messagePlayer(aPlayer, "You are now running the Auto-Crafter in mode: " + EnumChatFormatting.GREEN + "Assembly");
        } else {
            PlayerUtils.messagePlayer(aPlayer, "You are now running the Auto-Crafter in mode: " + EnumChatFormatting.RED + "Disassembly");
        }
    }

    private void setTier() {
        long tVoltage = this.getMaxInputVoltage();
        this.mTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
    }

    public boolean checkRecipe(ItemStack aStack) {
        if (this.mMachineMode == MODE.DISASSEMBLY) {
            return this.doDisassembly();
        }
        if (this.mMachineMode == MODE.CRAFTING) {
            return this.doCrafting(aStack);
        }
        ArrayList tFluids = this.getStoredFluids();
        for (GT_MetaTileEntity_Hatch_InputBus tBus : this.mInputBusses) {
            FluidStack[] tempArray;
            FluidStack[] properArray;
            ArrayList<ItemStack> tBusItems = new ArrayList<ItemStack>();
            if (GT4Entity_AutoCrafter.isValidMetaTileEntity((MetaTileEntity)tBus)) {
                for (int i = tBus.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                    if (tBus.getBaseMetaTileEntity().func_70301_a(i) == null) continue;
                    tBusItems.add(tBus.getBaseMetaTileEntity().func_70301_a(i));
                }
            }
            FluidStack[] fluidStackArray = properArray = (tempArray = tFluids.toArray(new FluidStack[0])) != null && tempArray.length > 0 ? tempArray : new FluidStack[]{};
            if (!this.checkRecipeGeneric(tBusItems.toArray(new ItemStack[0]), properArray, this.getMaxParallelRecipes(), 100L, 200, 10000)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 2 * Math.max(1, GT_Utility.getTier((long)this.getMaxInputVoltage()));
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 100;
    }

    public boolean doDisassembly() {
        NBTTagCompound tNBT;
        ArrayList tInputList = this.getStoredInputs();
        int tInputList_sS = tInputList.size();
        block0: for (int i = 0; i < tInputList_sS - 1; ++i) {
            for (int j = i + 1; j < tInputList_sS; ++j) {
                if (!GT_Utility.areStacksEqual((ItemStack)((ItemStack)tInputList.get(i)), (ItemStack)((ItemStack)tInputList.get(j)))) continue;
                if (((ItemStack)tInputList.get((int)i)).field_77994_a < ((ItemStack)tInputList.get((int)j)).field_77994_a) {
                    tInputList.remove(i--);
                    tInputList_sS = tInputList.size();
                    continue block0;
                }
                tInputList.remove(j--);
                tInputList_sS = tInputList.size();
            }
        }
        ItemStack[] tInputs = tInputList.toArray(new ItemStack[tInputList.size()]);
        ItemStack inputItem = tInputs[0];
        if (tInputs[0].field_77994_a <= 0) {
            tInputs[0] = null;
            this.updateSlots();
        }
        int outputSlots = ((GT_MetaTileEntity_Hatch_OutputBus)this.mOutputBusses.get(0)).func_70302_i_();
        if (this.mOutputBusses.size() > 1) {
            outputSlots = 0;
            for (GT_MetaTileEntity_Hatch_OutputBus r : this.mOutputBusses) {
                outputSlots += r.func_70302_i_();
            }
        }
        this.mOutputItems = new ItemStack[outputSlots];
        if (inputItem != null && inputItem.field_77994_a > 0 && (tNBT = inputItem.func_77978_p()) != null && (tNBT = tNBT.func_74775_l("GT.CraftingComponents")) != null) {
            this.lEUt = 16L * (1L << this.mTier - 1) * (1L << this.mTier - 1);
            this.mMaxProgresstime = 100 - 8 * this.mTier;
            for (int i = 0; i < this.mOutputItems.length; ++i) {
                if (this.getBaseMetaTileEntity().getRandomNumber(100) >= 60 + 12 * this.mTier) continue;
                this.mOutputItems[i] = GT_Utility.loadItem((NBTTagCompound)tNBT, (String)("Ingredient." + i));
                if (this.mOutputItems[i] == null) continue;
                this.mMaxProgresstime *= 1;
            }
            if (this.mTier > 5) {
                this.mMaxProgresstime >>= this.mTier - 5;
            }
            if (this.lEUt > 0L) {
                this.lEUt = -this.lEUt;
            }
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            --inputItem.field_77994_a;
            if (inputItem.field_77994_a <= 0) {
                tInputs[0] = null;
            }
            this.updateSlots();
            return true;
        }
        return false;
    }

    private boolean doesCrafterHave9SlotInput() {
        GT_MetaTileEntity_Hatch_InputBus craftingInput = null;
        if (!this.mInputBusses.isEmpty()) {
            for (GT_MetaTileEntity_Hatch_InputBus x : this.mInputBusses) {
                if (x.mInventory.length != 9) continue;
                craftingInput = x;
            }
        }
        if (craftingInput == null) {
            Logger.WARNING("Cannot do Auto-Crafting without a 9-slot Input Bus [MV].");
            return false;
        }
        return true;
    }

    private boolean doCrafting(ItemStack aStack) {
        this.mMaxProgresstime = 0;
        return false;
    }

    @Override
    public String[] getExtraInfoData() {
        String tMode;
        String tRunning = this.mMaxProgresstime > 0 ? "Auto-Crafter running" : "Auto-Crafter stopped";
        String tMaintainance = this.getIdealStatus() == this.getRepairStatus() ? "No Maintainance issues" : "Needs Maintainance";
        String tSpecialText = "" + (60 + 12 * this.mTier) + "% chance to recover disassembled parts.";
        if (this.mMachineMode == MODE.DISASSEMBLY) {
            tMode = "\u00a7cDisassembly";
            tSpecialText = "" + (60 + 12 * this.mTier) + "% chance to recover disassembled parts.";
        } else if (this.mMachineMode == MODE.ASSEMBLY) {
            tMode = "\u00a7aAssembly";
            tSpecialText = this.mLastRecipeToBuffer != null && this.mLastRecipeToBuffer.mOutputs[0].func_82833_r() != null ? "Currently processing: " + this.mLastRecipeToBuffer.mOutputs[0].func_82833_r() : "Currently processing: Nothing";
        } else {
            tMode = "\u00a7dAuto-Crafting";
            tSpecialText = "Does Auto-Crafter have 9-slot input bus? " + this.doesCrafterHave9SlotInput();
        }
        return new String[]{"Large Scale Auto-Asesembler v1.01c", tRunning, tMaintainance, "Mode: " + tMode, tSpecialText};
    }

    private String getMode() {
        return this.mMachineMode.name();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        String mMode = this.getMode();
        aNBT.func_74778_a("mMode", mMode);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        MODE newMode;
        String modeString = aNBT.func_74779_i("mMode");
        this.mMachineMode = newMode = MODE.valueOf(modeString);
        super.loadNBTData(aNBT);
    }

    @Override
    public void explodeMultiblock() {
        AC_Helper_Utils.removeCrafter(this);
        super.explodeMultiblock();
    }

    public void onExplosion() {
        AC_Helper_Utils.removeCrafter(this);
        super.onExplosion();
    }

    public void onRemoval() {
        AC_Helper_Utils.removeCrafter(this);
        super.onRemoval();
    }

    public void doExplosion(long aExplosionPower) {
        AC_Helper_Utils.removeCrafter(this);
        super.doExplosion(aExplosionPower);
    }

    public static enum MODE {
        CRAFTING("DISASSEMBLY", "ASSEMBLY"),
        ASSEMBLY("CRAFTING", "DISASSEMBLY"),
        DISASSEMBLY("ASSEMBLY", "CRAFTING");

        private final String lastMode;
        private final String nextMode;

        private MODE(String previous, String next) {
            this.lastMode = previous;
            this.nextMode = next;
        }

        public MODE nextMode() {
            return MODE.valueOf(this.nextMode);
        }

        public MODE lastMode() {
            return MODE.valueOf(this.lastMode);
        }
    }
}

