/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.misc;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.minecraft.ItemStackData;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GMTE_AmazonPackager
extends GregtechMeta_MultiBlockBase<GMTE_AmazonPackager>
implements ISurvivalConstructable {
    private long mVoltage;
    private byte mTier;
    private int mCasing;
    private static IStructureDefinition<GMTE_AmazonPackager> STRUCTURE_DEFINITION = null;
    private static final FluidStack[] sNoFluids = new FluidStack[0];

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GMTE_AmazonPackager(this.mName);
    }

    public GMTE_AmazonPackager(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GMTE_AmazonPackager(String aName) {
        super(aName);
    }

    @Override
    public String getMachineType() {
        return "Packager";
    }

    public IStructureDefinition<GMTE_AmazonPackager> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"C~C", "C-C", "CCC"}, {"CCC", "CCC", "CCC"}})).addElement('C', (IStructureElement)GT_StructureUtility.buildHatchAdder(GMTE_AmazonPackager.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.Maintenance, GT_HatchElement.Energy, GT_HatchElement.Muffler}).casingIndex(TAE.getIndexFromPage(2, 9)).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings3Misc, (int)9))})).build();
        }
        return STRUCTURE_DEFINITION;
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Amazon Warehouse").addInfo("This Multiblock is used for EXTREME packaging requirements").addInfo("Dust Schematics are inserted into the input busses").addInfo("If inserted into the controller, it is shared across all busses").addInfo("1x, 2x, 3x & Other Schematics are to be placed into the controller GUI slot").addInfo("500% faster than using single block machines of the same voltage").addInfo("Only uses 75% of the EU/t normally required").addInfo("Processes 16 items per voltage tier").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 3, 3, true).addController("Front center").addCasingInfo("Supply Depot Casings", 10).addInputBus("Any casing", new int[]{1}).addOutputBus("Any casing", new int[]{1}).addEnergyHatch("Any casing", new int[]{1}).addMaintenanceHatch("Any casing", new int[]{1}).addMufflerHatch("Any casing", new int[]{1}).toolTipFinisher("GT++");
        return tt;
    }

    private final void initFields() {
        this.mVoltage = this.getMaxInputVoltage();
        this.mTier = (byte)Math.max(1, GT_Utility.getTier((long)this.mVoltage));
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced;
    }

    @Override
    protected int getCasingTextureId() {
        return TAE.getIndexFromPage(2, 9);
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sBoxinatorRecipes;
    }

    public boolean checkRecipe(ItemStack aStack) {
        ItemStack[] tItemInputs;
        boolean state;
        this.initFields();
        ArrayList tItems = this.getStoredInputs();
        if (this.getGUIItemStack() != null) {
            tItems.add(this.getGUIItemStack());
        }
        if (state = this.checkRecipeGeneric(tItemInputs = tItems.toArray(new ItemStack[tItems.size()]), sNoFluids, this.getMaxParallelRecipes(), 75L, 500, 10000)) {
            return true;
        }
        tItems = this.getStoredInputs();
        AutoMap<ItemStackData> mCompleted = new AutoMap<ItemStackData>();
        AutoMap<ItemStackData> mSchematics = new AutoMap<ItemStackData>();
        for (ItemStack tInputItem : tItems) {
            if (tInputItem == null || !ItemList.Schematic_1by1.isStackEqual((Object)tInputItem) && !ItemList.Schematic_2by2.isStackEqual((Object)tInputItem) && !ItemList.Schematic_3by3.isStackEqual((Object)tInputItem)) continue;
            mSchematics.put(new ItemStackData(tInputItem));
        }
        if (mSchematics.size() > 0) {
            for (ItemStackData g : mSchematics) {
                for (ItemStack tInputItem : tItems) {
                    if (tInputItem == null) continue;
                    mCompleted.put(new ItemStackData(tInputItem));
                    this.checkRecipe(tInputItem, g.getStack());
                }
            }
        }
        return mCompleted != null && mCompleted.size() > 0;
    }

    public boolean checkRecipe(ItemStack inputStack, ItemStack schematicStack) {
        if (GT_Utility.isStackValid((Object)inputStack) && GT_Utility.isStackValid((Object)schematicStack) && GT_Utility.getContainerItem((ItemStack)inputStack, (boolean)true) == null) {
            if (ItemList.Schematic_1by1.isStackEqual((Object)schematicStack) && inputStack.field_77994_a >= 1) {
                ItemStack tOutputStack = GT_ModHandler.getRecipeOutput((ItemStack[])new ItemStack[]{inputStack});
                if (tOutputStack != null && this.allowPutStack(tOutputStack, schematicStack)) {
                    ItemStack input = inputStack;
                    --input.field_77994_a;
                    this.lEUt = 32L * (1L << this.mTier - 1) * (1L << this.mTier - 1);
                    this.mMaxProgresstime = 2;
                    this.addOutput(tOutputStack);
                    this.updateSlots();
                    return true;
                }
                return false;
            }
            if (ItemList.Schematic_2by2.isStackEqual((Object)schematicStack) && inputStack.field_77994_a >= 4) {
                ItemStack tOutputStack = GT_ModHandler.getRecipeOutput((ItemStack[])new ItemStack[]{inputStack, inputStack, null, inputStack, inputStack});
                if (tOutputStack != null && this.allowPutStack(tOutputStack, schematicStack)) {
                    ItemStack input2 = inputStack;
                    input2.field_77994_a -= 4;
                    this.lEUt = 32L * (1L << this.mTier - 1) * (1L << this.mTier - 1);
                    this.mMaxProgresstime = 4;
                    this.addOutput(tOutputStack);
                    this.updateSlots();
                    return true;
                }
                return false;
            }
            if (ItemList.Schematic_3by3.isStackEqual((Object)schematicStack) && inputStack.field_77994_a >= 9) {
                ItemStack tOutputStack = GT_ModHandler.getRecipeOutput((ItemStack[])new ItemStack[]{inputStack, inputStack, inputStack, inputStack, inputStack, inputStack, inputStack, inputStack, inputStack});
                if (tOutputStack != null && this.allowPutStack(tOutputStack, schematicStack)) {
                    ItemStack input3 = inputStack;
                    input3.field_77994_a -= 9;
                    this.lEUt = 32L * (1L << this.mTier - 1) * (1L << this.mTier - 1);
                    this.mMaxProgresstime = 6;
                    this.addOutput(tOutputStack);
                    this.updateSlots();
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public boolean allowPutStack(ItemStack aStack, ItemStack schematicStack) {
        if (!(ItemList.Schematic_1by1.isStackEqual((Object)schematicStack) || ItemList.Schematic_2by2.isStackEqual((Object)schematicStack) || ItemList.Schematic_3by3.isStackEqual((Object)schematicStack))) {
            return GT_Recipe.GT_Recipe_Map.sBoxinatorRecipes.containsInput(aStack);
        }
        if (GT_Recipe.GT_Recipe_Map.sBoxinatorRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), true, GT_Values.V[this.mTier], (FluidStack[])null, new ItemStack[]{GT_Utility.copyAmount((long)64L, (Object[])new Object[]{aStack}), schematicStack}) != null) {
            return true;
        }
        if (ItemList.Schematic_1by1.isStackEqual((Object)schematicStack) && GT_ModHandler.getRecipeOutput((ItemStack[])new ItemStack[]{aStack}) != null) {
            return true;
        }
        if (ItemList.Schematic_2by2.isStackEqual((Object)schematicStack) && GT_ModHandler.getRecipeOutput((ItemStack[])new ItemStack[]{aStack, aStack, null, aStack, aStack}) != null) {
            return true;
        }
        return ItemList.Schematic_3by3.isStackEqual((Object)schematicStack) && GT_ModHandler.getRecipeOutput((ItemStack[])new ItemStack[]{aStack, aStack, aStack, aStack, aStack, aStack, aStack, aStack, aStack}) != null;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 1, 1, 0) && this.mCasing >= 10 && this.checkHatch();
    }

    public int getMaxEfficiency(ItemStack p0) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack arg0) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiPackager;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 16 * GT_Utility.getTier((long)this.getMaxInputVoltage());
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 0;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 1, 1, 0, elementBudget, env, false, true);
    }
}

