/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.basic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.objects.GT_RenderedTexture;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_WorldAccelerator
extends GT_MetaTileEntity_TieredMachineBlock {
    public static String[] BlacklistedTileEntiyClassNames;
    private byte mMode = 0;
    private static Textures.BlockIcons.CustomIcon _mGTIco_Norm_Idle;
    private static Textures.BlockIcons.CustomIcon _mGTIco_Norm_Active;
    private static Textures.BlockIcons.CustomIcon _mGTIco_TE_Idle;
    private static Textures.BlockIcons.CustomIcon _mGTIco_TE_Active;
    private static int[] mAccelerateStatic;
    private static String[] mModeStr;
    private static List<String> _mBlacklistedTileEntities;

    public void registerIcons(IIconRegister aBlockIconRegister) {
        super.registerIcons(aBlockIconRegister);
        _mGTIco_Norm_Idle = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_ACCELERATOR");
        _mGTIco_Norm_Active = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_ACCELERATOR_ACTIVE");
        _mGTIco_TE_Idle = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_ACCELERATOR_TE");
        _mGTIco_TE_Active = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_ACCELERATOR_TE_ACTIVE");
    }

    @SideOnly(value=Side.CLIENT)
    public void onValueUpdate(byte aValue) {
        this.mMode = aValue;
    }

    public byte getUpdateData() {
        return this.mMode;
    }

    public GT_MetaTileEntity_WorldAccelerator(int pID, String pName, String pNameRegional, int pTier) {
        super(pID, pName, pNameRegional, pTier, 0, "", new ITexture[0]);
    }

    public String[] getDescription() {
        return new String[]{String.format("Accelerating things (Radius: %d EU/t: %d Speed Bonus: x%d)", this.mTier, GT_MetaTileEntity_WorldAccelerator.getEnergyDemand(this.mTier, false), mAccelerateStatic[this.mTier]), "Use a screwdriver to change mode", "To accelerate TileEntities, this machine has to be adjacent to it", "This machine accepts up to 8 Amps", "Accelerating TileEntities doubles Energy-Demand"};
    }

    public GT_MetaTileEntity_WorldAccelerator(String pName, int pTier, int pInvSlotCount, String pDescription, ITexture[][][] pTextures) {
        super(pName, pTier, pInvSlotCount, pDescription, pTextures);
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity pTileEntity) {
        return new GT_MetaTileEntity_WorldAccelerator(this.mName, this.mTier, this.mInventory.length, this.mDescription, this.mTextures);
    }

    public ITexture[][][] getTextureSet(ITexture[] pTextures) {
        return new ITexture[0][0][0];
    }

    public ITexture[] getTexture(IGregTechTileEntity pBaseMetaTileEntity, byte pSide, byte pFacing, byte pColorIndex, boolean pActive, boolean pRedstone) {
        if (this.mMode == 0) {
            return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][pColorIndex + 1], pSide < 2 ? null : (pActive ? new GT_RenderedTexture((IIconContainer)_mGTIco_Norm_Active) : new GT_RenderedTexture((IIconContainer)_mGTIco_Norm_Idle))};
        }
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][pColorIndex + 1], pSide < 2 ? null : (pActive ? new GT_RenderedTexture((IIconContainer)_mGTIco_TE_Active) : new GT_RenderedTexture((IIconContainer)_mGTIco_TE_Idle))};
    }

    public boolean allowPullStack(IGregTechTileEntity pBaseMetaTileEntity, int pIndex, byte pSide, ItemStack pStack) {
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity pBaseMetaTileEntity, int pIndex, byte pSide, ItemStack pStack) {
        return false;
    }

    public void saveNBTData(NBTTagCompound pNBT) {
        pNBT.func_74774_a("mAccelMode", this.mMode);
    }

    public static long getEnergyDemand(int pTier, boolean pIsAcceleratingTEs) {
        return GT_Values.V[pTier] * (long)(pIsAcceleratingTEs ? 6 : 3);
    }

    public void loadNBTData(NBTTagCompound pNBT) {
        this.mMode = pNBT.func_74771_c("mAccelMode");
    }

    public boolean isAccessAllowed(EntityPlayer pPlayer) {
        return true;
    }

    public boolean isSimpleMachine() {
        return false;
    }

    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    public boolean isEnetInput() {
        return true;
    }

    public boolean isInputFacing(byte aSide) {
        return true;
    }

    public boolean isTeleporterCompatible() {
        return false;
    }

    public long getMinimumStoredEU() {
        return 512L;
    }

    public long maxEUStore() {
        return 512L + GT_Values.V[this.mTier] * 50L;
    }

    public long maxEUInput() {
        return GT_Values.V[this.mTier];
    }

    public long maxAmperesIn() {
        return 8L;
    }

    public void onScrewdriverRightClick(byte pSide, EntityPlayer pPlayer, float pX, float pY, float pZ) {
        this.mMode = (byte)(this.mMode == 0 ? 1 : 0);
        this.func_70296_d();
        PlayerUtils.messagePlayer(pPlayer, String.format("Switched mode to: %s", mModeStr[this.mMode]));
    }

    public void onPostTick(IGregTechTileEntity pBaseMetaTileEntity, long pTick) {
        try {
            if (!pBaseMetaTileEntity.isServerSide()) {
                return;
            }
            long tEnergyDemand = GT_MetaTileEntity_WorldAccelerator.getEnergyDemand(this.mTier, this.mMode == 1);
            if (pBaseMetaTileEntity.getStoredEU() < tEnergyDemand || !pBaseMetaTileEntity.isAllowedToWork()) {
                if (pBaseMetaTileEntity.isActive()) {
                    pBaseMetaTileEntity.setActive(false);
                }
            } else if (pBaseMetaTileEntity.decreaseStoredEnergyUnits(tEnergyDemand, false)) {
                World tWorld = pBaseMetaTileEntity.getWorld();
                if (this.mMode == 0) {
                    if (pTick % 20L == 0L) {
                        this.doAccelerateNormalBlocks(pBaseMetaTileEntity, tWorld);
                    }
                } else {
                    this.doAccelerateTileEntities(pBaseMetaTileEntity, tWorld);
                }
            } else if (pBaseMetaTileEntity.isActive()) {
                pBaseMetaTileEntity.setActive(false);
            }
        }
        catch (Exception e) {
            Logger.ERROR("GT_MetaTileEntity_WorldAccelerator.onPostTick.crash");
            Logger.ERROR(e.getMessage());
        }
    }

    private void doAccelerateTileEntities(IGregTechTileEntity pBaseMetaTileEntity, World pWorld) {
        try {
            if (!pBaseMetaTileEntity.isActive()) {
                this.getBaseMetaTileEntity().setActive(true);
            }
            block2: for (ForgeDirection tDir : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tTile = pBaseMetaTileEntity.getTileEntityAtSide((byte)tDir.ordinal());
                if (this.isTEBlackListed(tTile)) continue;
                long tMaxTime = System.nanoTime() + 1000000L;
                for (int j = 0; j < mAccelerateStatic[this.mTier]; ++j) {
                    tTile.func_145845_h();
                    if (System.nanoTime() > tMaxTime) continue block2;
                }
            }
        }
        catch (Exception e) {
            Logger.ERROR("GT_MetaTileEntity_WorldAccelerator.doAccelerateTileEntities.crash");
            Logger.ERROR(e.getMessage());
        }
    }

    private boolean isTEBlackListed(TileEntity pTile) {
        if (pTile == null) {
            return true;
        }
        if (!pTile.canUpdate()) {
            return true;
        }
        if (pTile.func_145837_r()) {
            return true;
        }
        String tSimpleClassName = pTile.getClass().getSimpleName().toLowerCase();
        String tCanonicalName = pTile.getClass().getCanonicalName().toLowerCase();
        if (tSimpleClassName.contains("conduit") || tSimpleClassName.contains("wire") || tSimpleClassName.contains("cable")) {
            return true;
        }
        if (tCanonicalName.contains("appeng") || tCanonicalName.contains("gregtech")) {
            return true;
        }
        for (String tS : BlacklistedTileEntiyClassNames) {
            if (!tCanonicalName.equalsIgnoreCase(tS)) continue;
            return true;
        }
        return false;
    }

    private void doAccelerateNormalBlocks(IGregTechTileEntity pBaseMetaTileEntity, World pWorld) {
        if (!pBaseMetaTileEntity.isActive()) {
            this.getBaseMetaTileEntity().setActive(true);
        }
        Random rnd = new Random();
        int tX = pBaseMetaTileEntity.getXCoord();
        short tY = pBaseMetaTileEntity.getYCoord();
        int tZ = pBaseMetaTileEntity.getZCoord();
        int tX1 = tX - this.mTier;
        int tX2 = tX + this.mTier;
        int tY1 = Math.max(tY - this.mTier, 0);
        int tY2 = Math.min(tY + this.mTier, 255);
        int tZ1 = tZ - this.mTier;
        int tZ2 = tZ + this.mTier;
        for (int xi = tX1; xi <= tX2; ++xi) {
            for (int yi = tY1; yi <= tY2; ++yi) {
                for (int zi = tZ1; zi <= tZ2; ++zi) {
                    this.tryTickBlock(pWorld, xi, yi, zi, rnd);
                }
            }
        }
    }

    private void tryTickBlock(World pWorld, int pX, int pY, int pZ, Random pRnd) {
        try {
            for (int j = 0; j < this.mTier; ++j) {
                Block tBlock = pWorld.func_147439_a(pX, pY, pZ);
                if (!tBlock.func_149653_t()) continue;
                tBlock.func_149674_a(pWorld, pX, pY, pZ, pRnd);
            }
        }
        catch (Exception e) {
            Logger.ERROR("GT_MetaTileEntity_WorldAccelerator.tryTickBlock.crash");
            Logger.ERROR(e.getMessage());
        }
    }

    static {
        mAccelerateStatic = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 512, 512, 512, 512, 512, 512};
        mModeStr = new String[]{"Blocks", "TileEntities"};
        _mBlacklistedTileEntities = new ArrayList<String>();
    }
}

