/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.generators;

import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicGenerator;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Recipe;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class GregtechMetaTileEntityGeothermalGenerator
extends GT_MetaTileEntity_BasicGenerator {
    public int mEfficiency;

    public GregtechMetaTileEntityGeothermalGenerator(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, "Requires Pahoehoe Lava or Normal Lava as Fuel", new ITexture[0]);
        this.onConfigLoad();
    }

    public GregtechMetaTileEntityGeothermalGenerator(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
        this.onConfigLoad();
    }

    public String[] getDescription() {
        String aPollution = "Causes " + this.getPollution() + " Pollution per second";
        return new String[]{this.mDescription, "Generates power at " + this.getEfficiency() + "% Efficiency per tick", aPollution, CORE.GT_Tooltip.get()};
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GT_UIInfos.openGTTileEntityUI((IHasWorldObjectAndCoords)aBaseMetaTileEntity, (EntityPlayer)aPlayer);
        return true;
    }

    public int getCapacity() {
        return 5000 * this.mTier;
    }

    public void onConfigLoad() {
        this.mEfficiency = GregTech_API.sMachineFile.get((Object)ConfigCategories.machineconfig, "ThermalGenerator.efficiency.tier." + this.mTier, 100 - this.mTier * 7);
    }

    public int getEfficiency() {
        return this.mEfficiency;
    }

    public int getFuelValue(ItemStack aStack) {
        int rValue = Math.max(GT_ModHandler.getFuelCanValue((ItemStack)aStack) * 6 / 5, super.getFuelValue(aStack));
        if (ItemList.Fuel_Can_Plastic_Filled.isStackEqual((Object)aStack, false, true)) {
            rValue = Math.max(rValue, GameRegistry.getFuelValue((ItemStack)aStack) * 3);
        }
        return rValue;
    }

    public boolean isOutputFacing(byte aSide) {
        return aSide == this.getBaseMetaTileEntity().getFrontFacing();
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntityGeothermalGenerator(this.mName, this.mTier, this.mDescription, this.mTextures);
    }

    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{super.getFront(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.DIESEL_GENERATOR_SIDE), Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI[this.mTier]};
    }

    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{super.getBack(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.DIESEL_GENERATOR_BACK), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Overlay_Machine_Diesel_Vertical)};
    }

    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{super.getBottom(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.DIESEL_GENERATOR_BOTTOM)};
    }

    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{super.getTop(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.DIESEL_GENERATOR_SIDE), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ROCK_BREAKER)};
    }

    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{super.getSides(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.BOILER_LAVA_FRONT)};
    }

    public ITexture[] getFrontActive(byte aColor) {
        return new ITexture[]{super.getFrontActive(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.DIESEL_GENERATOR_SIDE_ACTIVE), Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI[this.mTier]};
    }

    public ITexture[] getBackActive(byte aColor) {
        return new ITexture[]{super.getBackActive(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.DIESEL_GENERATOR_BACK_ACTIVE), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Overlay_Machine_Diesel_Vertical_Active)};
    }

    public ITexture[] getBottomActive(byte aColor) {
        return new ITexture[]{super.getBottomActive(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.DIESEL_GENERATOR_BOTTOM_ACTIVE)};
    }

    public ITexture[] getTopActive(byte aColor) {
        return new ITexture[]{super.getTopActive(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.DIESEL_GENERATOR_SIDE), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ROCK_BREAKER_ACTIVE)};
    }

    public ITexture[] getSidesActive(byte aColor) {
        return new ITexture[]{super.getSidesActive(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.BOILER_LAVA_FRONT_ACTIVE)};
    }

    public GT_Recipe.GT_Recipe_Map getRecipes() {
        return GT_Recipe.GT_Recipe_Map.sHotFuels;
    }

    public int getPollution() {
        return (int)((double)CORE.ConfigSwitches.basePollutionPerSecondGeothermalGenerator * CORE.ConfigSwitches.pollutionReleasedByTierGeothermalGenerator[this.mTier]);
    }
}

