/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.generators;

import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicGenerator;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.CORE;
import net.minecraft.item.ItemStack;

public class GT_MetaTileEntity_SemiFluidGenerator
extends GT_MetaTileEntity_BasicGenerator {
    public int mEfficiency;

    public GT_MetaTileEntity_SemiFluidGenerator(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, "Requires semi-fluid Fuel", new ITexture[0]);
        this.onConfigLoad();
    }

    public GT_MetaTileEntity_SemiFluidGenerator(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
        this.onConfigLoad();
    }

    public int getPollution() {
        return (int)((double)CORE.ConfigSwitches.basePollutionPerSecondSemiFluidGenerator * CORE.ConfigSwitches.pollutionReleasedByTierSemiFluidGenerator[this.mTier]);
    }

    public int getCapacity() {
        return 4000 * this.mTier;
    }

    public void onConfigLoad() {
        this.mEfficiency = GregTech_API.sMachineFile.get((Object)ConfigCategories.machineconfig, "SemiFluidGenerator.efficiency.tier." + this.mTier, 100 - this.mTier * 5);
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_SemiFluidGenerator(this.mName, this.mTier, this.mDescription, this.mTextures);
    }

    public GT_Recipe.GT_Recipe_Map getRecipes() {
        return GTPP_Recipe.GTPP_Recipe_Map.sSemiFluidLiquidFuels;
    }

    public String[] getDescription() {
        return new String[]{this.mDescription, "Produces " + this.getPollution() + " pollution/sec", "Fuel Efficiency: " + this.getEfficiency() + "%", CORE.GT_Tooltip.get()};
    }

    public int getEfficiency() {
        return this.mEfficiency;
    }

    public boolean isOutputFacing(byte aSide) {
        return aSide == this.getBaseMetaTileEntity().getFrontFacing();
    }

    public boolean allowCoverOnSide(byte aSide, GT_ItemStack aCover) {
        if (aSide != this.getBaseMetaTileEntity().getFrontFacing()) {
            return true;
        }
        return super.allowCoverOnSide(aSide, aCover);
    }

    public int getFuelValue(ItemStack aStack) {
        if (GT_Utility.isStackInvalid((Object)aStack) || this.getRecipes() == null) {
            Logger.WARNING("Bad Fuel?");
            return 0;
        }
        int rValue = Math.max(GT_ModHandler.getFuelCanValue((ItemStack)aStack) * 6 / 5, super.getFuelValue(aStack));
        if (ItemList.Fuel_Can_Plastic_Filled.isStackEqual((Object)aStack, false, true)) {
            rValue = Math.max(rValue, GameRegistry.getFuelValue((ItemStack)aStack) * 3);
        }
        Logger.WARNING("Good Fuel: " + rValue);
        return rValue;
    }

    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{super.getFront(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.DIESEL_GENERATOR_FRONT), Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mTier]};
    }

    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{super.getBack(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.DIESEL_GENERATOR_TOP)};
    }

    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{super.getBottom(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.DIESEL_GENERATOR_BOTTOM)};
    }

    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{super.getTop(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.DIESEL_GENERATOR_SIDE)};
    }

    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{super.getSides(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.DIESEL_GENERATOR_TOP)};
    }

    public ITexture[] getFrontActive(byte aColor) {
        return new ITexture[]{super.getFrontActive(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.DIESEL_GENERATOR_FRONT_ACTIVE), Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mTier]};
    }

    public ITexture[] getBackActive(byte aColor) {
        return new ITexture[]{super.getBackActive(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.DIESEL_GENERATOR_TOP_ACTIVE)};
    }

    public ITexture[] getBottomActive(byte aColor) {
        return new ITexture[]{super.getBottomActive(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.DIESEL_GENERATOR_BOTTOM_ACTIVE)};
    }

    public ITexture[] getTopActive(byte aColor) {
        return new ITexture[]{super.getTopActive(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.DIESEL_GENERATOR_SIDE_ACTIVE)};
    }

    public ITexture[] getSidesActive(byte aColor) {
        return new ITexture[]{super.getSidesActive(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.DIESEL_GENERATOR_TOP_ACTIVE)};
    }
}

