/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.automation;

import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.wrapper.BaseSlot;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddGregtechLogo;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.xmod.gregtech.api.gui.GTPP_UITextures;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class GT_MetaTileEntity_ElectricInventoryManager
extends GT_MetaTileEntity_TieredMachineBlock
implements IAddGregtechLogo,
IAddUIWidgets {
    public int[] mSlotRange = new int[4];
    public boolean mWorkedLastTick = false;
    protected String mLocalName;
    private final int[] mTargetDirections = new int[12];
    private final int[] mRangeDirections = new int[4];
    private final boolean[] mTargetInOut = new boolean[12];
    private final boolean[] mTargetEnergy = new boolean[4];

    public GT_MetaTileEntity_ElectricInventoryManager(int aID, int aTier, String aDescription) {
        super(aID, "basicmachine.automation.inventorymanager.0" + aTier, "Electric Inventory Manager (" + GT_Values.VN[aTier] + ")", aTier, 16, aDescription, new ITexture[0]);
        this.mLocalName = "Auto Workbench (" + GT_Values.VN[aTier] + ")";
    }

    public GT_MetaTileEntity_ElectricInventoryManager(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 16, aDescription, aTextures);
    }

    public boolean isTransformerUpgradable() {
        return true;
    }

    public boolean isOverclockerUpgradable() {
        return false;
    }

    public boolean isSimpleMachine() {
        return false;
    }

    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    public boolean isEnetInput() {
        return true;
    }

    public boolean isEnetOutput() {
        return true;
    }

    public long maxEUInput() {
        return GT_Values.V[this.mTier];
    }

    public long maxEUOutput() {
        return GT_Values.V[this.mTier];
    }

    public long getMinimumStoredEU() {
        return GT_Values.V[this.mTier];
    }

    public long maxEUStore() {
        return GT_Values.V[this.mTier] * ((long)this.mTier * GT_Values.V[this.mTier]);
    }

    public long maxAmperesIn() {
        return 4L;
    }

    public long maxAmperesOut() {
        return 4L;
    }

    public boolean isValidSlot(int aIndex) {
        return aIndex < 3;
    }

    public boolean isInputFacing(byte aSide) {
        return !this.isOutputFacing(aSide);
    }

    public boolean isOutputFacing(byte aSide) {
        for (int i = 0; i < this.mSlotRange.length; ++i) {
            if (aSide != this.getRangeDirection(i) || !this.getRangeEnergy(i)) continue;
            return true;
        }
        return false;
    }

    public int func_70302_i_() {
        return 16;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GT_UIInfos.openGTTileEntityUI((IHasWorldObjectAndCoords)aBaseMetaTileEntity, (EntityPlayer)aPlayer);
        return true;
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_ElectricInventoryManager(this.mName, this.mTier, this.mDescription, this.mTextures);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mSlotRange0", this.mSlotRange[0]);
        aNBT.func_74768_a("mSlotRange1", this.mSlotRange[1]);
        aNBT.func_74768_a("mSlotRange2", this.mSlotRange[2]);
        aNBT.func_74768_a("mSlotRange3", this.mSlotRange[3]);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.mSlotRange[0] = aNBT.func_74762_e("mSlotRange0");
        this.mSlotRange[1] = aNBT.func_74762_e("mSlotRange1");
        this.mSlotRange[2] = aNBT.func_74762_e("mSlotRange2");
        this.mSlotRange[3] = aNBT.func_74762_e("mSlotRange3");
    }

    public void iterateRangeDirection(int aIndex) {
        this.mSlotRange[aIndex] = this.mSlotRange[aIndex] & 0xFFFFFFF8 | ((this.mSlotRange[aIndex] & 7) + 1) % 6;
    }

    public void switchRangeEnergy(int aIndex) {
        this.mSlotRange[aIndex] = this.mSlotRange[aIndex] & 0xFFFFFFF7 | ((this.mSlotRange[aIndex] & 8) > 0 ? 0 : 8);
    }

    public void iterateSlot1Direction(int aIndex) {
        this.mSlotRange[aIndex] = this.mSlotRange[aIndex] & 0xFFFFFF8F | (((this.mSlotRange[aIndex] & 0x70) >> 4) + 1) % 6 << 4;
    }

    public void iterateSlot2Direction(int aIndex) {
        this.mSlotRange[aIndex] = this.mSlotRange[aIndex] & 0xFFFFFC7F | (((this.mSlotRange[aIndex] & 0x380) >> 7) + 1) % 6 << 7;
    }

    public void iterateSlot3Direction(int aIndex) {
        this.mSlotRange[aIndex] = this.mSlotRange[aIndex] & 0xFFFFE3FF | (((this.mSlotRange[aIndex] & 0x1C00) >> 10) + 1) % 6 << 10;
    }

    public void switchSlot1InOut(int aIndex) {
        this.mSlotRange[aIndex] = this.mSlotRange[aIndex] & 0xFFFFDFFF | ((this.mSlotRange[aIndex] & 0x2000) > 0 ? 0 : 8192);
    }

    public void switchSlot2InOut(int aIndex) {
        this.mSlotRange[aIndex] = this.mSlotRange[aIndex] & 0xFFFFBFFF | ((this.mSlotRange[aIndex] & 0x4000) > 0 ? 0 : 16384);
    }

    public void switchSlot3InOut(int aIndex) {
        this.mSlotRange[aIndex] = this.mSlotRange[aIndex] & 0xFFFF7FFF | ((this.mSlotRange[aIndex] & 0x8000) > 0 ? 0 : 32768);
    }

    public byte getRangeDirection(int aIndex) {
        return (byte)(this.mSlotRange[aIndex] & 7);
    }

    public byte getSlot1Direction(int aIndex) {
        return (byte)((this.mSlotRange[aIndex] & 0x70) >> 4);
    }

    public byte getSlot2Direction(int aIndex) {
        return (byte)((this.mSlotRange[aIndex] & 0x380) >> 7);
    }

    public byte getSlot3Direction(int aIndex) {
        return (byte)((this.mSlotRange[aIndex] & 0x1C00) >> 10);
    }

    public boolean getRangeEnergy(int aIndex) {
        return (this.mSlotRange[aIndex] & 8) > 0;
    }

    public boolean getSlot1InOut(int aIndex) {
        return (this.mSlotRange[aIndex] & 0x2000) > 0;
    }

    public boolean getSlot2InOut(int aIndex) {
        return (this.mSlotRange[aIndex] & 0x4000) > 0;
    }

    public boolean getSlot3InOut(int aIndex) {
        return (this.mSlotRange[aIndex] & 0x8000) > 0;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.getBaseMetaTileEntity().isAllowedToWork() && this.getBaseMetaTileEntity().isServerSide() && this.getBaseMetaTileEntity().getUniversalEnergyStored() >= 5000L && (this.getBaseMetaTileEntity().hasWorkJustBeenEnabled() || this.getBaseMetaTileEntity().getTimer() % 100L == 0L || this.mWorkedLastTick || this.getBaseMetaTileEntity().hasInventoryBeenModified())) {
            this.mWorkedLastTick = false;
            IInventory[] tTileEntities = new IInventory[]{this.getBaseMetaTileEntity().getIInventoryAtSide((byte)0), this.getBaseMetaTileEntity().getIInventoryAtSide((byte)1), this.getBaseMetaTileEntity().getIInventoryAtSide((byte)2), this.getBaseMetaTileEntity().getIInventoryAtSide((byte)3), this.getBaseMetaTileEntity().getIInventoryAtSide((byte)4), this.getBaseMetaTileEntity().getIInventoryAtSide((byte)5), null, null};
            int tCost = 0;
            for (int i = 0; i < 4; ++i) {
                if (tTileEntities[this.getRangeDirection(i)] == null) continue;
                ArrayList<ItemStack> tList = new ArrayList<ItemStack>();
                tList.add(null);
                ItemStack tStack = this.mInventory[3 + i * 3 + 0];
                if (tStack == null) {
                    tCost = this.getSlot1InOut(i) ? (tCost += 5 * GT_Utility.moveOneItemStack((Object)this.getBaseMetaTileEntity(), (Object)tTileEntities[this.getRangeDirection(i)], (byte)this.getSlot1Direction(i), (byte)this.getSlot1Direction(i), null, (boolean)false, (byte)64, (byte)1, (byte)64, (byte)1)) : (tCost += 5 * GT_Utility.moveOneItemStack((Object)tTileEntities[this.getRangeDirection(i)], (Object)this.getBaseMetaTileEntity(), (byte)this.getSlot1Direction(i), (byte)this.getSlot1Direction(i), null, (boolean)false, (byte)64, (byte)1, (byte)64, (byte)1));
                } else {
                    tList.set(0, tStack);
                    tCost = this.getSlot1InOut(i) ? (tCost += 5 * GT_Utility.moveOneItemStack((Object)this.getBaseMetaTileEntity(), (Object)tTileEntities[this.getRangeDirection(i)], (byte)this.getSlot1Direction(i), (byte)this.getSlot1Direction(i), tList, (boolean)false, (byte)((byte)tStack.field_77994_a), (byte)1, (byte)64, (byte)1)) : (tCost += 5 * GT_Utility.moveOneItemStack((Object)tTileEntities[this.getRangeDirection(i)], (Object)this.getBaseMetaTileEntity(), (byte)this.getSlot1Direction(i), (byte)this.getSlot1Direction(i), tList, (boolean)false, (byte)((byte)tStack.field_77994_a), (byte)1, (byte)64, (byte)1));
                }
                tStack = this.mInventory[3 + i * 3 + 1];
                if (tStack == null) {
                    tCost = this.getSlot2InOut(i) ? (tCost += 5 * GT_Utility.moveOneItemStack((Object)this.getBaseMetaTileEntity(), (Object)tTileEntities[this.getRangeDirection(i)], (byte)this.getSlot2Direction(i), (byte)this.getSlot2Direction(i), null, (boolean)false, (byte)64, (byte)1, (byte)64, (byte)1)) : (tCost += 5 * GT_Utility.moveOneItemStack((Object)tTileEntities[this.getRangeDirection(i)], (Object)this.getBaseMetaTileEntity(), (byte)this.getSlot2Direction(i), (byte)this.getSlot2Direction(i), null, (boolean)false, (byte)64, (byte)1, (byte)64, (byte)1));
                } else {
                    tList.set(0, tStack);
                    tCost = this.getSlot2InOut(i) ? (tCost += 5 * GT_Utility.moveOneItemStack((Object)this.getBaseMetaTileEntity(), (Object)tTileEntities[this.getRangeDirection(i)], (byte)this.getSlot2Direction(i), (byte)this.getSlot2Direction(i), tList, (boolean)false, (byte)((byte)tStack.field_77994_a), (byte)1, (byte)64, (byte)1)) : (tCost += 5 * GT_Utility.moveOneItemStack((Object)tTileEntities[this.getRangeDirection(i)], (Object)this.getBaseMetaTileEntity(), (byte)this.getSlot2Direction(i), (byte)this.getSlot2Direction(i), tList, (boolean)false, (byte)((byte)tStack.field_77994_a), (byte)1, (byte)64, (byte)1));
                }
                tStack = this.mInventory[3 + i * 3 + 2];
                if (tStack == null) {
                    if (this.getSlot3InOut(i)) {
                        tCost += 5 * GT_Utility.moveOneItemStack((Object)this.getBaseMetaTileEntity(), (Object)tTileEntities[this.getRangeDirection(i)], (byte)this.getSlot3Direction(i), (byte)this.getSlot3Direction(i), null, (boolean)false, (byte)64, (byte)1, (byte)64, (byte)1);
                        continue;
                    }
                    tCost += 5 * GT_Utility.moveOneItemStack((Object)tTileEntities[this.getRangeDirection(i)], (Object)this.getBaseMetaTileEntity(), (byte)this.getSlot3Direction(i), (byte)this.getSlot3Direction(i), null, (boolean)false, (byte)64, (byte)1, (byte)64, (byte)1);
                    continue;
                }
                tList.set(0, tStack);
                if (this.getSlot3InOut(i)) {
                    tCost += 5 * GT_Utility.moveOneItemStack((Object)this.getBaseMetaTileEntity(), (Object)tTileEntities[this.getRangeDirection(i)], (byte)this.getSlot3Direction(i), (byte)this.getSlot3Direction(i), tList, (boolean)false, (byte)((byte)tStack.field_77994_a), (byte)1, (byte)64, (byte)1);
                    continue;
                }
                tCost += 5 * GT_Utility.moveOneItemStack((Object)tTileEntities[this.getRangeDirection(i)], (Object)this.getBaseMetaTileEntity(), (byte)this.getSlot3Direction(i), (byte)this.getSlot3Direction(i), tList, (boolean)false, (byte)((byte)tStack.field_77994_a), (byte)1, (byte)64, (byte)1);
            }
            if (tCost > 0) {
                this.mWorkedLastTick = true;
                this.getBaseMetaTileEntity().decreaseStoredEnergyUnits((long)tCost, true);
            }
        }
    }

    public String[] getDescription() {
        return new String[]{"It's simpler than you think. I promise.", this.mDescription, CORE.GT_Tooltip.get()};
    }

    public boolean allowCoverOnSide(byte aSide, GT_ItemStack aStack) {
        return false;
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return true;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return true;
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[16][17][];
        for (byte i = -1; i < 16; i = (byte)(i + 1)) {
            rTextures[0][i + 1] = this.getBottom(i);
            rTextures[1][i + 1] = this.getTop(i);
            rTextures[2][i + 1] = this.getNegativeZ(i);
            rTextures[3][i + 1] = this.getPositiveZ(i);
            rTextures[4][i + 1] = this.getNegativeX(i);
            rTextures[5][i + 1] = this.getPositiveX(i);
            rTextures[6][i + 1] = this.getBottomRedstone(i);
            rTextures[7][i + 1] = this.getTopRedstone(i);
            rTextures[8][i + 1] = this.getNegativeZRedstone(i);
            rTextures[9][i + 1] = this.getPositiveZRedstone(i);
            rTextures[10][i + 1] = this.getNegativeXRedstone(i);
            rTextures[11][i + 1] = this.getPositiveXRedstone(i);
        }
        return rTextures;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        return this.mTextures[!aRedstone ? aSide : aSide + 6][aColorIndex < 0 ? (byte)0 : aColorIndex];
    }

    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_InventoryManagaer_Red)};
    }

    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_InventoryManagaer_Green)};
    }

    public ITexture[] getNegativeZ(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_InventoryManagaer_Blue)};
    }

    public ITexture[] getPositiveZ(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_InventoryManagaer_Cyan)};
    }

    public ITexture[] getNegativeX(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_InventoryManagaer_Purple)};
    }

    public ITexture[] getPositiveX(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_InventoryManagaer_Yellow)};
    }

    public ITexture[] getBottomRedstone(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_InventoryManagaer_Red_Redstone)};
    }

    public ITexture[] getTopRedstone(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_InventoryManagaer_Green_Redstone)};
    }

    public ITexture[] getNegativeZRedstone(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_InventoryManagaer_Blue_Redstone)};
    }

    public ITexture[] getPositiveZRedstone(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_InventoryManagaer_Cyan_Redstone)};
    }

    public ITexture[] getNegativeXRedstone(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_InventoryManagaer_Purple_Redstone)};
    }

    public ITexture[] getPositiveXRedstone(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_InventoryManagaer_Yellow_Redstone)};
    }

    public boolean useModularUI() {
        return true;
    }

    public void addGregTechLogo(ModularWindow.Builder builder) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)this.getGUITextureSet().getGregTechLogo()).setSize(17, 17).setPos(154, 59));
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        int index;
        int i;
        int index2;
        int i2;
        for (int i3 = 0; i3 < 3; ++i3) {
            builder.widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, i3).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTPP_UITextures.OVERLAY_SLOT_CHEST}).setPos(154, 4 + i3 * 18));
        }
        int[] slotXPositions = new int[]{4, 60, 79, 135};
        for (i2 = 0; i2 < 12; ++i2) {
            index2 = i2;
            builder.widget(new SlotWidget(new BaseSlot((IItemHandlerModifiable)this.inventoryHandler, i2 + 3, true)){

                protected void phantomClick(Widget.ClickData clickData, ItemStack cursorStack) {
                    super.phantomClick(clickData, cursorStack);
                    if (clickData.mouseButton != 0 && cursorStack != null && this.getMcSlot().func_75216_d()) {
                        this.getMcSlot().func_75211_c().func_77964_b(Short.MAX_VALUE);
                    }
                }
            }.setControlsAmount(true).disableShiftInsert().setBackground(() -> {
                if (index2 % 3 == 0) {
                    return new IDrawable[]{GTPP_UITextures.SLOT_INVENTORY_MANAGER[this.mRangeDirections[index2 / 3]], GTPP_UITextures.OVERLAY_SLOT_INVENTORY_MANAGER_COLOR[this.mRangeDirections[index2 / 3]]};
                }
                if (index2 % 3 == 1) {
                    return new IDrawable[]{GTPP_UITextures.SLOT_INVENTORY_MANAGER[this.mRangeDirections[index2 / 3]], GTPP_UITextures.OVERLAY_SLOT_INVENTORY_MANAGER_ARROW[this.mRangeDirections[index2 / 3]]};
                }
                return new IDrawable[]{GTPP_UITextures.SLOT_INVENTORY_MANAGER[this.mRangeDirections[index2 / 3]]};
            }).setPos(slotXPositions[i2 / 3], 4 + i2 % 3 * 18));
        }
        for (i2 = 0; i2 < 4; ++i2) {
            index2 = i2;
            builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> this.switchRangeEnergy(index2)).setBackground(() -> new IDrawable[]{this.mTargetEnergy[index2] ? ModularUITextures.ITEM_SLOT : GT_UITextures.BUTTON_STANDARD, GT_UITextures.OVERLAY_BUTTON_EMIT_ENERGY}).setPos(slotXPositions[i2], 59).setSize(18, 18));
        }
        int[] buttonXPositions = new int[]{23, 41, 98, 116};
        for (i = 0; i < 12; ++i) {
            index = i;
            builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
                if (index % 3 == 0) {
                    if (clickData.mouseButton != 0) {
                        this.switchSlot1InOut(index / 3);
                    } else {
                        this.iterateSlot1Direction(index / 3);
                    }
                } else if (index % 3 == 1) {
                    if (clickData.mouseButton != 0) {
                        this.switchSlot2InOut(index / 3);
                    } else {
                        this.iterateSlot2Direction(index / 3);
                    }
                } else if (clickData.mouseButton != 0) {
                    this.switchSlot3InOut(index / 3);
                } else {
                    this.iterateSlot3Direction(index / 3);
                }
            }).setBackground(() -> new IDrawable[]{GT_UITextures.BUTTON_STANDARD, GTPP_UITextures.OVERLAY_BUTTON_DIRECTION[this.mTargetDirections[index]], this.mTargetInOut[index] ? GTPP_UITextures.OVERLAY_BUTTON_TIP_RED : GTPP_UITextures.OVERLAY_BUTTON_TIP_GREEN}).setPos(buttonXPositions[i / 3], 4 + i % 3 * 18).setSize(18, 18));
        }
        for (i = 0; i < 4; ++i) {
            index = i;
            builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> this.iterateRangeDirection(index)).setBackground(() -> new IDrawable[]{GT_UITextures.BUTTON_STANDARD, GTPP_UITextures.OVERLAY_BUTTON_DIRECTION_GRAY[this.mRangeDirections[index]]}).setPos(buttonXPositions[i], 59).setSize(18, 18));
        }
        i = 0;
        while (i < this.mTargetDirections.length) {
            index = i++;
            builder.widget((Widget)new FakeSyncWidget.ByteSyncer(() -> {
                if (index % 3 == 0) {
                    return this.getSlot1Direction(index / 3);
                }
                if (index % 3 == 1) {
                    return this.getSlot2Direction(index / 3);
                }
                return this.getSlot3Direction(index / 3);
            }, val -> {
                this.mTargetDirections[index] = val.byteValue();
            }));
        }
        i = 0;
        while (i < this.mRangeDirections.length) {
            index = i++;
            builder.widget((Widget)new FakeSyncWidget.ByteSyncer(() -> this.getRangeDirection(index), val -> {
                this.mRangeDirections[index] = val.byteValue();
            }));
        }
        i = 0;
        while (i < this.mTargetInOut.length) {
            index = i++;
            builder.widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> {
                if (index % 3 == 0) {
                    return this.getSlot1InOut(index / 3);
                }
                if (index % 3 == 1) {
                    return this.getSlot2InOut(index / 3);
                }
                return this.getSlot3InOut(index / 3);
            }, val -> {
                this.mTargetInOut[index] = val;
            }));
        }
        i = 0;
        while (i < this.mTargetEnergy.length) {
            index = i++;
            builder.widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.getRangeEnergy(index), val -> {
                this.mTargetEnergy[index] = val;
            }));
        }
    }
}

