/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.automation;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.CycleButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddGregtechLogo;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicTank;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.xmod.gregtech.api.gui.GTPP_UITextures;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_ElectricAutoWorkbench
extends GT_MetaTileEntity_BasicTank
implements IAddGregtechLogo {
    public int mMode = 0;
    public int mCurrentSlot = 0;
    public int mThroughPut = 0;
    public int mTicksUntilNextUpdate = 20;
    public boolean mLastCraftSuccessful = false;
    protected String mLocalName;
    private static final int MAX_MODES = 10;
    private static final int MAX_THROUGHPUT = 4;

    public GT_MetaTileEntity_ElectricAutoWorkbench(int aID, int aTier, String aDescription) {
        super(aID, "basicmachine.automation.autoworkbench.0" + aTier, "Auto Workbench (" + GT_Values.VN[aTier] + ")", aTier, 30, aDescription, new ITexture[0]);
        this.mLocalName = "Auto Workbench (" + GT_Values.VN[aTier] + ")";
    }

    public GT_MetaTileEntity_ElectricAutoWorkbench(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 30, aDescription, aTextures);
    }

    public boolean isTransformerUpgradable() {
        return true;
    }

    public boolean isOverclockerUpgradable() {
        return false;
    }

    public boolean isSimpleMachine() {
        return false;
    }

    public boolean isValidSlot(int aIndex) {
        return aIndex < 19;
    }

    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    public boolean isEnetInput() {
        return true;
    }

    public boolean isEnetOutput() {
        return true;
    }

    public boolean isInputFacing(byte aSide) {
        return !this.isOutputFacing(aSide);
    }

    public boolean isOutputFacing(byte aSide) {
        return aSide == this.getBaseMetaTileEntity().getBackFacing();
    }

    public boolean isTeleporterCompatible() {
        return false;
    }

    public long maxEUInput() {
        return GT_Values.V[this.mTier];
    }

    public long maxEUOutput() {
        return this.mThroughPut % 2 == 0 ? GT_Values.V[this.mTier] : 0L;
    }

    public long getMinimumStoredEU() {
        return GT_Values.V[this.mTier];
    }

    public long maxEUStore() {
        return GT_Values.V[this.mTier] * ((long)this.mTier * GT_Values.V[this.mTier]);
    }

    public int func_70302_i_() {
        return 30;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GT_UIInfos.openGTTileEntityUI((IHasWorldObjectAndCoords)aBaseMetaTileEntity, (EntityPlayer)aPlayer);
        return true;
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_ElectricAutoWorkbench(this.mName, this.mTier, this.mDescription, this.mTextures);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("mMode", this.mMode);
        aNBT.func_74768_a("mThroughPut", this.mThroughPut);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mMode = aNBT.func_74762_e("mMode");
        this.mThroughPut = aNBT.func_74762_e("mThroughPut");
    }

    public boolean doesFillContainers() {
        return false;
    }

    public boolean doesEmptyContainers() {
        return false;
    }

    public boolean canTankBeFilled() {
        return true;
    }

    public boolean canTankBeEmptied() {
        return true;
    }

    public boolean displaysItemStack() {
        return false;
    }

    public boolean displaysStackSize() {
        return false;
    }

    public boolean allowCoverOnSide(byte aSide, GT_ItemStack aStack) {
        return aSide != this.getBaseMetaTileEntity().getFrontFacing() && aSide != this.getBaseMetaTileEntity().getBackFacing();
    }

    private void switchMode() {
        this.mInventory[28] = null;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.getBaseMetaTileEntity().isAllowedToWork() && this.getBaseMetaTileEntity().isServerSide() && this.getBaseMetaTileEntity().getUniversalEnergyStored() >= (long)(this.mMode == 5 || this.mMode == 6 ? 128 : 2048) && (this.getBaseMetaTileEntity().hasWorkJustBeenEnabled() || --this.mTicksUntilNextUpdate < 1)) {
            int i;
            this.mTicksUntilNextUpdate = 32;
            for (i = 19; i < 28; i = (int)((byte)(i + 1))) {
                if (this.mInventory[i] == null || !this.mInventory[i].func_77984_f() || !this.mInventory[i].func_77973_b().func_77634_r()) continue;
                this.mInventory[i].func_77964_b(Short.MAX_VALUE);
            }
            if (this.mInventory[18] == null) {
                block13: for (i = 0; i < 18 && this.mFluid != null; i = (int)((byte)(i + 1))) {
                    ItemStack tOutput = GT_Utility.fillFluidContainer((FluidStack)this.mFluid, (ItemStack)this.mInventory[i], (boolean)false, (boolean)true);
                    if (tOutput == null) continue;
                    for (int j = 0; j < 9; j = (int)((byte)(j + 1))) {
                        if (this.mInventory[j] != null && (!GT_Utility.areStacksEqual((ItemStack)tOutput, (ItemStack)this.mInventory[j]) || this.mInventory[j].field_77994_a + tOutput.field_77994_a > tOutput.func_77976_d())) continue;
                        this.mFluid.amount -= GT_Utility.getFluidForFilledItem((ItemStack)tOutput, (boolean)true).amount * tOutput.field_77994_a;
                        this.getBaseMetaTileEntity().func_70298_a(i, 1);
                        if (this.mInventory[j] == null) {
                            this.mInventory[j] = tOutput;
                        } else {
                            ++this.mInventory[j].field_77994_a;
                        }
                        if (this.mFluid.amount > 0) continue block13;
                        this.mFluid = null;
                        continue block13;
                    }
                }
                ItemStack[] tRecipe = new ItemStack[9];
                ItemStack tTempStack = null;
                ItemStack tOutput = null;
                if (this.mInventory[17] != null && this.mThroughPut < 2 && this.mMode != 0) {
                    if (this.mInventory[18] == null) {
                        this.mInventory[18] = this.mInventory[17];
                        this.mInventory[17] = null;
                    }
                } else {
                    int i2;
                    if (!this.mLastCraftSuccessful) {
                        this.mCurrentSlot = (this.mCurrentSlot + 1) % 18;
                        for (i2 = 0; i2 < 17 && this.mInventory[this.mCurrentSlot] == null; ++i2) {
                            this.mCurrentSlot = (this.mCurrentSlot + 1) % 18;
                        }
                    }
                    block0 : switch (this.mMode) {
                        case 0: {
                            if (this.mInventory[this.mCurrentSlot] != null && !this.isItemTypeOrItsEmptyLiquidContainerInCraftingGrid(this.mInventory[this.mCurrentSlot])) {
                                if (this.mInventory[18] != null || this.mThroughPut >= 2 || this.mCurrentSlot >= 8) break;
                                this.mInventory[18] = this.mInventory[this.mCurrentSlot];
                                this.mInventory[this.mCurrentSlot] = null;
                                this.mTicksUntilNextUpdate = 1;
                                break;
                            }
                            for (i2 = 0; i2 < 9; ++i2) {
                                tRecipe[i2] = this.mInventory[i2 + 19];
                                if (tRecipe[i2] == null) continue;
                                tRecipe[i2] = GT_Utility.copy((Object[])new Object[]{tRecipe[i2]});
                                tRecipe[i2].field_77994_a = 1;
                            }
                            break;
                        }
                        case 1: {
                            if (this.isItemTypeOrItsEmptyLiquidContainerInCraftingGrid(this.mInventory[this.mCurrentSlot])) {
                                if (this.mInventory[18] != null || this.mThroughPut >= 2) break;
                                this.mInventory[18] = this.mInventory[this.mCurrentSlot];
                                this.mInventory[this.mCurrentSlot] = null;
                                this.mTicksUntilNextUpdate = 1;
                                break;
                            }
                            tTempStack = GT_Utility.copy((Object[])new Object[]{this.mInventory[this.mCurrentSlot]});
                            tTempStack.field_77994_a = 1;
                            tRecipe[0] = tTempStack;
                            if (GT_ModHandler.getAllRecipeOutput((World)this.getBaseMetaTileEntity().getWorld(), (ItemStack[])tRecipe) != null) break;
                            tRecipe[1] = tTempStack;
                            tRecipe[3] = tTempStack;
                            tRecipe[4] = tTempStack;
                            if (GT_ModHandler.getAllRecipeOutput((World)this.getBaseMetaTileEntity().getWorld(), (ItemStack[])tRecipe) != null) break;
                            tRecipe[2] = tTempStack;
                            tRecipe[5] = tTempStack;
                            tRecipe[6] = tTempStack;
                            tRecipe[7] = tTempStack;
                            tRecipe[8] = tTempStack;
                            if (GT_ModHandler.getAllRecipeOutput((World)this.getBaseMetaTileEntity().getWorld(), (ItemStack[])tRecipe) != null || this.mInventory[18] != null) break;
                            this.mInventory[18] = this.mInventory[this.mCurrentSlot];
                            this.mInventory[this.mCurrentSlot] = null;
                            this.mTicksUntilNextUpdate = 1;
                            break;
                        }
                        case 2: {
                            if (this.isItemTypeOrItsEmptyLiquidContainerInCraftingGrid(this.mInventory[this.mCurrentSlot])) {
                                if (this.mInventory[18] != null || this.mThroughPut >= 2) break;
                                this.mInventory[18] = this.mInventory[this.mCurrentSlot];
                                this.mInventory[this.mCurrentSlot] = null;
                                this.mTicksUntilNextUpdate = 1;
                                break;
                            }
                            tTempStack = GT_Utility.copy((Object[])new Object[]{this.mInventory[this.mCurrentSlot]});
                            tTempStack.field_77994_a = 1;
                            tRecipe[0] = tTempStack;
                            if (GT_ModHandler.getAllRecipeOutput((World)this.getBaseMetaTileEntity().getWorld(), (ItemStack[])tRecipe) != null || this.mInventory[18] != null) break;
                            this.mInventory[18] = this.mInventory[this.mCurrentSlot];
                            this.mInventory[this.mCurrentSlot] = null;
                            this.mTicksUntilNextUpdate = 1;
                            break;
                        }
                        case 3: {
                            if (this.isItemTypeOrItsEmptyLiquidContainerInCraftingGrid(this.mInventory[this.mCurrentSlot])) {
                                if (this.mInventory[18] != null || this.mThroughPut >= 2) break;
                                this.mInventory[18] = this.mInventory[this.mCurrentSlot];
                                this.mInventory[this.mCurrentSlot] = null;
                                this.mTicksUntilNextUpdate = 1;
                                break;
                            }
                            tTempStack = GT_Utility.copy((Object[])new Object[]{this.mInventory[this.mCurrentSlot]});
                            tTempStack.field_77994_a = 1;
                            tRecipe[0] = tTempStack;
                            tRecipe[1] = tTempStack;
                            tRecipe[3] = tTempStack;
                            tRecipe[4] = tTempStack;
                            if (GT_ModHandler.getAllRecipeOutput((World)this.getBaseMetaTileEntity().getWorld(), (ItemStack[])tRecipe) != null || this.mInventory[18] != null) break;
                            this.mInventory[18] = this.mInventory[this.mCurrentSlot];
                            this.mInventory[this.mCurrentSlot] = null;
                            this.mTicksUntilNextUpdate = 1;
                            break;
                        }
                        case 4: {
                            if (this.isItemTypeOrItsEmptyLiquidContainerInCraftingGrid(this.mInventory[this.mCurrentSlot])) {
                                if (this.mInventory[18] != null || this.mThroughPut >= 2) break;
                                this.mInventory[18] = this.mInventory[this.mCurrentSlot];
                                this.mInventory[this.mCurrentSlot] = null;
                                this.mTicksUntilNextUpdate = 1;
                                break;
                            }
                            tTempStack = GT_Utility.copy((Object[])new Object[]{this.mInventory[this.mCurrentSlot]});
                            tTempStack.field_77994_a = 1;
                            tRecipe[0] = tTempStack;
                            tRecipe[1] = tTempStack;
                            tRecipe[2] = tTempStack;
                            tRecipe[3] = tTempStack;
                            tRecipe[4] = tTempStack;
                            tRecipe[5] = tTempStack;
                            tRecipe[6] = tTempStack;
                            tRecipe[7] = tTempStack;
                            tRecipe[8] = tTempStack;
                            if (GT_ModHandler.getAllRecipeOutput((World)this.getBaseMetaTileEntity().getWorld(), (ItemStack[])tRecipe) != null || this.mInventory[18] != null) break;
                            this.mInventory[18] = this.mInventory[this.mCurrentSlot];
                            this.mInventory[this.mCurrentSlot] = null;
                            this.mTicksUntilNextUpdate = 1;
                            break;
                        }
                        case 5: {
                            if (this.isItemTypeOrItsEmptyLiquidContainerInCraftingGrid(this.mInventory[this.mCurrentSlot])) {
                                if (this.mInventory[18] != null || this.mThroughPut >= 2) break;
                                this.mInventory[18] = this.mInventory[this.mCurrentSlot];
                                this.mInventory[this.mCurrentSlot] = null;
                                this.mTicksUntilNextUpdate = 1;
                                break;
                            }
                            tTempStack = GT_Utility.copy((Object[])new Object[]{this.mInventory[this.mCurrentSlot]});
                            tTempStack.field_77994_a = 1;
                            tRecipe[0] = tTempStack;
                            tOutput = GT_OreDictUnificator.get((boolean)true, (ItemStack)tTempStack);
                            if (tOutput != null && GT_Utility.areStacksEqual((ItemStack)tOutput, (ItemStack)tTempStack)) {
                                tOutput = null;
                            }
                            if (tOutput != null) break;
                            tRecipe[0] = null;
                            if (this.mInventory[18] != null) break;
                            this.mInventory[18] = this.mInventory[this.mCurrentSlot];
                            this.mInventory[this.mCurrentSlot] = null;
                            this.mTicksUntilNextUpdate = 1;
                            break;
                        }
                        case 6: {
                            if (this.isItemTypeOrItsEmptyLiquidContainerInCraftingGrid(this.mInventory[this.mCurrentSlot])) {
                                if (this.mInventory[18] != null || this.mThroughPut >= 2) break;
                                this.mInventory[18] = this.mInventory[this.mCurrentSlot];
                                this.mInventory[this.mCurrentSlot] = null;
                                this.mTicksUntilNextUpdate = 1;
                                break;
                            }
                            if (OrePrefixes.dustSmall.contains(this.mInventory[this.mCurrentSlot])) {
                                tTempStack = GT_Utility.copy((Object[])new Object[]{this.mInventory[this.mCurrentSlot]});
                                tTempStack.field_77994_a = 1;
                                tRecipe[0] = tTempStack;
                                tRecipe[1] = tTempStack;
                                tRecipe[3] = tTempStack;
                                tRecipe[4] = tTempStack;
                                if (GT_ModHandler.getAllRecipeOutput((World)this.getBaseMetaTileEntity().getWorld(), (ItemStack[])tRecipe) != null || this.mInventory[18] != null) break;
                                this.mInventory[18] = this.mInventory[this.mCurrentSlot];
                                this.mInventory[this.mCurrentSlot] = null;
                                this.mTicksUntilNextUpdate = 1;
                                break;
                            }
                            if (OrePrefixes.dustTiny.contains(this.mInventory[this.mCurrentSlot])) {
                                tTempStack = GT_Utility.copy((Object[])new Object[]{this.mInventory[this.mCurrentSlot]});
                                tTempStack.field_77994_a = 1;
                                tRecipe[0] = tTempStack;
                                tRecipe[1] = tTempStack;
                                tRecipe[2] = tTempStack;
                                tRecipe[3] = tTempStack;
                                tRecipe[4] = tTempStack;
                                tRecipe[5] = tTempStack;
                                tRecipe[6] = tTempStack;
                                tRecipe[7] = tTempStack;
                                tRecipe[8] = tTempStack;
                                if (GT_ModHandler.getAllRecipeOutput((World)this.getBaseMetaTileEntity().getWorld(), (ItemStack[])tRecipe) != null || this.mInventory[18] != null) break;
                                this.mInventory[18] = this.mInventory[this.mCurrentSlot];
                                this.mInventory[this.mCurrentSlot] = null;
                                this.mTicksUntilNextUpdate = 1;
                                break;
                            }
                            if (this.mInventory[18] != null || this.mThroughPut >= 2) break;
                            this.mInventory[18] = this.mInventory[this.mCurrentSlot];
                            this.mInventory[this.mCurrentSlot] = null;
                            this.mTicksUntilNextUpdate = 1;
                            break;
                        }
                        case 7: {
                            if (this.isItemTypeOrItsEmptyLiquidContainerInCraftingGrid(this.mInventory[this.mCurrentSlot]) || !OrePrefixes.nugget.contains(this.mInventory[this.mCurrentSlot])) {
                                if (this.mInventory[18] != null || this.mThroughPut >= 2) break;
                                this.mInventory[18] = this.mInventory[this.mCurrentSlot];
                                this.mInventory[this.mCurrentSlot] = null;
                                this.mTicksUntilNextUpdate = 1;
                                break;
                            }
                            tTempStack = GT_Utility.copy((Object[])new Object[]{this.mInventory[this.mCurrentSlot]});
                            tTempStack.field_77994_a = 1;
                            tRecipe[0] = tTempStack;
                            tRecipe[1] = tTempStack;
                            tRecipe[2] = tTempStack;
                            tRecipe[3] = tTempStack;
                            tRecipe[4] = tTempStack;
                            tRecipe[5] = tTempStack;
                            tRecipe[6] = tTempStack;
                            tRecipe[7] = tTempStack;
                            tRecipe[8] = tTempStack;
                            if (GT_ModHandler.getAllRecipeOutput((World)this.getBaseMetaTileEntity().getWorld(), (ItemStack[])tRecipe) != null || this.mInventory[18] != null) break;
                            this.mInventory[18] = this.mInventory[this.mCurrentSlot];
                            this.mInventory[this.mCurrentSlot] = null;
                            this.mTicksUntilNextUpdate = 1;
                            break;
                        }
                        case 8: {
                            if (this.isItemTypeOrItsEmptyLiquidContainerInCraftingGrid(this.mInventory[this.mCurrentSlot]) || this.mInventory[this.mCurrentSlot].func_77960_j() <= 0 || !this.mInventory[this.mCurrentSlot].func_77973_b().isRepairable()) {
                                if (this.mInventory[18] != null || this.mThroughPut >= 2) break;
                                this.mInventory[18] = this.mInventory[this.mCurrentSlot];
                                this.mInventory[this.mCurrentSlot] = null;
                                this.mTicksUntilNextUpdate = 1;
                                break;
                            }
                            tTempStack = GT_Utility.copy((Object[])new Object[]{this.mInventory[this.mCurrentSlot]});
                            tTempStack.field_77994_a = 1;
                            for (i2 = this.mCurrentSlot + 1; i2 < 18; ++i2) {
                                if (this.mInventory[i2] == null || this.mInventory[i2].func_77973_b() != tTempStack.func_77973_b() || this.mInventory[this.mCurrentSlot].func_77960_j() + this.mInventory[i2].func_77960_j() <= tTempStack.func_77958_k()) continue;
                                tRecipe[0] = tTempStack;
                                tRecipe[1] = GT_Utility.copy((Object[])new Object[]{this.mInventory[i2]});
                                if (GT_ModHandler.getAllRecipeOutput((World)this.getBaseMetaTileEntity().getWorld(), (ItemStack[])tRecipe) != null || this.mInventory[18] != null) break block0;
                                this.mInventory[18] = this.mInventory[this.mCurrentSlot];
                                this.mInventory[this.mCurrentSlot] = null;
                                this.mTicksUntilNextUpdate = 1;
                                break block0;
                            }
                            break;
                        }
                        case 9: {
                            if (this.isItemTypeOrItsEmptyLiquidContainerInCraftingGrid(this.mInventory[this.mCurrentSlot])) {
                                if (this.mInventory[18] != null || this.mThroughPut >= 2) break;
                                this.mInventory[18] = this.mInventory[this.mCurrentSlot];
                                this.mInventory[this.mCurrentSlot] = null;
                                this.mTicksUntilNextUpdate = 1;
                                break;
                            }
                            int j = 0;
                            for (i2 = 0; i2 < 18 && j < 9 && (j < 2 || GT_ModHandler.getAllRecipeOutput((World)this.getBaseMetaTileEntity().getWorld(), (ItemStack[])tRecipe) == null); i2 = (int)((byte)(i2 + 1))) {
                                tRecipe[j] = this.mInventory[(this.mCurrentSlot + i2) % 18];
                                if (tRecipe[j] == null) continue;
                                tRecipe[j] = GT_Utility.copy((Object[])new Object[]{tRecipe[j]});
                                tRecipe[j].field_77994_a = 1;
                                j = (byte)(j + 1);
                            }
                            if (tRecipe[1] != null) break;
                            tRecipe[0] = null;
                        }
                    }
                }
                if (tOutput == null) {
                    tOutput = GT_ModHandler.getAllRecipeOutput((World)this.getBaseMetaTileEntity().getWorld(), (ItemStack[])tRecipe);
                }
                if (tOutput != null || this.mMode == 0) {
                    this.mInventory[28] = tOutput;
                }
                if (tOutput == null) {
                    this.mLastCraftSuccessful = false;
                } else {
                    tTempStack = GT_OreDictUnificator.get((boolean)true, (ItemStack)tOutput);
                    if (tTempStack != null) {
                        tTempStack.field_77994_a = tOutput.field_77994_a;
                        tOutput = tTempStack;
                    }
                    this.mInventory[28] = GT_Utility.copy((Object[])new Object[]{tOutput});
                    ArrayList<ItemStack> tList = this.recipeContent(tRecipe);
                    ArrayList<ItemStack> tContent = this.benchContent();
                    if (tList.size() > 0 && tContent.size() > 0) {
                        int j;
                        int i3;
                        boolean success = this.mMode == 6 || this.mMode == 7 || this.mInventory[17] == null;
                        for (i3 = 0; i3 < tList.size() && success; i3 = (int)((byte)(i3 + 1))) {
                            success = false;
                            for (j = 0; j < tContent.size() && !success; j = (int)((byte)(j + 1))) {
                                if (!GT_Utility.areStacksEqual((ItemStack)tList.get(i3), (ItemStack)tContent.get(j)) || tList.get((int)i3).field_77994_a > tContent.get((int)j).field_77994_a) continue;
                                success = true;
                            }
                        }
                        if (success) {
                            this.mLastCraftSuccessful = true;
                            block21: for (i3 = 8; i3 > -1; i3 = (int)((byte)(i3 - 1))) {
                                for (j = 17; j > -1; j = (int)((byte)(j - 1))) {
                                    if (tRecipe[i3] == null || this.mInventory[j] == null || !GT_Utility.areStacksEqual((ItemStack)tRecipe[i3], (ItemStack)this.mInventory[j])) continue;
                                    ItemStack tStack = GT_Utility.getContainerItem((ItemStack)this.mInventory[j], (boolean)true);
                                    if (tStack != null) {
                                        this.getBaseMetaTileEntity().func_70298_a(j, 1);
                                        if (tStack.func_77984_f() && tStack.func_77960_j() >= tStack.func_77958_k()) continue block21;
                                        for (int k = 9; k < 18; k = (int)((byte)(k + 1))) {
                                            if (this.mInventory[k] == null) {
                                                this.mInventory[k] = GT_Utility.copy((Object[])new Object[]{tStack});
                                                continue block21;
                                            }
                                            if (!GT_Utility.areStacksEqual((ItemStack)this.mInventory[k], (ItemStack)tStack) || this.mInventory[k].field_77994_a + tStack.field_77994_a > tStack.func_77976_d()) continue;
                                            this.mInventory[k].field_77994_a += tStack.field_77994_a;
                                            continue block21;
                                        }
                                        continue block21;
                                    }
                                    this.getBaseMetaTileEntity().func_70298_a(j, 1);
                                    continue block21;
                                }
                            }
                            this.mInventory[18] = GT_Utility.copy((Object[])new Object[]{tOutput});
                            this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(this.mMode == 5 || this.mMode == 6 || this.mMode == 7 ? 128L : 2048L, true);
                            this.mTicksUntilNextUpdate = 1;
                        } else {
                            this.mLastCraftSuccessful = false;
                            if (this.mInventory[this.mMode == 0 ? 8 : 17] != null && this.mInventory[18] == null && this.mThroughPut < 2) {
                                this.mInventory[18] = this.mInventory[this.mMode == 0 ? 8 : 17];
                                this.mInventory[this.mMode == 0 ? 8 : 17] = null;
                                this.mTicksUntilNextUpdate = 1;
                            }
                        }
                    }
                    if (this.mInventory[18] == null && this.mThroughPut < 2) {
                        block24: for (int i4 = 0; i4 < 8; i4 = (int)((byte)(i4 + 1))) {
                            int j = i4;
                            while ((j = (int)((byte)(j + 1))) < 9) {
                                if (!GT_Utility.areStacksEqual((ItemStack)this.mInventory[i4], (ItemStack)this.mInventory[j]) || this.mInventory[i4].func_77976_d() <= 8) continue;
                                this.mInventory[18] = this.mInventory[j];
                                this.mInventory[j] = null;
                                this.mTicksUntilNextUpdate = 1;
                                continue block24;
                            }
                        }
                    }
                }
            }
            if (this.mThroughPut < 2) {
                this.getBaseMetaTileEntity().decreaseStoredEnergyUnits((long)(GT_Utility.moveOneItemStack((Object)this.getBaseMetaTileEntity(), (Object)this.getBaseMetaTileEntity().getIInventoryAtSide(this.getBaseMetaTileEntity().getBackFacing()), (byte)this.getBaseMetaTileEntity().getBackFacing(), (byte)this.getBaseMetaTileEntity().getFrontFacing(), null, (boolean)false, (byte)64, (byte)1, (byte)64, (byte)1) * 10), true);
            }
        }
    }

    private boolean isItemTypeOrItsEmptyLiquidContainerInCraftingGrid(ItemStack aStack) {
        if (aStack == null) {
            return true;
        }
        for (int i = 19; i < 28; i = (int)((byte)(i + 1))) {
            if (this.mInventory[i] == null) continue;
            if (GT_Utility.areStacksEqual((ItemStack)this.mInventory[i], (ItemStack)aStack)) {
                return true;
            }
            if (!GT_Utility.areStacksEqual((ItemStack)GT_Utility.getContainerForFilledItem((ItemStack)this.mInventory[i], (boolean)true), (ItemStack)aStack)) continue;
            return true;
        }
        return false;
    }

    private ArrayList<ItemStack> recipeContent(ItemStack[] tRecipe) {
        ArrayList<ItemStack> tList = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; i = (int)((byte)(i + 1))) {
            if (tRecipe[i] == null) continue;
            boolean temp = false;
            for (int j = 0; j < tList.size(); j = (int)((byte)(j + 1))) {
                if (!GT_Utility.areStacksEqual((ItemStack)tRecipe[i], (ItemStack)tList.get(j))) continue;
                ++tList.get((int)j).field_77994_a;
                temp = true;
                break;
            }
            if (temp) continue;
            tList.add(GT_Utility.copy((Object[])new Object[]{1, tRecipe[i]}));
        }
        return tList;
    }

    private ArrayList<ItemStack> benchContent() {
        ArrayList<ItemStack> tList = new ArrayList<ItemStack>();
        for (int i = 0; i < 18; i = (int)((byte)(i + 1))) {
            if (this.mInventory[i] == null) continue;
            boolean temp = false;
            for (int j = 0; j < tList.size(); j = (int)((byte)(j + 1))) {
                if (!GT_Utility.areStacksEqual((ItemStack)this.mInventory[i], (ItemStack)this.mInventory[j])) continue;
                tList.get((int)j).field_77994_a += this.mInventory[i].field_77994_a;
                temp = true;
                break;
            }
            if (temp) continue;
            tList.add(GT_Utility.copy((Object[])new Object[]{this.mInventory[i]}));
        }
        return tList;
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return this.mMode == 0 ? aIndex >= 10 : aIndex >= 18;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return this.mMode == 0 ? aIndex < 9 : aIndex < 18;
    }

    public int getCapacity() {
        return 16000;
    }

    public int getTankPressure() {
        return -100;
    }

    public String[] getDescription() {
        return new String[]{"Automatic Crafting Table Mk III", CORE.GT_Tooltip.get()};
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[10][17][];
        for (byte i = -1; i < 16; i = (byte)(i + 1)) {
            rTextures[0][i + 1] = this.getFront(i);
            rTextures[1][i + 1] = this.getBack(i);
            rTextures[2][i + 1] = this.getBottom(i);
            rTextures[3][i + 1] = this.getTop(i);
            rTextures[4][i + 1] = this.getSides(i);
            rTextures[5][i + 1] = this.getFront(i);
            rTextures[6][i + 1] = this.getBack(i);
            rTextures[7][i + 1] = this.getBottom(i);
            rTextures[8][i + 1] = this.getTop(i);
            rTextures[9][i + 1] = this.getSides(i);
        }
        return rTextures;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return this.mTextures[0][aColorIndex + 1];
        }
        if (GT_Utility.getOppositeSide((int)aSide) == aFacing) {
            return this.mTextures[1][aColorIndex + 1];
        }
        return this.mTextures[4][aColorIndex + 1];
    }

    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Adv_Workbench_Crafting_Overlay)};
    }

    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_PIPE)};
    }

    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Adv_Workbench_Crafting_Overlay)};
    }

    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Adv_Workbench_Crafting_Overlay)};
    }

    public boolean useModularUI() {
        return true;
    }

    public void addGregTechLogo(ModularWindow.Builder builder) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)this.getGUITextureSet().getGregTechLogo()).setSize(17, 17).setPos(118, 22));
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)3).endAtSlot(8).build().setPos(7, 4))).widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)9).startFromSlot(9).endAtSlot(17).canInsert(false).background(new IDrawable[]{GT_UITextures.SLOT_DARK_GRAY}).applyForWidget(SlotWidget::disableShiftInsert).build().setPos(7, 59))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 18).setAccess(true, false).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_OUT}).setPos(151, 40))).widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_SLOTS_HOLO_3BY3).setPos(62, 4).setSize(54, 54))).widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)3).startFromSlot(19).endAtSlot(27).phantom(true).background(new IDrawable[]{GT_UITextures.TRANSPARENT}).build().setPos(62, 4))).widget(SlotWidget.phantom((IItemHandlerModifiable)this.inventoryHandler, (int)28).disableInteraction().setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTPP_UITextures.OVERLAY_SLOT_ARROW_4}).setPos(151, 4));
        builder.widget(new CycleButtonWidget().setGetter(() -> this.mThroughPut).setSetter(val -> {
            this.mThroughPut = val;
        }).setLength(4).setTextureGetter(i -> GTPP_UITextures.OVERLAY_BUTTON_THROUGHPUT[i]).setBackground(new IDrawable[]{GT_UITextures.BUTTON_STANDARD}).setPos(120, 4).setSize(18, 18));
        String[] mModeText = new String[]{"Normal Crafting Table", "???", "1x1", "2x2", "3x3", "Unifier", "Dust", "???", "Hammer?", "Circle"};
        CycleButtonWidget modeButton = new CycleButtonWidget().setGetter(() -> this.mMode).setSetter(val -> {
            this.mMode = val;
            this.switchMode();
        }).setLength(10).setTextureGetter(i -> GTPP_UITextures.OVERLAY_BUTTON_MODE[i]);
        for (int i2 = 0; i2 < 10; ++i2) {
            modeButton.addTooltip(i2, "Mode: " + mModeText[i2]);
        }
        builder.widget(modeButton.setBackground(new IDrawable[]{GT_UITextures.BUTTON_STANDARD}).setPos(120, 40).setSize(18, 18));
        ((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GTPP_UITextures.PICTURE_WORKBENCH_CIRCLE).setPos(136, 23).setSize(16, 16))).widget(new DrawableWidget().setDrawable((IDrawable)GTPP_UITextures.PICTURE_ARROW_WHITE_DOWN).setPos(155, 23).setSize(10, 16));
    }
}

