/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.covers;

import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.util.minecraft.LangUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;

public class GTPP_Cover_Overflow_Item
extends GT_CoverBehavior {
    public final int mInitialCapacity;
    public final int mMaxItemCapacity;
    public static final Class sQuantumChest;
    public static final Class sSuperChestGTPP;
    public static final Class sSuperChestGTNH;
    public static HashMap<Integer, Field> mItemAmountFields;
    public static HashMap<Integer, Field> mItemTypeFields;

    public GTPP_Cover_Overflow_Item(int aCapacity) {
        this.mInitialCapacity = aCapacity;
        this.mMaxItemCapacity = aCapacity * 1000;
    }

    public int doCoverThings(byte aSide, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        if (aCoverVariable == 0) {
            return aCoverVariable;
        }
        IGregTechTileEntity aGtTileEntity = aTileEntity.getIGregTechTileEntity(aTileEntity.getXCoord(), (int)aTileEntity.getYCoord(), aTileEntity.getZCoord());
        if (aGtTileEntity == null) {
            return aCoverVariable;
        }
        IMetaTileEntity aMetaTileEntity = aGtTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return aCoverVariable;
        }
        boolean didHandle = false;
        if (sQuantumChest != null && sQuantumChest.isInstance(aMetaTileEntity)) {
            didHandle = this.handleDigitalChest(aMetaTileEntity, 0);
        } else if (sSuperChestGTPP.isInstance(aMetaTileEntity)) {
            didHandle = this.handleDigitalChest(aMetaTileEntity, 1);
        } else if (sSuperChestGTNH != null && sSuperChestGTNH.isInstance(aMetaTileEntity)) {
            didHandle = this.handleDigitalChest(aMetaTileEntity, 2);
        }
        return aCoverVariable;
    }

    private boolean handleDigitalChest(IMetaTileEntity aTile, int aType) {
        int aItemAmount = (Integer)ReflectionUtils.getFieldValue(mItemAmountFields.get(aType), aTile);
        ItemStack aItemType = (ItemStack)ReflectionUtils.getFieldValue(mItemTypeFields.get(aType), aTile);
        if (aItemType == null || aItemAmount <= 0) {
            return false;
        }
        if (aItemAmount > this.mInitialCapacity) {
            int aNewItemAmount = this.mInitialCapacity;
            ReflectionUtils.setField((Object)aTile, mItemAmountFields.get(aType), (Object)aNewItemAmount);
        }
        return true;
    }

    public int onCoverScrewdriverclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        aCoverVariable = GT_Utility.getClickedFacingCoords((byte)aSide, (float)aX, (float)aY, (float)aZ)[0] >= 0.5f ? (int)((float)aCoverVariable + (float)this.mMaxItemCapacity * (aPlayer.func_70093_af() ? 0.1f : 0.01f)) : (int)((float)aCoverVariable - (float)this.mMaxItemCapacity * (aPlayer.func_70093_af() ? 0.1f : 0.01f));
        if (aCoverVariable > this.mMaxItemCapacity) {
            aCoverVariable = this.mInitialCapacity;
        }
        if (aCoverVariable <= 0) {
            aCoverVariable = this.mMaxItemCapacity;
        }
        GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)(LangUtils.trans("322", "Overflow point: ") + aCoverVariable + this.trans("323", "L")));
        return aCoverVariable;
    }

    public boolean onCoverRightclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        int aAmount;
        boolean aShift = aPlayer.func_70093_af();
        int n = aAmount = aShift ? 128 : 8;
        aCoverVariable = GT_Utility.getClickedFacingCoords((byte)aSide, (float)aX, (float)aY, (float)aZ)[0] >= 0.5f ? (aCoverVariable += aAmount) : (aCoverVariable -= aAmount);
        if (aCoverVariable > this.mMaxItemCapacity) {
            aCoverVariable = this.mInitialCapacity;
        }
        if (aCoverVariable <= 0) {
            aCoverVariable = this.mMaxItemCapacity;
        }
        GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)(LangUtils.trans("322", "Overflow point: ") + aCoverVariable + this.trans("323", "L")));
        aTileEntity.setCoverDataAtSide(aSide, aCoverVariable);
        return true;
    }

    public boolean letsRedstoneGoIn(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    public boolean letsRedstoneGoOut(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    public boolean letsEnergyIn(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    public boolean letsEnergyOut(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    public boolean letsItemsIn(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    public boolean letsItemsOut(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    public boolean letsFluidIn(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return false;
    }

    public boolean letsFluidOut(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    public boolean alwaysLookConnected(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    public int getTickRate(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 5;
    }

    static {
        mItemAmountFields = new HashMap();
        mItemTypeFields = new HashMap();
        sQuantumChest = ReflectionUtils.getClass("gregtech.common.tileentities.storage.GT_MetaTileEntity_QuantumChest");
        sSuperChestGTPP = ReflectionUtils.getClass("gtPlusPlus.xmod.gregtech.common.tileentities.storage.GT_MetaTileEntity_TieredChest");
        sSuperChestGTNH = ReflectionUtils.getClass("gregtech.common.tileentities.storage.GT_MetaTileEntity_SuperChest");
        if (sQuantumChest != null) {
            mItemAmountFields.put(0, ReflectionUtils.getField(sQuantumChest, "mItemCount"));
            mItemTypeFields.put(0, ReflectionUtils.getField(sQuantumChest, "mItemStack"));
        }
        if (sSuperChestGTPP != null) {
            mItemAmountFields.put(1, ReflectionUtils.getField(sSuperChestGTPP, "mItemCount"));
            mItemTypeFields.put(1, ReflectionUtils.getField(sSuperChestGTPP, "mItemStack"));
        }
        if (sSuperChestGTNH != null) {
            mItemAmountFields.put(2, ReflectionUtils.getField(sSuperChestGTNH, "mItemCount"));
            mItemTypeFields.put(2, ReflectionUtils.getField(sSuperChestGTNH, "mItemStack"));
        }
    }
}

