/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base;

import cofh.api.energy.IEnergyReceiver;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.metatileentity.IMetaTileEntityCable;
import gregtech.api.interfaces.tileentity.IColoredTileEntity;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IEnergyConnected;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechOrePrefixes;
import ic2.api.energy.tile.IEnergySink;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GregtechMetaPipeEntityBase_Cable
extends MetaPipeEntity
implements IMetaTileEntityCable {
    public final float mThickNess;
    public final GregtechOrePrefixes.GT_Materials mMaterial;
    public final long mCableLossPerMeter;
    public final long mAmperage;
    public final long mVoltage;
    public final boolean mInsulated;
    public final boolean mCanShock;
    public long mTransferredAmperage = 0L;
    public long mTransferredAmperageLast20 = 0L;
    public long mTransferredVoltageLast20 = 0L;
    public long mRestRF;
    public short mOverheat;
    public final int mWireHeatingTicks;

    public GregtechMetaPipeEntityBase_Cable(int aID, String aName, String aNameRegional, float aThickNess, GregtechOrePrefixes.GT_Materials aMaterial, long aCableLossPerMeter, long aAmperage, long aVoltage, boolean aInsulated, boolean aCanShock) {
        super(aID, aName, aNameRegional, 0);
        this.mThickNess = aThickNess;
        this.mMaterial = aMaterial;
        this.mAmperage = aAmperage;
        this.mVoltage = aVoltage;
        this.mInsulated = aInsulated;
        this.mCanShock = aCanShock;
        this.mCableLossPerMeter = aCableLossPerMeter;
        this.mWireHeatingTicks = this.getGT5Var();
    }

    public GregtechMetaPipeEntityBase_Cable(String aName, float aThickNess, GregtechOrePrefixes.GT_Materials aMaterial, long aCableLossPerMeter, long aAmperage, long aVoltage, boolean aInsulated, boolean aCanShock) {
        super(aName, 0);
        this.mThickNess = aThickNess;
        this.mMaterial = aMaterial;
        this.mAmperage = aAmperage;
        this.mVoltage = aVoltage;
        this.mInsulated = aInsulated;
        this.mCanShock = aCanShock;
        this.mCableLossPerMeter = aCableLossPerMeter;
        this.mWireHeatingTicks = this.getGT5Var();
    }

    private int getGT5Var() {
        Class<?> clazz = GT_Mod.gregtechproxy.getClass();
        String lookingForValue = "mWireHeatingTicks";
        int temp = 4;
        try {
            Field field = clazz.getClass().getField("mWireHeatingTicks");
            Class<?> clazzType = field.getType();
            temp = clazzType.toString().equals("int") ? field.getInt(clazz) : 4;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            Logger.WARNING("FATAL ERROR - REFLECTION FAILED FOR GT CABLES - PLEASE REPORT THIS.");
            Logger.ERROR("FATAL ERROR - REFLECTION FAILED FOR GT CABLES - PLEASE REPORT THIS.");
            temp = 4;
        }
        return temp;
    }

    public byte getTileEntityBaseType() {
        return (byte)(this.mInsulated ? 9 : 8);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaPipeEntityBase_Cable(this.mName, this.mThickNess, this.mMaterial, this.mCableLossPerMeter, this.mAmperage, this.mVoltage, this.mInsulated, this.mCanShock);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aConnections, byte aColorIndex, boolean aConnected, boolean aRedstone) {
        if (!this.mInsulated) {
            return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa)};
        }
        if (aConnected) {
            float tThickNess = this.getThickNess();
            if (tThickNess < 0.37f) {
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.INSULATION_TINY, Dyes.getModulation((int)aColorIndex, (short[])Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.49f) {
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.INSULATION_SMALL, Dyes.getModulation((int)aColorIndex, (short[])Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.74f) {
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.INSULATION_MEDIUM, Dyes.getModulation((int)aColorIndex, (short[])Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.99f) {
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.INSULATION_LARGE, Dyes.getModulation((int)aColorIndex, (short[])Dyes.CABLE_INSULATION.mRGBa))};
            }
            return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.INSULATION_HUGE, Dyes.getModulation((int)aColorIndex, (short[])Dyes.CABLE_INSULATION.mRGBa))};
        }
        return new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.INSULATION_FULL, Dyes.getModulation((int)aColorIndex, (short[])Dyes.CABLE_INSULATION.mRGBa))};
    }

    public void onEntityCollidedWithBlock(World aWorld, int aX, int aY, int aZ, Entity aEntity) {
        if (this.mCanShock && (((BaseMetaPipeEntity)this.getBaseMetaTileEntity()).mConnections & 0xFFFFFF80) == 0 && aEntity instanceof EntityLivingBase) {
            GT_Utility.applyElectricityDamage((EntityLivingBase)((EntityLivingBase)aEntity), (long)this.mTransferredVoltageLast20, (long)this.mTransferredAmperageLast20);
        }
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        if (!this.mCanShock) {
            return super.getCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ);
        }
        return AxisAlignedBB.func_72330_a((double)((double)aX + 0.125), (double)((double)aY + 0.125), (double)((double)aZ + 0.125), (double)((double)aX + 0.875), (double)((double)aY + 0.875), (double)((double)aZ + 0.875));
    }

    public boolean isSimpleMachine() {
        return true;
    }

    public boolean isFacingValid(byte aFacing) {
        return false;
    }

    public boolean isValidSlot(int aIndex) {
        return true;
    }

    public final boolean renderInside(byte aSide) {
        return false;
    }

    public int getProgresstime() {
        return (int)this.mTransferredAmperage * 64;
    }

    public int maxProgresstime() {
        return (int)this.mAmperage * 64;
    }

    public long injectEnergyUnits(byte aSide, long aVoltage, long aAmperage) {
        if (!this.getBaseMetaTileEntity().getCoverBehaviorAtSide(aSide).letsEnergyIn(aSide, this.getBaseMetaTileEntity().getCoverIDAtSide(aSide), this.getBaseMetaTileEntity().getCoverDataAtSide(aSide), (ICoverable)this.getBaseMetaTileEntity())) {
            return 0L;
        }
        return this.transferElectricity(aSide, aVoltage, aAmperage, new ArrayList<TileEntity>(Arrays.asList((TileEntity)this.getBaseMetaTileEntity())));
    }

    public long transferElectricity(byte arg0, long arg1, long arg2, HashSet<TileEntity> arg3) {
        ArrayList<TileEntity> aTiles = new ArrayList<TileEntity>();
        for (TileEntity y : arg3) {
            aTiles.add(y);
        }
        return this.transferElectricity(arg0, arg1, arg2, aTiles);
    }

    public long transferElectricity(byte aSide, long aVoltage, long aAmperage, ArrayList<TileEntity> aAlreadyPassedTileEntityList) {
        long rUsedAmperes = 0L;
        if ((aVoltage -= this.mCableLossPerMeter) > 0L) {
            for (byte i = 0; i < 6 && aAmperage > rUsedAmperes; i = (byte)(i + 1)) {
                int rfOut;
                TileEntity tTileEntity;
                if (i == aSide || (this.mConnections & 1 << i) == 0 || !this.getBaseMetaTileEntity().getCoverBehaviorAtSide(i).letsEnergyOut(i, this.getBaseMetaTileEntity().getCoverIDAtSide(i), this.getBaseMetaTileEntity().getCoverDataAtSide(i), (ICoverable)this.getBaseMetaTileEntity()) || aAlreadyPassedTileEntityList.contains(tTileEntity = this.getBaseMetaTileEntity().getTileEntityAtSide(i))) continue;
                aAlreadyPassedTileEntityList.add(tTileEntity);
                if (tTileEntity instanceof IEnergyConnected) {
                    byte tColor;
                    if (this.getBaseMetaTileEntity().getColorization() >= 0 && (tColor = ((IEnergyConnected)tTileEntity).getColorization()) >= 0 && tColor != this.getBaseMetaTileEntity().getColorization()) continue;
                    if (tTileEntity instanceof IGregTechTileEntity && ((IGregTechTileEntity)tTileEntity).getMetaTileEntity() instanceof IMetaTileEntityCable && ((IGregTechTileEntity)tTileEntity).getCoverBehaviorAtSide(GT_Utility.getOppositeSide((int)i)).letsEnergyIn(GT_Utility.getOppositeSide((int)i), ((IGregTechTileEntity)tTileEntity).getCoverIDAtSide(GT_Utility.getOppositeSide((int)i)), ((IGregTechTileEntity)tTileEntity).getCoverDataAtSide(GT_Utility.getOppositeSide((int)i)), (ICoverable)((IGregTechTileEntity)tTileEntity))) {
                        if (((IGregTechTileEntity)tTileEntity).getTimer() <= 50L) continue;
                        rUsedAmperes += ((IMetaTileEntityCable)((IGregTechTileEntity)tTileEntity).getMetaTileEntity()).transferElectricity(GT_Utility.getOppositeSide((int)i), aVoltage, aAmperage - rUsedAmperes, aAlreadyPassedTileEntityList);
                        continue;
                    }
                    rUsedAmperes += ((IEnergyConnected)tTileEntity).injectEnergyUnits(GT_Utility.getOppositeSide((int)i), aVoltage, aAmperage - rUsedAmperes);
                    continue;
                }
                if (tTileEntity instanceof IEnergySink) {
                    ForgeDirection tDirection = ForgeDirection.getOrientation((int)i).getOpposite();
                    if (!((IEnergySink)tTileEntity).acceptsEnergyFrom((TileEntity)this.getBaseMetaTileEntity(), tDirection) || !(((IEnergySink)tTileEntity).getDemandedEnergy() > 0.0) || !(((IEnergySink)tTileEntity).injectEnergy(tDirection, (double)aVoltage, (double)aVoltage) < (double)aVoltage)) continue;
                    ++rUsedAmperes;
                    continue;
                }
                if (!GregTech_API.mOutputRF || !(tTileEntity instanceof IEnergyReceiver)) continue;
                ForgeDirection tDirection = ForgeDirection.getOrientation((int)i).getOpposite();
                if (((IEnergyReceiver)tTileEntity).receiveEnergy(tDirection, rfOut = (int)(aVoltage * (long)GregTech_API.mEUtoRF / 100L), true) == rfOut) {
                    ((IEnergyReceiver)tTileEntity).receiveEnergy(tDirection, rfOut, false);
                    ++rUsedAmperes;
                } else if (((IEnergyReceiver)tTileEntity).receiveEnergy(tDirection, rfOut, true) > 0) {
                    int RFtrans;
                    if (this.mRestRF == 0L) {
                        RFtrans = ((IEnergyReceiver)tTileEntity).receiveEnergy(tDirection, rfOut, false);
                        ++rUsedAmperes;
                        this.mRestRF = rfOut - RFtrans;
                    } else {
                        RFtrans = ((IEnergyReceiver)tTileEntity).receiveEnergy(tDirection, (int)this.mRestRF, false);
                        this.mRestRF -= (long)RFtrans;
                    }
                }
                if (!GregTech_API.mRFExplosions || ((IEnergyReceiver)tTileEntity).getMaxEnergyStored(tDirection) >= rfOut * 600 || rfOut <= 32 * GregTech_API.mEUtoRF / 100) continue;
                this.doExplosion(rfOut);
            }
        }
        this.mTransferredAmperage += rUsedAmperes;
        this.mTransferredVoltageLast20 = Math.max(this.mTransferredVoltageLast20, aVoltage);
        this.mTransferredAmperageLast20 = Math.max(this.mTransferredAmperageLast20, this.mTransferredAmperage);
        if (aVoltage > this.mVoltage || this.mTransferredAmperage > this.mAmperage) {
            if (this.mOverheat > this.mWireHeatingTicks * 100) {
                this.getBaseMetaTileEntity().setToFire();
            } else {
                this.mOverheat = (short)(this.mOverheat + 100);
            }
            return aAmperage;
        }
        return rUsedAmperes;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            this.mTransferredAmperage = 0L;
            if (this.mOverheat > 0) {
                this.mOverheat = (short)(this.mOverheat - 1);
            }
            if (aTick % 20L == 0L) {
                this.mTransferredVoltageLast20 = 0L;
                this.mTransferredAmperageLast20 = 0L;
                this.mConnections = 0;
                byte j = 0;
                for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                    byte tColor;
                    TileEntity tTileEntity;
                    j = GT_Utility.getOppositeSide((int)i);
                    if (!aBaseMetaTileEntity.getCoverBehaviorAtSide(i).alwaysLookConnected(i, aBaseMetaTileEntity.getCoverIDAtSide(i), aBaseMetaTileEntity.getCoverDataAtSide(i), (ICoverable)aBaseMetaTileEntity) && !aBaseMetaTileEntity.getCoverBehaviorAtSide(i).letsEnergyIn(i, aBaseMetaTileEntity.getCoverIDAtSide(i), aBaseMetaTileEntity.getCoverDataAtSide(i), (ICoverable)aBaseMetaTileEntity) && !aBaseMetaTileEntity.getCoverBehaviorAtSide(i).letsEnergyOut(i, aBaseMetaTileEntity.getCoverIDAtSide(i), aBaseMetaTileEntity.getCoverDataAtSide(i), (ICoverable)aBaseMetaTileEntity) || (tTileEntity = aBaseMetaTileEntity.getTileEntityAtSide(i)) instanceof IColoredTileEntity && aBaseMetaTileEntity.getColorization() >= 0 && (tColor = ((IColoredTileEntity)tTileEntity).getColorization()) >= 0 && tColor != aBaseMetaTileEntity.getColorization()) continue;
                    if (tTileEntity instanceof IEnergyConnected && (((IEnergyConnected)tTileEntity).inputEnergyFrom(j) || ((IEnergyConnected)tTileEntity).outputsEnergyTo(j))) {
                        this.mConnections = (byte)(this.mConnections | 1 << i);
                        continue;
                    }
                    if (tTileEntity instanceof IGregTechTileEntity && ((IGregTechTileEntity)tTileEntity).getMetaTileEntity() instanceof IMetaTileEntityCable && (((IGregTechTileEntity)tTileEntity).getCoverBehaviorAtSide(j).alwaysLookConnected(j, ((IGregTechTileEntity)tTileEntity).getCoverIDAtSide(j), ((IGregTechTileEntity)tTileEntity).getCoverDataAtSide(j), (ICoverable)((IGregTechTileEntity)tTileEntity)) || ((IGregTechTileEntity)tTileEntity).getCoverBehaviorAtSide(j).letsEnergyIn(j, ((IGregTechTileEntity)tTileEntity).getCoverIDAtSide(j), ((IGregTechTileEntity)tTileEntity).getCoverDataAtSide(j), (ICoverable)((IGregTechTileEntity)tTileEntity)) || ((IGregTechTileEntity)tTileEntity).getCoverBehaviorAtSide(j).letsEnergyOut(j, ((IGregTechTileEntity)tTileEntity).getCoverIDAtSide(j), ((IGregTechTileEntity)tTileEntity).getCoverDataAtSide(j), (ICoverable)((IGregTechTileEntity)tTileEntity)))) {
                        this.mConnections = (byte)(this.mConnections | 1 << i);
                        continue;
                    }
                    if (tTileEntity instanceof IEnergySink && ((IEnergySink)tTileEntity).acceptsEnergyFrom((TileEntity)aBaseMetaTileEntity, ForgeDirection.getOrientation((int)j))) {
                        this.mConnections = (byte)(this.mConnections | 1 << i);
                        continue;
                    }
                    if (!GregTech_API.mOutputRF || !(tTileEntity instanceof IEnergyReceiver) || !((IEnergyReceiver)tTileEntity).canConnectEnergy(ForgeDirection.getOrientation((int)j))) continue;
                    this.mConnections = (byte)(this.mConnections | 1 << i);
                }
            }
        }
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public String[] getDescription() {
        return new String[]{"Max Voltage: " + EnumChatFormatting.GREEN + this.mVoltage + " (" + GT_Values.VN[GT_Utility.getTier((long)this.mVoltage)] + ")" + EnumChatFormatting.GRAY, "Max Amperage: " + EnumChatFormatting.YELLOW + this.mAmperage + EnumChatFormatting.GRAY, "Loss/Meter/Ampere: " + EnumChatFormatting.RED + this.mCableLossPerMeter + EnumChatFormatting.GRAY + " EU-Volt"};
    }

    public float getThickNess() {
        return this.mThickNess;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
    }

    public void loadNBTData(NBTTagCompound aNBT) {
    }
}

