/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations;

import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import java.lang.reflect.Field;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_Hatch_Naquadah
extends GT_MetaTileEntity_Hatch_Input {
    public final FluidStack[] mFluidsToUse = new FluidStack[3];
    public final int mFluidCapacity;
    private static String[] aDescCache = new String[3];
    private Field F1;
    private Field F2;

    public GT_MetaTileEntity_Hatch_Naquadah(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 6);
        this.mFluidCapacity = 32000;
        this.initHatch();
    }

    public GT_MetaTileEntity_Hatch_Naquadah(String aName, String aDescription, ITexture[][][] aTextures) {
        super(aName, 6, aDescription, aTextures);
        this.mFluidCapacity = 32000;
        this.initHatch();
    }

    public GT_MetaTileEntity_Hatch_Naquadah(String aName, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, 6, aDescription[0], aTextures);
        this.mFluidCapacity = 32000;
        this.initHatch();
    }

    private void initHatch() {
        if (this.mFluidsToUse[0] == null) {
            this.mFluidsToUse[0] = Materials.Naquadah.getMolten(1L);
        }
        if (this.mFluidsToUse[1] == null) {
            this.mFluidsToUse[1] = Materials.NaquadahEnriched.getMolten(1L);
        }
        if (this.mFluidsToUse[2] == null) {
            this.mFluidsToUse[2] = Materials.Naquadria.getMolten(1L);
        }
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.NAQUADAH_REACTOR_FLUID_SIDE_ACTIVE)};
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.NAQUADAH_REACTOR_FLUID_SIDE)};
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        if (aSide == aBaseMetaTileEntity.getFrontFacing() && aIndex == 0) {
            for (FluidStack f : this.mFluidsToUse) {
                if (f == null || GT_Utility.getFluidForFilledItem((ItemStack)aStack, (boolean)true).getFluid() != f.getFluid()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFluidInputAllowed(FluidStack aFluid) {
        for (FluidStack f : this.mFluidsToUse) {
            if (f == null || aFluid.getFluid() != f.getFluid()) continue;
            return true;
        }
        return false;
    }

    public int getCapacity() {
        return this.mFluidCapacity;
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_Naquadah(this.mName, this.mDescription, this.mTextures);
    }

    public String[] getDescription() {
        if (aDescCache[0] == null || aDescCache[0].contains(".name") || aDescCache[0].contains("fluid.")) {
            GT_MetaTileEntity_Hatch_Naquadah.aDescCache[0] = this.formatFluidString(this.mFluidsToUse[0]);
        }
        if (aDescCache[1] == null || aDescCache[1].contains(".name") || aDescCache[1].contains("fluid.")) {
            GT_MetaTileEntity_Hatch_Naquadah.aDescCache[1] = this.formatFluidString(this.mFluidsToUse[1]);
        }
        if (aDescCache[2] == null || aDescCache[2].contains(".name") || aDescCache[2].contains("fluid.")) {
            GT_MetaTileEntity_Hatch_Naquadah.aDescCache[2] = this.formatFluidString(this.mFluidsToUse[2]);
        }
        String aNaq = aDescCache[0];
        String aEnrNaq = aDescCache[1];
        String aNaquad = aDescCache[2];
        String[] s2 = new String[]{"Fluid Input for Multiblocks", "Capacity: " + this.getCapacity() + "L", "Accepted Fluid: " + aNaq, "Accepted Fluid: " + aEnrNaq, "Accepted Fluid: " + aNaquad, CORE.GT_Tooltip.get()};
        return s2;
    }

    private String formatFluidString(FluidStack f) {
        FluidStack mLockedStack = f;
        Integer mLockedTemp = 0;
        String mTempMod = "" + EnumChatFormatting.RESET;
        mLockedTemp = mLockedStack.getFluid().getTemperature();
        if (mLockedTemp != null) {
            if (mLockedTemp <= -3000) {
                mTempMod = "" + EnumChatFormatting.DARK_PURPLE;
            } else if (mLockedTemp >= -2999 && mLockedTemp <= -500) {
                mTempMod = "" + EnumChatFormatting.DARK_BLUE;
            } else if (mLockedTemp >= -499 && mLockedTemp <= -50) {
                mTempMod = "" + EnumChatFormatting.BLUE;
            } else if (mLockedTemp >= 30 && mLockedTemp <= 300) {
                mTempMod = "" + EnumChatFormatting.AQUA;
            } else if (mLockedTemp >= 301 && mLockedTemp <= 800) {
                mTempMod = "" + EnumChatFormatting.YELLOW;
            } else if (mLockedTemp >= 801 && mLockedTemp <= 1500) {
                mTempMod = "" + EnumChatFormatting.GOLD;
            } else if (mLockedTemp >= 1501) {
                mTempMod = "" + EnumChatFormatting.RED;
            }
        }
        return mTempMod + mLockedStack.getLocalizedName();
    }

    public boolean doesFillContainers() {
        return false;
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return super.getTextureSet(aTextures);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray;
        int a1 = 0;
        int a2 = 0;
        try {
            if (this.F1 == null) {
                this.F1 = ReflectionUtils.getField(((Object)((Object)this)).getClass(), "actualTexture");
            }
            if (this.F2 == null) {
                this.F2 = ReflectionUtils.getField(((Object)((Object)this)).getClass(), "mTexturePage");
            }
            if (this.F1 != null) {
                a1 = this.F1.getByte((Object)this);
            }
            if (this.F2 != null) {
                a2 = this.F2.getByte((Object)this);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
        int textureIndex = a1 | a2 << 7;
        byte texturePointer = (byte)(a1 & 0x7F);
        if (aSide == 1 || aSide == 0) {
            ITexture g = textureIndex > 0 ? Textures.BlockIcons.casingTexturePages[a2][texturePointer] : Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1];
            return new ITexture[]{g, new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.NAQUADAH_REACTOR_FLUID_TOP_ACTIVE)};
        }
        if (aSide != aFacing) {
            if (textureIndex > 0) {
                ITexture[] iTextureArray2 = new ITexture[1];
                iTextureArray = iTextureArray2;
                iTextureArray2[0] = Textures.BlockIcons.casingTexturePages[a2][texturePointer];
            } else {
                ITexture[] iTextureArray3 = new ITexture[1];
                iTextureArray = iTextureArray3;
                iTextureArray3[0] = Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1];
            }
        } else {
            iTextureArray = textureIndex > 0 ? (aActive ? this.getTexturesActive(Textures.BlockIcons.casingTexturePages[a2][texturePointer]) : this.getTexturesInactive(Textures.BlockIcons.casingTexturePages[a2][texturePointer])) : (aActive ? this.getTexturesActive(Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1]) : this.getTexturesInactive(Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1]));
        }
        return iTextureArray;
    }
}

