/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations;

import gregtech.api.enums.ItemList;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicTank;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public abstract class GT_MetaTileEntity_DeluxeTank
extends GT_MetaTileEntity_BasicTank {
    public FluidStack mFluid2;

    public GT_MetaTileEntity_DeluxeTank(int aID, String aName, String aNameRegional, int aTier, int aInvSlotCount, String aDescription, ITexture ... aTextures) {
        super(aID, aName, aNameRegional, aTier, aInvSlotCount, aDescription, aTextures);
    }

    public GT_MetaTileEntity_DeluxeTank(String aName, int aTier, int aInvSlotCount, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    public boolean isSimpleMachine() {
        return false;
    }

    public boolean isValidSlot(int aIndex) {
        return aIndex != this.getStackDisplaySlot();
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        if (this.mFluid != null) {
            aNBT.func_74782_a("mFluid", (NBTBase)this.mFluid.writeToNBT(new NBTTagCompound()));
        }
        if (this.mFluid2 != null) {
            aNBT.func_74782_a("mFluid2", (NBTBase)this.mFluid2.writeToNBT(new NBTTagCompound()));
        }
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.mFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT.func_74775_l("mFluid"));
        this.mFluid2 = FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT.func_74775_l("mFluid2"));
    }

    public abstract boolean doesFillContainers();

    public abstract boolean doesEmptyContainers();

    public abstract boolean canTankBeFilled();

    public abstract boolean canTankBeEmptied();

    public abstract boolean displaysItemStack();

    public abstract boolean displaysStackSize();

    public int getInputSlot() {
        return 0;
    }

    public int getOutputSlot() {
        return 1;
    }

    public int getStackDisplaySlot() {
        return 2;
    }

    public int getStackDisplaySlot2() {
        return 3;
    }

    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return true;
    }

    public boolean isFluidChangingAllowed() {
        return true;
    }

    public FluidStack getFillableStack() {
        return this.getFillableStackEx(1);
    }

    public FluidStack getFillableStackEx(int stackID) {
        if (stackID <= 1) {
            return this.mFluid;
        }
        return this.mFluid2;
    }

    public FluidStack setFillableStack(FluidStack aFluid) {
        this.mFluid = aFluid;
        return this.mFluid;
    }

    public FluidStack setFillableStack2(FluidStack aFluid) {
        this.mFluid2 = aFluid;
        return this.mFluid2;
    }

    public FluidStack getDrainableStack() {
        return this.getDrainableStackEx(1);
    }

    public FluidStack getDrainableStackEx(int stackID) {
        if (stackID <= 1) {
            return this.mFluid;
        }
        return this.mFluid2;
    }

    public FluidStack setDrainableStack(FluidStack aFluid) {
        this.mFluid = aFluid;
        return this.mFluid;
    }

    public FluidStack getDisplayedFluid() {
        return this.getDrainableStack();
    }

    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            ItemStack tOutput;
            FluidStack tFluid;
            if (this.isFluidChangingAllowed() && this.getFillableStack() != null && this.getFillableStack().amount <= 0) {
                this.setFillableStack(null);
            }
            if (this.displaysItemStack() && this.getStackDisplaySlot() >= 0 && this.getStackDisplaySlot() < this.mInventory.length) {
                if (this.getDisplayedFluid() == null) {
                    if (ItemList.Display_Fluid.isStackEqual((Object)this.mInventory[this.getStackDisplaySlot()], true, true)) {
                        this.mInventory[this.getStackDisplaySlot()] = null;
                    }
                } else {
                    this.mInventory[this.getStackDisplaySlot()] = GT_Utility.getFluidDisplayStack((FluidStack)this.getDisplayedFluid(), (boolean)this.displaysStackSize());
                }
            }
            if (this.displaysItemStack() && this.getStackDisplaySlot2() >= 0 && this.getStackDisplaySlot2() < this.mInventory.length) {
                if (this.getDrainableStackEx(2) == null) {
                    if (ItemList.Display_Fluid.isStackEqual((Object)this.mInventory[this.getStackDisplaySlot2()], true, true)) {
                        this.mInventory[this.getStackDisplaySlot2()] = null;
                    }
                } else {
                    this.mInventory[this.getStackDisplaySlot2()] = GT_Utility.getFluidDisplayStack((FluidStack)this.getDrainableStackEx(2), (boolean)this.displaysStackSize());
                }
            }
            if (this.doesEmptyContainers() && (tFluid = GT_Utility.getFluidForFilledItem((ItemStack)this.mInventory[this.getInputSlot()], (boolean)true)) != null && this.isFluidInputAllowed(tFluid)) {
                if (tFluid.isFluidEqual(this.getDrainableStackEx(1)) || this.getDrainableStackEx(1) == null) {
                    if (this.getFillableStackEx(1) == null) {
                        if (this.isFluidInputAllowed(tFluid) && tFluid.amount <= this.getCapacity() && aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot(), GT_Utility.getContainerItem((ItemStack)this.mInventory[this.getInputSlot()], (boolean)true), 1)) {
                            this.setFillableStack(tFluid.copy());
                            aBaseMetaTileEntity.func_70298_a(this.getInputSlot(), 1);
                        }
                    } else if (tFluid.isFluidEqual(this.getFillableStack()) && tFluid.amount + this.getFillableStack().amount <= this.getCapacity() && aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot(), GT_Utility.getContainerItem((ItemStack)this.mInventory[this.getInputSlot()], (boolean)true), 1)) {
                        this.getFillableStack().amount += tFluid.amount;
                        aBaseMetaTileEntity.func_70298_a(this.getInputSlot(), 1);
                    }
                } else if (tFluid.isFluidEqual(this.getDrainableStackEx(2)) || this.getDrainableStackEx(2) == null) {
                    if (this.getFillableStackEx(2) == null) {
                        if (this.isFluidInputAllowed(tFluid) && tFluid.amount <= this.getCapacity() && aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot(), GT_Utility.getContainerItem((ItemStack)this.mInventory[this.getInputSlot()], (boolean)true), 1)) {
                            this.setFillableStack2(tFluid.copy());
                            aBaseMetaTileEntity.func_70298_a(this.getInputSlot(), 1);
                        }
                    } else if (tFluid.isFluidEqual(this.getFillableStackEx(2)) && tFluid.amount + this.getFillableStackEx((int)2).amount <= this.getCapacity() && aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot(), GT_Utility.getContainerItem((ItemStack)this.mInventory[this.getInputSlot()], (boolean)true), 1)) {
                        this.getFillableStackEx((int)2).amount += tFluid.amount;
                        aBaseMetaTileEntity.func_70298_a(this.getInputSlot(), 1);
                    }
                } else {
                    Logger.INFO("Something broke when trying to empty cells between two fluid tank areas.");
                }
            }
            if (this.doesFillContainers() && (tOutput = GT_Utility.fillFluidContainer((FluidStack)this.getDrainableStack(), (ItemStack)this.mInventory[this.getInputSlot()], (boolean)false, (boolean)true)) != null && aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot(), tOutput, 1)) {
                FluidStack tFluid2 = GT_Utility.getFluidForFilledItem((ItemStack)tOutput, (boolean)true);
                aBaseMetaTileEntity.func_70298_a(this.getInputSlot(), 1);
                if (tFluid2 != null) {
                    this.getDrainableStack().amount -= tFluid2.amount;
                }
                if (this.getDrainableStack().amount <= 0 && this.isFluidChangingAllowed()) {
                    this.setDrainableStack(null);
                }
            }
        }
    }

    public FluidStack getFluid() {
        return this.getDrainableStack();
    }

    public int getFluidAmount() {
        return this.getDrainableStack() != null ? this.getDrainableStack().amount : 0;
    }

    public int fill(FluidStack aFluid, boolean doFill) {
        if (aFluid == null || aFluid.getFluid().getID() <= 0 || aFluid.amount <= 0 || !this.canTankBeFilled() || !this.isFluidInputAllowed(aFluid)) {
            return 0;
        }
        if (this.getFillableStack() == null || this.getFillableStack().getFluid().getID() <= 0) {
            if (aFluid.amount <= this.getCapacity()) {
                if (doFill) {
                    this.setFillableStack(aFluid.copy());
                    this.getBaseMetaTileEntity().func_70296_d();
                }
                return aFluid.amount;
            }
            if (doFill) {
                this.setFillableStack(aFluid.copy());
                this.getFillableStack().amount = this.getCapacity();
                this.getBaseMetaTileEntity().func_70296_d();
            }
            return this.getCapacity();
        }
        if (!this.getFillableStack().isFluidEqual(aFluid)) {
            return 0;
        }
        int space = this.getCapacity() - this.getFillableStack().amount;
        if (aFluid.amount <= space) {
            if (doFill) {
                this.getFillableStack().amount += aFluid.amount;
                this.getBaseMetaTileEntity().func_70296_d();
            }
            return aFluid.amount;
        }
        if (doFill) {
            this.getFillableStack().amount = this.getCapacity();
        }
        return space;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.getDrainableStack() == null || !this.canTankBeEmptied()) {
            return null;
        }
        if (this.getDrainableStack().amount <= 0 && this.isFluidChangingAllowed()) {
            this.setDrainableStack(null);
            this.getBaseMetaTileEntity().func_70296_d();
            return null;
        }
        int used = maxDrain;
        if (this.getDrainableStack().amount < used) {
            used = this.getDrainableStack().amount;
        }
        if (doDrain) {
            this.getDrainableStack().amount -= used;
            this.getBaseMetaTileEntity().func_70296_d();
        }
        FluidStack drained = this.getDrainableStack().copy();
        drained.amount = used;
        if (this.getDrainableStack().amount <= 0 && this.isFluidChangingAllowed()) {
            this.setDrainableStack(null);
            this.getBaseMetaTileEntity().func_70296_d();
        }
        return drained;
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aIndex == this.getOutputSlot();
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aIndex == this.getInputSlot();
    }
}

