/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.forestry.bees.tileentities;

import buildcraft.api.statements.ITriggerExternal;
import cpw.mods.fml.common.Optional;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IHiveFrame;
import forestry.apiculture.ApiaryBeeListener;
import forestry.apiculture.ApiaryBeeModifier;
import forestry.apiculture.IApiary;
import forestry.apiculture.gui.IGuiBeeHousingInventory;
import forestry.apiculture.inventory.IApiaryInventory;
import forestry.apiculture.inventory.InventoryApiary;
import forestry.apiculture.tiles.TileBeeHousingBase;
import forestry.apiculture.trigger.ApicultureTriggers;
import forestry.core.inventory.IInventoryAdapter;
import gtPlusPlus.xmod.forestry.bees.gui.ContainerBeeHouse;
import gtPlusPlus.xmod.forestry.bees.gui.GuiBeeHouse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileDenseBeeHouse
extends TileBeeHousingBase
implements IApiary {
    private final IBeeModifier beeModifier = new ApiaryBeeModifier();
    private final IBeeListener beeListener = new ApiaryBeeListener((IApiary)this);
    private final InventoryApiary inventory = new InventoryApiary(this.getAccessHandler());

    public TileDenseBeeHouse() {
        super("apiary2");
        this.setInternalInventory((IInventoryAdapter)this.inventory);
    }

    public IBeeHousingInventory getBeeInventory() {
        return this.inventory;
    }

    public IApiaryInventory getApiaryInventory() {
        return this.inventory;
    }

    public Collection<IBeeModifier> getBeeModifiers() {
        ArrayList<IBeeModifier> beeModifiers = new ArrayList<IBeeModifier>();
        beeModifiers.add(this.beeModifier);
        for (IHiveFrame frame : this.inventory.getFrames()) {
            beeModifiers.add(frame.getBeeModifier());
        }
        return beeModifiers;
    }

    public Iterable<IBeeListener> getBeeListeners() {
        return Collections.singleton(this.beeListener);
    }

    @Optional.Method(modid="BuildCraftAPI|statements")
    public Collection<ITriggerExternal> getExternalTriggers(ForgeDirection side, TileEntity tile) {
        LinkedList<ITriggerExternal> res = new LinkedList<ITriggerExternal>();
        res.add((ITriggerExternal)ApicultureTriggers.missingQueen);
        res.add((ITriggerExternal)ApicultureTriggers.missingDrone);
        res.add((ITriggerExternal)ApicultureTriggers.noFrames);
        return res;
    }

    public Object getGui(EntityPlayer player, int data) {
        ContainerBeeHouse container = new ContainerBeeHouse(player.field_71071_by, this, true);
        return new GuiBeeHouse<ContainerBeeHouse>((IGuiBeeHousingInventory)this, container, GuiBeeHouse.Icon.APIARY);
    }

    public Object getContainer(EntityPlayer player, int data) {
        return new ContainerBeeHouse(player.field_71071_by, this, true);
    }
}

