/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.plugin.fishing.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gtPlusPlus.plugin.fishing.misc.BaseFishTypes;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionHelper;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BaseFish
extends ItemFood {
    private final boolean isCooked;

    public BaseFish(boolean cooked) {
        super(0, 0.0f, false);
        this.isCooked = cooked;
    }

    public int func_150905_g(ItemStack p_150905_1_) {
        BaseFishTypes fishtype = BaseFishTypes.getFishTypeFromStackDamage(p_150905_1_);
        return this.isCooked && fishtype.isCooked() ? fishtype.func_150970_e() : fishtype.func_150975_c();
    }

    public float func_150906_h(ItemStack p_150906_1_) {
        BaseFishTypes fishtype = BaseFishTypes.getFishTypeFromStackDamage(p_150906_1_);
        return this.isCooked && fishtype.isCooked() ? fishtype.func_150977_f() : fishtype.func_150967_d();
    }

    public String func_150896_i(ItemStack p_150896_1_) {
        return BaseFishTypes.getFishTypeFromStackDamage(p_150896_1_) == BaseFishTypes.PUFFERFISH ? PotionHelper.field_151423_m : null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister p_94581_1_) {
        for (BaseFishTypes fishtype : BaseFishTypes.values()) {
            fishtype.func_150968_a(p_94581_1_);
        }
    }

    protected void func_77849_c(ItemStack fish, World world, EntityPlayer player) {
        BaseFishTypes fishtype = BaseFishTypes.getFishTypeFromStackDamage(fish);
        if (fishtype == BaseFishTypes.PUFFERFISH) {
            player.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 1200, 3));
            player.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 300, 2));
            player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 300, 1));
        }
        super.func_77849_c(fish, world, player);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int dmg) {
        BaseFishTypes fishtype = BaseFishTypes.getFishTypeFromDamageValue(dmg);
        return this.isCooked && fishtype.isCooked() ? fishtype.func_150979_h() : fishtype.func_150971_g();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item p_150895_1_, CreativeTabs p_150895_2_, List p_150895_3_) {
        for (BaseFishTypes fishtype : BaseFishTypes.values()) {
            if (this.isCooked && !fishtype.isCooked()) continue;
            p_150895_3_.add(new ItemStack((Item)this, 1, fishtype.getFishID()));
        }
    }

    public String func_77667_c(ItemStack p_77667_1_) {
        BaseFishTypes fishtype = BaseFishTypes.getFishTypeFromStackDamage(p_77667_1_);
        return this.func_77658_a() + "." + fishtype.getFishName() + "." + (this.isCooked && fishtype.isCooked() ? "cooked" : "raw");
    }
}

