/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.minecraft.network;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gtPlusPlus.api.interfaces.IGregtechPacketEntity;
import gtPlusPlus.core.util.minecraft.network.CustomPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.tileentity.TileEntity;

public class PacketTileEntity
extends CustomPacket {
    private IGregTechTileEntity tile;
    private IGregtechPacketEntity ptile;

    public PacketTileEntity() {
    }

    public PacketTileEntity(IGregTechTileEntity tile) {
        this.tile = tile;
        if (tile instanceof IGregtechPacketEntity) {
            this.ptile = (IGregtechPacketEntity)tile;
        }
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        if (this.ptile != null) {
            data.writeInt(this.tile.getXCoord());
            data.writeInt(this.tile.getYCoord());
            data.writeInt(this.tile.getZCoord());
            data.writeShort(this.tile.getMetaTileID());
            this.ptile.writePacketData(data);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readData(DataInputStream data) throws IOException {
        WorldClient world;
        Minecraft mc = FMLClientHandler.instance().getClient();
        WorldClient worldClient = world = mc != null ? mc.field_71441_e : null;
        if (world != null) {
            int x = data.readInt();
            int y = data.readInt();
            int z = data.readInt();
            short id = data.readShort();
            if (id >= 0 && y >= 0 && world.func_72899_e(x, y, z)) {
                TileEntity te = world.func_147438_o(x, y, z);
                if (te instanceof IGregTechTileEntity) {
                    this.tile = (IGregTechTileEntity)te;
                    if (this.tile.getMetaTileID() != id) {
                        this.tile = null;
                    }
                } else {
                    this.tile = null;
                }
                if (this.tile != null && this.tile instanceof IGregtechPacketEntity) {
                    this.ptile = (IGregtechPacketEntity)this.tile;
                    try {
                        this.ptile.readPacketData(data);
                    }
                    catch (IOException var10) {
                        throw var10;
                    }
                    catch (RuntimeException var11) {
                        Game.logThrowable((String)"Exception in PacketTileEntity.readData:", (Throwable)var11, (Object[])new Object[0]);
                    }
                }
            }
        }
    }

    @Override
    public int getID() {
        return 0;
    }
}

