/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.minecraft.network;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.util.minecraft.network.CustomPacket;
import gtPlusPlus.core.util.minecraft.network.PacketTileEntity;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;

public class PacketHandler {
    public static final PacketHandler INSTANCE = new PacketHandler();
    private static final CustomPacket.PacketType[] packetTypes = CustomPacket.PacketType.values();
    final FMLEventChannel channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("GTPP");

    private PacketHandler() {
        this.channel.register((Object)this);
    }

    public static void init() {
    }

    @SubscribeEvent
    public void onPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        byte[] data = new byte[event.packet.payload().readableBytes()];
        event.packet.payload().readBytes(data);
        this.onPacketData(data, ((NetHandlerPlayServer)event.handler).field_147369_b);
    }

    @SubscribeEvent
    public void onPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        byte[] data = new byte[event.packet.payload().readableBytes()];
        event.packet.payload().readBytes(data);
        this.onPacketData(data, null);
    }

    public void onPacketData(byte[] bData, EntityPlayerMP player) {
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(bData));
        try {
            PacketTileEntity pkt;
            byte packetID = data.readByte();
            if (packetID < 0) {
                return;
            }
            CustomPacket.PacketType type = packetTypes[packetID];
            switch (type.ordinal()) {
                case 0: {
                    pkt = new PacketTileEntity();
                    break;
                }
                default: {
                    return;
                }
            }
            if (pkt != null) {
                ((CustomPacket)pkt).readData(data);
            }
        }
        catch (IOException var7) {
            Logger.ERROR("Exception in PacketHandler.onPacketData: {0}" + var7 + new Object[]{Arrays.toString(bData)});
        }
    }
}

