/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.tileentities.machines;

import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.minecraft.BTF_FluidTank;
import gtPlusPlus.core.inventories.InventoryPestKiller;
import gtPlusPlus.core.lib.LoadedMods;
import gtPlusPlus.core.material.MISC_MATERIALS;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.EntityUtils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityPestKiller
extends TileEntity
implements ISidedInventory,
IFluidHandler {
    private final int mBaseTickRate = 600;
    private final InventoryPestKiller mInventory = new InventoryPestKiller();
    private final FluidTank mTank = new BTF_FluidTank(2000);
    private int mChunkX;
    private int mChunkZ;
    private boolean mSet = false;
    private int mTickCounter = 0;
    private int mUpdateTick = 0;
    private boolean mNeedsUpdate = false;
    private String mCustomName;
    private static final AutoMap<Class<?>> mEntityMap = new AutoMap();

    public InventoryPestKiller getInventory() {
        return this.mInventory;
    }

    public FluidTank getTank() {
        return this.mTank;
    }

    private final void setup() {
        Chunk c;
        World w = this.field_145850_b;
        if (w != null && (c = w.func_72938_d(this.field_145851_c, this.field_145849_e)) != null) {
            this.mChunkX = c.field_76635_g;
            this.mChunkZ = c.field_76647_h;
            this.mSet = true;
        }
    }

    public boolean tryKillPests() {
        int min = 0;
        int max = 0;
        switch (this.getTier()) {
            case 1: {
                min = -2;
                max = 3;
                break;
            }
            case 2: {
                min = -4;
                max = 5;
                break;
            }
        }
        int aChunkCount = 0;
        AutoMap<Entity> entities = new AutoMap<Entity>();
        if (min != 0 && max != 0) {
            for (int x = min; x < max; ++x) {
                for (int z = min; z < max; ++z) {
                    List[] lists;
                    Chunk c = this.getChunkFromOffsetIfLoaded(x, z);
                    if (c == null || !c.field_76644_m) continue;
                    ++aChunkCount;
                    for (List o : lists = c.field_76645_j) {
                        for (Class<Object> clazz : o) {
                            if (!(clazz instanceof Entity)) continue;
                            for (Class<?> C : mEntityMap) {
                                if (!clazz.getClass().equals(C) && !C.isAssignableFrom(clazz.getClass())) continue;
                                entities.put((Entity)clazz);
                            }
                        }
                    }
                }
            }
        } else {
            Chunk c = this.getChunkFromOffsetIfLoaded(0, 0);
            if (c != null && c.field_76644_m) {
                Chunk lists;
                for (Chunk o : lists = c.field_76645_j) {
                    for (Object e : o) {
                        if (!(e instanceof Entity)) continue;
                        for (Class<Object> clazz : mEntityMap) {
                            if (!e.getClass().equals(clazz) && !clazz.isAssignableFrom(e.getClass())) continue;
                            entities.put((Entity)e);
                        }
                    }
                }
            }
        }
        boolean killed = false;
        if (!entities.isEmpty()) {
            for (Entity e : entities) {
                int aChanceToUse;
                if (e == null || !e.func_70089_S() || this.mTank.getFluidAmount() < 1 && this.getTier() != 0) continue;
                if (this.getTier() > 0 && (aChanceToUse = MathUtils.randInt(1, 100 * this.getTier())) == 1) {
                    this.mTank.drain(1, true);
                }
                EntityUtils.doDamage(e, DamageSource.field_76377_j, Short.MAX_VALUE);
                e.func_70106_y();
                killed = true;
            }
        }
        this.updateTileEntity();
        return killed;
    }

    public Chunk getChunkFromOffsetIfLoaded(int x, int y) {
        Chunk c = this.field_145850_b.func_72964_e(this.mChunkX + x, this.mChunkZ + y);
        if (c.field_76636_d) {
            return c;
        }
        return null;
    }

    public int getTier() {
        FluidStack f;
        if (this.mTank != null && (f = this.mTank.getFluid()) != null) {
            if (f.isFluidEqual(FluidUtils.getWildcardFluidStack("formaldehyde", 1))) {
                return 1;
            }
            if (f.isFluidEqual(MISC_MATERIALS.HYDROGEN_CYANIDE.getFluidStack(1))) {
                return 2;
            }
        }
        return 0;
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.mSet) {
            this.setup();
        }
        ++this.mTickCounter;
        if (this.mTank != null && this.hasFluidSpace()) {
            this.handleInventory();
        }
        if (this.mTickCounter % this.mBaseTickRate == 0) {
            this.tryKillPests();
        }
        this.updateTick();
    }

    public boolean anyPlayerInRange() {
        return this.field_145850_b.func_72977_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 32.0) != null;
    }

    public NBTTagCompound getTag(NBTTagCompound nbt, String tag) {
        if (!nbt.func_74764_b(tag)) {
            nbt.func_74782_a(tag, (NBTBase)new NBTTagCompound());
        }
        return nbt.func_74775_l(tag);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        this.mTank.writeToNBT(nbt);
        super.func_145841_b(nbt);
        NBTTagCompound chestData = new NBTTagCompound();
        this.mInventory.writeToNBT(chestData);
        nbt.func_74782_a("ContentsChest", (NBTBase)chestData);
        if (this.func_145818_k_()) {
            nbt.func_74778_a("CustomName", this.getCustomName());
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.mTank.readFromNBT(nbt);
        super.func_145839_a(nbt);
        this.mInventory.readFromNBT(nbt.func_74775_l("ContentsChest"));
        if (nbt.func_150297_b("CustomName", 8)) {
            this.setCustomName(nbt.func_74779_i("CustomName"));
        }
    }

    public int func_70302_i_() {
        return this.getInventory().func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.getInventory().func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int count) {
        return this.getInventory().func_70298_a(slot, count);
    }

    public ItemStack func_70304_b(int slot) {
        return this.getInventory().func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.getInventory().func_70299_a(slot, stack);
    }

    public int func_70297_j_() {
        return this.getInventory().func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.getInventory().func_70300_a(entityplayer);
    }

    public void func_70295_k_() {
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, 1);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.func_145838_q());
        this.getInventory().func_70295_k_();
    }

    public void func_70305_f() {
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, 1);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.func_145838_q());
        this.getInventory().func_70305_f();
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return this.getInventory().func_94041_b(slot, itemstack);
    }

    public int[] func_94128_d(int p_94128_1_) {
        int[] accessibleSides = new int[this.func_70302_i_()];
        for (int r = 0; r < this.getInventory().func_70302_i_(); ++r) {
            accessibleSides[r] = r;
        }
        return accessibleSides;
    }

    public boolean func_102007_a(int aSlot, ItemStack aStack, int p_102007_3_) {
        int diff;
        if (this.getInventory().getInventory()[0] == null) {
            return true;
        }
        return GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)this.getInventory().getInventory()[0]) && this.getInventory().getInventory()[0].field_77994_a < 64 && aStack.field_77994_a <= (diff = 64 - this.getInventory().getInventory()[0].field_77994_a);
    }

    public boolean func_102008_b(int aSlot, ItemStack aStack, int p_102008_3_) {
        return this.getInventory().getInventory()[1] != null;
    }

    public String getCustomName() {
        return this.mCustomName;
    }

    public void setCustomName(String customName) {
        this.mCustomName = customName;
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.mCustomName : "container.pestkiller";
    }

    public boolean func_145818_k_() {
        return this.mCustomName != null && !this.mCustomName.equals("");
    }

    public final int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        this.updateTileEntity();
        return this.mTank.fill(resource, doFill);
    }

    public final FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        this.updateTileEntity();
        return this.mTank.drain(resource.amount, doDrain);
    }

    public final FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack fluid = this.mTank.getFluid();
        if (fluid == null) {
            return null;
        }
        int drained = maxDrain;
        if (fluid.amount < drained) {
            drained = fluid.amount;
        }
        FluidStack stack = new FluidStack(fluid, drained);
        if (doDrain) {
            fluid.amount -= drained;
            if (fluid.amount <= 0) {
                fluid = null;
            }
            if (this != null) {
                FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidDrainingEvent(fluid, this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, (IFluidTank)this.mTank, 0));
            }
        }
        this.updateTileEntity();
        return stack;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.mTank.getFluid() == null || this.mTank.getFluid().getFluid().equals(fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public final FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.mTank.getInfo()};
    }

    public final Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, tag);
    }

    public final void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
    }

    public boolean hasFluidSpace() {
        return this.mTank.getFluidAmount() <= 1000;
    }

    public boolean drainCell() {
        boolean didFill = false;
        ItemStack aInput = this.func_70301_a(0);
        if (aInput == null) {
            return false;
        }
        if ((aInput = aInput.func_77946_l()) != null && (this.func_70301_a(1) == null || this.func_70301_a((int)1).field_77994_a < 64)) {
            ArrayList t1Cells = OreDictionary.getOres((String)"cellFormaldehyde");
            ArrayList t2Cells = OreDictionary.getOres((String)"cellHydrogenCyanide");
            didFill = this.addFluid(t1Cells, aInput, FluidUtils.getWildcardFluidStack("formaldehyde", 1000));
            if (!didFill) {
                didFill = this.addFluid(t2Cells, aInput, MISC_MATERIALS.HYDROGEN_CYANIDE.getFluidStack(1000));
            }
        }
        return didFill;
    }

    public boolean handleInventory() {
        if (this.getInventory() != null && this.drainCell()) {
            this.func_70298_a(0, 1);
            if (this.func_70301_a(1) == null) {
                this.func_70299_a(1, CI.emptyCells(1));
            } else {
                ++this.func_70301_a((int)1).field_77994_a;
            }
            this.updateTileEntity();
            return true;
        }
        return false;
    }

    public boolean addFluid(ArrayList<ItemStack> inputs, ItemStack aInput, FluidStack aFluidForInput) {
        for (ItemStack a : inputs) {
            if (!GT_Utility.areStacksEqual((ItemStack)a, (ItemStack)aInput) || this.mTank.getFluid() != null && !this.mTank.getFluid().isFluidEqual(aFluidForInput)) continue;
            boolean didFill = this.fill(ForgeDirection.UNKNOWN, aFluidForInput, true) > 0;
            return didFill;
        }
        return false;
    }

    public void updateTileEntity() {
        this.getInventory().func_70296_d();
        this.func_70296_d();
        this.mNeedsUpdate = true;
    }

    private final void updateTick() {
        if (this.mNeedsUpdate) {
            if (this.mUpdateTick == 0) {
                this.mUpdateTick = 4;
            } else {
                --this.mUpdateTick;
                if (this.mUpdateTick == 0) {
                    this.func_70296_d();
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.mNeedsUpdate = false;
                }
            }
        }
    }

    static {
        mEntityMap.put(EntityBat.class);
        if (LoadedMods.Forestry) {
            mEntityMap.put(ReflectionUtils.getClass("forestry.lepidopterology.entities.EntityButterfly"));
        }
    }
}

