/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.tileentities.general;

import gtPlusPlus.api.objects.minecraft.BTF_FluidTank;
import gtPlusPlus.core.tileentities.base.TileBasicTank;
import gtPlusPlus.core.util.minecraft.EnchantingUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import org.lwjgl.input.Keyboard;

public class TileEntityXpConverter
extends TileBasicTank {
    public BTF_FluidTank tankEssence = new BTF_FluidTank(852480);
    public BTF_FluidTank tankLiquidXp = new BTF_FluidTank(64000);
    private boolean mConvertToEssence = true;

    public TileEntityXpConverter() {
        super(4, 32000);
    }

    private void changeMode() {
        if (this.mConvertToEssence) {
            this.mConvertToEssence = false;
            return;
        }
        this.mConvertToEssence = true;
    }

    public float getAdjustedVolume() {
        if (this.mConvertToEssence) {
            if (this.tankLiquidXp.getFluid() != null && this.tankLiquidXp.getFluidAmount() >= 100 && (double)this.tankEssence.getFluidAmount() <= (double)this.tankEssence.getCapacity() - 1332.0) {
                FluidStack bigStorage = EnchantingUtils.getEssenceFromLiquidXp(100);
                this.tankEssence.fill(bigStorage, true);
                this.tankLiquidXp.drain(100, true);
                return this.tankEssence.getCapacity() - this.tankEssence.getFluidAmount();
            }
        } else {
            double rm = 13.32;
            if (this.tankEssence.getFluid() != null && (double)this.tankEssence.getFluidAmount() >= 13.32 && (double)this.tankLiquidXp.getFluidAmount() <= (double)this.tankLiquidXp.getCapacity() - 13.32) {
                FluidStack bigStorage = EnchantingUtils.getLiquidXP(1);
                this.tankLiquidXp.fill(bigStorage, true);
                this.tankEssence.drain(13, true);
                return this.tankLiquidXp.getCapacity() - this.tankLiquidXp.getFluidAmount();
            }
        }
        return 0.0f;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        this.tankEssence.readFromNBT(tag);
        this.tankLiquidXp.readFromNBT(tag);
        this.mConvertToEssence = tag.func_74767_n("mConvertToEssence");
        super.func_145839_a(tag);
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        this.tankEssence.writeToNBT(tag);
        this.tankLiquidXp.writeToNBT(tag);
        tag.func_74757_a("mConvertToEssence", this.mConvertToEssence);
        super.func_145841_b(tag);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
    }

    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (this.isServerSide()) {
            if (this.mConvertToEssence) {
                PlayerUtils.messagePlayer(aPlayer, "Converting from Mob Essence to Liquid Xp.");
            } else {
                PlayerUtils.messagePlayer(aPlayer, "Converting from Liquid Xp to Mob Essence.");
            }
            this.changeMode();
        }
    }

    public void onRightClick(byte aSide, EntityPlayer aPlayer, int aX, int aY, int aZ) {
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            String mOutput;
            String mInput;
            if (this.mConvertToEssence) {
                mInput = "Liquid Xp";
                mOutput = "Mob Essence";
            } else {
                mInput = "Mob Essence";
                mOutput = "Liquid Xp";
            }
            PlayerUtils.messagePlayer(aPlayer, "Input: " + mInput + ".");
            PlayerUtils.messagePlayer(aPlayer, "Output: " + mOutput + ".");
        }
    }

    @Override
    public boolean onPreTick(long aTick) {
        boolean aSuperResult = super.onPreTick(aTick);
        long aTankSpaceLeft = 0L;
        double aAmount = 0.0;
        int aRuns = 0;
        if (this.mConvertToEssence) {
            aTankSpaceLeft = this.tankEssence.getCapacity() - this.tankEssence.getFluidAmount();
            aAmount = EnchantingUtils.getEssenceFromLiquidXp((int)100).amount;
        } else {
            aTankSpaceLeft = this.tankLiquidXp.getCapacity() - this.tankLiquidXp.getFluidAmount();
            aAmount = 13.32;
        }
        aRuns = (int)((double)aTankSpaceLeft / aAmount);
        for (int i = 0; i < aRuns && this.getAdjustedVolume() != 0.0f; ++i) {
        }
        return aSuperResult;
    }

    @Override
    public boolean isLiquidInput(byte aSide) {
        if (this.mConvertToEssence) {
            if (aSide == 0 || aSide == 1) {
                return false;
            }
        } else if (aSide == 0 || aSide == 1) {
            return true;
        }
        return false;
    }

    @Override
    public boolean isLiquidOutput(byte aSide) {
        if (this.mConvertToEssence) {
            if (aSide == 0 || aSide == 1) {
                return true;
            }
        } else if (aSide == 0 || aSide == 1) {
            return false;
        }
        return false;
    }

    @Override
    public int fill(ForgeDirection aSide, FluidStack aFluid, boolean doFill) {
        if (this.mConvertToEssence) {
            if (aSide != ForgeDirection.UP && aSide != ForgeDirection.DOWN) {
                return this.tankLiquidXp.fill(aFluid, doFill);
            }
        } else if (aSide == ForgeDirection.UP || aSide == ForgeDirection.DOWN) {
            return this.tankEssence.fill(aFluid, doFill);
        }
        return 0;
    }

    @Override
    public FluidStack drain(ForgeDirection aSide, int maxDrain, boolean doDrain) {
        if (this.mConvertToEssence) {
            if (aSide == ForgeDirection.UP || aSide == ForgeDirection.DOWN) {
                return this.tankEssence.drain(maxDrain, doDrain);
            }
        } else if (aSide != ForgeDirection.UP && aSide != ForgeDirection.DOWN) {
            return this.tankLiquidXp.drain(maxDrain, doDrain);
        }
        return null;
    }

    @Override
    public FluidStack drain(ForgeDirection aSide, FluidStack aFluid, boolean doDrain) {
        if (this.mConvertToEssence) {
            if (aSide == ForgeDirection.UP || aSide == ForgeDirection.DOWN) {
                return this.tankEssence.drain(aFluid, doDrain);
            }
        } else if (aSide != ForgeDirection.UP && aSide != ForgeDirection.DOWN) {
            return this.tankLiquidXp.drain(aFluid, doDrain);
        }
        return null;
    }

    @Override
    public boolean canFill(ForgeDirection aSide, Fluid aFluid) {
        if (this.mConvertToEssence) {
            if (aSide != ForgeDirection.UP && aSide != ForgeDirection.DOWN) {
                return this.tankLiquidXp.canTankBeFilled();
            }
        } else if (aSide == ForgeDirection.UP || aSide == ForgeDirection.DOWN) {
            return this.tankEssence.canTankBeFilled();
        }
        return false;
    }

    @Override
    public boolean canDrain(ForgeDirection aSide, Fluid aFluid) {
        if (this.mConvertToEssence) {
            if (aSide == ForgeDirection.UP || aSide == ForgeDirection.DOWN) {
                return this.tankEssence.canTankBeEmptied();
            }
        } else if (aSide != ForgeDirection.UP && aSide != ForgeDirection.DOWN) {
            return this.tankLiquidXp.canTankBeEmptied();
        }
        return false;
    }

    @Override
    public FluidTankInfo[] getTankInfo(ForgeDirection aSide) {
        if (aSide == ForgeDirection.UP || aSide == ForgeDirection.DOWN) {
            return new FluidTankInfo[]{this.tankEssence.getInfo()};
        }
        return new FluidTankInfo[]{this.tankLiquidXp.getInfo()};
    }

    @Override
    public FluidStack getFluid() {
        if (this.mConvertToEssence) {
            return this.tankEssence.getFluid();
        }
        return this.tankLiquidXp.getFluid();
    }

    @Override
    public int getFluidAmount() {
        if (this.mConvertToEssence) {
            return this.tankEssence.getFluidAmount();
        }
        return this.tankLiquidXp.getFluidAmount();
    }

    @Override
    public FluidTankInfo getInfo() {
        if (this.mConvertToEssence) {
            return this.tankEssence.getInfo();
        }
        return this.tankLiquidXp.getInfo();
    }

    @Override
    public int fill(FluidStack resource, boolean doFill) {
        if (this.mConvertToEssence) {
            return this.tankEssence.fill(resource, doFill);
        }
        return this.tankLiquidXp.fill(resource, doFill);
    }

    @Override
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.mConvertToEssence) {
            return this.tankEssence.drain(maxDrain, doDrain);
        }
        return this.tankLiquidXp.drain(maxDrain, doDrain);
    }
}

