/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.tileentities.general;

import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.inventories.InventoryFishTrap;
import gtPlusPlus.core.lib.LoadedMods;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.FishingHooks;

public class TileEntityFishTrap
extends TileEntity
implements ISidedInventory {
    private int tickCount = 0;
    private boolean isInWater = false;
    private final InventoryFishTrap inventoryContents = new InventoryFishTrap();
    private String customName;
    private int locationX;
    private int locationY;
    private int locationZ;
    private int waterSides = 0;
    private int baseTickRate = 3000;
    static final String prefix = "food";
    static final String suffix = "raw";
    static final String seaweed = "cropSeaweed";
    static final String greenheartFish = "Greenheartfish";
    private static final String[] harvestcraftFish = new String[]{"Anchovy", "Bass", "Carp", "Catfish", "Charr", "Clam", "Crab", "Crayfish", "Eel", "Frog", "Grouper", "Herring", "Jellyfish", "Mudfish", "Octopus", "Perch", "Scallop", "Shrimp", "Snail", "Snapper", "Tilapia", "Trout", "Tuna", "Turtle", "Walleye"};

    public TileEntityFishTrap() {
        this.setTileLocation();
    }

    public boolean setTileLocation() {
        if (this.func_145830_o() && !this.func_145831_w().field_72995_K) {
            this.locationX = this.field_145851_c;
            this.locationY = this.field_145848_d;
            this.locationZ = this.field_145849_e;
            return true;
        }
        return false;
    }

    public final boolean isSurroundedByWater() {
        this.setTileLocation();
        Block[] surroundingBlocks = new Block[6];
        if (this.func_145830_o() && !this.func_145831_w().field_72995_K) {
            surroundingBlocks[0] = this.field_145850_b.func_147439_a(this.locationX, this.locationY + 1, this.locationZ);
            surroundingBlocks[1] = this.field_145850_b.func_147439_a(this.locationX, this.locationY - 1, this.locationZ);
            surroundingBlocks[2] = this.field_145850_b.func_147439_a(this.locationX + 1, this.locationY, this.locationZ);
            surroundingBlocks[3] = this.field_145850_b.func_147439_a(this.locationX - 1, this.locationY, this.locationZ);
            surroundingBlocks[4] = this.field_145850_b.func_147439_a(this.locationX, this.locationY, this.locationZ + 1);
            surroundingBlocks[5] = this.field_145850_b.func_147439_a(this.locationX, this.locationY, this.locationZ - 1);
            int waterCount = 0;
            int trapCount = 0;
            for (Block checkBlock : surroundingBlocks) {
                if (checkBlock != Blocks.field_150355_j && checkBlock != Blocks.field_150358_i && !checkBlock.func_149739_a().toLowerCase().contains("water") && checkBlock != ModBlocks.blockFishTrap) continue;
                if (checkBlock != ModBlocks.blockFishTrap) {
                    ++waterCount;
                    continue;
                }
                ++waterCount;
                ++trapCount;
            }
            if (waterCount >= 2 && trapCount <= 4) {
                int aCheck = trapCount + waterCount;
                this.waterSides = MathUtils.balance(aCheck, 0, 6);
                Logger.MACHINE_INFO("Valid Trap. " + waterCount + " | " + this.tickCount / 20 + "/" + this.baseTickRate / 20, new Object[0]);
                return true;
            }
            if (waterCount >= 2 && trapCount > 4) {
                Logger.MACHINE_INFO("Too many fish traps surrounding this one.", new Object[0]);
                Logger.MACHINE_INFO("Not adding Loot to the fishtrap at x[" + this.locationX + "] y[" + this.locationY + "] z[" + this.locationZ + "] (Ticking for loot every " + this.baseTickRate + " ticks)", new Object[0]);
            }
        }
        return false;
    }

    public InventoryFishTrap getInventory() {
        return this.inventoryContents;
    }

    public boolean tryAddLoot() {
        if (this.getInventory().getInventory() != null) {
            int checkingSlot = 0;
            ItemUtils.organiseInventory(this.getInventory());
            ItemStack loot = this.generateLootForFishTrap().func_77946_l();
            try {
                for (ItemStack contents : this.getInventory().getInventory()) {
                    if (GT_Utility.areStacksEqual((ItemStack)loot, (ItemStack)contents) && contents.field_77994_a < contents.func_77976_d()) {
                        ++contents.field_77994_a;
                        this.func_70296_d();
                        return true;
                    }
                    ++checkingSlot;
                }
                checkingSlot = 0;
                for (ItemStack contents : this.getInventory().getInventory()) {
                    if (contents == null) {
                        this.getInventory().func_70299_a(checkingSlot, loot);
                        this.func_70296_d();
                        return true;
                    }
                    ++checkingSlot;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.func_70296_d();
        return false;
    }

    private ItemStack generateLootForFishTrap() {
        ItemStack loot;
        int lootWeight = MathUtils.randInt(0, 100);
        if (lootWeight <= 5) {
            loot = ItemUtils.getSimpleStack(Items.field_151123_aH);
        } else if (lootWeight <= 10) {
            loot = ItemUtils.getSimpleStack(Items.field_151103_aS);
        } else if (lootWeight <= 15) {
            loot = ItemUtils.getSimpleStack((Block)Blocks.field_150354_m);
        } else if (lootWeight <= 20) {
            loot = ItemUtils.simpleMetaStack(Items.field_151100_aR, 0, 1);
        } else if (lootWeight <= 23) {
            loot = LoadedMods.PamsHarvestcraft ? ItemUtils.getItemStackOfAmountFromOreDictNoBroken(seaweed, 1) : ItemUtils.getSimpleStack(Blocks.field_150346_d);
        } else if (lootWeight <= 99) {
            Random xstr = new Random();
            loot = FishingHooks.getRandomFishable((Random)xstr, (float)100.0f);
        } else if (lootWeight == 100) {
            int rareLoot = MathUtils.randInt(1, 10);
            if (rareLoot <= 4) {
                loot = ItemUtils.getItemStackOfAmountFromOreDictNoBroken("nuggetIron", 1);
                if (loot == null) {
                    loot = ItemUtils.getItemStackOfAmountFromOreDictNoBroken("ingotIron", 1);
                }
            } else if (rareLoot <= 7) {
                loot = ItemUtils.getItemStackOfAmountFromOreDictNoBroken("nuggetGold", 1);
                if (loot == null) {
                    loot = ItemUtils.getItemStackOfAmountFromOreDictNoBroken("ingotGold", 1);
                }
            } else {
                loot = rareLoot <= 9 ? ItemUtils.getSimpleStack(Items.field_151166_bC) : ItemUtils.getSimpleStack(Items.field_151045_i);
            }
        } else {
            loot = ItemUtils.getSimpleStack(Blocks.field_150482_ag);
        }
        loot.field_77994_a = 1;
        Logger.MACHINE_INFO("Adding x" + loot.field_77994_a + " " + loot.func_82833_r() + ".", new Object[0]);
        return loot;
    }

    public void func_145845_h() {
        try {
            if (!this.field_145850_b.field_72995_K) {
                ++this.tickCount;
                if (this.tickCount % 20 == 0) {
                    this.isInWater = this.isSurroundedByWater();
                }
                if (this.isInWater) {
                    this.calculateTickrate();
                }
                if (this.tickCount >= this.baseTickRate) {
                    if (this.isInWater) {
                        Logger.MACHINE_INFO("Adding Loot to the fishtrap at x[" + this.locationX + "] y[" + this.locationY + "] z[" + this.locationZ + "] (Ticking for loot every " + this.baseTickRate + " ticks)", new Object[0]);
                        int aExtraLootChance = MathUtils.randInt(1, 1000);
                        if (aExtraLootChance >= 999) {
                            this.tryAddLoot();
                            this.tryAddLoot();
                            this.tryAddLoot();
                        } else {
                            this.tryAddLoot();
                        }
                        this.func_70296_d();
                    } else {
                        Logger.MACHINE_INFO("Not in water.", new Object[0]);
                        this.func_70296_d();
                    }
                    this.tickCount = 0;
                }
                if (this.tickCount >= this.baseTickRate + 500) {
                    Logger.MACHINE_INFO("Resetting tick counter", new Object[0]);
                    this.tickCount = 0;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void calculateTickrate() {
        int water = this.waterSides;
        this.baseTickRate = water <= 1 ? 0 : (water == 2 ? 6800 : (water == 3 ? 5600 : (water == 4 ? 4400 : (water == 5 ? 3200 : 1750))));
        if (water > 1) {
            // empty if block
        }
    }

    public boolean anyPlayerInRange() {
        return this.field_145850_b.func_72977_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 32.0) != null;
    }

    public NBTTagCompound getTag(NBTTagCompound nbt, String tag) {
        if (!nbt.func_74764_b(tag)) {
            nbt.func_74782_a(tag, (NBTBase)new NBTTagCompound());
        }
        return nbt.func_74775_l(tag);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagCompound chestData = new NBTTagCompound();
        this.inventoryContents.writeToNBT(chestData);
        nbt.func_74782_a("ContentsChest", (NBTBase)chestData);
        if (this.func_145818_k_()) {
            nbt.func_74778_a("CustomName", this.getCustomName());
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inventoryContents.readFromNBT(nbt.func_74775_l("ContentsChest"));
        if (nbt.func_150297_b("CustomName", 8)) {
            this.setCustomName(nbt.func_74779_i("CustomName"));
        }
    }

    public static void pamsHarvestCraftCompat() {
        for (int i = 0; i < harvestcraftFish.length; ++i) {
        }
    }

    public int func_70302_i_() {
        return this.getInventory().func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.getInventory().func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int count) {
        return this.getInventory().func_70298_a(slot, count);
    }

    public ItemStack func_70304_b(int slot) {
        return this.getInventory().func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.getInventory().func_70299_a(slot, stack);
    }

    public int func_70297_j_() {
        return this.getInventory().func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.getInventory().func_70300_a(entityplayer);
    }

    public void func_70295_k_() {
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, 1);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.func_145838_q());
        this.getInventory().func_70295_k_();
    }

    public void func_70305_f() {
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, 1);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.func_145838_q());
        this.getInventory().func_70305_f();
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return this.getInventory().func_94041_b(slot, itemstack);
    }

    public int[] func_94128_d(int p_94128_1_) {
        int[] accessibleSides = new int[this.func_70302_i_()];
        for (int r = 0; r < this.getInventory().func_70302_i_(); ++r) {
            accessibleSides[r] = r;
        }
        return accessibleSides;
    }

    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return false;
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return true;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.fishtrap";
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.equals("");
    }
}

