/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.tool.staballoy;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.item.tool.staballoy.StaballoySpade;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.RecipeUtils;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class MultiSpadeBase
extends StaballoySpade {
    protected final int colour;
    protected final String materialName;
    protected final String displayName;
    public boolean isValid = true;

    @Override
    public double getDurabilityForDisplay(ItemStack stack) {
        if (super.getDurabilityForDisplay(stack) > 0.0) {
            return super.getDurabilityForDisplay(stack);
        }
        return 0.0;
    }

    public MultiSpadeBase(String unlocalizedName, Item.ToolMaterial material, int materialDurability, int colour) {
        super(Utils.sanitizeString(unlocalizedName), material);
        this.func_77655_b(Utils.sanitizeString(unlocalizedName));
        this.func_111206_d("minecraft:iron_shovel");
        this.func_77625_d(1);
        this.func_77656_e(materialDurability * 3);
        this.colour = colour;
        this.materialName = material.name();
        this.displayName = unlocalizedName;
        this.func_77637_a(AddToCreativeTab.tabTools);
        try {
            this.isValid = this.addRecipe();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (colour != 0 && this.isValid && GameRegistry.findItem((String)"miscutils", (String)Utils.sanitizeString(unlocalizedName)) == null) {
            GameRegistry.registerItem((Item)this, (String)Utils.sanitizeString(unlocalizedName));
        }
    }

    private boolean addRecipe() {
        String cleanName = Utils.sanitizeString(this.materialName);
        String plateDense = "plateDense" + cleanName;
        String plateDouble = "plateDouble" + cleanName;
        String rodLong = "stickLong" + cleanName;
        String toolHammer = "craftingToolHardHammer";
        String toolWrench = "craftingToolWrench";
        String toolFile = "craftingToolFile";
        String toolScrewDriver = "craftingToolScrewdriver";
        if (null == ItemUtils.getItemStackOfAmountFromOreDictNoBroken(rodLong, 1)) {
            return false;
        }
        if (null == ItemUtils.getItemStackOfAmountFromOreDictNoBroken(plateDense, 1)) {
            if (null != ItemUtils.getItemStackOfAmountFromOreDictNoBroken(plateDouble, 1)) {
                RecipeUtils.recipeBuilder("craftingToolFile", plateDouble, "craftingToolHardHammer", null, rodLong, null, "craftingToolWrench", rodLong, "craftingToolScrewdriver", ItemUtils.getSimpleStack((Item)this));
                return true;
            }
            return false;
        }
        RecipeUtils.recipeBuilder("craftingToolFile", plateDense, "craftingToolHardHammer", null, rodLong, null, "craftingToolWrench", rodLong, "craftingToolScrewdriver", ItemUtils.getSimpleStack((Item)this));
        return true;
    }

    public final String getMaterialName() {
        return this.materialName;
    }

    public String func_77653_i(ItemStack iStack) {
        return this.displayName;
    }

    public int func_82790_a(ItemStack stack, int HEX_OxFFFFFF) {
        if (this.colour == 0) {
            return MathUtils.generateSingularRandomHexValue();
        }
        return this.colour;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.uncommon;
    }

    @Override
    public boolean func_77636_d(ItemStack par1ItemStack) {
        return false;
    }
}

