/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.tool.staballoy;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.Pair;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.item.tool.staballoy.StaballoyPickaxe;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.RecipeUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class MultiPickaxeBase
extends StaballoyPickaxe {
    protected boolean canBreak = true;
    protected final int colour;
    protected final String materialName;
    protected final String displayName;
    public boolean isValid = true;
    private final Pair<?, ?> enchantment;

    @Override
    public double getDurabilityForDisplay(ItemStack stack) {
        if (super.getDurabilityForDisplay(stack) > 0.0) {
            return super.getDurabilityForDisplay(stack);
        }
        return 0.0;
    }

    public MultiPickaxeBase(String unlocalizedName, Item.ToolMaterial material, long materialDurability, int colour, Object enchant) {
        super(Utils.sanitizeString(unlocalizedName), material);
        this.func_77655_b(Utils.sanitizeString(unlocalizedName));
        this.func_111206_d("minecraft:iron_pickaxe");
        this.func_77625_d(1);
        if (materialDurability * 3L <= Integer.MAX_VALUE) {
            this.func_77656_e((int)(materialDurability * 3L));
        } else {
            this.func_77656_e(Integer.MAX_VALUE);
            this.canBreak = false;
        }
        this.colour = colour;
        this.materialName = material.name();
        this.displayName = unlocalizedName;
        this.func_77637_a(AddToCreativeTab.tabTools);
        this.miningLevel = material.func_77996_d();
        this.enchantment = enchant != null ? (enchant instanceof Pair ? (Pair)enchant : null) : null;
        try {
            this.isValid = this.addRecipe();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (colour != 0 && this.isValid && materialDurability > 10000L && GameRegistry.findItem((String)"miscutils", (String)Utils.sanitizeString(unlocalizedName)) == null) {
            GameRegistry.registerItem((Item)this, (String)Utils.sanitizeString(unlocalizedName));
        }
    }

    private boolean addRecipe() {
        String cleanName = Utils.sanitizeString(this.materialName);
        String plateDense = "plateDense" + cleanName;
        String plateDouble = "plateDouble" + cleanName;
        String rodLong = "stickLong" + cleanName;
        String toolHammer = "craftingToolHardHammer";
        String toolWrench = "craftingToolWrench";
        String toolFile = "craftingToolFile";
        String toolScrewDriver = "craftingToolScrewdriver";
        if (null == ItemUtils.getItemStackOfAmountFromOreDictNoBroken(rodLong, 1)) {
            Logger.WARNING("stickLong of " + cleanName + " does not exist.");
            return false;
        }
        if (null == ItemUtils.getItemStackOfAmountFromOreDictNoBroken(plateDense, 1)) {
            Logger.WARNING("plateDense of " + cleanName + " does not exist.");
            if (null != ItemUtils.getItemStackOfAmountFromOreDictNoBroken(plateDouble, 1)) {
                Logger.WARNING("plateDouble of " + cleanName + " does exist. Using it instead.");
                RecipeUtils.recipeBuilder(plateDouble, plateDouble, plateDouble, "craftingToolFile", rodLong, "craftingToolHardHammer", "craftingToolWrench", rodLong, "craftingToolScrewdriver", ItemUtils.getSimpleStack((Item)this));
                return true;
            }
            Logger.WARNING("plateDouble of " + cleanName + " does not exist.");
            return false;
        }
        RecipeUtils.recipeBuilder(plateDense, plateDense, plateDense, "craftingToolFile", rodLong, "craftingToolHardHammer", "craftingToolWrench", rodLong, "craftingToolScrewdriver", ItemUtils.getSimpleStack((Item)this));
        return true;
    }

    public final String getMaterialName() {
        return this.materialName;
    }

    public String func_77653_i(ItemStack iStack) {
        return this.displayName;
    }

    public int func_82790_a(ItemStack stack, int HEX_OxFFFFFF) {
        if (this.colour == 0) {
            return MathUtils.generateSingularRandomHexValue();
        }
        return this.colour;
    }

    private float calculateDurabilityLoss(World world, int X, int Y, int Z) {
        float bDurabilityLoss = 0.0f;
        Boolean correctTool = false;
        float bHardness = 0.0f;
        if (!world.field_72995_K) {
            try {
                Block removalist = world.func_147439_a(X, Y, Z);
                bHardness = removalist.func_149712_f(world, X, Y, Z) * 100.0f;
                Logger.INFO("Hardness: " + bHardness);
                bDurabilityLoss = 100.0f;
                correctTool = this.canPickaxeBlock(removalist, world, new int[]{X, Y, Z});
                Logger.WARNING("" + correctTool);
                if (!correctTool.booleanValue()) {
                    return 0.0f;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return bDurabilityLoss;
    }

    @Override
    public void damageItem(ItemStack item, int damage, EntityPlayer localPlayer) {
        if (this.canBreak) {
            item.func_77972_a(damage, (EntityLivingBase)localPlayer);
        }
    }

    @Override
    public void setItemDamage(ItemStack item, int damage) {
        if (this.canBreak) {
            item.func_77964_b(damage - 1);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.uncommon;
    }

    @Override
    public boolean func_77636_d(ItemStack par1ItemStack) {
        return false;
    }

    public void func_77622_d(ItemStack mThisItem, World mWorld, EntityPlayer mPlayer) {
        Enchantment enchant = null;
        int enchantmentLevel = 0;
        Pair<?, ?> Y = this.enchantment;
        if (Y != null) {
            if (Y.getKey() != null) {
                enchant = (Enchantment)this.enchantment.getKey();
            }
            if (Y.getValue() != null) {
                enchantmentLevel = (Integer)this.enchantment.getValue();
            }
        }
        ItemStack itemToEnchant = mThisItem;
        if (enchant != null && enchantmentLevel != 0 && enchantmentLevel >= 1) {
            itemToEnchant.func_77966_a(enchant, enchantmentLevel);
        }
        super.func_77622_d(itemToEnchant, mWorld, mPlayer);
    }

    public void func_150895_a(Item mItem, CreativeTabs mCreativeTab, List mList) {
        Enchantment enchant = null;
        int enchantmentLevel = 0;
        Pair<?, ?> Y = this.enchantment;
        if (Y != null) {
            if (Y.getKey() != null) {
                enchant = (Enchantment)this.enchantment.getKey();
            }
            if (Y.getValue() != null) {
                enchantmentLevel = (Integer)this.enchantment.getValue();
            }
        }
        Item thisItem = mItem;
        ItemStack itemToEnchant = ItemUtils.getSimpleStack(thisItem);
        if (enchant != null && enchantmentLevel != 0 && enchantmentLevel >= 1) {
            itemToEnchant.func_77966_a(enchant, enchantmentLevel);
            mList.add(itemToEnchant);
        } else {
            mList.add(new ItemStack(thisItem, 1, 0));
        }
    }

    public boolean func_77645_m() {
        return this.func_77612_l() > 0 && !this.field_77787_bX && this.canBreak;
    }
}

