/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.general;

import cofh.api.energy.ItemEnergyContainer;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class RF2EU_Battery
extends ItemEnergyContainer
implements IElectricItem,
IElectricItemManager,
IFuelHandler {
    public static double rfPerEU = 3.4;
    private final String unlocalizedName = "rfEUBattery";
    private final ItemStack thisStack;
    private static final int maxValueEU = 100000000;
    private static final int maxValueRF = (int)(1.0E8 * rfPerEU);
    protected double chargeEU = 0.0;

    public RF2EU_Battery() {
        super(maxValueRF);
        GameRegistry.registerFuelHandler((IFuelHandler)this);
        this.func_77637_a(AddToCreativeTab.tabMachines);
        this.func_77655_b(this.unlocalizedName);
        this.func_77625_d(1);
        this.func_111206_d("miscutils:itemIngot");
        this.thisStack = ItemUtils.getSimpleStack((Item)this);
        GameRegistry.registerItem((Item)this, (String)this.unlocalizedName);
    }

    public void func_77663_a(ItemStack itemStack, World worldObj, Entity player, int p_77663_4_, boolean p_77663_5_) {
        this.getEnergyStored(itemStack);
        if (worldObj.field_72995_K) {
            return;
        }
        if (player instanceof EntityPlayer) {
            for (ItemStack is : ((EntityPlayer)player).field_71071_by.field_70462_a) {
                if (is == itemStack || is == null || !(is.func_77973_b() instanceof IElectricItem)) continue;
                IElectricItem electricItem = (IElectricItem)is.func_77973_b();
                this.chargeEU = ElectricItem.manager.getCharge(is);
            }
        }
        super.func_77663_a(itemStack, worldObj, player, p_77663_4_, p_77663_5_);
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    public Item getChargedItem(ItemStack itemStack) {
        ItemStack x = itemStack.func_77946_l();
        x.func_77964_b(100000000);
        return x.func_77973_b();
    }

    public Item getEmptyItem(ItemStack itemStack) {
        ItemStack x = itemStack.func_77946_l();
        x.func_77964_b(0);
        return x.func_77973_b();
    }

    public double getMaxCharge(ItemStack itemStack) {
        return 1.0E8;
    }

    public int getTier(ItemStack itemStack) {
        return 3;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return 8196.0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return MathUtils.findPercentage(this.getEnergyStored(stack), this.getMaxEnergyStored(stack));
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack par1ItemStack, int par2) {
        int i = 30;
        float f13 = (float)(Minecraft.func_71386_F() % 6000L) / 3000.0f * (float)Math.PI * 2.0f;
        float t = 0.9f + 0.1f * MathHelper.func_76134_b((float)f13);
        double v = 1.0 - this.getDurabilityForDisplay(par1ItemStack);
        int r = 30 + (int)(v * 225.0 * (double)t);
        if (r > 255) {
            r = 255;
        }
        int g = 30 + (int)(v * 34.0 * (double)t);
        return r << 16 | g << 8 | 0x1E;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer aPlayer, List list, boolean bool) {
        list.add(StatCollector.func_74838_a((String)"item.rfEUBattery.tooltip.0"));
        list.add(StatCollector.func_74837_a((String)"item.rfEUBattery.tooltip.1", (Object[])new Object[]{this.getTier(this.thisStack), (long)this.getCharge(stack)}));
        list.add(StatCollector.func_74837_a((String)"item.rfEUBattery.tooltip.2", (Object[])new Object[]{this.getTransferLimit(this.thisStack), this.getBurnTime(stack) / 20}));
        list.add("");
        list.add(StatCollector.func_74838_a((String)"item.rfEUBattery.tooltip.3"));
        list.add(StatCollector.func_74837_a((String)"item.rfEUBattery.tooltip.4", (Object[])new Object[]{this.maxExtract, this.maxReceive}));
        list.add(StatCollector.func_74837_a((String)"item.rfEUBattery.tooltip.5", (Object[])new Object[]{this.getEnergyStored(stack), this.getMaxEnergyStored(stack), Float.valueOf(MathUtils.findPercentage(this.getEnergyStored(stack), this.getMaxEnergyStored(stack)))}));
        super.func_77624_a(stack, aPlayer, list, bool);
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        ItemStack newItem = itemStack.func_77946_l();
        newItem.field_77994_a = 1;
        this.extractEnergy(newItem, 150000, false);
        return newItem;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public int getBurnTime(ItemStack fuel) {
        if (fuel == null || fuel.func_77973_b() != this) {
            return 0;
        }
        return this.extractEnergy(fuel, 150000, true) / 50 / 100;
    }

    public double charge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        int energy = stack.field_77990_d.func_74762_e("Energy");
        int energyReceived = Math.min(this.capacity - energy, Math.min(this.maxReceive, this.maxReceive));
        if (!simulate) {
            stack.field_77990_d.func_74768_a("Energy", energy += energyReceived);
            ElectricItem.manager.discharge(stack, ElectricItem.manager.getCharge(stack), 3, true, true, false);
            ElectricItem.manager.charge(stack, (double)energy / rfPerEU, 3, true, false);
        }
        return ElectricItem.manager.charge(stack, amount, tier, ignoreTransferLimit, simulate);
    }

    public double discharge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        if (stack.field_77990_d == null || !stack.field_77990_d.func_74764_b("Energy")) {
            double euCharge = this.getCharge(ItemUtils.getSimpleStack((Item)this));
            if (euCharge != 0.0 && euCharge >= 1.0) {
                return (int)MathUtils.decimalRoundingToWholes(euCharge * rfPerEU);
            }
            return 0.0;
        }
        int energy = stack.field_77990_d.func_74762_e("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.maxExtract, this.maxExtract));
        if (!simulate) {
            stack.field_77990_d.func_74768_a("Energy", energy -= energyExtracted);
            ElectricItem.manager.discharge(stack, ElectricItem.manager.getCharge(stack), 3, true, true, false);
            ElectricItem.manager.charge(stack, (double)energy / rfPerEU, 3, true, false);
        }
        return ElectricItem.manager.discharge(stack, amount, tier, ignoreTransferLimit, externally, simulate);
    }

    public double getCharge(ItemStack stack) {
        return ElectricItem.manager.getCharge(stack);
    }

    public boolean canUse(ItemStack stack, double amount) {
        return ElectricItem.manager.canUse(stack, amount);
    }

    public boolean use(ItemStack stack, double amount, EntityLivingBase entity) {
        return ElectricItem.manager.use(stack, amount, entity);
    }

    public void chargeFromArmor(ItemStack stack, EntityLivingBase entity) {
        ElectricItem.manager.chargeFromArmor(stack, entity);
    }

    public String getToolTip(ItemStack stack) {
        return ElectricItem.manager.getToolTip(stack);
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            double euCharge = this.getCharge(ItemUtils.getSimpleStack((Item)this));
            if (euCharge != 0.0 && euCharge >= 1.0) {
                return (int)MathUtils.decimalRoundingToWholes(euCharge * rfPerEU);
            }
            return 0;
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyReceived = Math.min(this.capacity - energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy += energyReceived);
            ElectricItem.manager.discharge(container, ElectricItem.manager.getCharge(container), 3, true, true, false);
            ElectricItem.manager.charge(container, (double)energy / rfPerEU, 3, true, false);
        }
        return energyReceived;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            double euCharge = this.getCharge(ItemUtils.getSimpleStack((Item)this));
            if (euCharge != 0.0 && euCharge >= 1.0) {
                return (int)MathUtils.decimalRoundingToWholes(euCharge * rfPerEU);
            }
            return 0;
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy -= energyExtracted);
            ElectricItem.manager.discharge(container, ElectricItem.manager.getCharge(container), 3, true, true, false);
            ElectricItem.manager.charge(container, (double)energy / rfPerEU, 3, true, false);
        }
        return energyExtracted;
    }

    public int getEnergyStored(ItemStack container) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            double euCharge = this.getCharge(ItemUtils.getSimpleStack((Item)this));
            if (euCharge != 0.0 && euCharge >= 1.0) {
                return (int)MathUtils.decimalRoundingToWholes(euCharge * rfPerEU);
            }
            return 0;
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        ElectricItem.manager.discharge(container, ElectricItem.manager.getCharge(container), 3, true, true, false);
        ElectricItem.manager.charge(container, (double)energy / rfPerEU, 3, true, false);
        return energy;
    }
}

