/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.bauble;

import baubles.api.BaubleType;
import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gtPlusPlus.core.item.bauble.BaseBauble;
import gtPlusPlus.core.lib.LoadedMods;
import gtPlusPlus.core.util.minecraft.ModularArmourUtils;
import gtPlusPlus.core.util.minecraft.NBTUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import org.lwjgl.input.Keyboard;

public class ModularBauble
extends BaseBauble {
    @SideOnly(value=Side.CLIENT)
    private IIcon mTextureAmulet;
    @SideOnly(value=Side.CLIENT)
    private IIcon mTextureRing;
    @SideOnly(value=Side.CLIENT)
    private IIcon mTextureBelt;
    private IIcon[] iconArray = new IIcon[3];
    @SideOnly(value=Side.CLIENT)
    private IIcon mfallback;

    public ModularBauble() {
        super(BaubleType.AMULET, "Modular Bauble");
    }

    @Override
    void fillModifiers(Multimap<String, AttributeModifier> attributes, ItemStack stack) {
        int mStatlevel = 0;
        mStatlevel = ModularArmourUtils.getModifierLevel(stack, ModularArmourUtils.Modifiers.BOOST_DAMAGE);
        if (mStatlevel > 0) {
            if (mStatlevel > 0 && mStatlevel < 20) {
                attributes.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(ModularBauble.getBaubleUUID(stack), "AD" + mStatlevel, 1.0, 0));
            } else if (mStatlevel > 20 && mStatlevel < 45) {
                attributes.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(ModularBauble.getBaubleUUID(stack), "AD" + mStatlevel, 2.0, 0));
            } else if (mStatlevel >= 45 && mStatlevel < 75) {
                attributes.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(ModularBauble.getBaubleUUID(stack), "AD" + mStatlevel, 4.0, 0));
            } else if (mStatlevel >= 75 && mStatlevel < 99) {
                attributes.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(ModularBauble.getBaubleUUID(stack), "AD" + mStatlevel, 8.0, 0));
            } else if (mStatlevel >= 100) {
                attributes.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(ModularBauble.getBaubleUUID(stack), "AD" + mStatlevel, 16.0, 0));
            }
        }
        if ((mStatlevel = ModularArmourUtils.getModifierLevel(stack, ModularArmourUtils.Modifiers.BOOST_DEF)) > 0) {
            if (mStatlevel > 0 && mStatlevel < 20) {
                attributes.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(ModularBauble.getBaubleUUID(stack), "BD" + mStatlevel, 1.0, 0));
            } else if (mStatlevel > 20 && mStatlevel < 45) {
                attributes.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(ModularBauble.getBaubleUUID(stack), "BD" + mStatlevel, 2.0, 0));
            } else if (mStatlevel > 45 && mStatlevel < 75) {
                attributes.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(ModularBauble.getBaubleUUID(stack), "BD" + mStatlevel, 3.0, 0));
            } else if (mStatlevel > 75 && mStatlevel < 99) {
                attributes.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(ModularBauble.getBaubleUUID(stack), "BD" + mStatlevel, 6.0, 0));
            } else if (mStatlevel >= 100) {
                attributes.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(ModularBauble.getBaubleUUID(stack), "BD" + mStatlevel, 10.0, 0));
            }
        }
        if ((mStatlevel = ModularArmourUtils.getModifierLevel(stack, ModularArmourUtils.Modifiers.BOOST_HP)) > 0 && mStatlevel > 0 && mStatlevel <= 100) {
            int bonus = mStatlevel / 5;
            attributes.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(ModularBauble.getBaubleUUID(stack), "HP" + mStatlevel, (double)(bonus * 2), 0));
        }
        if ((mStatlevel = ModularArmourUtils.getModifierLevel(stack, ModularArmourUtils.Modifiers.BOOST_SPEED)) > 0) {
            if (mStatlevel > 0 && mStatlevel < 20) {
                attributes.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(ModularBauble.getBaubleUUID(stack), "SP" + mStatlevel, 1.0, 0));
            } else if (mStatlevel > 20 && mStatlevel < 45) {
                attributes.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(ModularBauble.getBaubleUUID(stack), "SP" + mStatlevel, 2.0, 0));
            } else if (mStatlevel > 45 && mStatlevel < 75) {
                attributes.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(ModularBauble.getBaubleUUID(stack), "SP" + mStatlevel, 3.0, 0));
            } else if (mStatlevel > 75 && mStatlevel < 99) {
                attributes.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(ModularBauble.getBaubleUUID(stack), "SP" + mStatlevel, 4.0, 0));
            } else if (mStatlevel >= 100) {
                attributes.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(ModularBauble.getBaubleUUID(stack), "SP" + mStatlevel, 5.0, 0));
            }
        }
        if ((mStatlevel = ModularArmourUtils.getModifierLevel(stack, ModularArmourUtils.Modifiers.BOOST_MINING)) > 0) {
            // empty if block
        }
        if ((mStatlevel = ModularArmourUtils.getModifierLevel(stack, ModularArmourUtils.Modifiers.BOOST_HOLY)) > 0) {
            // empty if block
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        if (ModularArmourUtils.getBaubleType(stack) == BaubleType.AMULET) {
            list.add(EnumChatFormatting.GRAY + "Current Form: " + EnumChatFormatting.RED + "Amulet" + EnumChatFormatting.GRAY + ".");
            list.add(EnumChatFormatting.GRAY + "You can change this into a Ring or a Belt.");
        } else if (ModularArmourUtils.getBaubleType(stack) == BaubleType.RING) {
            list.add(EnumChatFormatting.GRAY + "Current Form: " + EnumChatFormatting.RED + "Ring" + EnumChatFormatting.GRAY + ".");
            list.add(EnumChatFormatting.GRAY + "You can change this into an Amulet or a Belt.");
        } else if (ModularArmourUtils.getBaubleType(stack) == BaubleType.BELT) {
            list.add(EnumChatFormatting.GRAY + "Current Form: " + EnumChatFormatting.RED + "Belt" + EnumChatFormatting.GRAY + ".");
            list.add(EnumChatFormatting.GRAY + "You can change this into a Ring or an Amulet.");
        }
        int mStatlevel = 0;
        mStatlevel = ModularArmourUtils.getModifierLevel(stack, ModularArmourUtils.Modifiers.BOOST_DAMAGE);
        if (mStatlevel > 0) {
            list.add(EnumChatFormatting.GRAY + "Damage Boost: " + EnumChatFormatting.DARK_RED + mStatlevel + EnumChatFormatting.GRAY + "/100.");
        }
        if ((mStatlevel = ModularArmourUtils.getModifierLevel(stack, ModularArmourUtils.Modifiers.BOOST_HP)) > 0) {
            list.add(EnumChatFormatting.GRAY + "Health Boost: " + EnumChatFormatting.RED + mStatlevel + EnumChatFormatting.GRAY + "/100. Bonus " + mStatlevel / 5 + " hearts.");
        }
        if ((mStatlevel = ModularArmourUtils.getModifierLevel(stack, ModularArmourUtils.Modifiers.BOOST_SPEED)) > 0) {
            list.add(EnumChatFormatting.GRAY + "Speed Boost: " + EnumChatFormatting.WHITE + mStatlevel + EnumChatFormatting.GRAY + "/100.");
        }
        if ((mStatlevel = ModularArmourUtils.getModifierLevel(stack, ModularArmourUtils.Modifiers.BOOST_MINING)) > 0) {
            list.add(EnumChatFormatting.GRAY + "Mining Boost: " + EnumChatFormatting.DARK_GRAY + mStatlevel + EnumChatFormatting.GRAY + "/100.");
        }
        if ((mStatlevel = ModularArmourUtils.getModifierLevel(stack, ModularArmourUtils.Modifiers.BOOST_HOLY)) > 0) {
            list.add(EnumChatFormatting.GRAY + "Holy Boost: " + EnumChatFormatting.GOLD + mStatlevel + EnumChatFormatting.GRAY + "/100.");
        }
        if ((mStatlevel = ModularArmourUtils.getModifierLevel(stack, ModularArmourUtils.Modifiers.BOOST_DEF)) > 0) {
            list.add(EnumChatFormatting.GRAY + "Defence Boost: " + EnumChatFormatting.BLUE + mStatlevel + EnumChatFormatting.GRAY + "/100.");
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                if (mStatlevel >= 1) {
                    list.add(EnumChatFormatting.GRAY + "Protected From: " + EnumChatFormatting.BLUE + "Cactus" + EnumChatFormatting.GRAY + ".");
                }
                if (mStatlevel >= 10) {
                    list.add(EnumChatFormatting.GRAY + "Protected From: " + EnumChatFormatting.BLUE + "Falling Blocks" + EnumChatFormatting.GRAY + ".");
                }
                if (mStatlevel >= 20) {
                    list.add(EnumChatFormatting.GRAY + "Protected From: " + EnumChatFormatting.BLUE + "Wall Suffocation" + EnumChatFormatting.GRAY + ".");
                }
                if (mStatlevel >= 35) {
                    list.add(EnumChatFormatting.GRAY + "Protected From: " + EnumChatFormatting.BLUE + "Drowning" + EnumChatFormatting.GRAY + ".");
                }
                if (mStatlevel >= 50) {
                    list.add(EnumChatFormatting.GRAY + "Protected From: " + EnumChatFormatting.BLUE + "Starvation" + EnumChatFormatting.GRAY + ".");
                }
                if (mStatlevel >= 60) {
                    list.add(EnumChatFormatting.GRAY + "Protected From: " + EnumChatFormatting.BLUE + "Falling" + EnumChatFormatting.GRAY + ".");
                }
                if (mStatlevel >= 75) {
                    list.add(EnumChatFormatting.GRAY + "Protected From: " + EnumChatFormatting.BLUE + "Lava" + EnumChatFormatting.GRAY + ".");
                }
                if (mStatlevel >= 80) {
                    list.add(EnumChatFormatting.GRAY + "Protected From: " + EnumChatFormatting.BLUE + "Magic" + EnumChatFormatting.GRAY + ".");
                }
                if (mStatlevel >= 95) {
                    list.add(EnumChatFormatting.GRAY + "Protected From: " + EnumChatFormatting.BLUE + "Wither" + EnumChatFormatting.GRAY + ".");
                }
                if (mStatlevel >= 100) {
                    list.add(EnumChatFormatting.GRAY + "Protected From: " + EnumChatFormatting.BLUE + "Fire" + EnumChatFormatting.GRAY + ".");
                }
                if (mStatlevel >= 100) {
                    list.add(EnumChatFormatting.GRAY + "Protected From: " + EnumChatFormatting.BLUE + "Void" + EnumChatFormatting.GRAY + ".");
                }
            } else {
                list.add(EnumChatFormatting.GRAY + "<Press Shift to view protections>");
            }
        }
        if (NBTUtils.getBotanicaSoulboundOwner(stack) != null && !NBTUtils.getBotanicaSoulboundOwner(stack).equals("")) {
            list.add(EnumChatFormatting.GRAY + "Owner: " + EnumChatFormatting.GREEN + NBTUtils.getBotanicaSoulboundOwner(stack) + EnumChatFormatting.GRAY + ".");
        }
        super.func_77624_a(stack, player, list, bool);
    }

    @Override
    public boolean addDamageNegation(DamageSource damageSource, ItemStack aStack) {
        this.clearDamageNegation();
        int mStatlevel = 0;
        mStatlevel = ModularArmourUtils.getModifierLevel(aStack, ModularArmourUtils.Modifiers.BOOST_HOLY);
        if (mStatlevel > 0) {
            if (mStatlevel >= 1) {
                this.addDamageNegation(DamageSource.field_76367_g);
            }
            if (mStatlevel >= 10) {
                this.addDamageNegation(DamageSource.field_82729_p);
            }
            if (mStatlevel >= 20) {
                this.addDamageNegation(DamageSource.field_76368_d);
            }
            if (mStatlevel >= 35) {
                this.addDamageNegation(DamageSource.field_76369_e);
            }
            if (mStatlevel >= 50) {
                this.addDamageNegation(DamageSource.field_76366_f);
            }
            if (mStatlevel >= 60) {
                this.addDamageNegation(DamageSource.field_76379_h);
            }
            if (mStatlevel >= 75) {
                this.addDamageNegation(DamageSource.field_76371_c);
            }
            if (mStatlevel >= 80) {
                this.addDamageNegation(DamageSource.field_76376_m);
            }
            if (mStatlevel >= 95) {
                this.addDamageNegation(DamageSource.field_82727_n);
            }
            if (mStatlevel >= 100) {
                this.addDamageNegation(DamageSource.field_76372_a);
            }
            if (mStatlevel >= 100) {
                this.addDamageNegation(DamageSource.field_76370_b);
            }
            if (mStatlevel >= 100) {
                this.addDamageNegation(DamageSource.field_76380_i);
            }
        }
        return super.addDamageNegation(damageSource, null);
    }

    @Override
    public boolean canEquip(ItemStack arg0, EntityLivingBase arg1) {
        if (ModularArmourUtils.getBaubleTypeID(arg0) == ModularArmourUtils.BT.TYPE_AMULET.getID()) {
            this.SetBaubleType(ModularArmourUtils.BT.TYPE_AMULET);
        } else if (ModularArmourUtils.getBaubleTypeID(arg0) == ModularArmourUtils.BT.TYPE_RING.getID()) {
            this.SetBaubleType(ModularArmourUtils.BT.TYPE_RING);
        } else if (ModularArmourUtils.getBaubleTypeID(arg0) == ModularArmourUtils.BT.TYPE_BELT.getID()) {
            this.SetBaubleType(ModularArmourUtils.BT.TYPE_BELT);
        } else {
            this.SetBaubleType(ModularArmourUtils.BT.TYPE_RING);
        }
        if (PlayerUtils.isPlayerOP((EntityPlayer)arg1)) {
            return true;
        }
        if (NBTUtils.getBotanicaSoulboundOwner(arg0) == null || NBTUtils.getBotanicaSoulboundOwner(arg0).equals("")) {
            return true;
        }
        String mOwner = NBTUtils.getBotanicaSoulboundOwner(arg0);
        if (mOwner != null) {
            String mPlayerName = arg1.func_70005_c_();
            return mOwner.toLowerCase().equals(mPlayerName.toLowerCase());
        }
        return false;
    }

    @Override
    public BaubleType getBaubleType(ItemStack arg0) {
        return ModularArmourUtils.getBaubleType(arg0);
    }

    @Override
    public void onEquipped(ItemStack stack, EntityLivingBase entity) {
        if (entity instanceof EntityPlayer && (NBTUtils.getBotanicaSoulboundOwner(stack) == null || NBTUtils.getBotanicaSoulboundOwner(stack).equals(""))) {
            NBTUtils.setBotanicaSoulboundOwner(stack, entity.func_70005_c_());
        }
        super.onEquipped(stack, entity);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        if (meta < this.iconArray.length && this.iconArray[meta] != null) {
            return this.iconArray[meta];
        }
        return this.mfallback;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < 3; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.mfallback = register.func_94245_a("miscutils:itemAmulet");
        if (LoadedMods.Thaumcraft) {
            this.iconArray[0] = register.func_94245_a("thaumcraft:bauble_amulet");
            this.iconArray[1] = register.func_94245_a("thaumcraft:bauble_ring");
            this.iconArray[2] = register.func_94245_a("thaumcraft:bauble_belt");
        } else {
            this.iconArray[0] = register.func_94245_a("miscutils:itemAmulet");
            this.iconArray[1] = register.func_94245_a("miscutils:itemRingWearable");
            this.iconArray[2] = register.func_94245_a("miscutils:itemBelt");
        }
        this.mTextureAmulet = this.iconArray[0];
        this.mTextureRing = this.iconArray[1];
        this.mTextureBelt = this.iconArray[2];
    }

    @Override
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        super.onWornTick(stack, player);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    public Item func_77664_n() {
        return super.func_77664_n();
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean isRepairable() {
        return false;
    }
}

