/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.base.cell;

import gtPlusPlus.core.item.base.BaseItemComponent;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import ic2.core.Ic2Items;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BaseItemCell
extends BaseItemComponent {
    BaseItemComponent.ComponentTypes Cell = BaseItemComponent.ComponentTypes.CELL;
    private final short[] fluidColour;
    boolean upwards = true;

    public BaseItemCell(Material material) {
        super(material, BaseItemComponent.ComponentTypes.CELL);
        this.fluidColour = material.getRGBA();
    }

    public BaseItemCell(String unlocalName, String localName, short[] RGBa) {
        super(unlocalName, localName, RGBa);
        this.fluidColour = RGBa;
        FluidStack aFluid = FluidUtils.getFluidStack(unlocalName.toLowerCase(), 1000);
        if (aFluid != null) {
            FluidContainerRegistry.registerFluidContainer((FluidStack)aFluid, (ItemStack)ItemUtils.getSimpleStack(this), (ItemStack)Ic2Items.cell.func_77946_l());
        }
    }

    public BaseItemCell(String unlocalName, String localName, short[] RGBa, Fluid cellFluid) {
        super(unlocalName, localName, RGBa);
        this.fluidColour = RGBa;
        FluidContainerRegistry.registerFluidContainer((FluidStack)FluidUtils.getFluidStack(cellFluid, 1000), (ItemStack)ItemUtils.getSimpleStack(this), (ItemStack)Ic2Items.cell.func_77946_l());
    }

    @Override
    public void func_94581_a(IIconRegister i) {
        if (CORE.ConfigSwitches.useGregtechTextures) {
            this.base = i.func_94245_a("gregtech:materialicons/METALLIC/cell");
            this.overlay = i.func_94245_a("gregtech:materialicons/METALLIC/cell_OVERLAY");
        } else {
            this.base = i.func_94245_a("miscutils:item" + this.Cell.getComponent());
            this.overlay = i.func_94245_a("miscutils:item" + this.Cell.getComponent() + "_Overlay");
        }
    }

    @Override
    public int func_82790_a(ItemStack stack, int renderPass) {
        if (renderPass == 0 && !CORE.ConfigSwitches.useGregtechTextures) {
            return Utils.rgbtoHexValue(230, 230, 230);
        }
        if (renderPass == 1 && CORE.ConfigSwitches.useGregtechTextures) {
            return Utils.rgbtoHexValue(230, 230, 230);
        }
        return this.componentColour;
    }
}

