/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.fluids;

import cpw.mods.fml.common.eventhandler.Event;
import gtPlusPlus.api.objects.GregtechException;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.core.fluids.FluidFactory;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.FillBucketEvent;

public class ItemGenericFluidBucket
extends ItemBucket {
    private static IIcon mBaseBucketTexture;
    private static IIcon mOverlayBucketTexture;
    private static AutoMap<Block> mInternalFluidCache;
    Map<Integer, IIcon> mIconCache = new LinkedHashMap<Integer, IIcon>();

    public ItemGenericFluidBucket(Block aFluid) {
        super(aFluid);
        this.func_77642_a(Items.field_151133_ar);
        this.field_77777_bU = 1;
        mInternalFluidCache.put(aFluid);
    }

    public static ItemStack registerFluidForBucket(int aID) {
        if (FluidFactory.mMetaToBucketMap.containsKey(aID)) {
            try {
                throw new GregtechException("" + aID + " is already registered! Unable to register fluid: " + FluidFactory.mMetaToFluidMap.get(aID).getLocalizedName());
            }
            catch (GregtechException e) {
                e.printStackTrace();
                CORE.crash("" + aID + " is already registered! Unable to register fluid: " + FluidFactory.mMetaToFluidMap.get(aID).getLocalizedName());
            }
        }
        mInternalFluidCache.put(FluidFactory.mMetaToBlockMap.get(aID));
        return ItemUtils.simpleMetaStack(FluidFactory.mGenericBucket, aID, 1);
    }

    public ItemStack func_77659_a(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        Block isFull = FluidFactory.mMetaToBlockMap.get(aStack.func_77960_j());
        boolean flag = isFull == Blocks.field_150350_a;
        MovingObjectPosition movingobjectposition = this.func_77621_a(aWorld, aPlayer, flag);
        if (movingobjectposition == null || isFull == null) {
            return aStack;
        }
        FillBucketEvent event = new FillBucketEvent(aPlayer, aStack, aWorld, movingobjectposition);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return aStack;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            if (aPlayer.field_71075_bZ.field_75098_d) {
                return aStack;
            }
            if (--aStack.field_77994_a <= 0) {
                return event.result;
            }
            if (!aPlayer.field_71071_by.func_70441_a(event.result)) {
                aPlayer.func_71019_a(event.result, false);
            }
            return aStack;
        }
        if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int i = movingobjectposition.field_72311_b;
            int j = movingobjectposition.field_72312_c;
            int k = movingobjectposition.field_72309_d;
            if (!aWorld.func_72962_a(aPlayer, i, j, k)) {
                return aStack;
            }
            if (flag) {
                if (!aPlayer.func_82247_a(i, j, k, movingobjectposition.field_72310_e, aStack)) {
                    return aStack;
                }
                Material material = aWorld.func_147439_a(i, j, k).func_149688_o();
                int l = aWorld.func_72805_g(i, j, k);
                if (material == Material.field_151586_h && l == 0) {
                    aWorld.func_147468_f(i, j, k);
                    return this.func_150910_a(aStack, aPlayer, Items.field_151131_as);
                }
                if (material == Material.field_151587_i && l == 0) {
                    aWorld.func_147468_f(i, j, k);
                    return this.func_150910_a(aStack, aPlayer, Items.field_151129_at);
                }
            } else {
                if (isFull == Blocks.field_150350_a) {
                    return new ItemStack(Items.field_151133_ar);
                }
                if (movingobjectposition.field_72310_e == 0) {
                    --j;
                }
                if (movingobjectposition.field_72310_e == 1) {
                    ++j;
                }
                if (movingobjectposition.field_72310_e == 2) {
                    --k;
                }
                if (movingobjectposition.field_72310_e == 3) {
                    ++k;
                }
                if (movingobjectposition.field_72310_e == 4) {
                    --i;
                }
                if (movingobjectposition.field_72310_e == 5) {
                    ++i;
                }
                if (!aPlayer.func_82247_a(i, j, k, movingobjectposition.field_72310_e, aStack)) {
                    return aStack;
                }
                if (this.tryPlaceContainedLiquid(isFull, aWorld, i, j, k) && !aPlayer.field_71075_bZ.field_75098_d) {
                    return new ItemStack(Items.field_151133_ar);
                }
            }
        }
        return aStack;
    }

    private ItemStack func_150910_a(ItemStack p_150910_1_, EntityPlayer p_150910_2_, Item p_150910_3_) {
        if (p_150910_2_.field_71075_bZ.field_75098_d) {
            return p_150910_1_;
        }
        if (--p_150910_1_.field_77994_a <= 0) {
            return new ItemStack(p_150910_3_);
        }
        if (!p_150910_2_.field_71071_by.func_70441_a(new ItemStack(p_150910_3_))) {
            p_150910_2_.func_71019_a(new ItemStack(p_150910_3_, 1, 0), false);
        }
        return p_150910_1_;
    }

    public boolean tryPlaceContainedLiquid(Block isFull, World aWorld, int aX, int aY, int aZ) {
        boolean flag;
        if (isFull == Blocks.field_150350_a) {
            return false;
        }
        Material material = aWorld.func_147439_a(aX, aY, aZ).func_149688_o();
        boolean bl = flag = !material.func_76220_a();
        if (!aWorld.func_147437_c(aX, aY, aZ) && !flag) {
            return false;
        }
        if (!aWorld.field_72995_K && flag && !material.func_76224_d()) {
            aWorld.func_147480_a(aX, aY, aZ, true);
        }
        aWorld.func_147465_d(aX, aY, aZ, isFull, 0, 3);
        return true;
    }

    public IIcon func_77617_a(int aMeta) {
        IIcon aTemp = this.mIconCache.get(aMeta);
        return aTemp != null ? aTemp : super.func_77617_a(aMeta);
    }

    public boolean func_77614_k() {
        return mInternalFluidCache.size() > 0;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 0));
        for (Block f : mInternalFluidCache) {
            Integer aMeta;
            if (f == null || (aMeta = FluidFactory.mBlockToMetaMap.get(f)) == null) continue;
            list.add(new ItemStack(item, 1, aMeta.intValue()));
        }
    }

    public int func_77612_l() {
        return 512;
    }

    public boolean func_77645_m() {
        return false;
    }

    public void func_77624_a(ItemStack p_77624_1_, EntityPlayer p_77624_2_, List p_77624_3_, boolean p_77624_4_) {
        super.func_77624_a(p_77624_1_, p_77624_2_, p_77624_3_, p_77624_4_);
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isRepairable() {
        return false;
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (stack != null && renderPass == 1) {
            return mOverlayBucketTexture;
        }
        return mBaseBucketTexture;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public int getMaxDamage(ItemStack stack) {
        return 512;
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public int getItemEnchantability(ItemStack stack) {
        return 0;
    }

    public IIcon func_77618_c(int damage, int pass) {
        if (pass == 1) {
            return mOverlayBucketTexture;
        }
        return mBaseBucketTexture;
    }

    public void func_94581_a(IIconRegister i) {
        mBaseBucketTexture = i.func_94245_a("bucket_empty");
        mOverlayBucketTexture = i.func_94245_a("miscutils:bucket.generic.overlay");
    }

    public boolean func_77875_a(World p_77875_1_, int p_77875_2_, int p_77875_3_, int p_77875_4_) {
        return this.tryPlaceContainedLiquid(Blocks.field_150350_a, p_77875_1_, p_77875_2_, p_77875_3_, p_77875_4_);
    }

    public int func_82790_a(ItemStack aStack, int aPass) {
        if (aPass == 0) {
            return super.func_82790_a(aStack, aPass);
        }
        return FluidFactory.mMetaToColourMap.get(aStack.func_77960_j());
    }

    public boolean func_77623_v() {
        return true;
    }

    static {
        mInternalFluidCache = new AutoMap();
    }
}

