/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.growthcraft.fishtrap;

import gregtech.api.enums.GT_Values;
import gregtech.api.util.GT_ModHandler;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.lib.LoadedMods;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.xmod.growthcraft.fishtrap.Growthcraft_Old;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.item.ItemStack;

public class FishTrapHandler {
    private static final String[] fishTypes = new String[]{"fish", "junk", "treasure"};
    private static Object mFishingRegistry;
    private static Growthcraft_Old mHandler;
    static final String prefix = "food";
    static final String suffix = "raw";
    static final String seaweed = "cropSeaweed";
    static final String greenheartFish = "foodGreenheartfish";
    private static final String[] harvestcraftFish;

    public static Object getFishingRegistry() {
        if (mFishingRegistry != null) {
            return mFishingRegistry;
        }
        return FishTrapHandler.setFishTrapRegistry();
    }

    private static final Object setFishTrapRegistry() {
        try {
            Class<?> mFishingRegistryClass = ReflectionUtils.getClass("growthcraft.api.fishtrap.FishTrapRegistry");
            Method mFishingRegistryMethod = mFishingRegistryClass.getDeclaredMethod("getInstance", new Class[0]);
            mFishingRegistry = mFishingRegistryMethod.invoke(null, new Object[0]);
            if (mFishingRegistry != null) {
                return mFishingRegistry;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void addFish(String lootType, ItemStack lootStack, int lootChance) {
        if (mFishingRegistry == null) {
            FishTrapHandler.setFishTrapRegistry();
        }
        if (mHandler == null) {
            mHandler = new Growthcraft_Old();
        }
        String GCVersion = LoadedMods.getModVersion("Growthcraft");
        String[] versionString = GCVersion.split("//.");
        if (LoadedMods.getModVersion("Growthcraft").contains("2.3.1") || versionString[1].equals("3")) {
            if (lootType.equals(fishTypes[0])) {
                mHandler.addTrapFish(lootStack, lootChance);
                Logger.INFO("Added " + lootStack.func_82833_r() + " as an extra Fish for Growthcraft Fishtraps.");
                return;
            } else if (lootType.equals(fishTypes[1])) {
                mHandler.addTrapJunk(lootStack, lootChance);
                Logger.INFO("Added " + lootStack.func_82833_r() + " as extra Junk for Growthcraft Fishtraps.");
                return;
            } else {
                if (!lootType.equals(fishTypes[2])) return;
                mHandler.addTrapTreasure(lootStack, lootChance);
                Logger.INFO("Added " + lootStack.func_82833_r() + " as extra Treasure for Growthcraft Fishtraps.");
            }
            return;
        } else {
            Logger.INFO("Extra Fish loot for Growthcraft Fishtraps disabled. Found V." + LoadedMods.getModVersion("Growthcraft"));
        }
    }

    public static void pamsHarvestCraftCompat() {
        for (int i = 0; i < harvestcraftFish.length; ++i) {
            String itemName = prefix + harvestcraftFish[i] + suffix;
            int lootChance = FishTrapHandler.getLootChance(harvestcraftFish[i]);
            if (ItemUtils.getItemStackOfAmountFromOreDictNoBroken(itemName, 1) == null) continue;
            FishTrapHandler.addGregtechMaceratorRecipe(ItemUtils.getItemStackOfAmountFromOreDict(itemName, 1));
            FishTrapHandler.addGregtechCentrifugeRecipe(ItemUtils.getItemStackOfAmountFromOreDict(itemName, 1));
            FishTrapHandler.addGregtechFluidRecipe(ItemUtils.getItemStackOfAmountFromOreDict(itemName, 1));
        }
        if (ItemUtils.getItemStackOfAmountFromOreDictNoBroken(greenheartFish, 1) != null) {
            FishTrapHandler.addGregtechMaceratorRecipe(ItemUtils.getItemStackOfAmountFromOreDict(greenheartFish, 1));
            FishTrapHandler.addGregtechCentrifugeRecipe(ItemUtils.getItemStackOfAmountFromOreDict(greenheartFish, 1));
            FishTrapHandler.addGregtechFluidRecipe(ItemUtils.getItemStackOfAmountFromOreDict(greenheartFish, 1));
        }
        if (ItemUtils.getItemStackOfAmountFromOreDictNoBroken(seaweed, 1) != null) {
            // empty if block
        }
    }

    private static int getLootChance(String name) {
        if (name.equals(harvestcraftFish[0])) {
            return 20;
        }
        if (name.equals(harvestcraftFish[1])) {
            return 10;
        }
        if (name.equals(harvestcraftFish[2])) {
            return 15;
        }
        if (name.equals(harvestcraftFish[3])) {
            return 55;
        }
        if (name.equals(harvestcraftFish[4])) {
            return 5;
        }
        if (name.equals(harvestcraftFish[5])) {
            return 8;
        }
        if (name.equals(harvestcraftFish[6])) {
            return 11;
        }
        if (name.equals(harvestcraftFish[7])) {
            return 11;
        }
        if (name.equals(harvestcraftFish[8])) {
            return 15;
        }
        if (name.equals(harvestcraftFish[9])) {
            return 1;
        }
        if (name.equals(harvestcraftFish[10])) {
            return 5;
        }
        if (name.equals(harvestcraftFish[11])) {
            return 10;
        }
        if (name.equals(harvestcraftFish[12])) {
            return 25;
        }
        if (name.equals(harvestcraftFish[13])) {
            return 15;
        }
        if (name.equals(harvestcraftFish[14])) {
            return 20;
        }
        if (name.equals(harvestcraftFish[15])) {
            return 22;
        }
        if (name.equals(harvestcraftFish[16])) {
            return 10;
        }
        if (name.equals(harvestcraftFish[17])) {
            return 35;
        }
        if (name.equals(harvestcraftFish[18])) {
            return 3;
        }
        if (name.equals(harvestcraftFish[19])) {
            return 20;
        }
        if (name.equals(harvestcraftFish[20])) {
            return 4;
        }
        if (name.equals(harvestcraftFish[21])) {
            return 40;
        }
        if (name.equals(harvestcraftFish[22])) {
            return 30;
        }
        if (name.equals(harvestcraftFish[23])) {
            return 5;
        }
        if (name.equals(harvestcraftFish[24])) {
            return 8;
        }
        return 25;
    }

    private static void addGregtechCentrifugeRecipe(ItemStack input) {
        GT_Values.RA.addCentrifugeRecipe(input, null, null, FluidUtils.getFluidStack("methane", 96), null, null, null, null, null, null, null, 380, 5);
    }

    private static void addGregtechMaceratorRecipe(ItemStack input) {
        GT_ModHandler.addPulverisationRecipe((ItemStack)input, (ItemStack)ItemUtils.getItemStackOfAmountFromOreDict("dustMeatRaw", 1), (ItemStack)ItemUtils.getItemStackOfAmountFromOreDict("dustTinyBone", 1), (int)0);
    }

    private static void addGregtechFluidRecipe(ItemStack input) {
        CORE.RA.addFluidExtractionRecipe(input, FluidUtils.getFluidStack("fishoil", 50), 16, 4);
    }

    static {
        harvestcraftFish = new String[]{"Anchovy", "Bass", "Calamari", "Carp", "Catfish", "Charr", "Clam", "Crab", "Crayfish", "Eel", "Frog", "Grouper", "Herring", "Jellyfish", "Mudfish", "Octopus", "Perch", "Scallop", "Shrimp", "Snail", "Snapper", "Tilapia", "Trout", "Tuna", "Turtle", "Walley"};
    }
}

