/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.storage.shelving;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.core.util.sys.KeyboardUtils;
import gtPlusPlus.xmod.gregtech.common.tileentities.storage.shelving.GT4Entity_Shelf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class GT4Entity_Shelf_Large
extends GT4Entity_Shelf {
    private final int mSize;
    public int mItemCount;
    public ItemStack mItemStack;

    public GT4Entity_Shelf_Large(int aID, String aName, String aNameRegional, String aDescription, int aSize) {
        super(aID, aName, aNameRegional, aDescription);
        this.mSize = aSize;
        this.mItemCount = 0;
        this.mItemStack = null;
    }

    public GT4Entity_Shelf_Large(String mName, String mDescriptionArray, int aSize, ITexture[][][] mTextures) {
        super(mName, mDescriptionArray, mTextures);
        this.mSize = aSize;
        this.mItemCount = 0;
        this.mItemStack = null;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT4Entity_Shelf_Large(this.mName, this.mDescription, this.mSize, this.mTextures);
    }

    public boolean isGivingInformation() {
        return true;
    }

    public boolean isDigitalChest() {
        return true;
    }

    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        if (KeyboardUtils.isCtrlKeyDown()) {
            String itemName = this.mItemStack != null ? this.mItemStack.func_82833_r() : "Nothing.";
            String itemAmount = this.mItemCount > 0 ? "" + this.mItemCount : "bad";
            String itemMessage = "This container currently holds " + (itemAmount.equalsIgnoreCase("bad") ? "nothing." : itemName + " x" + itemAmount + ".");
            PlayerUtils.messagePlayer(aPlayer, itemMessage);
        } else {
            GT_UIInfos.openGTTileEntityUI((IHasWorldObjectAndCoords)aBaseMetaTileEntity, (EntityPlayer)aPlayer);
        }
        return true;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mItemCount", this.mItemCount);
        if (this.mItemStack != null) {
            aNBT.func_74782_a("mItemStack", (NBTBase)this.mItemStack.func_77955_b(new NBTTagCompound()));
        }
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        if (aNBT.func_74764_b("mItemCount")) {
            this.mItemCount = aNBT.func_74762_e("mItemCount");
        }
        if (aNBT.func_74764_b("mItemStack")) {
            this.mItemStack = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)aNBT.func_74781_a("mItemStack")));
        }
        super.loadNBTData(aNBT);
    }

    public void onOpenGUI() {
        super.onOpenGUI();
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        if (this.getBaseMetaTileEntity().isServerSide() && this.getBaseMetaTileEntity().isAllowedToWork()) {
            try {
                this.mType = this.mInventory[0] != null ? this.mIndex : (byte)0;
                if (this.getItemCount() <= 0) {
                    this.mItemStack = null;
                    this.mItemCount = 0;
                }
                if (this.mItemStack == null && this.mInventory[0] != null) {
                    this.mItemStack = this.mInventory[0].func_77946_l();
                }
                if (this.mInventory[0] != null && this.mItemCount < this.getMaxItemCount() && GT_Utility.areStacksEqual((ItemStack)this.mInventory[0], (ItemStack)this.mItemStack)) {
                    this.mItemCount += this.mInventory[0].field_77994_a;
                    if (this.mItemCount > this.getMaxItemCount()) {
                        this.mInventory[0].field_77994_a = this.mItemCount - this.getMaxItemCount();
                        this.mItemCount = this.getMaxItemCount();
                    } else {
                        this.mInventory[0] = null;
                    }
                }
                if (this.mInventory[1] == null && this.mItemStack != null) {
                    this.mInventory[1] = this.mItemStack.func_77946_l();
                    this.mInventory[1].field_77994_a = Math.min(this.mItemStack.func_77976_d(), this.mItemCount);
                    this.mItemCount -= this.mInventory[1].field_77994_a;
                } else if (this.mItemCount > 0 && GT_Utility.areStacksEqual((ItemStack)this.mInventory[1], (ItemStack)this.mItemStack) && this.mInventory[1].func_77976_d() > this.mInventory[1].field_77994_a) {
                    int tmp = Math.min(this.mItemCount, this.mInventory[1].func_77976_d() - this.mInventory[1].field_77994_a);
                    ItemStack itemStack = this.mInventory[1];
                    itemStack.field_77994_a += tmp;
                    this.mItemCount -= tmp;
                }
                if (this.mItemStack != null) {
                    this.mInventory[2] = this.mItemStack.func_77946_l();
                    this.mInventory[2].field_77994_a = Math.min(this.mItemStack.func_77976_d(), this.mItemCount);
                } else {
                    this.mInventory[2] = null;
                }
            }
            catch (Throwable t) {
                if (t instanceof ArrayIndexOutOfBoundsException) {
                    // empty if block
                }
            }
        }
    }

    private int getItemCount() {
        return this.mItemCount;
    }

    public void setItemCount(int aCount) {
        this.mItemCount = aCount;
    }

    public int getProgresstime() {
        try {
            return this.mItemCount + (this.mInventory[0] == null ? 0 : this.mInventory[0].field_77994_a) + (this.mInventory[1] == null ? 0 : this.mInventory[1].field_77994_a);
        }
        catch (Throwable t) {
            return 0;
        }
    }

    public int maxProgresstime() {
        return this.getMaxItemCount();
    }

    public int getMaxItemCount() {
        return this.mSize;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aIndex == 1;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aIndex == 0 && (this.mInventory[0] == null && this.mItemStack == null || GT_Utility.areStacksEqual((ItemStack)this.mInventory[0], (ItemStack)aStack) || this.mItemStack != null && GT_Utility.areStacksEqual((ItemStack)this.mItemStack, (ItemStack)aStack));
    }

    public String[] getInfoData() {
        if (this.mItemStack == null) {
            return new String[]{this.getLocalName(), "No Items Stored", "Free Space: " + Integer.toString(this.getMaxItemCount())};
        }
        return new String[]{this.getLocalName(), "Storing: " + this.mItemStack.func_82833_r() + " x" + Integer.toString(this.mItemCount), "Space Remaining: " + Integer.toString(this.getMaxItemCount() - this.getItemCount()) + "/" + Integer.toString(this.getMaxItemCount())};
    }

    @Override
    public String[] getDescription() {
        String[] mSuper = super.getDescription();
        String[] desc = new String[mSuper.length + 1];
        for (int i = 0; i > mSuper.length; ++i) {
            desc[i] = mSuper[i];
        }
        desc[desc.length - 1] = "Control + Rmb block to check contents";
        return desc;
    }

    public boolean func_94041_b(int aIndex, ItemStack aStack) {
        Logger.INFO("1:" + aIndex);
        if (aIndex == 2) {
            if (ItemStack.func_77989_b((ItemStack)aStack, (ItemStack)this.mItemStack)) {
                return true;
            }
            return this.mItemStack == null;
        }
        return super.func_94041_b(aIndex, aStack);
    }

    public boolean func_102007_a(int aIndex, ItemStack aStack, int aSide) {
        Logger.INFO("2:" + aIndex);
        if (aIndex == 0) {
            if (ItemStack.func_77989_b((ItemStack)aStack, (ItemStack)this.mItemStack)) {
                return true;
            }
            return this.mItemStack == null;
        }
        return super.func_102007_a(aIndex, aStack, aSide);
    }

    public boolean useModularUI() {
        return true;
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_SCREEN_BLACK).setPos(7, 16).setSize(71, 45))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 0).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_IN}).setPos(79, 16))).widget(new TextWidget("Item Amount").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(10, 20))).widget(TextWidget.dynamicString(() -> GT_Utility.parseNumberToString((int)this.mItemCount)).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(10, 30));
    }
}

