/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.storage;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Interactable;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import com.gtnewhorizons.modularui.common.internal.wrapper.BaseSlot;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.api.enums.GT_Values;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddGregtechLogo;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicTank;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.interfaces.IItemBlueprint;
import gtPlusPlus.core.item.general.ItemBlueprint;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.xmod.gregtech.api.gui.GTPP_UITextures;
import gtPlusPlus.xmod.gregtech.api.gui.widget.ElectricSlotWidget;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_AdvancedCraftingTable
extends GT_MetaTileEntity_BasicTank
implements IAddGregtechLogo {
    public boolean mFlushMode = false;
    protected String mLocalName;

    public GT_MetaTileEntity_AdvancedCraftingTable(int aID, String aName, String aNameRegional, int aTier, String aDescription) {
        super(aID, aName, aNameRegional, aTier, 35, aDescription, new ITexture[0]);
        this.mLocalName = aNameRegional;
    }

    public GT_MetaTileEntity_AdvancedCraftingTable(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 35, aDescription, aTextures);
    }

    public boolean isTransformerUpgradable() {
        return true;
    }

    public boolean isSimpleMachine() {
        return true;
    }

    public boolean isValidSlot(int aIndex) {
        return aIndex < 31 || aIndex > 32;
    }

    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public boolean isEnetInput() {
        return this.isElectric();
    }

    public boolean isInputFacing(byte aSide) {
        return true;
    }

    public long maxEUInput() {
        return this.isElectric() ? GT_Values.V[3] : 0L;
    }

    public long maxEUStore() {
        return this.isElectric() ? GT_Values.V[3] * 1024L : 0L;
    }

    public boolean isElectric() {
        return this.isAdvanced();
    }

    public boolean isPneumatic() {
        return false;
    }

    public boolean isSteampowered() {
        return false;
    }

    public long maxAmperesIn() {
        return this.isElectric() ? 2L : 0L;
    }

    public long getMinimumStoredEU() {
        return this.isElectric() ? GT_Values.V[3] * 2L : 0L;
    }

    public int func_70302_i_() {
        return 35;
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_AdvancedCraftingTable(this.mName, this.mTier, this.mDescription, this.mTextures);
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GT_UIInfos.openGTTileEntityUI((IHasWorldObjectAndCoords)aBaseMetaTileEntity, (EntityPlayer)aPlayer);
        return true;
    }

    public boolean doesFillContainers() {
        return false;
    }

    public boolean doesEmptyContainers() {
        return false;
    }

    public boolean canTankBeFilled() {
        return true;
    }

    public boolean canTankBeEmptied() {
        return true;
    }

    public boolean displaysItemStack() {
        return false;
    }

    public boolean displaysStackSize() {
        return false;
    }

    public void sortIntoTheInputSlots() {
        for (int i = 21; i < 30; i = (int)((byte)(i + 1))) {
            int j;
            if (this.mInventory[i] == null) continue;
            if (this.mInventory[i].field_77994_a == 0) {
                this.mInventory[i] = null;
            }
            if (this.mInventory[i] != null) {
                for (j = 0; j < 16; j = (int)((byte)(j + 1))) {
                    if (!GT_Utility.areStacksEqual((ItemStack)this.mInventory[i], (ItemStack)this.mInventory[j])) continue;
                    GT_Utility.moveStackFromSlotAToSlotB((IInventory)this.getBaseMetaTileEntity(), (IInventory)this.getBaseMetaTileEntity(), (int)i, (int)j, (byte)64, (byte)1, (byte)64, (byte)1);
                }
            }
            if (this.mInventory[i] == null) continue;
            for (j = 0; j < 16; j = (int)((byte)(j + 1))) {
                if (this.mInventory[j] != null) continue;
                GT_Utility.moveStackFromSlotAToSlotB((IInventory)this.getBaseMetaTileEntity(), (IInventory)this.getBaseMetaTileEntity(), (int)i, (int)j, (byte)64, (byte)1, (byte)64, (byte)1);
            }
        }
    }

    private void fillLiquidContainers() {
        for (int i = 16; i < 21 && this.mFluid != null; i = (int)((byte)(i + 1))) {
            ItemStack tOutput = GT_Utility.fillFluidContainer((FluidStack)this.mFluid, (ItemStack)this.mInventory[i], (boolean)false, (boolean)true);
            if (tOutput == null) continue;
            if (this.mInventory[i].field_77994_a == 1) {
                this.mFluid.amount -= GT_Utility.getFluidForFilledItem((ItemStack)tOutput, (boolean)true).amount * tOutput.field_77994_a;
                this.mInventory[i] = tOutput;
            } else {
                for (int j = 16; j < 21; j = (int)((byte)(j + 1))) {
                    if (this.mInventory[j] != null && (!GT_Utility.areStacksEqual((ItemStack)tOutput, (ItemStack)this.mInventory[j]) || this.mInventory[j].field_77994_a + tOutput.field_77994_a > tOutput.func_77976_d())) continue;
                    this.mFluid.amount -= GT_Utility.getFluidForFilledItem((ItemStack)tOutput, (boolean)true).amount * tOutput.field_77994_a;
                    this.getBaseMetaTileEntity().func_70298_a(i, 1);
                    if (this.mInventory[j] == null) {
                        this.mInventory[j] = tOutput;
                        break;
                    }
                    ++this.mInventory[j].field_77994_a;
                    break;
                }
            }
            if (this.mFluid == null || this.mFluid.amount > 0) continue;
            this.mFluid = null;
        }
        if (this.mFluid != null && this.mFluid.amount <= 0) {
            this.mFluid = null;
        }
    }

    public void setBluePrint(ItemStack aStack) {
        if (aStack == null) {
            aStack = this.mInventory[30];
            Logger.INFO("Using Slot 30 supply.");
        }
        if (this.mInventory[31] == null || aStack == null || aStack.func_77973_b() == null || aStack.func_77960_j() != 0 || aStack.field_77994_a != 1 || !(aStack.func_77973_b() instanceof ItemBlueprint)) {
            try {
                Logger.INFO("Could not set Blueprint. Slot 31: " + (this.mInventory[31] != null ? this.mInventory[31].func_82833_r() : "Null") + ", aStack: " + (aStack != null ? aStack.func_82833_r() : "Null") + ", Damage: " + (aStack != null ? Integer.valueOf(aStack.func_77960_j()) : "Null"));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return;
        }
        if (!aStack.func_77978_p().func_74764_b("Inventory")) {
            NBTTagCompound tNBT = new NBTTagCompound();
            NBTTagList tNBT_ItemList = new NBTTagList();
            for (int i = 0; i < 9; ++i) {
                ItemStack tStack = this.mInventory[i + 21];
                if (tStack == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74774_a("Slot", (byte)i);
                tStack.func_77955_b(tag);
                tNBT_ItemList.func_74742_a((NBTBase)tag);
            }
            tNBT.func_74782_a("Inventory", (NBTBase)tNBT_ItemList);
            tNBT.func_74757_a("mBlueprint", true);
            tNBT.func_74768_a("mID", MathUtils.randInt(1, Short.MAX_VALUE));
            tNBT.func_74778_a("mName", this.mInventory[31].func_82833_r());
            aStack.func_77982_d(tNBT);
            Logger.INFO("Set NBT of crafting table to Stack in slot 30.");
        } else {
            Logger.INFO("Blueprint already has recipe tags.");
        }
    }

    public ItemStack getCraftingOutput() {
        if (this.mInventory[30] != null && this.mInventory[30].func_77973_b() != null && this.mInventory[30].func_77960_j() == 0 && this.mInventory[30].func_77942_o() && this.mInventory[30].func_77973_b() instanceof ItemBlueprint) {
            NBTTagCompound tNBT = this.mInventory[30].func_77978_p();
            NBTTagList tNBT_ItemList = tNBT.func_150295_c("Blueprint", 10);
            for (int i = 0; i < tNBT_ItemList.func_74745_c() && i < 9; ++i) {
                NBTTagCompound tag = tNBT_ItemList.func_150305_b(i);
                byte slot = tag.func_74771_c("Slot");
                if (slot < 0 || slot >= 9 || this.mInventory[slot + 21] != null) continue;
                this.mInventory[slot + 21] = GT_Utility.loadItem((NBTTagCompound)tag);
                if (this.mInventory[slot + 21] == null) continue;
                this.mInventory[slot + 21].field_77994_a = 0;
            }
        }
        this.mInventory[31] = GT_ModHandler.getAllRecipeOutput((World)this.getBaseMetaTileEntity().getWorld(), (ItemStack[])new ItemStack[]{this.mInventory[21], this.mInventory[22], this.mInventory[23], this.mInventory[24], this.mInventory[25], this.mInventory[26], this.mInventory[27], this.mInventory[28], this.mInventory[29]});
        return this.mInventory[31];
    }

    public boolean canDoCraftingOutput() {
        if (this.mInventory[31] == null) {
            return false;
        }
        for (ItemStack tStack : this.recipeContent()) {
            if (tStack.field_77994_a <= this.getAmountOf(tStack)) continue;
            return false;
        }
        return true;
    }

    private int getAmountOf(ItemStack aStack) {
        int tAmount = 0;
        for (int i = 0; i < 30 && tAmount < 9; i = (int)((byte)(i + 1))) {
            if (!GT_Utility.areStacksOrToolsEqual((ItemStack)aStack, (ItemStack)this.mInventory[i])) continue;
            tAmount += this.mInventory[i].field_77994_a;
        }
        return tAmount;
    }

    private ArrayList<ItemStack> recipeContent() {
        ArrayList<ItemStack> tList = new ArrayList<ItemStack>();
        for (int i = 21; i < 30; i = (int)((byte)(i + 1))) {
            if (this.mInventory[i] == null) continue;
            boolean temp = false;
            for (int j = 0; j < tList.size(); j = (int)((byte)(j + 1))) {
                if (!GT_Utility.areStacksOrToolsEqual((ItemStack)this.mInventory[i], (ItemStack)tList.get(j))) continue;
                ++tList.get((int)j).field_77994_a;
                temp = true;
                break;
            }
            if (temp) continue;
            tList.add(GT_Utility.copy((Object[])new Object[]{1, this.mInventory[i]}));
        }
        return tList;
    }

    public ItemStack consumeMaterials(EntityPlayer aPlayer, ItemStack aHoldStack) {
        if (this.mInventory[31] == null) {
            return aHoldStack;
        }
        if (aHoldStack != null) {
            if (!GT_Utility.areStacksEqual((ItemStack)aHoldStack, (ItemStack)this.mInventory[31])) {
                return aHoldStack;
            }
            if (aHoldStack.field_77994_a + this.mInventory[31].field_77994_a > aHoldStack.func_77976_d()) {
                return aHoldStack;
            }
        }
        block0: for (int i = 21; i < 30; i = (int)((byte)(i + 1))) {
            if (this.mInventory[i] == null) continue;
            for (int j = 0; j <= i; j = (int)((byte)(j + 1))) {
                if (j >= 21 && j != i || !GT_Utility.areStacksOrToolsEqual((ItemStack)this.mInventory[i], (ItemStack)this.mInventory[j]) || this.mInventory[j].field_77994_a <= 0) continue;
                ItemStack tStack = GT_Utility.getContainerItem((ItemStack)this.mInventory[j], (boolean)true);
                if (tStack == null || tStack.func_77984_f() && tStack.func_77960_j() >= tStack.func_77958_k()) {
                    this.getBaseMetaTileEntity().func_70298_a(j, 1);
                    continue block0;
                }
                if (this.mInventory[j].field_77994_a == 1) {
                    this.mInventory[j] = tStack;
                    continue block0;
                }
                this.getBaseMetaTileEntity().func_70298_a(j, 1);
                for (int k = 0; k < 21; k = (int)((byte)(k + 1))) {
                    if (this.mInventory[k] == null) {
                        this.mInventory[k] = tStack;
                        continue block0;
                    }
                    if (!GT_Utility.areStacksEqual((ItemStack)tStack, (ItemStack)this.mInventory[k]) || tStack.field_77994_a + this.mInventory[k].field_77994_a > this.mInventory[k].func_77976_d()) continue;
                    this.mInventory[k].field_77994_a += tStack.field_77994_a;
                    continue block0;
                }
                continue block0;
            }
        }
        if (aHoldStack == null) {
            aHoldStack = GT_Utility.copy((Object[])new Object[]{this.mInventory[31]});
            aHoldStack.func_77980_a(this.getBaseMetaTileEntity().getWorld(), aPlayer, this.mInventory[31].field_77994_a);
        } else {
            aHoldStack.field_77994_a += this.mInventory[31].field_77994_a;
            aHoldStack.func_77980_a(this.getBaseMetaTileEntity().getWorld(), aPlayer, this.mInventory[31].field_77994_a);
        }
        this.fillLiquidContainers();
        return aHoldStack;
    }

    public int rechargerSlotStartIndex() {
        return 16;
    }

    public int rechargerSlotCount() {
        return 5;
    }

    public long getOutputTier() {
        return GT_Utility.getTier((long)this.getBaseMetaTileEntity().getInputVoltage());
    }

    public int getCapacity() {
        return 64000;
    }

    public int getTankPressure() {
        return -100;
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aIndex == 33 || this.mFlushMode && aIndex >= 21 && aIndex < 30;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        if (aIndex < 16) {
            for (int i = 0; i < 16; i = (int)((byte)(i + 1))) {
                if (!GT_Utility.areStacksOrToolsEqual((ItemStack)aStack, (ItemStack)this.mInventory[i])) continue;
                return aIndex == i;
            }
            return true;
        }
        return false;
    }

    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        this.getCraftingOutput();
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.getBaseMetaTileEntity().isServerSide()) {
            if (this.getBaseMetaTileEntity().hasInventoryBeenModified()) {
                this.getCraftingOutput();
            }
            this.fillLiquidContainers();
            if (this.mFlushMode) {
                this.mFlushMode = false;
                for (int i = 21; i < 30; i = (int)((byte)(i + 1))) {
                    if (this.mInventory[i] == null) continue;
                    if (this.mInventory[i].field_77994_a == 0) {
                        this.mInventory[i] = null;
                        continue;
                    }
                    this.mFlushMode = true;
                    break;
                }
            }
        }
    }

    public String[] getDescription() {
        return new String[]{this.isAdvanced() ? "For the very large Projects" : "For the smaller Projects", "Hold Shift in GUI to see slot usage", this.mDescription, CORE.GT_Tooltip.get()};
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[10][17][];
        for (byte i = -1; i < 16; i = (byte)(i + 1)) {
            rTextures[0][i + 1] = this.getFront(i);
            rTextures[1][i + 1] = this.getBack(i);
            rTextures[2][i + 1] = this.getBottom(i);
            rTextures[3][i + 1] = this.getTop(i);
            rTextures[4][i + 1] = this.getSides(i);
            rTextures[5][i + 1] = this.getFront(i);
            rTextures[6][i + 1] = this.getBack(i);
            rTextures[7][i + 1] = this.getBottom(i);
            rTextures[8][i + 1] = this.getTop(i);
            rTextures[9][i + 1] = this.getSides(i);
        }
        return rTextures;
    }

    protected boolean isAdvanced() {
        return true;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        return this.mTextures[(aActive ? 5 : 0) + (aSide == aFacing ? 0 : (aSide == GT_Utility.getOppositeSide((int)aFacing) ? 1 : (aSide == 0 ? 2 : (aSide == 1 ? 3 : 4))))][aColorIndex + 1];
    }

    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{this.isAdvanced() ? new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Adv_Workbench_Side) : new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Workbench_Side)};
    }

    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{this.isAdvanced() ? new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Adv_Workbench_Side) : new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Workbench_Side)};
    }

    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{this.isAdvanced() ? new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Adv_Workbench_Bottom) : new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Workbench_Bottom)};
    }

    public ITexture[] getTop(byte aColor) {
        if (this.isAdvanced()) {
            return new ITexture[]{new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Adv_Workbench_Top), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Adv_Workbench_Crafting_Overlay)};
        }
        return new ITexture[]{new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Workbench_Top), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Workbench_Crafting_Overlay)};
    }

    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{this.isAdvanced() ? new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Adv_Workbench_Side) : new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Workbench_Side)};
    }

    public boolean useModularUI() {
        return true;
    }

    public void addGregTechLogo(ModularWindow.Builder builder) {
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)4).endAtSlot(15).background(new IDrawable[]{this.getGUITextureSet().getItemSlot()}).build().setPos(7, 7));
        for (int i = 0; i < 5; ++i) {
            builder.widget(this.createElectricSlot(i + 16).setPos(81 + i * 18, 7));
        }
        builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)3).startFromSlot(21).endAtSlot(29).background(new IDrawable[]{this.getGUITextureSet().getItemSlot()}).applyForWidget(SlotWidget::disableShiftInsert).build().setPos(81, 27));
        ((ModularWindow.Builder)builder.widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 33).disableShiftInsert().addTooltipShift("Extraction Slot").addTooltipShift("Things can always be pulled from here").setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), this.getArrowOverlay()}).setPos(153, 27))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 34).disableShiftInsert().addTooltipShift("Free Parking").setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), this.getParkOverlay()}).setPos(153, 63));
        builder.widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 30){

            public Interactable.ClickResult onClick(int buttonId, boolean doubleClick) {
                if (buttonId == 0 && Interactable.hasShiftDown()) {
                    this.syncToServer(99, NetworkUtils.EMPTY_PACKET);
                    return Interactable.ClickResult.SUCCESS;
                }
                return super.onClick(buttonId, doubleClick);
            }

            public void readOnServer(int id, PacketBuffer buf) throws IOException {
                if (id == 99) {
                    GT_MetaTileEntity_AdvancedCraftingTable.this.setBluePrint(null);
                } else {
                    super.readOnServer(id, buf);
                }
            }
        }.setFilter(stack -> stack.func_77973_b() instanceof IItemBlueprint).disableShiftInsert().addTooltipShift("Blueprint Slot").addTooltipShift("Shift+Lmb Sets to crafting output").setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), this.getBlueprintOverlay()}).setPos(135, 27));
        builder.widget(new SlotWidget(BaseSlot.phantom((IItemHandlerModifiable)this.inventoryHandler, (int)31)){

            protected void phantomClick(Widget.ClickData clickData, ItemStack cursorStack) {
                block7: {
                    ItemStack tCraftedStack;
                    ItemStack tStack;
                    EntityPlayer aPlayer;
                    block9: {
                        block8: {
                            aPlayer = this.getContext().getPlayer();
                            tStack = this.getMcSlot().func_75211_c();
                            if (tStack == null) {
                                return;
                            }
                            if (tStack.field_77994_a <= 0 && !GT_Utility.areStacksEqual((ItemStack)tStack, (ItemStack)aPlayer.field_71071_by.func_70445_o())) {
                                return;
                            }
                            tCraftedStack = GT_MetaTileEntity_AdvancedCraftingTable.this.getCraftingOutput();
                            if (tCraftedStack == null) break block7;
                            if (!clickData.shift) break block8;
                            for (int i = 0; i < aPlayer.field_71071_by.field_70462_a.length; i = (int)((byte)(i + 1))) {
                                for (int j = 0; j < tCraftedStack.func_77976_d() / tCraftedStack.field_77994_a && GT_MetaTileEntity_AdvancedCraftingTable.this.canDoCraftingOutput(); j = (int)((byte)(j + 1))) {
                                    ItemStack tStack2 = GT_MetaTileEntity_AdvancedCraftingTable.this.getCraftingOutput();
                                    if (!GT_Utility.areStacksEqual((ItemStack)tStack2, (ItemStack)tCraftedStack) || tStack.field_77994_a != tStack2.field_77994_a) {
                                        return;
                                    }
                                    aPlayer.field_71071_by.field_70462_a[i] = GT_MetaTileEntity_AdvancedCraftingTable.this.consumeMaterials(aPlayer, aPlayer.field_71071_by.field_70462_a[i]);
                                }
                            }
                            break block7;
                        }
                        if (clickData.mouseButton != 0) break block9;
                        if (!GT_MetaTileEntity_AdvancedCraftingTable.this.canDoCraftingOutput()) break block7;
                        aPlayer.field_71071_by.func_70437_b(GT_MetaTileEntity_AdvancedCraftingTable.this.consumeMaterials(aPlayer, aPlayer.field_71071_by.func_70445_o()));
                        break block7;
                    }
                    for (int i = 0; i < tCraftedStack.func_77976_d() / tCraftedStack.field_77994_a && GT_MetaTileEntity_AdvancedCraftingTable.this.canDoCraftingOutput(); ++i) {
                        ItemStack tStack2 = GT_MetaTileEntity_AdvancedCraftingTable.this.getCraftingOutput();
                        if (!GT_Utility.areStacksEqual((ItemStack)tStack2, (ItemStack)tCraftedStack) || tStack.field_77994_a != tStack2.field_77994_a) {
                            return;
                        }
                        aPlayer.field_71071_by.func_70437_b(GT_MetaTileEntity_AdvancedCraftingTable.this.consumeMaterials(aPlayer, aPlayer.field_71071_by.func_70445_o()));
                    }
                }
            }

            public boolean handleDragAndDrop(ItemStack draggedStack, int button) {
                return false;
            }

            public List<String> getExtraTooltip() {
                return Collections.emptyList();
            }
        }.setAccess(false, false).setHandlePhantomActionClient(true).addTooltipShift("Output Slot").setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), this.getCraftOutputOverlay()}).setPos(135, 63));
        ((ModularWindow.Builder)builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> this.sortIntoTheInputSlots()).addTooltipShift("Flush").addTooltipShift("Empty crafting grid back to storage").setBackground(new IDrawable[]{this.getButtonIcon(), this.getFlushOverlay()}).setPos(135, 45).setSize(18, 18))).widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            this.mFlushMode = true;
        }).addTooltipShift("Automation").addTooltipShift("Allows output while").addTooltipShift("crafting grid is full").setBackground(new IDrawable[]{this.getButtonIcon(), GTPP_UITextures.OVERLAY_BUTTON_AUTOMATION}).setPos(153, 45).setSize(18, 18));
    }

    protected SlotWidget createElectricSlot(int index) {
        return (SlotWidget)new ElectricSlotWidget((IItemHandlerModifiable)this.inventoryHandler, index).setShiftClickPriority(-1).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTPP_UITextures.OVERLAY_SLOT_ELECTRIC_TOOL});
    }

    protected IDrawable getArrowOverlay() {
        return GTPP_UITextures.OVERLAY_SLOT_ARROW;
    }

    protected IDrawable getParkOverlay() {
        return GTPP_UITextures.OVERLAY_SLOT_PARK;
    }

    protected IDrawable getBlueprintOverlay() {
        return GT_UITextures.OVERLAY_SLOT_PAGE_PRINTED;
    }

    protected IDrawable getCraftOutputOverlay() {
        return GTPP_UITextures.OVERLAY_SLOT_CRAFT_OUTPUT;
    }

    protected IDrawable getButtonIcon() {
        return GT_UITextures.BUTTON_STANDARD;
    }

    protected IDrawable getFlushOverlay() {
        return GTPP_UITextures.OVERLAY_BUTTON_FLUSH;
    }
}

