/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.redstone;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.CycleButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.IRedstoneCircuitBlock;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_CircuitryBehavior;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.xmod.gregtech.api.gui.GTPP_UITextures;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.common.tileentities.redstone.GT_MetaTileEntity_RedstoneBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class GT_MetaTileEntity_RedstoneCircuitBlock
extends GT_MetaTileEntity_RedstoneBase
implements IRedstoneCircuitBlock,
IAddUIWidgets {
    public int mGate = 0;
    public int[] mGateData = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    public boolean bOutput = true;
    public static final Map<Integer, ItemStack> sCoversItems = new HashMap<Integer, ItemStack>();

    public GT_MetaTileEntity_RedstoneCircuitBlock(int aID) {
        super(aID, "redstone.circuit", "Redstone Circuit Block", 1, 5, "Computes Redstone", new ITexture[0]);
    }

    public GT_MetaTileEntity_RedstoneCircuitBlock(String aName, String aDescription, ITexture[][][] aTextures) {
        super(aName, 1, 5, aDescription, aTextures);
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_RedstoneCircuitBlock(this.mName, this.mDescription, this.mTextures);
    }

    public boolean hasSidedRedstoneOutputBehavior() {
        return true;
    }

    public boolean isEnetInput() {
        return true;
    }

    public boolean isEnetOutput() {
        return true;
    }

    public boolean isInputFacing(byte aSide) {
        return !this.isOutputFacing(aSide);
    }

    public boolean isElectric() {
        return true;
    }

    public boolean isPneumatic() {
        return false;
    }

    public boolean isSteampowered() {
        return false;
    }

    public boolean isOutputFacing(byte aSide) {
        return aSide == this.getOutputFacing();
    }

    public long getMinimumStoredEU() {
        return 512L;
    }

    public long maxEUInput() {
        return GT_Values.V[1];
    }

    public long maxEUOutput() {
        return this.bOutput ? GT_Values.V[1] : 0L;
    }

    public long maxAmperesIn() {
        return 2L;
    }

    public long maxAmperesOut() {
        return 1L;
    }

    public int func_70302_i_() {
        return 5;
    }

    public long maxEUStore() {
        return GT_Values.V[3] * 1024L;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GT_UIInfos.openGTTileEntityUI((IHasWorldObjectAndCoords)aBaseMetaTileEntity, (EntityPlayer)aPlayer);
        return true;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mGate", this.mGate);
        aNBT.func_74783_a("mGateData", this.mGateData);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mGate = aNBT.func_74762_e("mGate");
        this.mGateData = aNBT.func_74759_k("mGateData");
        if (this.mGateData.length != 8) {
            this.mGateData = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        }
    }

    public void switchGateForward(boolean aShift) {
        try {
            Set tKeys = GregTech_API.sCircuitryBehaviors.keySet();
            ArrayList tList = new ArrayList();
            tList.addAll(tKeys);
            if (tList.size() <= 0) {
                return;
            }
            Collections.sort(tList);
            if (!GregTech_API.sCircuitryBehaviors.containsKey(this.mGate)) {
                this.mGate = (Integer)tList.get(0);
            }
            int tIndex = Collections.binarySearch(tList, this.mGate);
            tIndex += aShift ? 16 : 1;
            while (tIndex >= tList.size()) {
                tIndex -= tList.size();
            }
            this.mGate = (Integer)tList.get(tIndex);
            this.switchGate();
        }
        catch (Throwable e) {
            GT_Log.err.print(e);
        }
    }

    public void switchGateBackward(boolean aShift) {
        try {
            Set tKeys = GregTech_API.sCircuitryBehaviors.keySet();
            ArrayList tList = new ArrayList();
            tList.addAll(tKeys);
            if (tList.size() <= 0) {
                return;
            }
            Collections.sort(tList);
            if (!GregTech_API.sCircuitryBehaviors.containsKey(this.mGate)) {
                this.mGate = (Integer)tList.get(0);
            }
            int tIndex = Collections.binarySearch(tList, this.mGate);
            tIndex -= aShift ? 16 : 1;
            while (tIndex < 0) {
                tIndex += tList.size();
            }
            this.mGate = (Integer)tList.get(tIndex);
            this.switchGate();
        }
        catch (Throwable e) {
            GT_Log.err.print(e);
        }
    }

    public void onFacingChange() {
        this.resetRedstone();
    }

    private void resetRedstone() {
        this.getBaseMetaTileEntity().setInternalOutputRedstoneSignal((byte)0, (byte)0);
        this.getBaseMetaTileEntity().setInternalOutputRedstoneSignal((byte)1, (byte)0);
        this.getBaseMetaTileEntity().setInternalOutputRedstoneSignal((byte)2, (byte)0);
        this.getBaseMetaTileEntity().setInternalOutputRedstoneSignal((byte)3, (byte)0);
        this.getBaseMetaTileEntity().setInternalOutputRedstoneSignal((byte)4, (byte)0);
        this.getBaseMetaTileEntity().setInternalOutputRedstoneSignal((byte)5, (byte)0);
    }

    public void changeGateData(int aIndex, int aValue) {
        int n = aIndex;
        this.mGateData[n] = this.mGateData[n] + aValue;
        this.validateGateData();
    }

    public void stackGateData(int aIndex, ItemStack aStack) {
        this.mGateData[aIndex] = GT_Utility.stackToInt((ItemStack)aStack);
        this.validateGateData();
    }

    private void switchGate() {
        this.resetRedstone();
        for (int i = 0; i < this.mGateData.length; ++i) {
            this.mGateData[i] = 0;
        }
        GT_CircuitryBehavior tBehaviour = (GT_CircuitryBehavior)GregTech_API.sCircuitryBehaviors.get(this.mGate);
        if (tBehaviour != null) {
            try {
                tBehaviour.initParameters(this.mGateData, (IRedstoneCircuitBlock)this);
            }
            catch (Throwable e) {
                GT_Log.err.print(e);
            }
        }
        this.validateGateData();
    }

    private void validateGateData() {
        GT_CircuitryBehavior tBehaviour = (GT_CircuitryBehavior)GregTech_API.sCircuitryBehaviors.get(this.mGate);
        if (tBehaviour != null) {
            try {
                tBehaviour.validateParameters(this.mGateData, (IRedstoneCircuitBlock)this);
            }
            catch (Throwable e) {
                GT_Log.err.print(e);
            }
        }
    }

    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        this.getBaseMetaTileEntity().setGenericRedstoneOutput(true);
        this.validateGateData();
    }

    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        this.getBaseMetaTileEntity().setGenericRedstoneOutput(true);
        if (this.getBaseMetaTileEntity().isAllowedToWork() && this.getBaseMetaTileEntity().isServerSide()) {
            this.mInventory[4] = null;
            this.mInventory[3] = null;
            this.mInventory[2] = null;
            this.mInventory[1] = null;
            this.mInventory[0] = null;
            if (this.getBaseMetaTileEntity().getUniversalEnergyStored() >= this.getMinimumStoredEU()) {
                GT_CircuitryBehavior tBehaviour;
                if (this.getBaseMetaTileEntity().isActive() && (tBehaviour = (GT_CircuitryBehavior)GregTech_API.sCircuitryBehaviors.get(this.mGate)) != null) {
                    try {
                        tBehaviour.onTick(this.mGateData, (IRedstoneCircuitBlock)this);
                        if (tBehaviour.displayItemStack(this.mGateData, (IRedstoneCircuitBlock)this, 0)) {
                            this.mInventory[1] = GT_MetaTileEntity_RedstoneCircuitBlock.getCoverByID(this.mGateData[0]);
                        }
                        if (tBehaviour.displayItemStack(this.mGateData, (IRedstoneCircuitBlock)this, 1)) {
                            this.mInventory[2] = GT_MetaTileEntity_RedstoneCircuitBlock.getCoverByID(this.mGateData[1]);
                        }
                        if (tBehaviour.displayItemStack(this.mGateData, (IRedstoneCircuitBlock)this, 2)) {
                            this.mInventory[3] = GT_MetaTileEntity_RedstoneCircuitBlock.getCoverByID(this.mGateData[2]);
                        }
                        if (tBehaviour.displayItemStack(this.mGateData, (IRedstoneCircuitBlock)this, 3)) {
                            this.mInventory[4] = GT_MetaTileEntity_RedstoneCircuitBlock.getCoverByID(this.mGateData[3]);
                        }
                    }
                    catch (Throwable e) {
                        GT_Log.err.print(e);
                    }
                }
                this.getBaseMetaTileEntity().setErrorDisplayID(0);
            } else {
                this.getBaseMetaTileEntity().setErrorDisplayID(1);
            }
        }
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (!this.getBaseMetaTileEntity().isServerSide()) {
            return;
        }
        for (byte i = 0; i < 6; i = (byte)(i + 1)) {
            byte aRedstone = this.getBaseMetaTileEntity().getOutputRedstoneSignal(i);
            this.getBaseMetaTileEntity().setInternalOutputRedstoneSignal(i, aRedstone);
        }
    }

    @Override
    public final boolean hasRedstoneSignal() {
        for (byte i = 0; i < 6; i = (byte)(i + 1)) {
            if (this.getBaseMetaTileEntity().getOutputRedstoneSignal(i) <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean allowGeneralRedstoneOutput() {
        return true;
    }

    private static void initCovers() {
        for (GT_ItemStack aKey : GregTech_API.sCovers.keySet()) {
            ItemStack aStack = aKey.toStack().func_77946_l();
            if (aStack == null) continue;
            sCoversItems.put(GT_Utility.stackToInt((ItemStack)aStack), aStack);
        }
    }

    public static ItemStack getCoverByID(int aStack) {
        if (sCoversItems.isEmpty()) {
            GT_MetaTileEntity_RedstoneCircuitBlock.initCovers();
        }
        return sCoversItems.get(aStack);
    }

    public byte getOutputFacing() {
        return this.getBaseMetaTileEntity().getBackFacing();
    }

    public boolean setRedstone(byte aStrength, byte aSide) {
        if (this.getOutputRedstone(aSide) != aStrength) {
            if (this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(1L, false)) {
                this.getBaseMetaTileEntity().setInternalOutputRedstoneSignal(aSide, aStrength);
                this.getBaseMetaTileEntity().setErrorDisplayID(0);
                return true;
            }
            this.getBaseMetaTileEntity().setErrorDisplayID(1);
            return false;
        }
        return false;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public byte getOutputRedstone(byte aSide) {
        return this.getBaseMetaTileEntity().getOutputRedstoneSignal(aSide);
    }

    public byte getInputRedstone(byte aSide) {
        return this.getBaseMetaTileEntity().getInternalInputRedstoneSignal(aSide);
    }

    public Block getBlockAtSide(byte aSide) {
        return this.getBaseMetaTileEntity().getBlockAtSide(aSide);
    }

    public byte getMetaIDAtSide(byte aSide) {
        return this.getBaseMetaTileEntity().getMetaIDAtSide(aSide);
    }

    public TileEntity getTileEntityAtSide(byte aSide) {
        return this.getBaseMetaTileEntity().getTileEntityAtSide(aSide);
    }

    public int getRandom(int aRange) {
        return this.getBaseMetaTileEntity().getRandomNumber(aRange);
    }

    public GT_CoverBehavior getCover(byte aSide) {
        return this.getBaseMetaTileEntity().getCoverBehaviorAtSide(aSide);
    }

    public int getCoverID(byte aSide) {
        return this.getBaseMetaTileEntity().getCoverIDAtSide(aSide);
    }

    public int getCoverVariable(byte aSide) {
        return this.getBaseMetaTileEntity().getCoverDataAtSide(aSide);
    }

    public ICoverable getOwnTileEntity() {
        return this.getBaseMetaTileEntity();
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[10][17][];
        for (byte i = -1; i < 16; i = (byte)(i + 1)) {
            rTextures[0][i + 1] = this.getSides(i);
            rTextures[1][i + 1] = this.getBack(i);
            rTextures[2][i + 1] = this.getBottom(i);
            rTextures[3][i + 1] = this.getTop(i);
            rTextures[4][i + 1] = this.getSides(i);
            rTextures[5][i + 1] = this.getSidesActive(i);
            rTextures[6][i + 1] = this.getBackActive(i);
            rTextures[7][i + 1] = this.getBottomActive(i);
            rTextures[8][i + 1] = this.getTopActive(i);
            rTextures[9][i + 1] = this.getSidesActive(i);
        }
        return rTextures;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        return this.mTextures[(aActive || this.hasRedstoneSignal() ? 5 : 0) + (aSide == aFacing ? 0 : (aSide == GT_Utility.getOppositeSide((int)aFacing) ? 1 : (aSide == 0 ? 2 : (aSide == 1 ? 3 : 4))))][aColorIndex + 1];
    }

    private GT_RenderedTexture getBase() {
        return new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Simple_Top);
    }

    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{this.getBase(), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Redstone_Top_Off)};
    }

    public ITexture[] getTopActive(byte aColor) {
        return new ITexture[]{this.getBase(), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Redstone_Top_On)};
    }

    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{this.getBase(), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Redstone_Side_Off), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_InventoryManagaer_Red)};
    }

    public ITexture[] getBackActive(byte aColor) {
        return new ITexture[]{this.getBase(), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Redstone_Side_On), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_InventoryManagaer_Red_Redstone)};
    }

    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{this.getBase(), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Redstone_Bottom_Off)};
    }

    public ITexture[] getBottomActive(byte aColor) {
        return new ITexture[]{this.getBase(), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Redstone_Bottom_On)};
    }

    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{this.getBase(), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Redstone_Side_Off)};
    }

    public ITexture[] getSidesActive(byte aColor) {
        return new ITexture[]{this.getBase(), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Redstone_Side_On)};
    }

    public boolean useModularUI() {
        return true;
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        int index;
        int i;
        builder.widget(new DrawableWidget().setDrawable((IDrawable)GTPP_UITextures.PICTURE_REDSTONE_CIRCUIT_SCREEN).setPos(43, 5).setSize(108, 72));
        for (i = 0; i < 4; ++i) {
            index = i;
            ((ModularWindow.Builder)builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
                ItemStack tStack = widget.getContext().getPlayer().field_71071_by.func_70445_o();
                if (tStack == null) {
                    this.changeGateData(index, clickData.mouseButton == 0 ? (clickData.shift ? 128 : 1) : (clickData.shift ? -128 : -1));
                } else {
                    tStack = GT_Utility.copy((Object[])new Object[]{tStack});
                    if (clickData.mouseButton != 0) {
                        tStack.func_77964_b(Short.MAX_VALUE);
                    }
                    this.stackGateData(index, tStack);
                }
            }).setBackground(new IDrawable[]{GT_UITextures.BUTTON_STANDARD, GTPP_UITextures.OVERLAY_BUTTON_PLUS_MINUS}).setPos(7, 5 + i * 18).setSize(18, 18))).widget(SlotWidget.phantom((IItemHandlerModifiable)this.inventoryHandler, (int)(i + 1)).disableInteraction().setPos(25, 5 + i * 18));
        }
        ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new CycleButtonWidget().setToggle(() -> this.bOutput, val -> {
            this.bOutput = val;
        }).setVariableBackground(new UITexture[]{GT_UITextures.BUTTON_STANDARD_TOGGLE}).setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_EMIT_ENERGY).addTooltip("Toggle EU Output").setPos(151, 5).setSize(18, 18))).widget(new CycleButtonWidget().setToggle(() -> this.getBaseMetaTileEntity().isActive(), val -> this.getBaseMetaTileEntity().setActive(val.booleanValue())).setVariableBackground(new UITexture[]{GT_UITextures.BUTTON_STANDARD_TOGGLE}).setStaticTexture((IDrawable)GTPP_UITextures.OVERLAY_BUTTON_ACTIVE_STATE).addTooltip("Toggle Active State").setPos(151, 23).setSize(18, 18))).widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (clickData.mouseButton == 0) {
                this.switchGateForward(clickData.shift);
            } else {
                this.switchGateBackward(clickData.shift);
            }
        }).setBackground(new IDrawable[]{GT_UITextures.BUTTON_STANDARD, GTPP_UITextures.OVERLAY_BUTTON_CHANGE_MODE}).addTooltip("Change Redstone Circuit").setPos(151, 41).setSize(18, 18));
        builder.widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.mGate, val -> {
            this.mGate = val;
        }));
        i = 0;
        while (i < this.mGateData.length) {
            index = i++;
            builder.widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.mGateData[index], val -> {
                this.mGateData[index] = val;
            }));
        }
        ((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable(() -> {
            if (this.getBaseMetaTileEntity().getErrorDisplayID() > 0) {
                if (this.getBaseMetaTileEntity().getTimer() / 5L % 2L == 0L) {
                    return GTPP_UITextures.PICTURE_ELECTRICITY_ERROR;
                }
                return null;
            }
            return GTPP_UITextures.PICTURE_ELECTRICITY_FINE;
        }).setPos(140, 9).setSize(7, 7))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.getBaseMetaTileEntity().getErrorDisplayID(), val -> this.getBaseMetaTileEntity().setErrorDisplayID(val.intValue())));
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(TextWidget.dynamicString(() -> {
            GT_CircuitryBehavior tCircuit = (GT_CircuitryBehavior)GregTech_API.sCircuitryBehaviors.get(this.mGate);
            if (tCircuit != null) {
                return tCircuit.getName();
            }
            return "";
        }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(46, 8))).widget(TextWidget.dynamicString(() -> {
            GT_CircuitryBehavior tCircuit = (GT_CircuitryBehavior)GregTech_API.sCircuitryBehaviors.get(this.mGate);
            if (tCircuit != null) {
                return tCircuit.getDescription();
            }
            return "";
        }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(46, 19))).widget(TextWidget.dynamicString(() -> {
            GT_CircuitryBehavior tCircuit = (GT_CircuitryBehavior)GregTech_API.sCircuitryBehaviors.get(this.mGate);
            if (tCircuit != null) {
                return tCircuit.getDataDescription(this.mGateData, 0);
            }
            return "";
        }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(46, 33))).widget(TextWidget.dynamicString(() -> {
            GT_CircuitryBehavior tCircuit = (GT_CircuitryBehavior)GregTech_API.sCircuitryBehaviors.get(this.mGate);
            if (tCircuit != null) {
                return tCircuit.getDataDescription(this.mGateData, 1);
            }
            return "";
        }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(46, 44))).widget(TextWidget.dynamicString(() -> {
            GT_CircuitryBehavior tCircuit = (GT_CircuitryBehavior)GregTech_API.sCircuitryBehaviors.get(this.mGate);
            if (tCircuit != null) {
                return tCircuit.getDataDescription(this.mGateData, 2);
            }
            return "";
        }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(46, 55))).widget(TextWidget.dynamicString(() -> {
            GT_CircuitryBehavior tCircuit = (GT_CircuitryBehavior)GregTech_API.sCircuitryBehaviors.get(this.mGate);
            if (tCircuit != null) {
                return tCircuit.getDataDescription(this.mGateData, 3);
            }
            return "";
        }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(46, 66))).widget(TextWidget.dynamicString(() -> {
            GT_CircuitryBehavior tCircuit = (GT_CircuitryBehavior)GregTech_API.sCircuitryBehaviors.get(this.mGate);
            if (tCircuit != null) {
                String tString = tCircuit.getDataDisplay(this.mGateData, 0);
                return tString == null ? GT_Utility.parseNumberToString((int)this.mGateData[0]) : tString;
            }
            return "";
        }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(99, 33))).widget(TextWidget.dynamicString(() -> {
            GT_CircuitryBehavior tCircuit = (GT_CircuitryBehavior)GregTech_API.sCircuitryBehaviors.get(this.mGate);
            if (tCircuit != null) {
                String tString = tCircuit.getDataDisplay(this.mGateData, 1);
                return tString == null ? GT_Utility.parseNumberToString((int)this.mGateData[1]) : tString;
            }
            return "";
        }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(99, 44))).widget(TextWidget.dynamicString(() -> {
            GT_CircuitryBehavior tCircuit = (GT_CircuitryBehavior)GregTech_API.sCircuitryBehaviors.get(this.mGate);
            if (tCircuit != null) {
                String tString = tCircuit.getDataDisplay(this.mGateData, 2);
                return tString == null ? GT_Utility.parseNumberToString((int)this.mGateData[2]) : tString;
            }
            return "";
        }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(99, 55))).widget(TextWidget.dynamicString(() -> {
            GT_CircuitryBehavior tCircuit = (GT_CircuitryBehavior)GregTech_API.sCircuitryBehaviors.get(this.mGate);
            if (tCircuit != null) {
                String tString = tCircuit.getDataDisplay(this.mGateData, 3);
                return tString == null ? GT_Utility.parseNumberToString((int)this.mGateData[3]) : tString;
            }
            return "";
        }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(99, 66));
    }
}

