/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.common.helpers.FlotationRecipeHandler;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class GregtechMTE_FrothFlotationCell
extends GregtechMeta_MultiBlockBase<GregtechMTE_FrothFlotationCell>
implements ISurvivalConstructable {
    private int mCasing;
    private static IStructureDefinition<GregtechMTE_FrothFlotationCell> STRUCTURE_DEFINITION = null;
    private String lockedMaterialName = null;

    public GregtechMTE_FrothFlotationCell(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMTE_FrothFlotationCell(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMTE_FrothFlotationCell(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Flotation Cell";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Process that milled ore!").addInfo("You can only ever process one type of material per controller").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(7, 9, 7, true).addController("Front Center").addCasingInfo("Inconel Reinforced Casing", 68).addCasingInfo("Flotation Casing", 52).addInputBus("Bottom Casing", new int[]{1}).addInputHatch("Bottom Casing", new int[]{1}).addOutputHatch("Bottom Casing", new int[]{1}).addEnergyHatch("Bottom Casing", new int[]{1}).addMaintenanceHatch("Bottom Casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder.get());
        return tt;
    }

    @Override
    public String getSound() {
        return (String)GregTech_API.sSoundList.get(207);
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Default_Active;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Default;
    }

    @Override
    protected int getCasingTextureId() {
        return TAE.getIndexFromPage(2, 1);
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GTPP_Recipe.GTPP_Recipe_Map.sFlotationCellRecipes;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 1;
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 0;
    }

    public IStructureDefinition<GregtechMTE_FrothFlotationCell> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, (String[][])new String[][]{{"       ", "       ", "   X   ", "  X~X  ", "   X   ", "       ", "       "}, {"       ", "   F   ", "  FFF  ", " FF FF ", "  FFF  ", "   F   ", "       "}, {"       ", "   F   ", "  F F  ", " F   F ", "  F F  ", "   F   ", "       "}, {"       ", "   F   ", "  F F  ", " F   F ", "  F F  ", "   F   ", "       "}, {"       ", "   F   ", "  F F  ", " F   F ", "  F F  ", "   F   ", "       "}, {"       ", "   F   ", "  F F  ", " F   F ", "  F F  ", "   F   ", "       "}, {"       ", "   F   ", "  F F  ", " F   F ", "  F F  ", "   F   ", "       "}, {"  CCC  ", " CCCCC ", "CCCCCCC", "CCCCCCC", "CCCCCCC", " CCCCC ", "  CCC  "}, {"  CCC  ", " CCCCC ", "CCCCCCC", "CCCCCCC", "CCCCCCC", " CCCCC ", "  CCC  "}}).addElement('C', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMTE_FrothFlotationCell.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch, GT_HatchElement.Maintenance, GT_HatchElement.Energy}).casingIndex(this.getCasingTextureId()).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings3Misc, (int)1))})).addElement('F', StructureUtility.ofBlock((Block)ModBlocks.blockSpecialMultiCasings, (int)9)).addElement('X', StructureUtility.ofBlock((Block)ModBlocks.blockCasings3Misc, (int)1)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 3, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 3, 3, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 3, 3, 0) && this.mCasing >= 64 && this.checkHatch();
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiFrothFlotationCell;
    }

    @Override
    public int getAmountOfOutputs() {
        return 1;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (this.getBaseMetaTileEntity().getFrontFacing() != 1) {
            this.log("Fixing Bad Facing. (GT Bug)");
            this.getBaseMetaTileEntity().setFrontFacing((byte)1);
        }
    }

    public boolean checkRecipe(ItemStack arg0) {
        return super.checkRecipeGeneric();
    }

    @Override
    public boolean checkRecipeGeneric(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, int aMaxParallelRecipes, long aEUPercent, int aSpeedBonusPercent, int aOutputChanceRoll, GT_Recipe aRecipe) {
        GT_Recipe tRecipe;
        this.lEUt = 0L;
        this.mMaxProgresstime = 0;
        this.mOutputItems = new ItemStack[0];
        this.mOutputFluids = new FluidStack[0];
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
        this.mLastRecipe = tRecipe = this.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.mLastRecipe, false, GT_Values.V[tTier], aFluidInputs, aItemInputs);
        if (tRecipe == null) {
            return false;
        }
        Material foundMaterial = FlotationRecipeHandler.getMaterialOfMilledProduct(FlotationRecipeHandler.findMilledStack(tRecipe));
        String foundMaterialName = null;
        if (foundMaterial != null) {
            foundMaterialName = foundMaterial.getUnlocalizedName();
        }
        if (foundMaterialName == null) {
            return false;
        }
        if (this.lockedMaterialName == null) {
            this.lockedMaterialName = foundMaterialName;
        }
        if (!Objects.equals(this.lockedMaterialName, foundMaterialName)) {
            return false;
        }
        return super.checkRecipeGeneric(aItemInputs, aFluidInputs, aMaxParallelRecipes, aEUPercent, aSpeedBonusPercent, aOutputChanceRoll, tRecipe);
    }

    public void setItemNBT(NBTTagCompound aNBT) {
        if (this.lockedMaterialName != null) {
            aNBT.func_74778_a("lockedMaterialName", this.lockedMaterialName);
        }
        super.setItemNBT(aNBT);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        if (this.lockedMaterialName != null) {
            aNBT.func_74778_a("lockedMaterialName", this.lockedMaterialName);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_150297_b("lockedMaterialName", 8)) {
            this.lockedMaterialName = aNBT.func_74779_i("lockedMaterialName");
        }
    }

    @Override
    public String[] getExtraInfoData() {
        return new String[]{"Locked material: " + this.lockedMaterialName};
    }

    protected boolean isRecipeLockingEnabled() {
        return this.lockedMaterialName != null && !this.lockedMaterialName.equals("");
    }
}

