/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing.advanced;

import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.block.base.BasicBlock;
import gtPlusPlus.core.block.base.BlockBaseModular;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.material.ALLOY;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GregtechMetaTileEntity_Adv_HeatExchanger
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_Adv_HeatExchanger> {
    private static final int CASING_INDEX = TAE.getIndexFromPage(1, 12);
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<GregtechMetaTileEntity_Adv_HeatExchanger> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{" ccc ", "cCCCc", "cCCCc", "cCCCc", " ccc "}, {" ccc ", "cPPPc", "cPPPc", "cPPPc", " ccc "}, {" ccc ", "cPPPc", "cPPPc", "cPPPc", " ccc "}, {" ccc ", "cPPPc", "cPPPc", "cPPPc", " ccc "}, {" ccc ", "cPPPc", "cPPPc", "cPPPc", " ccc "}, {" c~c ", "cPPPc", "cPPPc", "cPPPc", " ccc "}, {" hhh ", "hHHHh", "hHHHh", "hHHHh", " hhh "}, {" f f ", "f   f", "     ", "f   f", " f f "}, {" f f ", "f   f", "     ", "f   f", " f f "}})).addElement('P', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)15)).addElement('f', StructureUtility.ofBlock((Block)GregtechMetaTileEntity_Adv_HeatExchanger.getFrame(), (int)0)).addElement('C', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GregtechMetaTileEntity_Adv_HeatExchanger::addColdFluidOutputToMachineList, (int)CASING_INDEX, (int)2), StructureUtility.onElementPass(GregtechMetaTileEntity_Adv_HeatExchanger::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockSpecialMultiCasings, (int)14))})).addElement('H', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GregtechMetaTileEntity_Adv_HeatExchanger::addHotFluidInputToMachineList, (int)CASING_INDEX, (int)3), StructureUtility.onElementPass(GregtechMetaTileEntity_Adv_HeatExchanger::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockSpecialMultiCasings, (int)14))})).addElement('h', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GregtechMeta_MultiBlockBase::addInputToMachineList, (int)CASING_INDEX, (int)1), GT_StructureUtility.ofHatchAdder(GregtechMeta_MultiBlockBase::addOutputToMachineList, (int)CASING_INDEX, (int)1), GT_StructureUtility.ofHatchAdder(GregtechMeta_MultiBlockBase::addMaintenanceToMachineList, (int)CASING_INDEX, (int)1), StructureUtility.onElementPass(GregtechMetaTileEntity_Adv_HeatExchanger::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockSpecialMultiCasings, (int)14))})).addElement('c', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onElementPass(GregtechMetaTileEntity_Adv_HeatExchanger::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockSpecialMultiCasings, (int)14))})).build();
    public static float penalty_per_config = 0.015f;
    private GT_MetaTileEntity_Hatch_Input mInputHotFluidHatch;
    private GT_MetaTileEntity_Hatch_Output mOutputColdFluidHatch;
    private boolean superheated = false;
    private int superheated_threshold = 0;
    private float water;
    private int mCasingAmount;
    private static Block sFrame;

    public GregtechMetaTileEntity_Adv_HeatExchanger(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_Adv_HeatExchanger(String aName) {
        super(aName);
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the XL Heat Exchanger").addInfo("More complicated than a Fusion Reactor. Seriously").addInfo("But you know this by now, right?").addInfo("Works as fast as 16 Large Heat Exchangers").addSeparator().addInfo("Inputs are Hot Coolant or Lava").addInfo("Outputs Coolant or Pahoehoe Lava and SH Steam/Steam").addInfo("Outputs SH Steam if input flow is equal to or above a certain value:").addInfo("Hot Coolant: 12,800 L/s, maximum 25,600 EU/t, max output 6,400,000 SH Steam/s").addInfo("Lava: 16,000 L/s, maximum 32,000 EU/t, max output 2,560,000 SH Steam/s").addInfo("A circuit in the controller lowers the SH Steam threshold and efficiency").addInfo("2400 L/s reduction and 1.5% efficiency loss per circuit config over 1").addSeparator().beginStructureBlock(5, 9, 5, false).addController("Front bottom").addCasingInfo("Reinforced Heat Exchanger Casing", 90).addOtherStructurePart("Tungstensteel Pipe Casing", "Center 3x5x3 (45 blocks)").addMaintenanceHatch("Any casing", new int[]{1}).addInputHatch("Hot fluid, bottom center", new int[]{2}).addInputHatch("Distilled water, any bottom layer casing", new int[]{1}).addOutputHatch("Cold fluid, top center", new int[]{3}).addOutputHatch("Steam/SH Steam, any bottom layer casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder.get());
        return tt;
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.superheated = aNBT.func_74767_n("superheated");
        super.loadNBTData(aNBT);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74757_a("superheated", this.superheated);
        super.saveNBTData(aNBT);
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced;
    }

    @Override
    protected int getCasingTextureId() {
        return CASING_INDEX;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> !r.isUpsideDown() && !f.isVerticallyFliped();
    }

    public boolean checkRecipe(ItemStack aStack) {
        int circuit_config;
        if (this.mInputHotFluidHatch.getFluid() == null) {
            return true;
        }
        int fluidAmountToConsume = this.mInputHotFluidHatch.getFluidAmount();
        this.superheated_threshold = 128000;
        float efficiency = 1.0f;
        int shs_reduction_per_config = 4800;
        float steam_output_multiplier = 20.0f;
        float penalty = 0.0f;
        boolean do_lava = false;
        if (this.mInventory[1] != null && this.mInventory[1].func_77977_a().startsWith("gt.integrated_circuit") && (circuit_config = this.mInventory[1].func_77960_j()) >= 1 && circuit_config <= 25) {
            penalty = (float)(circuit_config - 1) * penalty_per_config;
            this.superheated_threshold -= shs_reduction_per_config * (circuit_config - 1);
        }
        efficiency -= penalty;
        if (GT_ModHandler.isLava((FluidStack)this.mInputHotFluidHatch.getFluid())) {
            steam_output_multiplier /= 5.0f;
            this.superheated_threshold = (int)((float)this.superheated_threshold / 4.0f);
            do_lava = true;
        } else if (this.mInputHotFluidHatch.getFluid().isFluidEqual(FluidRegistry.getFluidStack((String)"ic2hotcoolant", (int)1))) {
            steam_output_multiplier /= 2.0f;
            this.superheated_threshold = (int)((float)this.superheated_threshold / 5.0f);
        } else {
            this.superheated_threshold = 0;
            return false;
        }
        this.superheated = fluidAmountToConsume >= this.superheated_threshold;
        fluidAmountToConsume = Math.min(fluidAmountToConsume, this.superheated_threshold * 2);
        this.mInputHotFluidHatch.drain(fluidAmountToConsume, true);
        this.mMaxProgresstime = 20;
        this.lEUt = (long)((float)fluidAmountToConsume * steam_output_multiplier * efficiency);
        if (do_lava) {
            this.mOutputColdFluidHatch.fill(FluidRegistry.getFluidStack((String)"ic2pahoehoelava", (int)fluidAmountToConsume), true);
        } else {
            this.mOutputColdFluidHatch.fill(FluidRegistry.getFluidStack((String)"ic2coolant", (int)fluidAmountToConsume), true);
        }
        this.mEfficiencyIncrease = 80;
        return true;
    }

    private int useWater(float input) {
        this.water += input;
        int usage = (int)this.water;
        this.water -= (float)usage;
        return usage;
    }

    public boolean onRunningTick(ItemStack aStack) {
        if (this.lEUt > 0L) {
            int tGeneratedEU = (int)(this.lEUt * 2L * (long)this.mEfficiency / 10000L);
            if (tGeneratedEU > 0) {
                int distilledConsumed;
                FluidStack distilledStack;
                if (this.superheated) {
                    tGeneratedEU /= 2;
                }
                if (this.depleteInput(distilledStack = GT_ModHandler.getDistilledWater((long)(distilledConsumed = this.useWater((float)tGeneratedEU / 160.0f))))) {
                    if (this.superheated) {
                        this.addOutput(FluidRegistry.getFluidStack((String)"ic2superheatedsteam", (int)tGeneratedEU));
                    } else {
                        this.addOutput(GT_ModHandler.getSteam((long)tGeneratedEU));
                    }
                } else {
                    GT_Log.exp.println(this.mName + " had no more Distilled water!");
                    this.explodeMultiblock();
                }
            }
            return true;
        }
        return true;
    }

    public IStructureDefinition<GregtechMetaTileEntity_Adv_HeatExchanger> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    private void onCasingAdded() {
        ++this.mCasingAmount;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mOutputColdFluidHatch = null;
        this.mInputHotFluidHatch = null;
        this.mCasingAmount = 0;
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 2, 5, 0) && this.mCasingAmount >= 90 && this.mMaintenanceHatches.size() == 1;
    }

    public boolean addColdFluidOutputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            this.mOutputColdFluidHatch = (GT_MetaTileEntity_Hatch_Output)aMetaTileEntity;
            return true;
        }
        return false;
    }

    public boolean addHotFluidInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
            this.mInputHotFluidHatch = (GT_MetaTileEntity_Hatch_Input)aMetaTileEntity;
            return true;
        }
        return false;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_Adv_HeatExchanger(this.mName);
    }

    @Override
    public boolean isGivingInformation() {
        return super.isGivingInformation();
    }

    @Override
    public String[] getExtraInfoData() {
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers((long)(this.mProgresstime / 20)) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((long)(this.mMaxProgresstime / 20)) + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + " " + StatCollector.func_74838_a((String)"GT5U.LHE.steam") + ": " + (this.superheated ? EnumChatFormatting.RED : EnumChatFormatting.YELLOW) + GT_Utility.formatNumbers((long)(this.superheated ? -2L * this.lEUt : -this.lEUt)) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", StatCollector.func_74838_a((String)"GT5U.LHE.superheated") + ": " + (this.superheated ? EnumChatFormatting.RED : EnumChatFormatting.BLUE) + this.superheated + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.LHE.superheated") + " " + StatCollector.func_74838_a((String)"GT5U.LHE.threshold") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers((long)this.superheated_threshold) + EnumChatFormatting.RESET};
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 2, 5, 0);
    }

    @Override
    public String getMachineType() {
        return "Heat Exchanger";
    }

    @Override
    public int getMaxParallelRecipes() {
        return 0;
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 0;
    }

    public static Block getFrame() {
        if (sFrame == null) {
            sFrame = BlockBaseModular.getMaterialBlock(ALLOY.TALONITE, BasicBlock.BlockTypes.FRAME);
        }
        return sFrame;
    }
}

