/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class GregtechMetaTileEntity_IndustrialMacerator
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_IndustrialMacerator>
implements ISurvivalConstructable {
    private int mCasing;
    private int mPerLayer;
    private static IStructureDefinition<GregtechMetaTileEntity_IndustrialMacerator> STRUCTURE_DEFINITION = null;

    public GregtechMetaTileEntity_IndustrialMacerator(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_IndustrialMacerator(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_IndustrialMacerator(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Macerator/Pulverizer";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller block for the Industrial Maceration Stack").addInfo("60% faster than using single block machines of the same voltage").addInfo("Maximum of 8*tier parallels, LV = Tier 1, MV = Tier 2, etc.").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 6, 3, true).addController("Bottom center").addCasingInfo("Maceration Stack Casings", 26).addInputBus("Bottom casing", new int[]{1}).addEnergyHatch("Bottom casing", new int[]{1}).addMaintenanceHatch("Bottom casing", new int[]{1}).addOutputBus("One per layer except bottom layer", new int[]{2}).addMufflerHatch("Any casing except bottom layer", new int[]{2}).toolTipFinisher(CORE.GT_Tooltip_Builder.get());
        return tt;
    }

    public IStructureDefinition<GregtechMetaTileEntity_IndustrialMacerator> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName + "top", StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}})).addShape(this.mName + "mid", StructureUtility.transpose((String[][])new String[][]{{"CCC", "C-C", "CCC"}})).addShape(this.mName + "bottom", StructureUtility.transpose((String[][])new String[][]{{"B~B", "BBB", "BBB"}})).addElement('C', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_IndustrialMacerator.class).atLeast(new IHatchElement[]{GT_HatchElement.OutputBus}).shouldReject(t -> t.mPerLayer + 1 == t.mOutputBusses.size()).disallowOnly(new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN}).casingIndex(TAE.GTPP_INDEX(7)).dot(2).build(), GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_IndustrialMacerator.class).atLeast(new IHatchElement[]{GT_HatchElement.Energy, GT_HatchElement.Maintenance, GT_HatchElement.Muffler}).disallowOnly(new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN}).casingIndex(TAE.GTPP_INDEX(7)).dot(2).build(), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)7))})).addElement('B', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_IndustrialMacerator.class).atLeast(new IHatchElement[]{GT_HatchElement.Energy, GT_HatchElement.Maintenance, GT_HatchElement.InputBus}).disallowOnly(new ForgeDirection[]{ForgeDirection.UP}).casingIndex(TAE.GTPP_INDEX(7)).dot(2).build(), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)7))})).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName + "bottom", stackSize, hintsOnly, 1, 0, 0);
        this.buildPiece(this.mName + "mid", stackSize, hintsOnly, 1, 1, 0);
        this.buildPiece(this.mName + "mid", stackSize, hintsOnly, 1, 2, 0);
        this.buildPiece(this.mName + "mid", stackSize, hintsOnly, 1, 3, 0);
        this.buildPiece(this.mName + "mid", stackSize, hintsOnly, 1, 4, 0);
        this.buildPiece(this.mName + "top", stackSize, hintsOnly, 1, 5, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int built = this.survivialBuildPiece(this.mName + "bottom", stackSize, 1, 0, 0, elementBudget, env, false, true);
        this.mPerLayer = 0;
        if (built >= 0) {
            return built;
        }
        built = this.survivialBuildPiece(this.mName + "mid", stackSize, 1, 1, 0, elementBudget, env, false, true);
        this.mPerLayer = 1;
        if (built >= 0) {
            return built;
        }
        built = this.survivialBuildPiece(this.mName + "mid", stackSize, 1, 2, 0, elementBudget, env, false, true);
        if (built >= 0) {
            return built;
        }
        this.mPerLayer = 2;
        built = this.survivialBuildPiece(this.mName + "mid", stackSize, 1, 3, 0, elementBudget, env, false, true);
        if (built >= 0) {
            return built;
        }
        this.mPerLayer = 3;
        built = this.survivialBuildPiece(this.mName + "mid", stackSize, 1, 4, 0, elementBudget, env, false, true);
        if (built >= 0) {
            return built;
        }
        return this.survivialBuildPiece(this.mName + "top", stackSize, 1, 5, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        this.mPerLayer = 0;
        if (this.checkPiece(this.mName + "bottom", 1, 0, 0)) {
            while (this.mPerLayer < 4) {
                if (!this.checkPiece(this.mName + "mid", 1, this.mPerLayer + 1, 0) || this.mPerLayer + 1 != this.mOutputBusses.size()) {
                    return false;
                }
                ++this.mPerLayer;
            }
            return this.checkPiece(this.mName + "top", 1, 5, 0) && this.mOutputBusses.size() == 5 && this.mCasing >= 26 && this.checkHatch();
        }
        return false;
    }

    @Override
    public String getSound() {
        return (String)GregTech_API.sSoundList.get(201);
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_MatterFab_Active;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_MatterFab;
    }

    @Override
    protected int getCasingTextureId() {
        return TAE.GTPP_INDEX(7);
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sMaceratorRecipes;
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isClientSide() && aBaseMetaTileEntity.isActive() && aBaseMetaTileEntity.getFrontFacing() != 1 && aBaseMetaTileEntity.getCoverIDAtSide((byte)1) == 0 && !aBaseMetaTileEntity.getOpacityAtSide((byte)1)) {
            Random tRandom = aBaseMetaTileEntity.getWorld().field_73012_v;
            aBaseMetaTileEntity.getWorld().func_72869_a("smoke", (double)((float)aBaseMetaTileEntity.getXCoord() + 0.8f - tRandom.nextFloat() * 0.6f), (double)((float)aBaseMetaTileEntity.getYCoord() + 0.3f + tRandom.nextFloat() * 0.2f), (double)((float)aBaseMetaTileEntity.getZCoord() + 1.2f - tRandom.nextFloat() * 1.6f), 0.0, 0.0, 0.0);
        }
    }

    public boolean checkRecipe(ItemStack aStack) {
        return this.checkRecipeGeneric(this.getMaxParallelRecipes(), this.getEuDiscountForParallelism(), 60, 7500);
    }

    @Override
    protected boolean doesMachineBoostOutput() {
        return true;
    }

    @Override
    public int getMaxParallelRecipes() {
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
        return Math.max(1, 8 * tTier);
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 100;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiIndustrialMacerator;
    }

    @Override
    public int getAmountOfOutputs() {
        return 16;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public boolean isOverclockerUpgradable() {
        return true;
    }
}

