/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_ParallelHelper;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import team.chisel.carving.Carving;

public class GregtechMetaTileEntity_IndustrialChisel
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_IndustrialChisel>
implements ISurvivalConstructable {
    private int mCasing;
    private static IStructureDefinition<GregtechMetaTileEntity_IndustrialChisel> STRUCTURE_DEFINITION = null;
    private ItemStack mInputCache;
    private ItemStack mOutputCache;
    private GTPP_Recipe mCachedRecipe;
    private static String sChiselSound = null;

    public GregtechMetaTileEntity_IndustrialChisel(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_IndustrialChisel(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_IndustrialChisel(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Chisel";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Factory Grade Auto Chisel").addInfo("Target block goes in GUI slot").addInfo("If no target provided, firdt chisel result is used").addInfo("Speed: +200% | EU Usage: 75% | Parallel: Tier x 16").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 3, 3, true).addController("Front center").addCasingInfo("Sturdy Printer Casing", 10).addInputBus("Any casing", new int[]{1}).addOutputBus("Any casing", new int[]{1}).addEnergyHatch("Any casing", new int[]{1}).addMaintenanceHatch("Any casing", new int[]{1}).addMufflerHatch("Any casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder.get());
        return tt;
    }

    public IStructureDefinition<GregtechMetaTileEntity_IndustrialChisel> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"C~C", "C-C", "CCC"}, {"CCC", "CCC", "CCC"}})).addElement('C', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_IndustrialChisel.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.Maintenance, GT_HatchElement.Energy, GT_HatchElement.Muffler}).casingIndex(90).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings5Misc, (int)5))})).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 1, 1, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 1, 1, 0) && this.mCasing >= 10 && this.checkHatch();
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced;
    }

    @Override
    protected int getCasingTextureId() {
        return 90;
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return null;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    private boolean hasValidCache(ItemStack aStack, ItemStack aSpecialSlot, boolean aClearOnFailure) {
        if (this.mInputCache != null && this.mOutputCache != null && this.mCachedRecipe != null && GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)this.mInputCache) && GT_Utility.areStacksEqual((ItemStack)aSpecialSlot, (ItemStack)this.mOutputCache)) {
            return true;
        }
        if (aClearOnFailure) {
            this.mInputCache = null;
            this.mOutputCache = null;
            this.mCachedRecipe = null;
        }
        return false;
    }

    private void cacheItem(ItemStack aInputItem, ItemStack aOutputItem, GTPP_Recipe aRecipe) {
        this.mInputCache = aInputItem.func_77946_l();
        this.mOutputCache = aOutputItem.func_77946_l();
        this.mCachedRecipe = aRecipe;
    }

    private static boolean canBeMadeFrom(ItemStack from, ItemStack to) {
        List<ItemStack> results = GregtechMetaTileEntity_IndustrialChisel.getItemsForChiseling(from);
        for (ItemStack s : results) {
            if (s.func_77973_b() != to.func_77973_b() || s.func_77960_j() != to.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasChiselResults(ItemStack from) {
        List<ItemStack> results = GregtechMetaTileEntity_IndustrialChisel.getItemsForChiseling(from);
        return results.size() > 0;
    }

    private static List<ItemStack> getItemsForChiseling(ItemStack aStack) {
        return Carving.chisel.getItemsForChiseling(aStack);
    }

    private static ItemStack getChiselOutput(ItemStack aInput, ItemStack aTarget) {
        Object tOutput = null;
        tOutput = aTarget != null && GregtechMetaTileEntity_IndustrialChisel.canBeMadeFrom(aInput, aTarget) ? aTarget : (aTarget != null && !GregtechMetaTileEntity_IndustrialChisel.canBeMadeFrom(aInput, aTarget) ? null : GregtechMetaTileEntity_IndustrialChisel.getItemsForChiseling(aInput).get(0));
        return tOutput;
    }

    private GTPP_Recipe generateChiselRecipe(ItemStack aInput, ItemStack aTarget) {
        boolean tIsCached = this.hasValidCache(aInput, aTarget, true);
        if (tIsCached || aInput != null && GregtechMetaTileEntity_IndustrialChisel.hasChiselResults(aInput)) {
            ItemStack tOutput;
            ItemStack itemStack = tOutput = tIsCached ? this.mOutputCache.func_77946_l() : GregtechMetaTileEntity_IndustrialChisel.getChiselOutput(aInput, aTarget);
            if (tOutput != null) {
                if (this.mCachedRecipe != null && GT_Utility.areStacksEqual((ItemStack)aInput, (ItemStack)this.mInputCache) && GT_Utility.areStacksEqual((ItemStack)tOutput, (ItemStack)this.mOutputCache)) {
                    return this.mCachedRecipe;
                }
                GTPP_Recipe aRecipe = new GTPP_Recipe(false, new ItemStack[]{ItemUtils.getSimpleStack(aInput, 1)}, new ItemStack[]{ItemUtils.getSimpleStack(tOutput, 1)}, null, new int[]{10000}, new FluidStack[0], new FluidStack[0], 20, 16, 0);
                this.cacheItem(aInput, tOutput, aRecipe);
                return aRecipe;
            }
        }
        return null;
    }

    public boolean checkRecipe(ItemStack aStack) {
        ArrayList aItems = this.getStoredInputs();
        if (!aItems.isEmpty()) {
            GTPP_Recipe tRecipe = this.generateChiselRecipe((ItemStack)aItems.get(0), this.getGUIItemStack());
            if (tRecipe == null) {
                return false;
            }
            ItemStack[] aItemInputs = aItems.toArray(new ItemStack[aItems.size()]);
            FluidStack[] aFluidInputs = new FluidStack[]{};
            this.lEUt = 0L;
            this.mMaxProgresstime = 0;
            this.mOutputItems = new ItemStack[0];
            this.mOutputFluids = new FluidStack[0];
            long tVoltage = this.getMaxInputVoltage();
            long tEnergy = this.getMaxInputEnergy();
            this.mLastRecipe = tRecipe;
            int aMaxParallelRecipes = this.getMaxParallelRecipes();
            int aEUPercent = this.getEuDiscountForParallelism();
            int aSpeedBonusPercent = 200;
            GT_ParallelHelper helper = new GT_ParallelHelper().setRecipe((GT_Recipe)tRecipe).setItemInputs(aItemInputs).setFluidInputs(aFluidInputs).setAvailableEUt(tEnergy).setMaxParallel(aMaxParallelRecipes).enableConsumption().enableOutputCalculation().setEUtModifier((float)aEUPercent / 100.0f);
            if (!this.voidExcess) {
                helper.enableVoidProtection((GT_MetaTileEntity_MultiBlockBase)this);
            }
            if (this.batchMode) {
                helper.enableBatchMode(128);
            }
            helper.build();
            if (helper.getCurrentParallel() == 0) {
                return false;
            }
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            GT_OverclockCalculator calculator = new GT_OverclockCalculator().setRecipeEUt((long)tRecipe.mEUt).setEUt(tEnergy).setDuration(tRecipe.mDuration).setEUtDiscount((float)aEUPercent / 100.0f).setSpeedBoost(100.0f / (100.0f + (float)aSpeedBonusPercent)).setParallel((int)Math.floor((float)helper.getCurrentParallel() / helper.getDurationMultiplier())).calculate();
            this.lEUt = -calculator.getConsumption();
            this.mMaxProgresstime = (int)Math.ceil((float)calculator.getDuration() * helper.getDurationMultiplier());
            this.mOutputItems = helper.getItemOutputs();
            this.mOutputFluids = helper.getFluidOutputs();
            this.updateSlots();
            this.startProcess();
            return true;
        }
        return false;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 16 * GT_Utility.getTier((long)this.getMaxInputVoltage());
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 75;
    }

    private static final String getChiselSound() {
        if (sChiselSound == null) {
            sChiselSound = Carving.chisel.getVariationSound(Blocks.field_150348_b, 0);
        }
        return sChiselSound;
    }

    @Override
    public String getSound() {
        return GregtechMetaTileEntity_IndustrialChisel.getChiselSound();
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiIndustrialChisel;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }
}

