/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_ParallelHelper;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GregtechMetaTileEntity_IndustrialAlloySmelter
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_IndustrialAlloySmelter>
implements ISurvivalConstructable {
    public static int CASING_TEXTURE_ID;
    private HeatingCoilLevel mHeatingCapacity;
    private int mLevel = 0;
    private int mCasing;
    private static IStructureDefinition<GregtechMetaTileEntity_IndustrialAlloySmelter> STRUCTURE_DEFINITION;

    public GregtechMetaTileEntity_IndustrialAlloySmelter(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        CASING_TEXTURE_ID = TAE.getIndexFromPage(2, 1);
    }

    public GregtechMetaTileEntity_IndustrialAlloySmelter(String aName) {
        super(aName);
        CASING_TEXTURE_ID = TAE.getIndexFromPage(2, 1);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_IndustrialAlloySmelter(this.mName);
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER_ACTIVE;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER;
    }

    @Override
    protected int getCasingTextureId() {
        return CASING_TEXTURE_ID;
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sAlloySmelterRecipes;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiIndustrialAlloySmelter;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public String getMachineType() {
        return "Alloy Smelter";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Industrial Alloy Smelter").addInfo("Gains one parallel per voltage tier").addInfo("Gains one multiplier per coil tier").addInfo("Parallel = Tier * Coil Tier").addInfo("Gains 5% speed bonus per coil tier").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 5, 3, true).addController("Bottom center").addCasingInfo("Inconel Reinforced Casings", 8).addCasingInfo("Integral Encasement V", 8).addCasingInfo("Heating Coils", 16).addInputBus("Any Inconel Reinforced Casing", new int[]{1}).addOutputBus("Any Inconel Reinforced Casing", new int[]{1}).addEnergyHatch("Any Inconel Reinforced Casing", new int[]{1}).addMaintenanceHatch("Any Inconel Reinforced Casing", new int[]{1}).addMufflerHatch("Any Inconel Reinforced Casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder.get());
        return tt;
    }

    public IStructureDefinition<GregtechMetaTileEntity_IndustrialAlloySmelter> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"HHH", "H-H", "HHH"}, {"VVV", "V-V", "VVV"}, {"HHH", "H-H", "HHH"}, {"C~C", "CCC", "CCC"}})).addElement('C', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_IndustrialAlloySmelter.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.Maintenance, GT_HatchElement.Energy, GT_HatchElement.Muffler}).casingIndex(CASING_TEXTURE_ID).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings3Misc, (int)1))})).addElement('H', GT_StructureUtility.ofCoil(GregtechMetaTileEntity_IndustrialAlloySmelter::setCoilLevel, GregtechMetaTileEntity_IndustrialAlloySmelter::getCoilLevel)).addElement('V', StructureUtility.ofBlock((Block)ModBlocks.blockCasingsTieredGTPP, (int)4)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 4, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 1, 3, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        this.mLevel = 0;
        this.setCoilLevel(HeatingCoilLevel.None);
        return this.checkPiece(this.mName, 1, 4, 0) && this.mCasing >= 8 && this.getCoilLevel() != HeatingCoilLevel.None && (this.mLevel = this.getCoilLevel().getTier() + 1) > 0 && this.checkHatch();
    }

    @Override
    public int getMaxParallelRecipes() {
        return this.mLevel * GT_Utility.getTier((long)this.getMaxInputVoltage());
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 100;
    }

    public boolean checkRecipe(ItemStack aStack) {
        FluidStack[] tFluids = this.getStoredFluids().toArray(new FluidStack[0]);
        for (GT_MetaTileEntity_Hatch_InputBus tBus : this.mInputBusses) {
            ItemStack[] tItems;
            ArrayList<ItemStack> tInputs = new ArrayList<ItemStack>();
            if (GregtechMetaTileEntity_IndustrialAlloySmelter.isValidMetaTileEntity((MetaTileEntity)tBus)) {
                for (int i = tBus.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                    if (tBus.getBaseMetaTileEntity().func_70301_a(i) == null) continue;
                    tInputs.add(tBus.getBaseMetaTileEntity().func_70301_a(i));
                }
            }
            if (tInputs.size() <= 1 || !this.checkRecipeGeneric(tItems = tInputs.toArray(new ItemStack[0]), tFluids, this.getMaxParallelRecipes(), 100L, 5 * this.mLevel, 10000)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean checkRecipeGeneric(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, int aMaxParallelRecipes, long aEUPercent, int aSpeedBonusPercent, int aOutputChanceRoll) {
        GT_Recipe tRecipe;
        this.lEUt = 0L;
        this.mMaxProgresstime = 0;
        this.mOutputItems = new ItemStack[0];
        this.mOutputFluids = new FluidStack[0];
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
        long tEnergy = this.getMaxInputEnergy();
        this.mLastRecipe = tRecipe = this.getRecipeMap().findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.mLastRecipe, false, GT_Values.V[tTier], aFluidInputs, aItemInputs);
        if (tRecipe == null) {
            Logger.WARNING("BAD RETURN - 1");
            return false;
        }
        GT_ParallelHelper helper = new GT_ParallelHelper().setRecipe(tRecipe).setItemInputs(aItemInputs).setFluidInputs(aFluidInputs).setAvailableEUt(tEnergy).setMaxParallel(aMaxParallelRecipes).enableConsumption().enableOutputCalculation().setEUtModifier((float)aEUPercent / 100.0f);
        if (!this.voidExcess) {
            helper.enableVoidProtection((GT_MetaTileEntity_MultiBlockBase)this);
        }
        if (this.batchMode) {
            helper.enableBatchMode(128);
        }
        helper.build();
        if (helper.getCurrentParallel() == 0) {
            return false;
        }
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        GT_OverclockCalculator calculator = new GT_OverclockCalculator().setRecipeEUt((long)tRecipe.mEUt).setEUt(tEnergy).setDuration(tRecipe.mDuration).setEUtDiscount((float)aEUPercent / 100.0f).setSpeedBoost(100.0f / (100.0f + (float)aSpeedBonusPercent)).setParallel((int)Math.floor((float)helper.getCurrentParallel() / helper.getDurationMultiplier())).enableHeatOC().setRecipeHeat(0).setMultiHeat((int)this.getCoilLevel().getHeat() * 2).calculate();
        this.lEUt = -calculator.getConsumption();
        this.mMaxProgresstime = (int)Math.ceil((float)calculator.getDuration() * helper.getDurationMultiplier());
        this.mOutputItems = helper.getItemOutputs();
        this.mOutputFluids = helper.getFluidOutputs();
        this.updateSlots();
        this.startProcess();
        return true;
    }

    public HeatingCoilLevel getCoilLevel() {
        return this.mHeatingCapacity;
    }

    public void setCoilLevel(HeatingCoilLevel aCoilLevel) {
        this.mHeatingCapacity = aCoilLevel;
    }

    static {
        STRUCTURE_DEFINITION = null;
    }
}

