/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.generators;

import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.SteamVariant;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.gui.modularui.GUITextureSet;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.generators.GregtechMetaSolarGenerator;

public class GregtechMetaTileEntitySolarGenerator
extends GregtechMetaSolarGenerator {
    ITexture[] SolarArray = new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.SOLARPANEL_8V), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.SOLARPANEL_LV), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.SOLARPANEL_MV), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.SOLARPANEL_HV), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.SOLARPANEL_EV), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.SOLARPANEL_IV), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.SOLARPANEL_LuV), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.SOLARPANEL_ZPM), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.SOLARPANEL_UV), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.SOLARPANEL)};

    public GregtechMetaTileEntitySolarGenerator(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, "Feasts on the power of the Sun!", new ITexture[0]);
        this.onConfigLoad();
    }

    public GregtechMetaTileEntitySolarGenerator(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
        this.onConfigLoad();
    }

    @Override
    public String[] getDescription() {
        return new String[]{this.mDescription, "Generates power at " + this.getEfficiency() + "% Efficiency per tick", "Output Voltage: " + this.getOutputTier() + " EU/t", CORE.GT_Tooltip.get()};
    }

    @Override
    public boolean isOutputFacing(byte aSide) {
        return aSide == this.getBaseMetaTileEntity().getFrontFacing();
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntitySolarGenerator(this.mName, this.mTier, this.mDescription, this.mTextures);
    }

    public void onConfigLoad() {
        this.mEfficiency = GregTech_API.sMachineFile.get((Object)ConfigCategories.machineconfig, "SunAbsorber.efficiency.tier." + this.mTier, 100 - this.mTier * 10);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.isAllowedToWork() && aBaseMetaTileEntity.getUniversalEnergyStored() < this.maxEUOutput() + aBaseMetaTileEntity.getEUCapacity()) {
            if (this.mSolarCharge <= 20) {
                this.mSolarCharge = 20;
                this.mLossTimer = 0;
            }
            if (++this.mLossTimer > 45) {
                --this.mSolarCharge;
                this.mLossTimer = 0;
            }
            if (aTick % 10L == 0L) {
                Logger.WARNING("getUniversalEnergyStored: " + aBaseMetaTileEntity.getUniversalEnergyStored() + "    maxEUOutput * 20 + getMinimumStoredEU: " + (this.maxEUOutput() * 20L + this.getMinimumStoredEU()));
                if (this.mSolarCharge > 100 && aBaseMetaTileEntity.isAllowedToWork() && !aBaseMetaTileEntity.getWorld().func_72911_I() && aBaseMetaTileEntity.getUniversalEnergyStored() < this.maxEUStore() - this.getMinimumStoredEU()) {
                    this.getBaseMetaTileEntity().increaseStoredEnergyUnits((long)(sEnergyPerTick * this.getEfficiency()), true);
                }
            }
            if (this.mSolarCharge < 500 && this.mProcessingEnergy != 0 && aTick % 32L == 0L) {
                Logger.WARNING("Adding Solar Charge. Currently " + this.mSolarCharge);
                --this.mProcessingEnergy;
                ++this.mSolarCharge;
            }
            if (this.mProcessingEnergy <= 0 && aBaseMetaTileEntity.isAllowedToWork() && aTick % 64L == 0L && !aBaseMetaTileEntity.getWorld().func_72911_I()) {
                boolean bRain;
                Logger.WARNING("Adding Processing Energy. Currently " + this.mProcessingEnergy);
                boolean bl = bRain = aBaseMetaTileEntity.getWorld().func_72896_J() && aBaseMetaTileEntity.getBiome().field_76751_G > 0.0f;
                this.mProcessingEnergy += bRain && aBaseMetaTileEntity.getWorld().field_73008_k >= 4 || !aBaseMetaTileEntity.getSkyAtSide((byte)1) ? 0 : (!bRain && aBaseMetaTileEntity.getWorld().func_72935_r() ? 8 : 1);
            }
            if (aBaseMetaTileEntity.isServerSide()) {
                aBaseMetaTileEntity.setActive(aBaseMetaTileEntity.isAllowedToWork() && aBaseMetaTileEntity.getUniversalEnergyStored() >= this.maxEUOutput() + this.getMinimumStoredEU());
            }
        }
    }

    public void inValidate() {
    }

    @Override
    public int getEfficiency() {
        return this.mEfficiency;
    }

    @Override
    public long maxEUStore() {
        return Math.max(this.getEUVar(), GT_Values.V[this.mTier] * 16000L + this.getMinimumStoredEU());
    }

    @Override
    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{super.getFront(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_MAGIC_FRONT), Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI[this.mTier]};
    }

    @Override
    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{super.getBack(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_MAGIC)};
    }

    @Override
    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{super.getBottom(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_MAGIC)};
    }

    @Override
    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{super.getTop(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.SOLARPANEL)};
    }

    @Override
    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{super.getSides(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_MAGIC)};
    }

    @Override
    public ITexture[] getFrontActive(byte aColor) {
        return new ITexture[]{super.getFrontActive(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_MAGIC_FRONT_ACTIVE), Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mTier]};
    }

    @Override
    public ITexture[] getBackActive(byte aColor) {
        return new ITexture[]{super.getBackActive(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_MAGIC_ACTIVE)};
    }

    @Override
    public ITexture[] getBottomActive(byte aColor) {
        return new ITexture[]{super.getBottomActive(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_MAGIC_ACTIVE)};
    }

    @Override
    public ITexture[] getTopActive(byte aColor) {
        return new ITexture[]{super.getTopActive(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.SOLARPANEL)};
    }

    @Override
    public ITexture[] getSidesActive(byte aColor) {
        return new ITexture[]{super.getSidesActive(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_MAGIC_ACTIVE)};
    }

    public SteamVariant getSteamVariant() {
        return SteamVariant.BRONZE;
    }

    public boolean useModularUI() {
        return true;
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new ProgressBar().setProgress(() -> Float.valueOf((float)this.mProcessingEnergy / 1000.0f)).setTexture(GT_UITextures.PROGRESSBAR_BOILER_EMPTY_STEAM.get(this.getSteamVariant()), GT_UITextures.PROGRESSBAR_BOILER_STEAM, 10).setDirection(ProgressBar.Direction.UP).setPos(70, 25).setSize(10, 54))).widget(new ProgressBar().setProgress(() -> Float.valueOf(this.getBaseMetaTileEntity().getStoredEU())).setTexture(GT_UITextures.PROGRESSBAR_BOILER_EMPTY_STEAM.get(this.getSteamVariant()), GT_UITextures.PROGRESSBAR_BOILER_WATER, 10).setDirection(ProgressBar.Direction.UP).setPos(83, 25).setSize(10, 54))).widget(new ProgressBar().setProgress(() -> Float.valueOf((float)this.mSolarCharge / (float)this.maxProgresstime())).setTexture(GT_UITextures.PROGRESSBAR_BOILER_EMPTY_STEAM.get(this.getSteamVariant()), GT_UITextures.PROGRESSBAR_BOILER_HEAT, 10).setDirection(ProgressBar.Direction.UP).setPos(96, 25).setSize(10, 54))).widget(new ProgressBar().setProgress(() -> Float.valueOf((float)this.mProcessingEnergy / 1000.0f)).setTexture(GT_UITextures.PROGRESSBAR_FUEL_STEAM.get(this.getSteamVariant()), 14).setDirection(ProgressBar.Direction.UP).setPos(116, 45).setSize(14, 14));
    }

    public GUITextureSet getGUITextureSet() {
        return new GUITextureSet().setMainBackground(GT_UITextures.BACKGROUND_STEAM.get(this.getSteamVariant())).setItemSlot(GT_UITextures.SLOT_ITEM_STEAM.get(this.getSteamVariant())).setCoverTab(GT_UITextures.TAB_COVER_STEAM_NORMAL.get(this.getSteamVariant()), GT_UITextures.TAB_COVER_STEAM_HIGHLIGHT.get(this.getSteamVariant()), GT_UITextures.TAB_COVER_STEAM_DISABLED.get(this.getSteamVariant())).setTitleTab(GT_UITextures.TAB_TITLE_STEAM.getAdaptable(this.getSteamVariant()), GT_UITextures.TAB_TITLE_DARK_STEAM.getAdaptable(this.getSteamVariant()), GT_UITextures.TAB_TITLE_ANGULAR_STEAM.getAdaptable(this.getSteamVariant())).setGregTechLogo(GT_UITextures.PICTURE_GT_LOGO_17x17_TRANSPARENT_STEAM.get(this.getSteamVariant()));
    }
}

