/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.world;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.common.blocks.GT_TileEntity_Ores;
import gregtech.loaders.misc.GT_Achievements;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.xmod.gregtech.HANDLER_GT;
import gtPlusPlus.xmod.gregtech.api.world.GTPP_Worldgen;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class GTPP_Worldgen_GT_Ore_Layer
extends GTPP_Worldgen {
    public static ArrayList<GTPP_Worldgen_GT_Ore_Layer> sList = new ArrayList();
    public static int sWeight = 0;
    public final short mMinY;
    public final short mMaxY;
    public final short mWeight;
    public final short mDensity;
    public final short mSize;
    public short mPrimaryMeta;
    public short mSecondaryMeta;
    public short mBetweenMeta;
    public short mSporadicMeta;
    public final String mRestrictBiome;
    public final boolean mDarkWorld;
    public final String aTextWorldgen = "worldgen.gtpp.";
    private Method mSetOre = null;

    public GTPP_Worldgen_GT_Ore_Layer(String aName, boolean aDefault, int aMinY, int aMaxY, int aWeight, int aDensity, int aSize, boolean aOverworld, Materials aPrimary, Materials aSecondary, Materials aBetween, Materials aSporadic) {
        super(aName, sList, aDefault);
        this.mDarkWorld = HANDLER_GT.sCustomWorldgenFile.get((Object)("worldgen.gtpp." + this.mWorldGenName), "Overworld", aOverworld);
        this.mMinY = (short)HANDLER_GT.sCustomWorldgenFile.get((Object)("worldgen.gtpp." + this.mWorldGenName), "MinHeight", aMinY);
        this.mMaxY = (short)Math.max(this.mMinY + 5, HANDLER_GT.sCustomWorldgenFile.get((Object)("worldgen.gtpp." + this.mWorldGenName), "MaxHeight", aMaxY));
        this.mWeight = (short)HANDLER_GT.sCustomWorldgenFile.get((Object)("worldgen.gtpp." + this.mWorldGenName), "RandomWeight", aWeight);
        this.mDensity = (short)HANDLER_GT.sCustomWorldgenFile.get((Object)("worldgen.gtpp." + this.mWorldGenName), "Density", aDensity);
        this.mSize = (short)Math.max(1, HANDLER_GT.sCustomWorldgenFile.get((Object)("worldgen.gtpp." + this.mWorldGenName), "Size", aSize));
        this.mPrimaryMeta = (short)HANDLER_GT.sCustomWorldgenFile.get((Object)("worldgen.gtpp." + this.mWorldGenName), "OrePrimaryLayer", aPrimary.mMetaItemSubID);
        this.mSecondaryMeta = (short)HANDLER_GT.sCustomWorldgenFile.get((Object)("worldgen.gtpp." + this.mWorldGenName), "OreSecondaryLayer", aSecondary.mMetaItemSubID);
        this.mBetweenMeta = (short)HANDLER_GT.sCustomWorldgenFile.get((Object)("worldgen.gtpp." + this.mWorldGenName), "OreSporadiclyInbetween", aBetween.mMetaItemSubID);
        this.mSporadicMeta = (short)HANDLER_GT.sCustomWorldgenFile.get((Object)("worldgen.gtpp." + this.mWorldGenName), "OreSporaticlyAround", aSporadic.mMetaItemSubID);
        this.mRestrictBiome = HANDLER_GT.sCustomWorldgenFile.get((Object)("worldgen.gtpp." + this.mWorldGenName), "RestrictToBiomeName", "None");
        if (this.mEnabled) {
            GT_Achievements.registerOre((Materials)GregTech_API.sGeneratedMaterials[this.mPrimaryMeta % 1000], (int)aMinY, (int)aMaxY, (int)aWeight, (boolean)false, (boolean)false, (boolean)false);
            GT_Achievements.registerOre((Materials)GregTech_API.sGeneratedMaterials[this.mSecondaryMeta % 1000], (int)aMinY, (int)aMaxY, (int)aWeight, (boolean)false, (boolean)false, (boolean)false);
            GT_Achievements.registerOre((Materials)GregTech_API.sGeneratedMaterials[this.mBetweenMeta % 1000], (int)aMinY, (int)aMaxY, (int)aWeight, (boolean)false, (boolean)false, (boolean)false);
            GT_Achievements.registerOre((Materials)GregTech_API.sGeneratedMaterials[this.mSporadicMeta % 1000], (int)aMinY, (int)aMaxY, (int)aWeight, (boolean)false, (boolean)false, (boolean)false);
            sWeight += this.mWeight;
        }
    }

    public GTPP_Worldgen_GT_Ore_Layer(String aName, boolean aDefault, int aMinY, int aMaxY, int aWeight, int aDensity, int aSize, Material aPrimary, Material aSecondary, Material aBetween, Material aSporadic) {
        super(aName, sList, aDefault);
        this.mDarkWorld = HANDLER_GT.sCustomWorldgenFile.get((Object)("worldgen.gtpp." + this.mWorldGenName), "Darkworld", true);
        this.mMinY = (short)HANDLER_GT.sCustomWorldgenFile.get((Object)("worldgen.gtpp." + this.mWorldGenName), "MinHeight", aMinY);
        this.mMaxY = (short)Math.max(this.mMinY + 5, HANDLER_GT.sCustomWorldgenFile.get((Object)("worldgen.gtpp." + this.mWorldGenName), "MaxHeight", aMaxY));
        this.mWeight = (short)HANDLER_GT.sCustomWorldgenFile.get((Object)("worldgen.gtpp." + this.mWorldGenName), "RandomWeight", aWeight);
        this.mDensity = (short)HANDLER_GT.sCustomWorldgenFile.get((Object)("worldgen.gtpp." + this.mWorldGenName), "Density", aDensity);
        this.mSize = (short)Math.max(1, HANDLER_GT.sCustomWorldgenFile.get((Object)("worldgen.gtpp." + this.mWorldGenName), "Size", aSize));
        this.mRestrictBiome = HANDLER_GT.sCustomWorldgenFile.get((Object)("worldgen.gtpp." + this.mWorldGenName), "RestrictToBiomeName", "None");
        if (this.mEnabled) {
            sWeight += this.mWeight;
        }
    }

    @Override
    public boolean executeWorldgen(World aWorld, Random aRandom, String aBiome, int aDimensionType, int aChunkX, int aChunkZ, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider) {
        int n;
        if (!this.mRestrictBiome.equals("None") && !this.mRestrictBiome.equals(aBiome)) {
            return false;
        }
        if (aDimensionType == -1) {
            // empty if block
        }
        if (aDimensionType == 0 && this.mDarkWorld) {
            n = aDimensionType;
        } else {
            if (aDimensionType == 1) {
                // empty if block
            }
            if (aWorld.field_73011_w.func_80007_l().equals("Moon")) {
                // empty if block
            }
            if (aWorld.field_73011_w.func_80007_l().equals("Mars")) {
                // empty if block
            }
            n = ~aDimensionType;
        }
        if (!this.isGenerationAllowed(aWorld, aDimensionType, n)) {
            return false;
        }
        int tMinY = this.mMinY + aRandom.nextInt(this.mMaxY - this.mMinY - 5);
        int cX = aChunkX - aRandom.nextInt(this.mSize);
        int eX = aChunkX + 16 + aRandom.nextInt(this.mSize);
        for (int tX = cX; tX <= eX; ++tX) {
            int cZ = aChunkZ - aRandom.nextInt(this.mSize);
            int eZ = aChunkZ + 16 + aRandom.nextInt(this.mSize);
            for (int tZ = cZ; tZ <= eZ; ++tZ) {
                int i;
                if (this.mSecondaryMeta > 0) {
                    for (i = tMinY - 1; i < tMinY + 2; ++i) {
                        if (aRandom.nextInt(Math.max(1, Math.max(MathHelper.func_76130_a((int)(cZ - tZ)), MathHelper.func_76130_a((int)(eZ - tZ))) / this.mDensity)) != 0 && aRandom.nextInt(Math.max(1, Math.max(MathHelper.func_76130_a((int)(cX - tX)), MathHelper.func_76130_a((int)(eX - tX))) / this.mDensity)) != 0) continue;
                        this.setOreBlock(aWorld, tX, i, tZ, this.mSecondaryMeta, false);
                    }
                }
                if (this.mBetweenMeta > 0 && (aRandom.nextInt(Math.max(1, Math.max(MathHelper.func_76130_a((int)(cZ - tZ)), MathHelper.func_76130_a((int)(eZ - tZ))) / this.mDensity)) == 0 || aRandom.nextInt(Math.max(1, Math.max(MathHelper.func_76130_a((int)(cX - tX)), MathHelper.func_76130_a((int)(eX - tX))) / this.mDensity)) == 0)) {
                    this.setOreBlock(aWorld, tX, tMinY + 2 + aRandom.nextInt(2), tZ, this.mBetweenMeta, false);
                }
                if (this.mPrimaryMeta > 0) {
                    for (i = tMinY + 3; i < tMinY + 6; ++i) {
                        if (aRandom.nextInt(Math.max(1, Math.max(MathHelper.func_76130_a((int)(cZ - tZ)), MathHelper.func_76130_a((int)(eZ - tZ))) / this.mDensity)) != 0 && aRandom.nextInt(Math.max(1, Math.max(MathHelper.func_76130_a((int)(cX - tX)), MathHelper.func_76130_a((int)(eX - tX))) / this.mDensity)) != 0) continue;
                        this.setOreBlock(aWorld, tX, i, tZ, this.mPrimaryMeta, false);
                    }
                }
                if (this.mSporadicMeta <= 0 || aRandom.nextInt(Math.max(1, Math.max(MathHelper.func_76130_a((int)(cZ - tZ)), MathHelper.func_76130_a((int)(eZ - tZ))) / this.mDensity)) != 0 && aRandom.nextInt(Math.max(1, Math.max(MathHelper.func_76130_a((int)(cX - tX)), MathHelper.func_76130_a((int)(eX - tX))) / this.mDensity)) != 0) continue;
                this.setOreBlock(aWorld, tX, tMinY - 1 + aRandom.nextInt(7), tZ, this.mSporadicMeta, false);
            }
        }
        if (GT_Values.D1) {
            System.out.println("Generated Orevein: " + this.mWorldGenName + " " + aChunkX + " " + aChunkZ);
        }
        return true;
    }

    private boolean setOreBlock(World world, int x, int y, int z, int secondarymeta, boolean bool) {
        if (this.mSetOre == null) {
            try {
                this.mSetOre = GT_TileEntity_Ores.class.getMethod("setOreBlock", World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
            }
            catch (NoSuchMethodException | SecurityException e) {
                try {
                    this.mSetOre = GT_TileEntity_Ores.class.getMethod("setOreBlock", World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                }
                catch (NoSuchMethodException | SecurityException exception) {
                    // empty catch block
                }
            }
        }
        if (this.mSetOre != null) {
            try {
                return (Boolean)this.mSetOre.invoke((Object)world, x, y, z, secondarymeta, bool);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException t) {
                return false;
            }
        }
        return false;
    }
}

