/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base;

import gregtech.GT_Mod;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Utility;
import gregtech.common.gui.modularui.widget.FluidDisplaySlotWidget;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_Hatch_CustomFluidBase
extends GT_MetaTileEntity_Hatch {
    public final Fluid mLockedFluid;
    public final int mFluidCapacity;
    protected FluidStack mLockedStack = null;
    protected String mTempMod = null;

    public GT_MetaTileEntity_Hatch_CustomFluidBase(Fluid aFluid, int aAmount, int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 6, 3, new String[]{"Fluid Input for Multiblocks", "Capacity: " + GT_Utility.formatNumbers((long)aAmount) + "L"}, new ITexture[0]);
        this.mLockedFluid = aFluid;
        this.mFluidCapacity = aAmount;
    }

    public GT_MetaTileEntity_Hatch_CustomFluidBase(Fluid aFluid, int aAmount, String aName, String aDescription, ITexture[][][] aTextures) {
        super(aName, 6, 3, aDescription, aTextures);
        this.mLockedFluid = aFluid;
        this.mFluidCapacity = aAmount;
    }

    public GT_MetaTileEntity_Hatch_CustomFluidBase(Fluid aFluid, int aAmount, String aName, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, 6, 3, aDescription[0], aTextures);
        this.mLockedFluid = aFluid;
        this.mFluidCapacity = aAmount;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        if (aSide == aBaseMetaTileEntity.getFrontFacing() && aIndex == 0) {
            FluidStack fs = GT_Utility.getFluidForFilledItem((ItemStack)aStack, (boolean)true);
            return fs != null && fs.getFluid() == this.mLockedFluid;
        }
        return false;
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aSide == aBaseMetaTileEntity.getFrontFacing() && aIndex == 1;
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        ITexture[] iTextureArray;
        if (GT_Mod.gregtechproxy.mRenderIndicatorsOnHatch) {
            ITexture[] iTextureArray2 = new ITexture[3];
            iTextureArray2[0] = aBaseTexture;
            iTextureArray2[1] = TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_PIPE_IN);
            iTextureArray = iTextureArray2;
            iTextureArray2[2] = TextureFactory.of((IIconContainer)Textures.BlockIcons.FLUID_IN_SIGN);
        } else {
            ITexture[] iTextureArray3 = new ITexture[2];
            iTextureArray3[0] = aBaseTexture;
            iTextureArray = iTextureArray3;
            iTextureArray3[1] = TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_PIPE_IN);
        }
        return iTextureArray;
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        ITexture[] iTextureArray;
        if (GT_Mod.gregtechproxy.mRenderIndicatorsOnHatch) {
            ITexture[] iTextureArray2 = new ITexture[3];
            iTextureArray2[0] = aBaseTexture;
            iTextureArray2[1] = TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_PIPE_IN);
            iTextureArray = iTextureArray2;
            iTextureArray2[2] = TextureFactory.of((IIconContainer)Textures.BlockIcons.FLUID_IN_SIGN);
        } else {
            ITexture[] iTextureArray3 = new ITexture[2];
            iTextureArray3[0] = aBaseTexture;
            iTextureArray = iTextureArray3;
            iTextureArray3[1] = TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_PIPE_IN);
        }
        return iTextureArray;
    }

    public boolean isSimpleMachine() {
        return true;
    }

    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GT_UIInfos.openGTTileEntityUI((IHasWorldObjectAndCoords)aBaseMetaTileEntity, (EntityPlayer)aPlayer);
        return true;
    }

    public boolean doesFillContainers() {
        return false;
    }

    public boolean doesEmptyContainers() {
        return true;
    }

    public boolean canTankBeFilled() {
        return true;
    }

    public boolean canTankBeEmptied() {
        return true;
    }

    public boolean displaysItemStack() {
        return true;
    }

    public boolean displaysStackSize() {
        return false;
    }

    public void updateSlots() {
        if (this.mInventory[this.getInputSlot()] != null && this.mInventory[this.getInputSlot()].field_77994_a <= 0) {
            this.mInventory[this.getInputSlot()] = null;
        }
    }

    public int getTankPressure() {
        return -100;
    }

    public int getCapacity() {
        return this.mFluidCapacity;
    }

    public String[] getDescription() {
        if (this.mLockedStack == null) {
            this.mLockedStack = FluidUtils.getFluidStack(this.mLockedFluid, 1);
        }
        int aFluidTemp = 0;
        boolean isSteam = false;
        if (this.mLockedFluid != null) {
            aFluidTemp = this.mLockedFluid.getTemperature();
            this.mTempMod = this.mLockedFluid.getName();
        }
        if (this.mTempMod.equalsIgnoreCase("steam")) {
            isSteam = true;
        }
        EnumChatFormatting aColour = EnumChatFormatting.BLUE;
        if (aFluidTemp <= -3000) {
            aColour = EnumChatFormatting.DARK_PURPLE;
        } else if (aFluidTemp >= -2999 && aFluidTemp <= -500) {
            aColour = EnumChatFormatting.DARK_BLUE;
        } else if (aFluidTemp >= -499 && aFluidTemp <= -50) {
            aColour = EnumChatFormatting.BLUE;
        } else if (aFluidTemp >= 30 && aFluidTemp <= 300) {
            aColour = EnumChatFormatting.AQUA;
        } else if (aFluidTemp >= 301 && aFluidTemp <= 800) {
            aColour = EnumChatFormatting.YELLOW;
        } else if (aFluidTemp >= 801 && aFluidTemp <= 1500) {
            aColour = EnumChatFormatting.GOLD;
        } else if (aFluidTemp >= 1501) {
            aColour = EnumChatFormatting.RED;
        }
        String aFluidName = "Accepted Fluid: " + aColour + (this.mLockedStack != null ? this.mLockedStack.getLocalizedName() : "Empty") + EnumChatFormatting.RESET;
        return new String[]{"Fluid Input for " + (isSteam ? "Steam " : "") + "Multiblocks", "Capacity: " + this.getCapacity() + "L", aFluidName, CORE.GT_Tooltip.get()};
    }

    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return aFluid.getFluid() == this.mLockedFluid;
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_CustomFluidBase(this.mLockedFluid, this.mFluidCapacity, this.mName, this.mDescription, this.mTextures);
    }

    public boolean useModularUI() {
        return true;
    }

    protected FluidDisplaySlotWidget createDrainableFluidSlot() {
        return super.createDrainableFluidSlot().setEmptyCanFillFilter(s -> s == this.mLockedFluid);
    }
}

