/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations;

import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine_GT_Recipe;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Recipe;
import gtPlusPlus.core.lib.CORE;

public class GT_MetaTileEntity_Dehydrator
extends GT_MetaTileEntity_BasicMachine_GT_Recipe {
    private static final Textures.BlockIcons.CustomIcon[] sDehydratorOverlays = new Textures.BlockIcons.CustomIcon[10];

    public GT_MetaTileEntity_Dehydrator(int aID, String aName, String aNameRegional, int aTier, String aDescription, int aTankCapacity) {
        super(aID, aName, aNameRegional, aTier, aDescription, (GT_Recipe.GT_Recipe_Map)GTPP_Recipe.GTPP_Recipe_Map.sChemicalDehydratorRecipes, 2, 9, aTankCapacity, 2, 5, "Dehydrator.png", SoundResource.NONE, false, false, GT_MetaTileEntity_BasicMachine_GT_Recipe.SpecialEffects.NONE, "", null);
    }

    public String[] getDescription() {
        String[] S = super.getDescription();
        String[] desc = new String[S.length + 1];
        System.arraycopy(S, 0, desc, 0, S.length);
        desc[S.length] = CORE.GT_Tooltip.get();
        return desc;
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[15][17][];
        for (byte i = -1; i < 16; i = (byte)(i + 1)) {
            rTextures[0][i + 1] = this.getSideFacingActive(i);
            rTextures[1][i + 1] = this.getSideFacingInactive(i);
            rTextures[2][i + 1] = this.getFrontFacingActive(i);
            rTextures[3][i + 1] = this.getFrontFacingInactive(i);
            rTextures[4][i + 1] = this.getTopFacingActive(i);
            rTextures[5][i + 1] = this.getTopFacingInactive(i);
            rTextures[6][i + 1] = this.getBottomFacingActive(i);
            rTextures[7][i + 1] = this.getBottomFacingInactive(i);
            rTextures[8][i + 1] = this.getBottomFacingPipeActive(i);
            rTextures[9][i + 1] = this.getBottomFacingPipeInactive(i);
            rTextures[10][i + 1] = this.getTopFacingPipeActive(i);
            rTextures[11][i + 1] = this.getTopFacingPipeInactive(i);
            rTextures[12][i + 1] = this.getSideFacingPipeActive(i);
            rTextures[13][i + 1] = this.getSideFacingPipeInactive(i);
        }
        return rTextures;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        return super.getTexture(aBaseMetaTileEntity, aSide, aFacing, aColorIndex, aActive, aRedstone);
    }

    public ITexture[] getFrontFacingInactive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)sDehydratorOverlays[0])};
    }

    public ITexture[] getBottomFacingInactive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)sDehydratorOverlays[2])};
    }

    public ITexture[] getTopFacingInactive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)sDehydratorOverlays[3])};
    }

    public ITexture[] getSideFacingInactive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)sDehydratorOverlays[4])};
    }

    public ITexture[] getFrontFacingActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)sDehydratorOverlays[5])};
    }

    public ITexture[] getBottomFacingActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)sDehydratorOverlays[7])};
    }

    public ITexture[] getTopFacingActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)sDehydratorOverlays[8])};
    }

    public ITexture[] getSideFacingActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)sDehydratorOverlays[9])};
    }

    public ITexture[] getBottomFacingPipeActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    public ITexture[] getBottomFacingPipeInactive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    public ITexture[] getTopFacingPipeActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    public ITexture[] getTopFacingPipeInactive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    public ITexture[] getSideFacingPipeActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    public ITexture[] getSideFacingPipeInactive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    static {
        GT_MetaTileEntity_Dehydrator.sDehydratorOverlays[0] = new Textures.BlockIcons.CustomIcon("basicmachines/microwave/OVERLAY_FRONT");
        GT_MetaTileEntity_Dehydrator.sDehydratorOverlays[2] = new Textures.BlockIcons.CustomIcon("basicmachines/plasma_arc_furnace/OVERLAY_BOTTOM");
        GT_MetaTileEntity_Dehydrator.sDehydratorOverlays[3] = new Textures.BlockIcons.CustomIcon("basicmachines/fluid_heater/OVERLAY_SIDE");
        GT_MetaTileEntity_Dehydrator.sDehydratorOverlays[4] = new Textures.BlockIcons.CustomIcon("basicmachines/chemical_bath/OVERLAY_FRONT");
        GT_MetaTileEntity_Dehydrator.sDehydratorOverlays[5] = new Textures.BlockIcons.CustomIcon("basicmachines/microwave/OVERLAY_FRONT_ACTIVE");
        GT_MetaTileEntity_Dehydrator.sDehydratorOverlays[7] = new Textures.BlockIcons.CustomIcon("basicmachines/plasma_arc_furnace/OVERLAY_BOTTOM_ACTIVE");
        GT_MetaTileEntity_Dehydrator.sDehydratorOverlays[8] = new Textures.BlockIcons.CustomIcon("basicmachines/fluid_heater/OVERLAY_SIDE_ACTIVE");
        GT_MetaTileEntity_Dehydrator.sDehydratorOverlays[9] = new Textures.BlockIcons.CustomIcon("basicmachines/chemical_bath/OVERLAY_FRONT_ACTIVE");
    }
}

