/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.reflect;

import com.google.common.reflect.ClassPath;
import com.gtnewhorizon.gtnhlib.reflect.Fields;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.util.data.StringUtils;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class ReflectionUtils {
    public static Map<String, Class<?>> mCachedClasses = new LinkedHashMap();
    public static Map<String, CachedMethod> mCachedMethods = new LinkedHashMap<String, CachedMethod>();
    public static Map<String, CachedField> mCachedFields = new LinkedHashMap<String, CachedField>();
    public static Map<String, CachedConstructor> mCachedConstructors = new LinkedHashMap<String, CachedConstructor>();
    public static Map<Field, Fields.ClassFields.Field> mCachedFieldAccessors = new LinkedHashMap<Field, Fields.ClassFields.Field>();

    private static Fields.ClassFields.Field cacheAccessor(Field f) {
        return mCachedFieldAccessors.computeIfAbsent(f, field -> Fields.ofClass(field.getDeclaringClass()).getUntypedField(Fields.LookupType.DECLARED_IN_HIERARCHY, field.getName()));
    }

    private static boolean cacheClass(Class<?> aClass) {
        if (aClass == null) {
            return false;
        }
        Class<?> y = mCachedClasses.get(aClass.getCanonicalName());
        if (y == null) {
            mCachedClasses.put(aClass.getCanonicalName(), aClass);
            return true;
        }
        return false;
    }

    private static boolean cacheMethod(Class<?> aClass, Method aMethod) {
        if (aMethod == null) {
            return false;
        }
        boolean isStatic = Modifier.isStatic(aMethod.getModifiers());
        CachedMethod y = mCachedMethods.get(aClass.getName() + "." + aMethod.getName() + "." + ArrayUtils.toString(aMethod.getParameterTypes()));
        if (y == null) {
            mCachedMethods.put(aClass.getName() + "." + aMethod.getName() + "." + ArrayUtils.toString(aMethod.getParameterTypes()), new CachedMethod(aMethod, isStatic));
            return true;
        }
        return false;
    }

    private static boolean cacheField(Class<?> aClass, Field aField) {
        if (aField == null) {
            return false;
        }
        boolean isStatic = Modifier.isStatic(aField.getModifiers());
        CachedField y = mCachedFields.get(aClass.getName() + "." + aField.getName());
        if (y == null) {
            mCachedFields.put(aClass.getName() + "." + aField.getName(), new CachedField(aField, isStatic));
            return true;
        }
        return false;
    }

    private static boolean cacheConstructor(Class<?> aClass, Constructor<?> aConstructor) {
        if (aConstructor == null) {
            return false;
        }
        CachedConstructor y = mCachedConstructors.get(aClass.getName() + "." + ArrayUtils.toString(aConstructor.getParameterTypes()));
        if (y == null) {
            mCachedConstructors.put(aClass.getName() + "." + ArrayUtils.toString(aConstructor.getParameterTypes()), new CachedConstructor(aConstructor));
            return true;
        }
        return false;
    }

    public static Constructor<?> getConstructor(Class<?> aClass, Class<?> ... aTypes) {
        if (aClass == null || aTypes == null) {
            return null;
        }
        String aMethodKey = ArrayUtils.toString(aTypes);
        CachedConstructor y = mCachedConstructors.get(aClass.getName() + "." + aMethodKey);
        if (y == null) {
            Constructor<?> u = ReflectionUtils.getConstructor_Internal(aClass, aTypes);
            if (u != null) {
                Logger.REFLECTION("Caching Constructor: " + aClass.getName() + "." + aMethodKey);
                ReflectionUtils.cacheConstructor(aClass, u);
                return u;
            }
            return null;
        }
        return y.get();
    }

    public static Class<?> getClass(String aClassCanonicalName) {
        if (aClassCanonicalName == null || aClassCanonicalName.length() <= 0) {
            return null;
        }
        Class<?> y = mCachedClasses.get(aClassCanonicalName);
        if (y == null && (y = ReflectionUtils.getClass_Internal(aClassCanonicalName)) != null) {
            Logger.REFLECTION("Caching Class: " + aClassCanonicalName);
            ReflectionUtils.cacheClass(y);
        }
        return y;
    }

    public static Method getMethod(Object aObject, String aMethodName, Class[] aTypes) {
        return ReflectionUtils.getMethod(aObject.getClass(), aMethodName, aTypes);
    }

    public static Method getMethod(Class<?> aClass, String aMethodName, Class<?> ... aTypes) {
        if (aClass == null || aMethodName == null || aMethodName.length() <= 0) {
            return null;
        }
        String aMethodKey = ArrayUtils.toString(aTypes);
        CachedMethod y = mCachedMethods.get(aClass.getName() + "." + aMethodName + "." + aMethodKey);
        if (y == null) {
            Method u = ReflectionUtils.getMethod_Internal(aClass, aMethodName, aTypes);
            if (u != null) {
                Logger.REFLECTION("Caching Method: " + aMethodName + "." + aMethodKey);
                ReflectionUtils.cacheMethod(aClass, u);
                return u;
            }
            return null;
        }
        return y.get();
    }

    public static boolean isStaticMethod(Class<?> aClass, String aMethodName, Class<?> ... aTypes) {
        return ReflectionUtils.isStaticMethod(ReflectionUtils.getMethod(aClass, aMethodName, aTypes));
    }

    public static boolean isStaticMethod(Method aMethod) {
        return aMethod != null && Modifier.isStatic(aMethod.getModifiers());
    }

    public static Field getField(Class<?> aClass, String aFieldName) {
        if (aClass == null || aFieldName == null || aFieldName.length() <= 0) {
            return null;
        }
        CachedField y = mCachedFields.get(aClass.getName() + "." + aFieldName);
        if (y == null) {
            try {
                Field u = ReflectionUtils.getField_Internal(aClass, aFieldName);
                if (u != null) {
                    Logger.REFLECTION("Caching Field '" + aFieldName + "' from " + aClass.getName());
                    ReflectionUtils.cacheField(aClass, u);
                    return u;
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            return null;
        }
        return y.get();
    }

    public static Field[] getAllFields(Class<?> aClass) {
        Field[] aFields;
        if (aClass == null) {
            return null;
        }
        for (Field f : aFields = aClass.getDeclaredFields()) {
            CachedField y = mCachedFields.get(aClass.getName() + "." + f.getName());
            if (y != null) continue;
            ReflectionUtils.makeFieldAccessible(f);
            ReflectionUtils.cacheField(aClass, f);
        }
        return aFields;
    }

    public static <T> T getField(Object aInstance, String aFieldName) {
        try {
            return (T)ReflectionUtils.getField(aInstance.getClass(), aFieldName).get(aInstance);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            return null;
        }
    }

    public static boolean doesClassExist(String classname) {
        return ReflectionUtils.isClassPresent(classname);
    }

    public static Class<?> getTypeOfGenericObject(Object o) {
        Class<?> aTypeParam = ReflectionUtils.findSuperClassParameterType(o, o.getClass(), 0);
        if (aTypeParam == null) {
            aTypeParam = ReflectionUtils.findSubClassParameterType(o, o.getClass(), 0);
        }
        return aTypeParam;
    }

    public static void makeFieldAccessible(Field field) {
        if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
            field.setAccessible(true);
        }
    }

    public static void makeMethodAccessible(Method field) {
        if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
            field.setAccessible(true);
        }
    }

    public static String getMethodName(int depth) {
        StackTraceElement[] ste = new Throwable().getStackTrace();
        if (ste.length < depth) {
            return "No valid stack.";
        }
        return ste[depth + 1].getMethodName();
    }

    public static boolean dynamicallyLoadClassesInPackage(String aPackageName) {
        ClassLoader classLoader = ReflectionUtils.class.getClassLoader();
        int loaded = 0;
        try {
            ClassPath path = ClassPath.from((ClassLoader)classLoader);
            for (ClassPath.ClassInfo info : path.getTopLevelClassesRecursive(aPackageName)) {
                Class<?> clazz = Class.forName(info.getName(), true, classLoader);
                if (clazz == null) continue;
                Logger.INFO("Found " + clazz.getCanonicalName() + ". [" + ++loaded + "]");
            }
        }
        catch (IOException | ClassNotFoundException exception) {
            // empty catch block
        }
        return loaded > 0;
    }

    public static void loadClass(String aClassName) {
        try {
            Class.forName(aClassName, true, ReflectionUtils.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static boolean setField(Object object, String fieldName, Object fieldValue) {
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        while (clazz != null) {
            try {
                Field field = ReflectionUtils.getField(clazz, fieldName);
                if (field == null) continue;
                ReflectionUtils.setFieldValue_Internal(object, field, fieldValue);
                return true;
            }
            catch (NoSuchFieldException e) {
                Logger.REFLECTION("setField(" + object.toString() + ", " + fieldName + ") failed.");
                clazz = clazz.getSuperclass();
            }
            catch (Exception e) {
                Logger.REFLECTION("setField(" + object.toString() + ", " + fieldName + ") failed.");
                throw new IllegalStateException(e);
            }
        }
        return false;
    }

    public static boolean setField(Object object, Field field, Object fieldValue) {
        if (field == null) {
            return false;
        }
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        while (clazz != null) {
            try {
                Field field2 = ReflectionUtils.getField(clazz, field.getName());
                if (field2 == null) continue;
                ReflectionUtils.setFieldValue_Internal(object, field, fieldValue);
                return true;
            }
            catch (NoSuchFieldException e) {
                Logger.REFLECTION("setField(" + object.toString() + ", " + field.getName() + ") failed.");
                clazz = clazz.getSuperclass();
            }
            catch (Exception e) {
                Logger.REFLECTION("setField(" + object.toString() + ", " + field.getName() + ") failed.");
                throw new IllegalStateException(e);
            }
        }
        return false;
    }

    public static void setFinalFieldValue(Class<?> clazz, String fieldName, Object newValue) {
        Field nameField = ReflectionUtils.getField(clazz, fieldName);
        try {
            ReflectionUtils.setFieldValue_Internal(clazz, nameField, newValue);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void setFinalFieldValue(Class<?> clazz, Field field, Object newValue) {
        try {
            ReflectionUtils.setFieldValue_Internal(clazz, field, newValue);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Deprecated
    public static void setFinalStatic(Field field, Object newValue) throws Exception {
        ReflectionUtils.cacheAccessor(field).setValue(null, newValue);
    }

    public static void setByte(Object clazz, String fieldName, byte newValue) throws Exception {
        Field nameField = ReflectionUtils.getField(clazz.getClass(), fieldName);
        ReflectionUtils.cacheAccessor(nameField).setValue(null, (Object)newValue);
    }

    public static boolean invoke(Object objectInstance, String methodName, Class[] parameters, Object[] values) {
        if (objectInstance == null || methodName == null || parameters == null || values == null) {
            return false;
        }
        Class<?> mLocalClass = objectInstance instanceof Class ? (Class<?>)objectInstance : objectInstance.getClass();
        Logger.REFLECTION("Trying to invoke " + methodName + " on an instance of " + mLocalClass.getCanonicalName() + ".");
        try {
            Method mInvokingMethod = mLocalClass.getDeclaredMethod(methodName, parameters);
            if (mInvokingMethod != null) {
                return ReflectionUtils.invoke(objectInstance, mInvokingMethod, values);
            }
        }
        catch (IllegalArgumentException | NoSuchMethodException | SecurityException e) {
            Logger.REFLECTION("Failed to Dynamically invoke " + methodName + " on an object of type: " + mLocalClass.getName());
        }
        Logger.REFLECTION("Invoke failed or did something wrong.");
        return false;
    }

    public static boolean invoke(Object objectInstance, Method method, Object[] values) {
        if (method == null || values == null || !ReflectionUtils.isStaticMethod(method) && objectInstance == null) {
            return false;
        }
        String methodName = method.getName();
        String classname = objectInstance != null ? objectInstance.getClass().getCanonicalName() : method.getDeclaringClass().getCanonicalName();
        Logger.REFLECTION("Trying to invoke " + methodName + " on an instance of " + classname + ".");
        try {
            Method mInvokingMethod = method;
            if (mInvokingMethod != null) {
                Logger.REFLECTION(methodName + " was not null.");
                if (((Boolean)mInvokingMethod.invoke(objectInstance, values)).booleanValue()) {
                    Logger.REFLECTION("Successfully invoked " + methodName + ".");
                    return true;
                }
                Logger.REFLECTION("Invocation failed for " + methodName + ".");
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            Logger.REFLECTION("Failed to Dynamically invoke " + methodName + " on an object of type: " + classname);
        }
        Logger.REFLECTION("Invoke failed or did something wrong.");
        return false;
    }

    public static boolean invokeVoid(Object objectInstance, Method method, Object[] values) {
        if (method == null || values == null || !ReflectionUtils.isStaticMethod(method) && objectInstance == null) {
            return false;
        }
        String methodName = method.getName();
        String classname = objectInstance != null ? objectInstance.getClass().getCanonicalName() : method.getDeclaringClass().getCanonicalName();
        Logger.REFLECTION("Trying to invoke " + methodName + " on an instance of " + classname + ".");
        try {
            Method mInvokingMethod = method;
            if (mInvokingMethod != null) {
                Logger.REFLECTION(methodName + " was not null.");
                mInvokingMethod.invoke(objectInstance, values);
                Logger.REFLECTION("Successfully invoked " + methodName + ".");
                return true;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            Logger.REFLECTION("Failed to Dynamically invoke " + methodName + " on an object of type: " + classname);
        }
        Logger.REFLECTION("Invoke failed or did something wrong.");
        return false;
    }

    public static boolean invokeVoid(Object objectInstance, String methodName, Class[] parameters, Object[] values) {
        if (objectInstance == null || methodName == null || parameters == null || values == null) {
            return false;
        }
        Class<?> mLocalClass = objectInstance instanceof Class ? (Class<?>)objectInstance : objectInstance.getClass();
        Logger.REFLECTION("Trying to invoke " + methodName + " on an instance of " + mLocalClass.getCanonicalName() + ".");
        try {
            Method mInvokingMethod = mLocalClass.getDeclaredMethod(methodName, parameters);
            if (mInvokingMethod != null) {
                Logger.REFLECTION(methodName + " was not null.");
                mInvokingMethod.invoke(objectInstance, values);
                Logger.REFLECTION("Successfully invoked " + methodName + ".");
                return true;
            }
            Logger.REFLECTION(methodName + " is null.");
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            Logger.REFLECTION("Failed to Dynamically invoke " + methodName + " on an object of type: " + mLocalClass.getName());
        }
        Logger.REFLECTION("Invoke failed or did something wrong.");
        return false;
    }

    public static Object invokeNonBool(Object objectInstance, Method method, Object[] values) {
        if (!ReflectionUtils.isStaticMethod(method) && objectInstance == null || method == null || values == null) {
            return false;
        }
        String methodName = method.getName();
        String classname = objectInstance != null ? objectInstance.getClass().getCanonicalName() : method.getDeclaringClass().getCanonicalName();
        Logger.REFLECTION("Trying to invoke " + methodName + " on an instance of " + classname + ".");
        try {
            return method.invoke(objectInstance, values);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            Logger.REFLECTION("Failed to Dynamically invoke " + methodName + " on an object of type: " + classname);
            Logger.REFLECTION("Invoke failed or did something wrong.");
            return null;
        }
    }

    public static Object invokeNonBool(Object objectInstance, String methodName, Class[] parameters, Object[] values) {
        if (objectInstance == null || methodName == null || parameters == null || values == null) {
            return false;
        }
        Class<?> mLocalClass = objectInstance instanceof Class ? (Class<?>)objectInstance : objectInstance.getClass();
        Logger.REFLECTION("Trying to invoke " + methodName + " on an instance of " + mLocalClass.getCanonicalName() + ".");
        try {
            Method mInvokingMethod = mLocalClass.getDeclaredMethod(methodName, parameters);
            if (mInvokingMethod != null) {
                Logger.REFLECTION(methodName + " was not null.");
                return mInvokingMethod.invoke(objectInstance, values);
            }
            Logger.REFLECTION(methodName + " is null.");
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            Logger.REFLECTION("Failed to Dynamically invoke " + methodName + " on an object of type: " + mLocalClass.getName());
        }
        Logger.REFLECTION("Invoke failed or did something wrong.");
        return null;
    }

    public static Class<?> findSuperClassParameterType(Object instance, Class<?> classOfInterest, int parameterIndex) {
        Class<?> subClass = instance.getClass();
        while (classOfInterest != subClass.getSuperclass()) {
            if ((subClass = subClass.getSuperclass()) != null) continue;
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)subClass.getGenericSuperclass();
        Class aReturn = (Class)parameterizedType.getActualTypeArguments()[parameterIndex];
        return aReturn;
    }

    public static Class<?> findSubClassParameterType(Object instance, Class<?> classOfInterest, int parameterIndex) {
        HashMap<Type, Type> typeMap = new HashMap<Type, Type>();
        Class<?> instanceClass = instance.getClass();
        while (classOfInterest != instanceClass.getSuperclass()) {
            ReflectionUtils.extractTypeArguments(typeMap, instanceClass);
            if ((instanceClass = instanceClass.getSuperclass()) != null) continue;
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)instanceClass.getGenericSuperclass();
        Type actualType = parameterizedType.getActualTypeArguments()[parameterIndex];
        if (typeMap.containsKey(actualType)) {
            actualType = (Type)typeMap.get(actualType);
        }
        if (actualType instanceof Class) {
            return (Class)actualType;
        }
        if (actualType instanceof TypeVariable) {
            return ReflectionUtils.browseNestedTypes(instance, (TypeVariable)actualType);
        }
        return null;
    }

    private static void extractTypeArguments(Map<Type, Type> typeMap, Class<?> clazz) {
        Type genericSuperclass = clazz.getGenericSuperclass();
        if (!(genericSuperclass instanceof ParameterizedType)) {
            return;
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericSuperclass;
        TypeVariable<Class<T>>[] typeParameter = ((Class)parameterizedType.getRawType()).getTypeParameters();
        Type[] actualTypeArgument = parameterizedType.getActualTypeArguments();
        for (int i = 0; i < typeParameter.length; ++i) {
            if (typeMap.containsKey(actualTypeArgument[i])) {
                actualTypeArgument[i] = typeMap.get(actualTypeArgument[i]);
            }
            typeMap.put(typeParameter[i], actualTypeArgument[i]);
        }
    }

    private static Class<?> browseNestedTypes(Object instance, TypeVariable<?> actualType) {
        Class<?> instanceClass = instance.getClass();
        LinkedList nestedOuterTypes = new LinkedList();
        for (Class<?> enclosingClass = instanceClass.getEnclosingClass(); enclosingClass != null; enclosingClass = enclosingClass.getEnclosingClass()) {
            try {
                Field this$0 = instanceClass.getDeclaredField("this$0");
                Object outerInstance = this$0.get(instance);
                Class<?> outerClass = outerInstance.getClass();
                nestedOuterTypes.add(outerClass);
                HashMap<Type, Type> outerTypeMap = new HashMap<Type, Type>();
                ReflectionUtils.extractTypeArguments(outerTypeMap, outerClass);
                for (Map.Entry entry : outerTypeMap.entrySet()) {
                    TypeVariable foundType;
                    if (!(entry.getKey() instanceof TypeVariable) || !(foundType = (TypeVariable)entry.getKey()).getName().equals(actualType.getName()) || !ReflectionUtils.isInnerClass(foundType.getGenericDeclaration(), actualType.getGenericDeclaration())) continue;
                    if (entry.getValue() instanceof Class) {
                        return (Class)entry.getValue();
                    }
                    actualType = (TypeVariable)entry.getValue();
                }
                continue;
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean isInnerClass(GenericDeclaration outerDeclaration, GenericDeclaration innerDeclaration) {
        if (!(outerDeclaration instanceof Class) || !(innerDeclaration instanceof Class)) {
            return false;
        }
        Class outerClass = (Class)outerDeclaration;
        Class<?> innerClass = (Class<?>)innerDeclaration;
        while ((innerClass = innerClass.getEnclosingClass()) != null) {
            if (innerClass != outerClass) continue;
            return true;
        }
        return false;
    }

    private static Field getField_Internal(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        try {
            Logger.REFLECTION("Field: Internal Lookup: " + fieldName);
            Field k = clazz.getDeclaredField(fieldName);
            ReflectionUtils.makeFieldAccessible(k);
            return k;
        }
        catch (NoSuchFieldException e) {
            Logger.REFLECTION("Field: Internal Lookup Failed: " + fieldName);
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                Logger.REFLECTION("Unable to find field '" + fieldName + "'");
                throw e;
            }
            Logger.REFLECTION("Method: Recursion Lookup: " + fieldName + " - Checking in " + superClass.getName());
            return ReflectionUtils.getField_Internal(superClass, fieldName);
        }
    }

    private static boolean isClassPresent(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    @Deprecated
    public static Method getMethodViaReflection(Class<?> lookupClass, String methodName, boolean invoke) throws Exception {
        Class<?> lookup = lookupClass.getClass();
        Method m = lookup.getDeclaredMethod(methodName, new Class[0]);
        m.setAccessible(true);
        if (invoke) {
            m.invoke(lookup, new Object[0]);
        }
        return m;
    }

    private static Method getMethod_Internal(Class<?> aClass, String aMethodName, Class<?> ... aTypes) {
        Method m = null;
        try {
            Logger.REFLECTION("Method: Internal Lookup: " + aMethodName);
            m = aClass.getDeclaredMethod(aMethodName, aTypes);
            if (m != null) {
                m.setAccessible(true);
            }
        }
        catch (Throwable t) {
            Logger.REFLECTION("Method: Internal Lookup Failed: " + aMethodName);
            try {
                m = ReflectionUtils.getMethodRecursively(aClass, aMethodName);
            }
            catch (NoSuchMethodException e) {
                Logger.REFLECTION("Unable to find method '" + aMethodName + "'");
                e.printStackTrace();
                ReflectionUtils.dumpClassInfo(aClass);
            }
        }
        return m;
    }

    private static Constructor<?> getConstructor_Internal(Class<?> aClass, Class<?> ... aTypes) {
        Constructor<?> c = null;
        try {
            Logger.REFLECTION("Constructor: Internal Lookup: " + aClass.getName());
            c = aClass.getDeclaredConstructor(aTypes);
            if (c != null) {
                c.setAccessible(true);
            }
        }
        catch (Throwable t) {
            Logger.REFLECTION("Constructor: Internal Lookup Failed: " + aClass.getName());
            try {
                c = ReflectionUtils.getConstructorRecursively(aClass, aTypes);
            }
            catch (Exception e) {
                Logger.REFLECTION("Unable to find method '" + aClass.getName() + "'");
                e.printStackTrace();
                ReflectionUtils.dumpClassInfo(aClass);
            }
        }
        return c;
    }

    private static Constructor<?> getConstructorRecursively(Class<?> aClass, Class<?> ... aTypes) throws Exception {
        try {
            Logger.REFLECTION("Constructor: Recursion Lookup: " + aClass.getName());
            Constructor<?> c = aClass.getConstructor(aTypes);
            if (c != null) {
                c.setAccessible(true);
            }
            return c;
        }
        catch (IllegalArgumentException | NoSuchMethodException e) {
            Class<?> superClass = aClass.getSuperclass();
            if (superClass == null || superClass == Object.class) {
                throw e;
            }
            return ReflectionUtils.getConstructor_Internal(superClass, aTypes);
        }
    }

    private static Method getMethodRecursively(Class<?> clazz, String aMethodName) throws NoSuchMethodException {
        try {
            Logger.REFLECTION("Method: Recursion Lookup: " + aMethodName);
            Method k = clazz.getDeclaredMethod(aMethodName, new Class[0]);
            ReflectionUtils.makeMethodAccessible(k);
            return k;
        }
        catch (NoSuchMethodException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null || superClass == Object.class) {
                throw e;
            }
            return ReflectionUtils.getMethod_Internal(superClass, aMethodName, new Class[0]);
        }
    }

    private static void dumpClassInfo(Class<?> aClass) {
        Logger.INFO("We ran into an error processing reflection in " + aClass.getName() + ", dumping all data for debugging.");
        Method[] methods = aClass.getDeclaredMethods();
        Field[] fields = aClass.getDeclaredFields();
        Constructor<?>[] consts = aClass.getDeclaredConstructors();
        Logger.INFO("Dumping all Methods.");
        for (Method method : methods) {
            System.out.println(method.getName() + " | " + StringUtils.getDataStringFromArray(method.getParameterTypes()));
        }
        Logger.INFO("Dumping all Fields.");
        for (AccessibleObject accessibleObject : fields) {
            System.out.println(((Field)accessibleObject).getName());
        }
        Logger.INFO("Dumping all Constructors.");
        for (AccessibleObject accessibleObject : consts) {
            System.out.println(((Constructor)accessibleObject).getName() + " | " + ((Constructor)accessibleObject).getParameterCount() + " | " + StringUtils.getDataStringFromArray(((Constructor)accessibleObject).getParameterTypes()));
        }
    }

    private static Class<?> getNonPublicClass(String className) {
        Class<?> c = null;
        try {
            c = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (null != c) {
            Constructor<?> constructor = null;
            try {
                constructor = c.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                e.printStackTrace();
            }
            if (null != constructor) {
                constructor.setAccessible(true);
                try {
                    Object o = constructor.newInstance(new Object[0]);
                    return (Class)o;
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Class<?> getClass_Internal(String string) {
        Class<?> aClass = null;
        if (ReflectionUtils.doesClassExist(string)) {
            try {
                aClass = Class.forName(string);
            }
            catch (ClassNotFoundException e) {
                aClass = ReflectionUtils.getNonPublicClass(string);
            }
        }
        if (aClass != null) return aClass;
        String aClassName = "";
        Logger.REFLECTION("Splitting " + string + " to try look for hidden classes.");
        String[] aData = string.split("\\.");
        Logger.REFLECTION("Obtained " + aData.length + " pieces.");
        for (int i = 0; i < aData.length - 1; ++i) {
            aClassName = aClassName + (i > 0 ? "." + aData[i] : "" + aData[i]);
            Logger.REFLECTION("Building: " + aClassName);
        }
        if (aClassName == null) return null;
        if (aClassName.length() <= 0) return null;
        Logger.REFLECTION("Trying to search '" + aClassName + "' for inner classes.");
        Class<?> clazz = ReflectionUtils.getClass(aClassName);
        if (clazz == null) return null;
        Class<?>[] y = clazz.getDeclaredClasses();
        if (y == null || y.length <= 0) {
            Logger.REFLECTION("No hidden inner classes found.");
            return null;
        }
        boolean found = false;
        for (Class<?> h : y) {
            Logger.REFLECTION("Found hidden inner class: " + h.getCanonicalName());
            if (!h.getSimpleName().toLowerCase().equals(aData[aData.length - 1].toLowerCase())) continue;
            Logger.REFLECTION("Found correct class. [" + aData[aData.length - 1] + "] Caching at correct location: " + string);
            Logger.REFLECTION("Found at location: " + h.getCanonicalName());
            mCachedClasses.put(string, h);
            return h;
        }
        if (found) return aClass;
        return null;
    }

    private static void setFieldValue_Internal(Object owner, Field field, Object value) throws Exception {
        ReflectionUtils.cacheAccessor(field).setValue(owner, value);
    }

    public static boolean doesFieldExist(String clazz, String string) {
        return ReflectionUtils.doesFieldExist(ReflectionUtils.getClass(clazz), string);
    }

    public static boolean doesFieldExist(Class<?> clazz, String string) {
        return clazz != null && ReflectionUtils.getField(clazz, string) != null;
    }

    public static <T> T getFieldValue(Field field) {
        return ReflectionUtils.getFieldValue(field, null);
    }

    public static <T> T getFieldValue(Field field, Object instance) {
        try {
            return (T)field.get(instance);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            return null;
        }
    }

    public static <T> T createNewInstanceFromConstructor(Constructor aConstructor, Object[] aArgs) {
        try {
            Object aInstance = aConstructor.newInstance(aArgs);
            if (aInstance != null) {
                return aInstance;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Enum getEnum(Class<Enum> sgtbees, String name) {
        if (sgtbees.isEnum()) {
            Enum[] aValues;
            for (Enum o : aValues = sgtbees.getEnumConstants()) {
                if (!o.toString().toLowerCase().equals(name.toLowerCase())) continue;
                return o;
            }
        }
        return null;
    }

    private static class CachedField {
        private final boolean STATIC;
        private final Field FIELD;

        public CachedField(Field aField, boolean isStatic) {
            this.FIELD = aField;
            this.STATIC = isStatic;
        }

        public Field get() {
            return this.FIELD;
        }

        public boolean type() {
            return this.STATIC;
        }
    }

    private static class CachedMethod {
        private final boolean STATIC;
        private final Method METHOD;

        public CachedMethod(Method aMethod, boolean isStatic) {
            this.METHOD = aMethod;
            this.STATIC = isStatic;
        }

        public Method get() {
            return this.METHOD;
        }

        public boolean type() {
            return this.STATIC;
        }
    }

    private static class CachedConstructor {
        private final Constructor<?> METHOD;

        public CachedConstructor(Constructor<?> aCons) {
            this.METHOD = aCons;
        }

        public Constructor<?> get() {
            return this.METHOD;
        }
    }
}

