/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.minecraft;

import baubles.api.BaubleType;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.Pair;
import gtPlusPlus.core.util.minecraft.NBTUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ModularArmourUtils {
    public static ItemStack addComponent(ItemStack tArmour, ItemStack[] tComponents) {
        ItemStack rArmour;
        if (tArmour == null || (rArmour = NBTUtils.writeItemsToGtCraftingComponents(tArmour, tComponents, true)) != null) {
            // empty if block
        }
        return null;
    }

    public static void setModifierLevel(ItemStack aStack, Pair<Modifiers, Integer> mPair) {
        ModularArmourUtils.setModifierLevel(aStack, mPair.getKey(), (int)mPair.getValue());
    }

    public static void setModifierLevel(ItemStack aStack, Modifiers aMod, Integer aInt) {
        ModularArmourUtils.setModifierLevel(aStack, aMod, (int)aInt);
    }

    public static void setModifierLevel(ItemStack aStack, Modifiers aMod, int aInt) {
        int mCurrentLevel = ModularArmourUtils.getModifierLevel(aStack, aMod);
        int mNewTotalLevel = mCurrentLevel + aInt;
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        if (aMod.isValidLevel(mNewTotalLevel)) {
            tNBT.func_74768_a(aMod.getModifier(), mNewTotalLevel);
            GT_Utility.ItemNBT.setNBT((ItemStack)aStack, (NBTTagCompound)tNBT);
        } else if (ModularArmourUtils.getModifierLevel(aStack, aMod) > 100) {
            ModularArmourUtils.setModifierLevel(aStack, aMod, 100);
        }
    }

    public static int getModifierLevel(ItemStack aStack, Pair<Modifiers, Integer> newPair) {
        return ModularArmourUtils.getModifierLevel(aStack, newPair.getKey());
    }

    public static int getModifierLevel(ItemStack aStack, Modifiers aMod) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        return tNBT.func_74762_e(aMod.getModifier());
    }

    public static void setBaubleType(ItemStack aStack, BT aMod) {
        Logger.INFO("Changing bauble type.");
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        if (aMod != null) {
            tNBT.func_74768_a("mBaubleType", aMod.getID());
            GT_Utility.ItemNBT.setNBT((ItemStack)aStack, (NBTTagCompound)tNBT);
        }
    }

    public static int getBaubleTypeID(ItemStack aStack) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        return tNBT.func_74762_e("mBaubleType");
    }

    public static BaubleType getBaubleType(ItemStack aStack) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        return ModularArmourUtils.getBaubleByID(tNBT.func_74762_e("mBaubleType"));
    }

    public static BaubleType getBaubleByID(int tID) {
        if (tID == 0) {
            return BaubleType.AMULET;
        }
        if (tID == 1) {
            return BaubleType.RING;
        }
        if (tID == 2) {
            return BaubleType.BELT;
        }
        return BaubleType.RING;
    }

    public static ItemStack setDefaultStats(ItemStack aStack) {
        ItemStack tempStack = aStack;
        ModularArmourUtils.setModifierLevel(tempStack, Modifiers.BOOST_DAMAGE, 0);
        ModularArmourUtils.setModifierLevel(tempStack, Modifiers.BOOST_DEF, 0);
        ModularArmourUtils.setModifierLevel(tempStack, Modifiers.BOOST_HOLY, 0);
        ModularArmourUtils.setModifierLevel(tempStack, Modifiers.BOOST_HP, 0);
        ModularArmourUtils.setModifierLevel(tempStack, Modifiers.BOOST_MINING, 0);
        ModularArmourUtils.setModifierLevel(tempStack, Modifiers.BOOST_SPEED, 0);
        return tempStack;
    }

    public static enum BT {
        TYPE_AMULET(BaubleType.AMULET, 0),
        TYPE_RING(BaubleType.RING, 1),
        TYPE_BELT(BaubleType.BELT, 2);

        private final BaubleType mType;
        private final int mID;
        private final String mBaubleType;

        private BT(BaubleType tType, int tID) {
            this.mType = tType;
            this.mID = tID;
            this.mBaubleType = tType.name().toLowerCase();
        }

        public BaubleType getType() {
            return this.mType;
        }

        public BT getThis() {
            return this;
        }

        public BaubleType getBaubleByID(int tID) {
            if (tID == 0) {
                return BaubleType.AMULET;
            }
            if (tID == 1) {
                return BaubleType.RING;
            }
            if (tID == 2) {
                return BaubleType.BELT;
            }
            return BaubleType.RING;
        }

        public int getID() {
            return this.mID;
        }

        public String getTypeAsString() {
            return this.mBaubleType;
        }
    }

    public static enum Modifiers {
        BOOST_HP("skill.hpboost"),
        BOOST_DEF("skill.defenceboost"),
        BOOST_SPEED("skill.speedboost"),
        BOOST_MINING("skill.miningboost"),
        BOOST_DAMAGE("skill.damageboost"),
        BOOST_HOLY("skill.holyboost");

        private String MODIFIER_NAME;

        private Modifiers(String mModifier) {
            this.MODIFIER_NAME = mModifier;
        }

        public String getModifier() {
            return this.MODIFIER_NAME;
        }

        public boolean isValidLevel(int i) {
            return i >= 0 && i <= 100;
        }
    }
}

