/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.slots;

import gregtech.api.items.GT_MetaGenerated_Tool;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.slots.SlotGtTool;
import ic2.api.info.Info;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class SlotGtToolElectric
extends SlotGtTool {
    public int tier;
    private ItemStack content;
    public boolean allowRedstoneDust = true;

    public SlotGtToolElectric(IInventory base, int x, int y, int z, int tier, boolean allowRedstoneDust) {
        super(base, x, y, z);
        this.tier = tier;
        this.allowRedstoneDust = allowRedstoneDust;
    }

    public boolean accepts(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() == Items.field_151137_ax && !this.allowRedstoneDust) {
            return false;
        }
        return Info.itemEnergy.getEnergyValue(stack) > 0.0 || ElectricItem.manager.discharge(stack, Double.POSITIVE_INFINITY, this.tier, true, true, true) > 0.0;
    }

    public double discharge(double amount, boolean ignoreLimit) {
        if (amount <= 0.0) {
            throw new IllegalArgumentException("Amount must be > 0.");
        }
        ItemStack stack = this.get(0);
        if (stack == null) {
            return 0.0;
        }
        double realAmount = ElectricItem.manager.discharge(stack, amount, this.tier, ignoreLimit, true, false);
        if (realAmount <= 0.0) {
            realAmount = Info.itemEnergy.getEnergyValue(stack);
            if (realAmount <= 0.0) {
                return 0.0;
            }
            --stack.field_77994_a;
            if (stack.field_77994_a <= 0) {
                this.put(0, null);
            }
        }
        return realAmount;
    }

    public void setTier(int tier1) {
        this.tier = tier1;
    }

    public ItemStack get() {
        return this.get(0);
    }

    public ItemStack get(int index) {
        return this.content;
    }

    public void put(ItemStack content) {
        this.put(0, content);
    }

    public void put(int index, ItemStack content) {
        this.content = content;
        this.onChanged();
    }

    public void onChanged() {
    }

    @Override
    public boolean func_75214_a(ItemStack itemstack) {
        if (itemstack.func_77973_b() instanceof GT_MetaGenerated_Tool || itemstack.func_77973_b() instanceof IElectricItem) {
            Logger.WARNING(itemstack.func_82833_r() + " is a valid Tool.");
            return true;
        }
        Logger.WARNING(itemstack.func_82833_r() + " is not a valid Tool.");
        return false;
    }
}

